/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.experimental.led;

import javafx.animation.AnimationTimer;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;

public class LedOne
extends Canvas {
    private static final double PREFERRED_SIZE = 16.0;
    private static final long SHORTEST_INTERVAL = 50000000L;
    private static final long LONGEST_INTERVAL = 5000000000L;
    private ObjectProperty<Color> ledColor;
    private BooleanProperty on;
    private boolean toggle;
    private BooleanProperty blinking;
    private BooleanProperty frameVisible;
    private InnerShadow ledOnShadow;
    private InnerShadow ledOffShadow;
    private LinearGradient frameGradient;
    private LinearGradient ledOnGradient;
    private LinearGradient ledOffGradient;
    private RadialGradient highlightGradient;
    private long lastTimerCall = System.nanoTime();
    private LongProperty interval;
    private AnimationTimer timer = new AnimationTimer(){

        public void handle(long NOW) {
            if (NOW > LedOne.this.lastTimerCall + LedOne.this.getInterval()) {
                LedOne.this.setOn(!LedOne.this.isOn());
                LedOne.this.lastTimerCall = NOW;
            }
        }
    };
    private GraphicsContext ctx;
    private double width;
    private double height;
    private double size;
    private double offsetX = 0.0;
    private double offsetY = 0.0;

    public LedOne() {
        this(16.0, Color.RED, true, 500000000L, false);
    }

    public LedOne(double SIZE, Color LED_COLOR, boolean FRAME_VISIBLE, long INTERVAL, boolean BLINKING) {
        super(SIZE, SIZE);
        this.on = new SimpleBooleanProperty((Object)this, "on", false);
        this.ledColor = new SimpleObjectProperty((Object)this, "ledColor", (Object)LED_COLOR);
        this.frameVisible = new SimpleBooleanProperty((Object)this, "frameVisible", FRAME_VISIBLE);
        this.interval = new SimpleLongProperty((Object)this, "interval", INTERVAL);
        this.blinking = new SimpleBooleanProperty((Object)this, "blinking", BLINKING);
        this.init();
        this.initGraphics();
        this.registerListeners();
        this.toggle = false;
        this.lastTimerCall = System.nanoTime();
        this.timer = new AnimationTimer(){

            public void handle(long NOW) {
                if (NOW > LedOne.this.lastTimerCall + LedOne.this.getInterval()) {
                    LedOne.this.toggle = LedOne.this.toggle ^ true;
                    LedOne.this.setOn(LedOne.this.toggle);
                    LedOne.this.lastTimerCall = NOW;
                }
            }
        };
        this.init();
        this.initGraphics();
        this.registerListeners();
        if (this.isBlinking()) {
            this.timer.start();
        } else {
            this.timer.stop();
        }
    }

    private void init() {
        if (Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            this.setPrefSize(16.0, 16.0);
        }
    }

    private void initGraphics() {
        this.ctx = this.getGraphicsContext2D();
    }

    private void registerListeners() {
        this.widthProperty().addListener(observable -> this.recalc());
        this.heightProperty().addListener(observable -> this.recalc());
        this.frameVisibleProperty().addListener(observable -> this.draw());
        this.onProperty().addListener(observable -> this.draw());
        this.ledColorProperty().addListener(observable -> this.recalc());
        this.parentProperty().addListener(observable -> {
            if (null == this.getParent()) {
                return;
            }
            this.widthProperty().unbind();
            this.heightProperty().unbind();
            if (this.getParent() instanceof Pane) {
                this.widthProperty().bind((ObservableValue)((Pane)this.getParent()).widthProperty());
                this.heightProperty().bind((ObservableValue)((Pane)this.getParent()).heightProperty());
            }
        });
    }

    public boolean isResizable() {
        return true;
    }

    public double prefWidth(double height) {
        return this.getWidth();
    }

    public double prefHeight(double width) {
        return this.getHeight();
    }

    public void setPrefSize(double WIDTH, double HEIGHT) {
        super.setWidth(WIDTH);
        super.setHeight(HEIGHT);
        this.recalc();
    }

    public final boolean isOn() {
        return this.on.get();
    }

    public final void setOn(boolean ON) {
        this.on.set(ON);
    }

    public final BooleanProperty onProperty() {
        return this.on;
    }

    public final boolean isBlinking() {
        return this.blinking.get();
    }

    public final void setBlinking(boolean BLINKING) {
        if (BLINKING) {
            this.timer.start();
        } else {
            this.timer.stop();
            this.setOn(false);
        }
        this.blinking.set(BLINKING);
    }

    public final BooleanProperty blinkingProperty() {
        return this.blinking;
    }

    public final long getInterval() {
        return this.interval.get();
    }

    public final void setInterval(long INTERVAL) {
        this.interval.set(INTERVAL);
    }

    public final LongProperty intervalProperty() {
        return this.interval;
    }

    public final boolean isFrameVisible() {
        return this.frameVisible.get();
    }

    public final void setFrameVisible(boolean FRAME_VISIBLE) {
        this.frameVisible.set(FRAME_VISIBLE);
    }

    public final BooleanProperty frameVisibleProperty() {
        return this.frameVisible;
    }

    public final Color getLedColor() {
        return (Color)this.ledColor.get();
    }

    public final void setLedColor(Color LED_COLOR) {
        this.ledColor.set((Object)LED_COLOR);
    }

    public final ObjectProperty<Color> ledColorProperty() {
        return this.ledColor;
    }

    public static long clamp(long MIN, long MAX, long VALUE) {
        if (VALUE < MIN) {
            return MIN;
        }
        if (VALUE > MAX) {
            return MAX;
        }
        return VALUE;
    }

    private void recalc() {
        this.width = this.getWidth();
        this.height = this.getHeight();
        if (this.width <= 0.0 || this.height <= 0.0) {
            return;
        }
        this.size = this.width < this.height ? this.width : this.height;
        this.offsetX = 0.0;
        this.offsetY = 0.0;
        if (this.width > this.height) {
            this.offsetX = 0.5 * (this.width - this.size);
        } else if (this.height > this.width) {
            this.offsetY = 0.5 * (this.height - this.size);
        }
        this.ledOffShadow = new InnerShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.65), 0.07 * this.size, 0.0, 0.0, 0.0);
        this.ledOnShadow = new InnerShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.65), 0.07 * this.size, 0.0, 0.0, 0.0);
        this.ledOnShadow.setInput((Effect)new DropShadow(BlurType.TWO_PASS_BOX, (Color)this.ledColor.get(), 0.36 * this.size, 0.0, 0.0, 0.0));
        this.frameGradient = new LinearGradient(this.offsetX + 0.14 * this.size, this.offsetY + 0.14 * this.size, this.offsetX + 0.84 * this.size, this.offsetY + 0.84 * this.size, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)20, (int)20, (int)20, (double)0.65)), new Stop(0.15, Color.rgb((int)20, (int)20, (int)20, (double)0.65)), new Stop(0.26, Color.rgb((int)41, (int)41, (int)41, (double)0.65)), new Stop(0.26, Color.rgb((int)41, (int)41, (int)41, (double)0.64)), new Stop(0.85, Color.rgb((int)200, (int)200, (int)200, (double)0.41)), new Stop(1.0, Color.rgb((int)200, (int)200, (int)200, (double)0.35))});
        this.ledOnGradient = new LinearGradient(this.offsetX + 0.25 * this.size, this.offsetY + 0.25 * this.size, this.offsetX + 0.74 * this.size, this.offsetY + 0.74 * this.size, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, ((Color)this.ledColor.get()).deriveColor(0.0, 1.0, 0.77, 1.0)), new Stop(0.49, ((Color)this.ledColor.get()).deriveColor(0.0, 1.0, 0.5, 1.0)), new Stop(1.0, (Color)this.ledColor.get())});
        this.ledOffGradient = new LinearGradient(this.offsetX + 0.25 * this.size, this.offsetY + 0.25 * this.size, this.offsetX + 0.74 * this.size, this.offsetY + 0.74 * this.size, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, ((Color)this.ledColor.get()).deriveColor(0.0, 1.0, 0.2, 1.0)), new Stop(0.49, ((Color)this.ledColor.get()).deriveColor(0.0, 1.0, 0.13, 1.0)), new Stop(1.0, ((Color)this.ledColor.get()).deriveColor(0.0, 1.0, 0.2, 1.0))});
        this.highlightGradient = new RadialGradient(0.0, 0.0, this.offsetX + 0.3 * this.size, this.offsetY + 0.3 * this.size, 0.29 * this.size, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.WHITE), new Stop(1.0, Color.TRANSPARENT)});
        this.draw();
    }

    private void draw() {
        this.ctx.clearRect(0.0, 0.0, this.width, this.height);
        if (this.isFrameVisible()) {
            this.ctx.setFill((Paint)this.frameGradient);
            this.ctx.fillOval(this.offsetX, this.offsetY, this.size, this.size);
        }
        if (this.isOn()) {
            this.ctx.save();
            this.ctx.setEffect((Effect)this.ledOnShadow);
            this.ctx.setFill((Paint)this.ledOnGradient);
            this.ctx.fillOval(this.offsetX + 0.14 * this.size, this.offsetY + 0.14 * this.size, 0.72 * this.size, 0.72 * this.size);
            this.ctx.restore();
        } else {
            this.ctx.save();
            this.ctx.setEffect((Effect)this.ledOffShadow);
            this.ctx.setFill((Paint)this.ledOffGradient);
            this.ctx.fillOval(this.offsetX + 0.14 * this.size, this.offsetY + 0.14 * this.size, 0.72 * this.size, 0.72 * this.size);
            this.ctx.restore();
        }
        this.ctx.setFill((Paint)this.highlightGradient);
        this.ctx.fillOval(this.offsetX + 0.21 * this.size, this.offsetY + 0.21 * this.size, 0.58 * this.size, 0.58 * this.size);
    }
}

