/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.experimental.pushbutton.skin;

import eu.hansolo.enzo.experimental.pushbutton.PushButton;
import javafx.collections.ListChangeListener;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class PushButtonSkin
extends SkinBase<PushButton>
implements Skin<PushButton> {
    private static final double MINIMUM_WIDTH = 5.0;
    private static final double MINIMUM_HEIGHT = 5.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private static final double PREFERRED_WIDTH = 128.0;
    private static final double PREFERRED_HEIGHT = 128.0;
    private double aspectRatio = 1.0;
    private double size;
    private double width;
    private double height;
    private Pane pane = new Pane();
    private Region frame;
    private InnerShadow frameInnerShadow0;
    private InnerShadow frameInnerShadow1;
    private Region deselected;
    private InnerShadow deselectedInnerShadow0;
    private InnerShadow deselectedInnerShadow1;
    private DropShadow deselectedDropShadow;
    private Region selected;
    private InnerShadow selectedInnerShadow0;
    private InnerShadow selectedInnerShadow1;
    private DropShadow selectedDropShadow;
    private Region icon;

    public PushButtonSkin(PushButton CONTROL) {
        super((Control)CONTROL);
        this.init();
        this.initGraphics();
        this.registerListeners();
    }

    private void init() {
        if (Double.compare(((PushButton)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((PushButton)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((PushButton)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((PushButton)this.getSkinnable()).getHeight(), 0.0) <= 0) {
            if (((PushButton)this.getSkinnable()).getPrefWidth() > 0.0 && ((PushButton)this.getSkinnable()).getPrefHeight() > 0.0) {
                ((PushButton)this.getSkinnable()).setPrefSize(((PushButton)this.getSkinnable()).getPrefWidth(), ((PushButton)this.getSkinnable()).getPrefHeight());
            } else {
                ((PushButton)this.getSkinnable()).setPrefSize(128.0, 128.0);
            }
        }
        if (Double.compare(((PushButton)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((PushButton)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((PushButton)this.getSkinnable()).setMinSize(5.0, 5.0);
        }
        if (Double.compare(((PushButton)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((PushButton)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((PushButton)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
        if (((PushButton)this.getSkinnable()).getPrefWidth() != 128.0 || ((PushButton)this.getSkinnable()).getPrefHeight() != 128.0) {
            this.aspectRatio = ((PushButton)this.getSkinnable()).getPrefHeight() / ((PushButton)this.getSkinnable()).getPrefWidth();
        }
    }

    private void initGraphics() {
        this.frame = new Region();
        this.frame.getStyleClass().setAll((Object[])new String[]{"frame"});
        this.frameInnerShadow0 = new InnerShadow();
        this.frameInnerShadow0.setOffsetX(0.0);
        this.frameInnerShadow0.setOffsetY(1.0);
        this.frameInnerShadow0.setRadius(0.0);
        this.frameInnerShadow0.setColor(Color.web((String)"0x333333a6"));
        this.frameInnerShadow0.setBlurType(BlurType.TWO_PASS_BOX);
        this.frameInnerShadow1 = new InnerShadow();
        this.frameInnerShadow1.setOffsetX(0.0);
        this.frameInnerShadow1.setOffsetY(-1.0);
        this.frameInnerShadow1.setRadius(0.0);
        this.frameInnerShadow1.setColor(Color.web((String)"0xeeeeeea6"));
        this.frameInnerShadow1.setBlurType(BlurType.TWO_PASS_BOX);
        this.frameInnerShadow1.setInput((Effect)this.frameInnerShadow0);
        this.frame.setEffect((Effect)this.frameInnerShadow1);
        this.deselected = new Region();
        this.deselected.getStyleClass().setAll((Object[])new String[]{"deselected"});
        this.deselectedInnerShadow0 = new InnerShadow();
        this.deselectedInnerShadow0.setOffsetX(0.0);
        this.deselectedInnerShadow0.setOffsetY(-1.0);
        this.deselectedInnerShadow0.setRadius(0.0);
        this.deselectedInnerShadow0.setColor(Color.web((String)"0x4b4e52a6"));
        this.deselectedInnerShadow0.setBlurType(BlurType.TWO_PASS_BOX);
        this.deselectedInnerShadow1 = new InnerShadow();
        this.deselectedInnerShadow1.setOffsetX(0.0);
        this.deselectedInnerShadow1.setOffsetY(1.0);
        this.deselectedInnerShadow1.setRadius(0.0);
        this.deselectedInnerShadow1.setColor(Color.web((String)"0xeeeeeea6"));
        this.deselectedInnerShadow1.setBlurType(BlurType.TWO_PASS_BOX);
        this.deselectedInnerShadow1.setInput((Effect)this.deselectedInnerShadow0);
        this.deselectedDropShadow = new DropShadow();
        this.deselectedDropShadow.setOffsetX(0.0);
        this.deselectedDropShadow.setOffsetY(3.0);
        this.deselectedDropShadow.setRadius(3.0);
        this.deselectedDropShadow.setColor(Color.web((String)"0x000000a6"));
        this.deselectedDropShadow.setBlurType(BlurType.TWO_PASS_BOX);
        this.deselectedDropShadow.setInput((Effect)this.deselectedInnerShadow1);
        this.deselected.setEffect((Effect)this.deselectedDropShadow);
        this.selected = new Region();
        this.selected.getStyleClass().setAll((Object[])new String[]{"selected"});
        this.selectedInnerShadow0 = new InnerShadow();
        this.selectedInnerShadow0.setOffsetX(0.0);
        this.selectedInnerShadow0.setOffsetY(-1.0);
        this.selectedInnerShadow0.setRadius(0.0);
        this.selectedInnerShadow0.setColor(Color.web((String)"0x4b4e52a6"));
        this.selectedInnerShadow0.setBlurType(BlurType.TWO_PASS_BOX);
        this.selectedInnerShadow1 = new InnerShadow();
        this.selectedInnerShadow1.setOffsetX(0.0);
        this.selectedInnerShadow1.setOffsetY(1.0);
        this.selectedInnerShadow1.setRadius(0.0);
        this.selectedInnerShadow1.setColor(Color.web((String)"0xeeeeeea6"));
        this.selectedInnerShadow1.setBlurType(BlurType.TWO_PASS_BOX);
        this.selectedInnerShadow1.setInput((Effect)this.selectedInnerShadow0);
        this.selectedDropShadow = new DropShadow();
        this.selectedDropShadow.setOffsetX(0.0);
        this.selectedDropShadow.setOffsetY(0.0);
        this.selectedDropShadow.setRadius(2.0);
        this.selectedDropShadow.setColor(Color.web((String)"0x000000a6"));
        this.selectedDropShadow.setBlurType(BlurType.TWO_PASS_BOX);
        this.selectedDropShadow.setInput((Effect)this.selectedInnerShadow1);
        this.selected.setEffect((Effect)this.selectedDropShadow);
        this.icon = new Region();
        this.icon.getStyleClass().setAll((Object[])new String[]{"icon"});
        this.pane.getChildren().setAll((Object[])new Node[]{this.frame, this.deselected, this.selected, this.icon});
        this.updateStatus();
        this.getChildren().setAll((Object[])new Node[]{this.pane});
        this.resize();
    }

    private void registerListeners() {
        ((PushButton)this.getSkinnable()).widthProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((PushButton)this.getSkinnable()).heightProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((PushButton)this.getSkinnable()).prefWidthProperty().addListener(observable -> this.handleControlPropertyChanged("PREF_SIZE"));
        ((PushButton)this.getSkinnable()).prefHeightProperty().addListener(observable -> this.handleControlPropertyChanged("PREF_SIZE"));
        ((PushButton)this.getSkinnable()).statusProperty().addListener(observable -> this.handleControlPropertyChanged("STATUS"));
        ((PushButton)this.getSkinnable()).colorProperty().addListener(observable -> this.handleControlPropertyChanged("COLOR"));
        ((PushButton)this.getSkinnable()).getStyleClass().addListener((ListChangeListener)new ListChangeListener<String>(){

            public void onChanged(ListChangeListener.Change<? extends String> change) {
                PushButtonSkin.this.resize();
            }
        });
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        if ("RESIZE".equals(PROPERTY)) {
            this.resize();
        } else if ("STATUS".equals(PROPERTY)) {
            this.updateStatus();
        } else if ("COLOR".equals(PROPERTY)) {
            this.icon.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)((PushButton)this.getSkinnable()).getColor(), null, null)}));
            this.resize();
        }
    }

    protected double computeMinWidth(double HEIGHT, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        return super.computeMinWidth(Math.max(5.0, HEIGHT - TOP_INSET - BOTTOM_INSET), TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    protected double computeMinHeight(double WIDTH, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        return super.computeMinHeight(Math.max(5.0, WIDTH - LEFT_INSET - RIGHT_INSET), TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    protected double computeMaxWidth(double HEIGHT, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        return super.computeMaxWidth(Math.min(1024.0, HEIGHT - TOP_INSET - BOTTOM_INSET), TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    protected double computeMaxHeight(double WIDTH, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        return super.computeMaxHeight(Math.min(1024.0, WIDTH - LEFT_INSET - RIGHT_INSET), TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    protected double computePrefWidth(double HEIGHT, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        double prefHeight = 128.0;
        if (HEIGHT != -1.0) {
            prefHeight = Math.max(0.0, HEIGHT - TOP_INSET - BOTTOM_INSET);
        }
        return super.computePrefWidth(prefHeight, TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    protected double computePrefHeight(double WIDTH, double TOP_INSET, double RIGHT_INSET, double BOTTOM_INSET, double LEFT_INSET) {
        double prefWidth = 128.0;
        if (WIDTH != -1.0) {
            prefWidth = Math.max(0.0, WIDTH - LEFT_INSET - RIGHT_INSET);
        }
        return super.computePrefHeight(prefWidth, TOP_INSET, RIGHT_INSET, BOTTOM_INSET, LEFT_INSET);
    }

    private void updateStatus() {
        switch (((PushButton)this.getSkinnable()).getStatus()) {
            case DESELECTED: {
                this.selected.setOpacity(0.0);
                this.deselected.setOpacity(1.0);
                this.icon.getStyleClass().setAll((Object[])new String[]{"icon"});
                this.icon.setOpacity(1.0);
                break;
            }
            case SELECTED: {
                this.selected.setOpacity(1.0);
                this.deselected.setOpacity(0.0);
                this.icon.getStyleClass().setAll((Object[])new String[]{"icon", "icon-selected"});
                this.icon.setOpacity(1.0);
                break;
            }
            default: {
                this.selected.setOpacity(0.0);
                this.deselected.setOpacity(0.0);
                this.icon.setOpacity(0.0);
            }
        }
    }

    private void resize() {
        this.size = ((PushButton)this.getSkinnable()).getWidth() < ((PushButton)this.getSkinnable()).getHeight() ? ((PushButton)this.getSkinnable()).getWidth() : ((PushButton)this.getSkinnable()).getHeight();
        this.width = ((PushButton)this.getSkinnable()).getWidth();
        this.height = ((PushButton)this.getSkinnable()).getHeight();
        if (((PushButton)this.getSkinnable()).isKeepAspect()) {
            if (this.aspectRatio * this.width > this.height) {
                this.width = 1.0 / (this.aspectRatio / this.height);
            } else if (1.0 / (this.aspectRatio / this.height) > this.width) {
                this.height = this.aspectRatio * this.width;
            }
        }
        if (this.width > 0.0 && this.height > 0.0) {
            this.frame.setPrefSize(this.width, this.height);
            this.deselected.setPrefSize(0.6875 * this.width, 0.6875 * this.height);
            this.deselected.setTranslateX(0.15625 * this.width);
            this.deselected.setTranslateY(0.15625 * this.height);
            this.deselectedDropShadow.setRadius(0.0234375 * this.size);
            this.selected.setPrefSize(0.6875 * this.width, 0.6796875 * this.height);
            this.selected.setTranslateX(0.15625 * this.width);
            this.selected.setTranslateY(0.15625 * this.height);
            this.selectedDropShadow.setRadius(0.015625 * this.size);
            this.icon.setPrefSize(0.375 * this.width, 0.4375 * this.height);
            this.icon.setTranslateX(0.3125 * this.width);
            this.icon.setTranslateY(0.28125 * this.height);
        }
    }
}

