/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.flippanel;

import eu.hansolo.enzo.flippanel.FlipEvent;
import eu.hansolo.enzo.flippanel.FlipPanel;
import javafx.application.Application;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Camera;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.PerspectiveCamera;
import javafx.scene.Scene;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;

public class Demo
extends Application {
    private FlipPanel flipPanel;
    private StackPane frontPanel;

    public void init() {
        this.frontPanel = new StackPane();
        this.frontPanel.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.AQUAMARINE, CornerRadii.EMPTY, Insets.EMPTY)}));
        this.flipPanel = new FlipPanel(Orientation.VERTICAL);
        this.flipPanel.getFront().getChildren().add((Object)this.initFront(this.flipPanel, this.frontPanel));
        this.flipPanel.getBack().getChildren().add((Object)this.initBack(this.flipPanel, this.frontPanel));
        this.flipPanel.addEventHandler(FlipEvent.FLIP_TO_FRONT_FINISHED, event -> System.out.println("Flip to front finished"));
        this.flipPanel.addEventHandler(FlipEvent.FLIP_TO_BACK_FINISHED, event -> System.out.println("Flip to back finished"));
    }

    private Pane initFront(FlipPanel FLIP_PANEL, StackPane FRONT_PANEL) {
        Region settingsButton = new Region();
        settingsButton.getStyleClass().add((Object)"settings-button");
        settingsButton.addEventHandler(MouseEvent.MOUSE_CLICKED, EVENT -> FLIP_PANEL.flipToBack());
        VBox componentsFront = new VBox(new Node[]{settingsButton, FRONT_PANEL});
        componentsFront.setSpacing(10.0);
        VBox.setVgrow((Node)FRONT_PANEL, (Priority)Priority.ALWAYS);
        StackPane front = new StackPane();
        front.setPadding(new Insets(20.0, 20.0, 20.0, 20.0));
        front.getStyleClass().add((Object)"panel");
        front.getChildren().addAll((Object[])new Node[]{componentsFront});
        return front;
    }

    private Pane initBack(FlipPanel flipPanel, StackPane FRONT_PANEL) {
        Region backButton = new Region();
        backButton.getStyleClass().add((Object)"back-button");
        backButton.addEventHandler(MouseEvent.MOUSE_CLICKED, EVENT -> flipPanel.flipToFront());
        ToggleGroup group = new ToggleGroup();
        RadioButton standardGreen = new RadioButton("Green");
        standardGreen.setToggleGroup(group);
        standardGreen.setSelected(true);
        standardGreen.setOnAction(event -> FRONT_PANEL.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.GREEN, CornerRadii.EMPTY, Insets.EMPTY)})));
        RadioButton amber = new RadioButton("Red");
        amber.setToggleGroup(group);
        amber.setOnAction(event -> FRONT_PANEL.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.RED, CornerRadii.EMPTY, Insets.EMPTY)})));
        RadioButton blueDarkBlue = new RadioButton("Blue");
        blueDarkBlue.setToggleGroup(group);
        blueDarkBlue.setOnAction(event -> FRONT_PANEL.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.BLUE, CornerRadii.EMPTY, Insets.EMPTY)})));
        VBox componentsBack = new VBox(new Node[]{backButton, standardGreen, amber, blueDarkBlue});
        componentsBack.setSpacing(10.0);
        StackPane back = new StackPane();
        back.setPadding(new Insets(20.0, 20.0, 20.0, 20.0));
        back.getStyleClass().add((Object)"panel");
        back.getChildren().addAll((Object[])new Node[]{componentsBack});
        return back;
    }

    public void start(Stage stage) {
        BorderPane pane = new BorderPane((Node)this.flipPanel);
        pane.setPrefSize(400.0, 250.0);
        pane.setPadding(new Insets(50.0, 50.0, 50.0, 50.0));
        pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.rgb((int)68, (int)68, (int)68), CornerRadii.EMPTY, Insets.EMPTY)}));
        PerspectiveCamera camera = new PerspectiveCamera(false);
        camera.setFieldOfView(20.0);
        Scene scene = new Scene((Parent)pane);
        scene.setCamera((Camera)camera);
        scene.getStylesheets().add((Object)Demo.class.getResource("styles.css").toExternalForm());
        stage.setTitle("FlipPanel Demo");
        stage.setScene(scene);
        stage.show();
    }

    public void stop() {
    }

    public static void main(String[] args) {
        Demo.launch((String[])args);
    }
}

