/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.gauge;

import eu.hansolo.enzo.common.GradientLookup;
import eu.hansolo.enzo.fonts.Fonts;
import eu.hansolo.enzo.gauge.skin.AvGaugeSkin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.WritableValue;
import javafx.css.CssMetaData;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;
import javafx.scene.text.Text;
import javafx.util.Duration;

public class AvGauge
extends Control {
    private static final double PREFERRED_WIDTH = 300.0;
    private static final double PREFERRED_HEIGHT = 300.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private static final Color DEFAULT_OUTER_BAR_COLOR = Color.web((String)"#a71037");
    private static final Color DEFAULT_INNER_BAR_COLOR = Color.web((String)"#f06185");
    private static final Color DEFAULT_BACKGROUND_COLOR = Color.web((String)"#414141");
    private static final Color DEFAULT_OUTER_VALUE_TEXT_COLOR = Color.web((String)"#ffffff");
    private static final Color DEFAULT_INNER_VALUE_TEXT_COLOR = Color.web((String)"#ffffff");
    private static final Color DEFAULT_TITLE_TEXT_COLOR = Color.web((String)"#ffffff");
    private static final Color DEFAULT_BORDER_COLOR = Color.web((String)"#414141");
    private static final Color DEFAULT_SEPARATOR_COLOR = Color.web((String)"#ffffff");
    private double size;
    private double width;
    private double height;
    private Circle border;
    private Arc outerBar;
    private Arc innerBar;
    private Line separator;
    private Circle background;
    private Text outerValueText;
    private Text innerValueText;
    private Text titleText;
    private Pane pane;
    private double range;
    private double angleStep;
    private int decimals;
    private int animationDurationInMs;
    private boolean multiColor;
    private DoubleProperty minValue;
    private DoubleProperty maxValue;
    private DoubleProperty outerValue;
    private DoubleProperty outerCurrentValue;
    private DoubleProperty innerValue;
    private DoubleProperty innerCurrentValue;
    private StringProperty title;
    private ObjectProperty<Paint> outerBarColor;
    private ObjectProperty<Paint> innerBarColor;
    private ObjectProperty<Paint> backgroundColor;
    private ObjectProperty<Paint> outerValueTextColor;
    private ObjectProperty<Paint> innerValueTextColor;
    private ObjectProperty<Paint> titleTextColor;
    private ObjectProperty<Paint> borderColor;
    private ObjectProperty<Paint> separatorColor;
    private Timeline outerBarTimeline;
    private Timeline innerBarTimeline;
    private GradientLookup outerGradientLookup;
    private GradientLookup innerGradientLookup;

    public AvGauge() {
        this.getStylesheets().add((Object)AvGauge.class.getResource("avgauge.css").toExternalForm());
        this.getStyleClass().setAll((Object[])new String[]{"av-gauge"});
        this.range = 100.0;
        this.angleStep = 360.0 / this.range;
        this.decimals = 0;
        this.animationDurationInMs = 500;
        this.minValue = new DoublePropertyBase(0.0){

            public void set(double VALUE) {
                if (VALUE > AvGauge.this.maxValue.get()) {
                    AvGauge.this.maxValue.set(VALUE + 0.1);
                }
                double v = AvGauge.this.clamp(-1.7976931348623157E308, AvGauge.this.maxValue.get() - 0.1, VALUE);
                super.set(v);
            }

            public Object getBean() {
                return AvGauge.this;
            }

            public String getName() {
                return "minValue";
            }
        };
        this.maxValue = new DoublePropertyBase(100.0){

            public void set(double VALUE) {
                if (VALUE < AvGauge.this.minValue.get()) {
                    AvGauge.this.minValue.set(VALUE - 0.1);
                }
                double v = AvGauge.this.clamp(AvGauge.this.minValue.get() + 0.1, Double.MAX_VALUE, VALUE);
                super.set(v);
            }

            public Object getBean() {
                return AvGauge.this;
            }

            public String getName() {
                return "maxBarValue";
            }
        };
        this.outerValue = new DoublePropertyBase(this.minValue.get()){

            public void set(double VALUE) {
                super.set(AvGauge.this.clamp(AvGauge.this.minValue.get(), AvGauge.this.maxValue.get(), VALUE));
            }

            public Object getBean() {
                return AvGauge.this;
            }

            public String getName() {
                return "outerValue";
            }
        };
        this.outerCurrentValue = new SimpleDoubleProperty((Object)this, "outerCurrentValue", 0.0);
        this.innerValue = new DoublePropertyBase(this.minValue.get()){

            public void set(double VALUE) {
                super.set(AvGauge.this.clamp(AvGauge.this.minValue.get(), AvGauge.this.maxValue.get(), VALUE));
            }

            public Object getBean() {
                return AvGauge.this;
            }

            public String getName() {
                return "innerValue";
            }
        };
        this.innerCurrentValue = new SimpleDoubleProperty((Object)this, "innerCurrentValue", 0.0);
        this.title = new SimpleStringProperty((Object)this, "title", "");
        this.outerBarColor = new StyleableObjectProperty<Paint>((Paint)DEFAULT_OUTER_BAR_COLOR){

            public CssMetaData getCssMetaData() {
                return StyleableProperties.OUTER_BAR_COLOR;
            }

            public Object getBean() {
                return AvGauge.this;
            }

            public String getName() {
                return "outerBarColor";
            }
        };
        this.innerBarColor = new StyleableObjectProperty<Paint>((Paint)DEFAULT_INNER_BAR_COLOR){

            public CssMetaData getCssMetaData() {
                return StyleableProperties.INNER_BAR_COLOR;
            }

            public Object getBean() {
                return AvGauge.this;
            }

            public String getName() {
                return "innerBarColor";
            }
        };
        this.backgroundColor = new StyleableObjectProperty<Paint>((Paint)DEFAULT_BACKGROUND_COLOR){

            public CssMetaData getCssMetaData() {
                return StyleableProperties.BACKGROUND_COLOR;
            }

            public Object getBean() {
                return AvGauge.this;
            }

            public String getName() {
                return "backgroundColor";
            }
        };
        this.outerValueTextColor = new StyleableObjectProperty<Paint>((Paint)DEFAULT_OUTER_VALUE_TEXT_COLOR){

            public CssMetaData getCssMetaData() {
                return StyleableProperties.OUTER_VALUE_TEXT_COLOR;
            }

            public Object getBean() {
                return AvGauge.this;
            }

            public String getName() {
                return "outerValueTextColor";
            }
        };
        this.innerValueTextColor = new StyleableObjectProperty<Paint>((Paint)DEFAULT_INNER_VALUE_TEXT_COLOR){

            public CssMetaData getCssMetaData() {
                return StyleableProperties.INNER_VALUE_TEXT_COLOR;
            }

            public Object getBean() {
                return AvGauge.this;
            }

            public String getName() {
                return "innerValueTextColor";
            }
        };
        this.titleTextColor = new StyleableObjectProperty<Paint>((Paint)DEFAULT_TITLE_TEXT_COLOR){

            public CssMetaData getCssMetaData() {
                return StyleableProperties.TITLE_TEXT_COLOR;
            }

            public Object getBean() {
                return AvGauge.this;
            }

            public String getName() {
                return "titleTextColor";
            }
        };
        this.borderColor = new StyleableObjectProperty<Paint>((Paint)DEFAULT_BORDER_COLOR){

            public CssMetaData getCssMetaData() {
                return StyleableProperties.BORDER_COLOR;
            }

            public Object getBean() {
                return AvGauge.this;
            }

            public String getName() {
                return "borderColor";
            }
        };
        this.separatorColor = new StyleableObjectProperty<Paint>((Paint)DEFAULT_SEPARATOR_COLOR){

            public CssMetaData getCssMetaData() {
                return StyleableProperties.SEPARATOR_COLOR;
            }

            public Object getBean() {
                return AvGauge.this;
            }

            public String getName() {
                return "separatorColor";
            }
        };
        this.outerBarTimeline = new Timeline();
        this.innerBarTimeline = new Timeline();
        this.multiColor = false;
        this.outerGradientLookup = new GradientLookup(new Stop(0.0, Color.BLUE), new Stop(0.2, Color.CYAN), new Stop(0.4, Color.LIME), new Stop(0.6, Color.YELLOW), new Stop(0.8, Color.ORANGE), new Stop(1.0, Color.RED));
        this.innerGradientLookup = new GradientLookup(new Stop(0.0, Color.BLUE), new Stop(0.2, Color.CYAN), new Stop(0.4, Color.LIME), new Stop(0.6, Color.YELLOW), new Stop(0.8, Color.ORANGE), new Stop(1.0, Color.RED));
        this.init();
        this.initGraphics();
        this.registerListeners();
    }

    private void init() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(300.0, 300.0);
            }
        }
        if (Double.compare(this.getMinWidth(), 0.0) <= 0 || Double.compare(this.getMinHeight(), 0.0) <= 0) {
            this.setMinSize(50.0, 50.0);
        }
        if (Double.compare(this.getMaxWidth(), 0.0) <= 0 || Double.compare(this.getMaxHeight(), 0.0) <= 0) {
            this.setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.border = new Circle(150.0, 150.0, 150.0);
        this.border.setFill((Paint)Color.TRANSPARENT);
        this.border.setStroke((Paint)this.borderColor.get());
        this.outerBar = new Arc(150.0, 150.0, 150.0, 150.0, 90.0, 0.0);
        this.outerBar.setType(ArcType.ROUND);
        this.outerBar.setFill((Paint)this.outerBarColor.get());
        this.innerBar = new Arc(150.0, 124.9995, 150.0, 124.9995, 90.0, 0.0);
        this.innerBar.setType(ArcType.ROUND);
        this.innerBar.setFill((Paint)this.innerBarColor.get());
        this.separator = new Line(150.0, 1.0, 150.0, 50.001000000000005);
        this.separator.setStroke((Paint)this.separatorColor.get());
        this.separator.setFill((Paint)Color.TRANSPARENT);
        this.background = new Circle(150.0, 150.0, 100.0005);
        this.background.setFill((Paint)this.backgroundColor.get());
        this.outerValueText = new Text(String.format(Locale.US, "%." + this.decimals + "f", this.getOuterValue()));
        this.outerValueText.setFont(Fonts.latoLight(81.99900000000001));
        this.outerValueText.setFill((Paint)this.outerValueTextColor.get());
        this.innerValueText = new Text(String.format(Locale.US, "%." + this.decimals + "f", this.getInnerValue()));
        this.innerValueText.setFont(Fonts.latoLight(24.0));
        this.innerValueText.setFill((Paint)this.innerValueTextColor.get());
        this.titleText = new Text("");
        this.titleText.setFont(Fonts.latoLight(24.0));
        this.titleText.setFill((Paint)this.titleTextColor.get());
        this.pane = new Pane();
        this.pane.getChildren().setAll((Object[])new Node[]{this.border, this.outerBar, this.innerBar, this.separator, this.background, this.outerValueText, this.innerValueText, this.titleText});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
        this.outerValue.addListener(o -> this.handleControlPropertyChanged("OUTER_VALUE"));
        this.outerCurrentValue.addListener(o -> this.handleControlPropertyChanged("OUTER_CURRENT_VALUE"));
        this.innerValue.addListener(o -> this.handleControlPropertyChanged("INNER_VALUE"));
        this.innerCurrentValue.addListener(o -> this.handleControlPropertyChanged("INNER_CURRENT_VALUE"));
        this.title.addListener(o -> this.handleControlPropertyChanged("TITLE"));
        this.outerBarColor.addListener(o -> this.handleControlPropertyChanged("OUTER_BAR_COLOR"));
        this.innerBarColor.addListener(o -> this.handleControlPropertyChanged("INNER_BAR_COLOR"));
        this.backgroundColor.addListener(o -> this.handleControlPropertyChanged("BACKGROUND_COLOR"));
        this.outerValueTextColor.addListener(o -> this.handleControlPropertyChanged("OUTER_VALUE_TEXT_COLOR"));
        this.innerValueTextColor.addListener(o -> this.handleControlPropertyChanged("INNER_VALUE_TEXT_COLOR"));
        this.titleTextColor.addListener(o -> this.handleControlPropertyChanged("TEXT_COLOR"));
        this.borderColor.addListener(o -> this.handleControlPropertyChanged("BORDER_COLOR"));
        this.separatorColor.addListener(o -> this.handleControlPropertyChanged("SEPARATOR_COLOR"));
    }

    private void handleControlPropertyChanged(String PROPERTY) {
        if ("OUTER_VALUE".equals(PROPERTY)) {
            this.outerBarTimeline.stop();
            this.range = this.maxValue.get() - this.minValue.get();
            this.angleStep = 360.0 / this.range;
            this.outerCurrentValue.set(this.clamp(this.minValue.get(), this.maxValue.get(), this.outerCurrentValue.get()));
            KeyValue KV_START = new KeyValue((WritableValue)this.outerCurrentValue, (Object)this.outerCurrentValue.get(), Interpolator.EASE_BOTH);
            KeyValue KV_STOP = new KeyValue((WritableValue)this.outerCurrentValue, (Object)this.outerValue.get(), Interpolator.EASE_BOTH);
            KeyFrame KF_START = new KeyFrame(Duration.ZERO, new KeyValue[]{KV_START});
            KeyFrame KF_STOP = new KeyFrame(Duration.millis((double)this.animationDurationInMs), new KeyValue[]{KV_STOP});
            this.outerBarTimeline.getKeyFrames().setAll((Object[])new KeyFrame[]{KF_START, KF_STOP});
            this.outerBarTimeline.play();
        } else if ("INNER_VALUE".equals(PROPERTY)) {
            this.innerBarTimeline.stop();
            this.range = this.maxValue.get() - this.minValue.get();
            this.angleStep = 360.0 / this.range;
            this.innerCurrentValue.set(this.clamp(this.minValue.get(), this.maxValue.get(), this.innerCurrentValue.get()));
            KeyValue KV_START = new KeyValue((WritableValue)this.innerCurrentValue, (Object)this.innerCurrentValue.get(), Interpolator.EASE_BOTH);
            KeyValue KV_STOP = new KeyValue((WritableValue)this.innerCurrentValue, (Object)this.innerValue.get(), Interpolator.EASE_BOTH);
            KeyFrame KF_START = new KeyFrame(Duration.ZERO, new KeyValue[]{KV_START});
            KeyFrame KF_STOP = new KeyFrame(Duration.millis((double)this.animationDurationInMs), new KeyValue[]{KV_STOP});
            this.innerBarTimeline.getKeyFrames().setAll((Object[])new KeyFrame[]{KF_START, KF_STOP});
            this.innerBarTimeline.play();
        } else if ("OUTER_CURRENT_VALUE".equals(PROPERTY)) {
            this.setOuterBar(this.outerCurrentValue.get());
        } else if ("INNER_CURRENT_VALUE".equals(PROPERTY)) {
            this.setInnerBar(this.innerCurrentValue.get());
        } else if ("TITLE".equals(PROPERTY)) {
            this.titleText.setText((String)this.title.get());
            this.adjustTitleTextSize();
        } else if ("OUTER_BAR_COLOR".equals(PROPERTY)) {
            this.outerBar.setFill((Paint)this.outerBarColor.get());
        } else if ("INNER_BAR_COLOR".equals(PROPERTY)) {
            this.innerBar.setFill((Paint)this.innerBarColor.get());
        } else if ("BACKGROUND_COLOR".equals(PROPERTY)) {
            this.background.setFill((Paint)this.backgroundColor.get());
        } else if ("OUTER_VALUE_TEXT_COLOR".equals(PROPERTY)) {
            this.outerValueText.setFill((Paint)this.outerValueTextColor.get());
        } else if ("INNER_VALUE_TEXT_COLOR".equals(PROPERTY)) {
            this.innerValueText.setFill((Paint)this.innerValueTextColor.get());
        } else if ("TEXT_COLOR".equals(PROPERTY)) {
            this.titleText.setFill((Paint)this.titleTextColor.get());
        } else if ("BORDER_COLOR".equals(PROPERTY)) {
            this.border.setStroke((Paint)this.borderColor.get());
        } else if ("SEPARATOR_COLOR".equals(PROPERTY)) {
            this.separator.setStroke((Paint)this.separatorColor.get());
        }
    }

    public double getMinValue() {
        return this.minValue.get();
    }

    public void setMinValue(double MIN_VALUE) {
        this.minValue.set(MIN_VALUE);
    }

    public DoubleProperty minValueProperty() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue.get();
    }

    public void setMaxValue(double MAX_VALUE) {
        this.maxValue.set(MAX_VALUE);
    }

    public DoubleProperty maxValueProperty() {
        return this.maxValue;
    }

    public double getOuterValue() {
        return this.outerValue.get();
    }

    public void setOuterValue(double OUTER_VALUE) {
        this.outerValue.set(OUTER_VALUE);
    }

    public DoubleProperty outerValueProperty() {
        return this.outerValue;
    }

    public ReadOnlyDoubleProperty outerCurrentValueProperty() {
        return this.outerCurrentValue;
    }

    public double getInnerValue() {
        return this.innerValue.get();
    }

    public void setInnerValue(double INNER_VALUE) {
        this.innerValue.set(INNER_VALUE);
    }

    public DoubleProperty innerValueProperty() {
        return this.innerValue;
    }

    public ReadOnlyDoubleProperty innerCurrentValueProperty() {
        return this.innerCurrentValue;
    }

    public String getTitle() {
        return (String)this.title.get();
    }

    public void setTitle(String TITLE) {
        this.title.set((Object)TITLE);
    }

    public StringProperty titleProperty() {
        return this.title;
    }

    public Paint getOuterBarColor() {
        return (Paint)this.outerBarColor.get();
    }

    public void setOuterBarColor(Color OUTER_BAR_COLOR) {
        if (this.multiColor) {
            return;
        }
        this.outerBarColor.set((Object)OUTER_BAR_COLOR);
    }

    public ObjectProperty<Paint> outerBarColorProperty() {
        return this.outerBarColor;
    }

    public Paint getInnerBarColor() {
        return (Paint)this.innerBarColor.get();
    }

    public void setInnerBarColor(Color INNER_BAR_COLOR) {
        if (this.multiColor) {
            return;
        }
        this.innerBarColor.set((Object)INNER_BAR_COLOR);
    }

    public ObjectProperty<Paint> innerBarColorProperty() {
        return this.innerBarColor;
    }

    public Paint getBackgroundColor() {
        return (Paint)this.backgroundColor.get();
    }

    public void setBackgroundColor(Color BACKGROUND_COLOR) {
        this.backgroundColor.set((Object)BACKGROUND_COLOR);
    }

    public ObjectProperty<Paint> backgroundColorProperty() {
        return this.backgroundColor;
    }

    public Paint getOuterValueTextColor() {
        return (Paint)this.outerValueTextColor.get();
    }

    public void setOuterValueTextColor(Color OUTER_VALUE_TEXT_COLOR) {
        this.outerValueTextColor.set((Object)OUTER_VALUE_TEXT_COLOR);
    }

    public ObjectProperty<Paint> outerValueTextColorProperty() {
        return this.outerValueTextColor;
    }

    public Paint getInnerValueTextColor() {
        return (Paint)this.innerValueTextColor.get();
    }

    public void setInnerValueTextColor(Color INNER_VALUE_TEXT_COLOR) {
        this.innerValueTextColor.set((Object)INNER_VALUE_TEXT_COLOR);
    }

    public ObjectProperty<Paint> innerValueTextColorProperty() {
        return this.innerValueTextColor;
    }

    public Paint getTitleTextColor() {
        return (Paint)this.titleTextColor.get();
    }

    public void setTitleTextColor(Color TITLE_TEXT_COLOR) {
        this.titleTextColor.set((Object)TITLE_TEXT_COLOR);
    }

    public ObjectProperty<Paint> titleTextColorProperty() {
        return this.titleTextColor;
    }

    public Paint getBorderColor() {
        return (Paint)this.borderColor.get();
    }

    public void setBorderColor(Color BORDER_COLOR) {
        this.borderColor.set((Object)BORDER_COLOR);
    }

    public ObjectProperty<Paint> borderColorProperty() {
        return this.borderColor;
    }

    public Paint getSeparatorColor() {
        return (Paint)this.separatorColor.get();
    }

    public void setSeparatorColor(Color SEPARATOR_COLOR) {
        this.separatorColor.set((Object)SEPARATOR_COLOR);
    }

    public ObjectProperty<Paint> separatorColorProperty() {
        return this.separatorColor;
    }

    public void setOuterGradient(Stop ... STOPS) {
        this.outerGradientLookup.setStops(STOPS);
    }

    public void setInnerGradient(Stop ... STOPS) {
        this.innerGradientLookup.setStops(STOPS);
    }

    public void setDecimals(int DECIMALS) {
        this.decimals = this.clamp(0, 3, DECIMALS);
        this.adjustOuterValueTextSize();
        this.adjustInnerValueTextSize();
    }

    public int getAnimationDurationInMs() {
        return this.animationDurationInMs;
    }

    public void setAnimationDurationInMs(int ANIMATION_DURATION_IN_MS) {
        this.animationDurationInMs = this.clamp(1, 10000, ANIMATION_DURATION_IN_MS);
    }

    public boolean isMultiColor() {
        return this.multiColor;
    }

    public void setMultiColor(boolean MULTI_COLOR) {
        this.multiColor = MULTI_COLOR;
        if (this.multiColor) {
            return;
        }
        this.outerBar.setFill((Paint)this.outerBarColor.get());
        this.innerBar.setFill((Paint)this.innerBarColor.get());
    }

    private void setOuterBar(double VALUE) {
        if (this.multiColor) {
            this.outerBar.setFill((Paint)this.outerGradientLookup.getColorAt((VALUE - this.minValue.get()) / this.range));
        }
        if (this.minValue.get() > 0.0) {
            this.outerBar.setLength((VALUE - this.minValue.get()) * -1.0 * this.angleStep);
        } else if (VALUE < 0.0) {
            this.outerBar.setLength((-VALUE + this.minValue.get()) * this.angleStep);
        } else {
            this.outerBar.setLength((this.minValue.get() - VALUE) * this.angleStep);
        }
        this.outerValueText.setText(String.format(Locale.US, "%." + this.decimals + "f", VALUE));
        this.adjustOuterValueTextSize();
    }

    private void setInnerBar(double VALUE) {
        if (this.multiColor) {
            this.innerBar.setFill((Paint)this.innerGradientLookup.getColorAt((VALUE - this.minValue.get()) / this.range));
        }
        if (this.minValue.get() > 0.0) {
            this.innerBar.setLength((VALUE - this.minValue.get()) * -1.0 * this.angleStep);
        } else if (VALUE < 0.0) {
            this.innerBar.setLength((-VALUE + this.minValue.get()) * this.angleStep);
        } else {
            this.innerBar.setLength((this.minValue.get() - VALUE) * this.angleStep);
        }
        this.innerValueText.setText(String.format(Locale.US, "%." + this.decimals + "f", VALUE));
        this.adjustInnerValueTextSize();
    }

    private void adjustOuterValueTextSize() {
        this.outerValueText.setFont(Fonts.latoLight(this.size * 0.23677));
        double decrement = 0.0;
        while (this.outerValueText.getLayoutBounds().getWidth() > 0.5 * this.size && this.outerValueText.getFont().getSize() > 0.0) {
            this.outerValueText.setFont(Fonts.latoLight(this.size * (0.23677 - decrement)));
            decrement += 0.01;
        }
        this.outerValueText.relocate((this.size - this.outerValueText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.23667);
    }

    private void adjustInnerValueTextSize() {
        this.innerValueText.setFont(Fonts.latoLight(this.size * 0.08));
        double decrement = 0.0;
        while (this.innerValueText.getLayoutBounds().getWidth() > 0.41333 * this.size && this.innerValueText.getFont().getSize() > 0.0) {
            this.innerValueText.setFont(Fonts.latoLight(this.size * (0.08 - decrement)));
            decrement += 0.01;
        }
        this.innerValueText.relocate((this.size - this.innerValueText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.66667);
    }

    private void adjustTitleTextSize() {
        this.titleText.setFont(Fonts.latoLight(this.size * 0.08));
        double decrement = 0.0;
        while (this.titleText.getLayoutBounds().getWidth() > 0.56667 * this.size && this.titleText.getFont().getSize() > 0.0) {
            this.titleText.setFont(Fonts.latoLight(this.size * (0.08 - decrement)));
            decrement += 0.01;
        }
        this.titleText.relocate((this.size - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.55333);
    }

    private String colorToCss(Color COLOR) {
        return COLOR.toString().replace("0x", "#");
    }

    private double clamp(double MIN_VALUE, double MAX_VALUE, double VALUE) {
        if (VALUE < MIN_VALUE) {
            return MIN_VALUE;
        }
        if (VALUE > MAX_VALUE) {
            return MAX_VALUE;
        }
        return VALUE;
    }

    private int clamp(int MIN_VALUE, int MAX_VALUE, int VALUE) {
        if (VALUE < MIN_VALUE) {
            return MIN_VALUE;
        }
        if (VALUE > MAX_VALUE) {
            return MAX_VALUE;
        }
        return VALUE;
    }

    protected Skin createDefaultSkin() {
        return new AvGaugeSkin(this);
    }

    public String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("avgauge.css").toExternalForm();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return AvGauge.getClassCssMetaData();
    }

    private void resize() {
        this.width = this.getWidth();
        this.height = this.getHeight();
        double d = this.size = this.width < this.height ? this.width : this.height;
        if (this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.size, this.size);
            this.pane.relocate((this.width - this.size) * 0.5, (this.height - this.size) * 0.5);
            this.border.setCenterX(this.size * 0.5);
            this.border.setCenterY(this.size * 0.5);
            this.border.setRadius(this.size * 0.5);
            this.outerBar.setCenterX(this.size * 0.5);
            this.outerBar.setCenterY(this.size * 0.5);
            this.outerBar.setRadiusX(this.size * 0.5);
            this.outerBar.setRadiusY(this.size * 0.5);
            this.innerBar.setCenterX(this.size * 0.5);
            this.innerBar.setCenterY(this.size * 0.5);
            this.innerBar.setRadiusX(this.size * 0.83333 * 0.5);
            this.innerBar.setRadiusY(this.size * 0.83333 * 0.5);
            this.separator.setStartX(this.size * 0.5);
            this.separator.setStartY(1.0);
            this.separator.setEndX(this.size * 0.5);
            this.separator.setEndY(this.size * 0.16667);
            this.background.setCenterX(this.size * 0.5);
            this.background.setCenterY(this.size * 0.5);
            this.background.setRadius(this.size * 0.66667 * 0.5);
            this.adjustOuterValueTextSize();
            this.adjustInnerValueTextSize();
            this.adjustTitleTextSize();
        }
    }

    static /* synthetic */ Color access$1100() {
        return DEFAULT_OUTER_BAR_COLOR;
    }

    static /* synthetic */ Color access$1300() {
        return DEFAULT_INNER_BAR_COLOR;
    }

    static /* synthetic */ Color access$1500() {
        return DEFAULT_BACKGROUND_COLOR;
    }

    static /* synthetic */ Color access$1700() {
        return DEFAULT_OUTER_VALUE_TEXT_COLOR;
    }

    static /* synthetic */ Color access$1900() {
        return DEFAULT_INNER_VALUE_TEXT_COLOR;
    }

    static /* synthetic */ Color access$2100() {
        return DEFAULT_TITLE_TEXT_COLOR;
    }

    static /* synthetic */ Color access$2300() {
        return DEFAULT_BORDER_COLOR;
    }

    static /* synthetic */ Color access$2500() {
        return DEFAULT_SEPARATOR_COLOR;
    }

    private static class StyleableProperties {
        private static final CssMetaData<AvGauge, Paint> OUTER_BAR_COLOR = new CssMetaData<AvGauge, Paint>("-outer-bar-color", StyleConverter.getPaintConverter(), (Paint)AvGauge.access$1100()){

            public boolean isSettable(AvGauge node) {
                return null == node.outerBarColor || !node.outerBarColor.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(AvGauge node) {
                return (StyleableProperty)node.outerBarColorProperty();
            }

            public Paint getInitialValue(AvGauge node) {
                return node.getOuterBarColor();
            }
        };
        private static final CssMetaData<AvGauge, Paint> INNER_BAR_COLOR = new CssMetaData<AvGauge, Paint>("-inner-bar-color", StyleConverter.getPaintConverter(), (Paint)AvGauge.access$1300()){

            public boolean isSettable(AvGauge node) {
                return null == node.innerBarColor || !node.innerBarColor.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(AvGauge node) {
                return (StyleableProperty)node.innerBarColorProperty();
            }

            public Paint getInitialValue(AvGauge node) {
                return node.getInnerBarColor();
            }
        };
        private static final CssMetaData<AvGauge, Paint> BACKGROUND_COLOR = new CssMetaData<AvGauge, Paint>("-background-color", StyleConverter.getPaintConverter(), (Paint)AvGauge.access$1500()){

            public boolean isSettable(AvGauge node) {
                return null == node.backgroundColor || !node.backgroundColor.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(AvGauge node) {
                return (StyleableProperty)node.backgroundColorProperty();
            }

            public Paint getInitialValue(AvGauge node) {
                return node.getBackgroundColor();
            }
        };
        private static final CssMetaData<AvGauge, Paint> OUTER_VALUE_TEXT_COLOR = new CssMetaData<AvGauge, Paint>("-outer-value-text-color", StyleConverter.getPaintConverter(), (Paint)AvGauge.access$1700()){

            public boolean isSettable(AvGauge node) {
                return null == node.outerValueTextColor || !node.outerValueTextColor.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(AvGauge node) {
                return (StyleableProperty)node.outerValueTextColorProperty();
            }

            public Paint getInitialValue(AvGauge node) {
                return node.getOuterValueTextColor();
            }
        };
        private static final CssMetaData<AvGauge, Paint> INNER_VALUE_TEXT_COLOR = new CssMetaData<AvGauge, Paint>("-inner-value-text-color", StyleConverter.getPaintConverter(), (Paint)AvGauge.access$1900()){

            public boolean isSettable(AvGauge node) {
                return null == node.innerValueTextColor || !node.innerValueTextColor.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(AvGauge node) {
                return (StyleableProperty)node.innerValueTextColorProperty();
            }

            public Paint getInitialValue(AvGauge node) {
                return node.getInnerValueTextColor();
            }
        };
        private static final CssMetaData<AvGauge, Paint> TITLE_TEXT_COLOR = new CssMetaData<AvGauge, Paint>("-title-text-color", StyleConverter.getPaintConverter(), (Paint)AvGauge.access$2100()){

            public boolean isSettable(AvGauge node) {
                return null == node.titleTextColor || !node.titleTextColor.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(AvGauge node) {
                return (StyleableProperty)node.titleTextColorProperty();
            }

            public Paint getInitialValue(AvGauge node) {
                return node.getTitleTextColor();
            }
        };
        private static final CssMetaData<AvGauge, Paint> BORDER_COLOR = new CssMetaData<AvGauge, Paint>("-border-color", StyleConverter.getPaintConverter(), (Paint)AvGauge.access$2300()){

            public boolean isSettable(AvGauge node) {
                return null == node.borderColor || !node.borderColor.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(AvGauge node) {
                return (StyleableProperty)node.borderColorProperty();
            }

            public Paint getInitialValue(AvGauge node) {
                return node.getBorderColor();
            }
        };
        private static final CssMetaData<AvGauge, Paint> SEPARATOR_COLOR = new CssMetaData<AvGauge, Paint>("-separator-color", StyleConverter.getPaintConverter(), (Paint)AvGauge.access$2500()){

            public boolean isSettable(AvGauge node) {
                return null == node.separatorColor || !node.separatorColor.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(AvGauge node) {
                return (StyleableProperty)node.separatorColorProperty();
            }

            public Paint getInitialValue(AvGauge node) {
                return node.getSeparatorColor();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            Collections.addAll(styleables, OUTER_BAR_COLOR, INNER_BAR_COLOR, BACKGROUND_COLOR, OUTER_VALUE_TEXT_COLOR, INNER_VALUE_TEXT_COLOR, TITLE_TEXT_COLOR, BORDER_COLOR, SEPARATOR_COLOR);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

