/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.gauge;

import eu.hansolo.enzo.common.Marker;
import eu.hansolo.enzo.common.Section;
import eu.hansolo.enzo.gauge.RadialBargraph;
import eu.hansolo.enzo.gauge.RadialBargraphBuilder;
import java.util.ArrayList;
import java.util.Random;
import javafx.animation.AnimationTimer;
import javafx.application.Application;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.stage.Stage;

public class DemoRadialBargraph
extends Application {
    private static final Random RND = new Random();
    private static int noOfNodes = 0;
    private RadialBargraph control;
    private long lastTimerCall;
    private AnimationTimer timer;

    public void init() {
        this.control = RadialBargraphBuilder.create().title("Enzo").unit("\u00b0C").markers(new Marker(40.0)).threshold(25.0).sections(new Section(60.0, 80.0, Color.rgb((int)255, (int)255, (int)0, (double)0.5))).thresholdVisible(true).build();
        this.control.setBarGradientEnabled(true);
        ArrayList<Stop> stops = new ArrayList<Stop>();
        stops.add(new Stop(0.0, Color.BLUE));
        stops.add(new Stop(1.0, Color.RED));
        this.control.setBarGradient(stops);
        this.lastTimerCall = System.nanoTime() + 2000000000L;
        this.timer = new AnimationTimer(){

            public void handle(long now) {
                if (now > DemoRadialBargraph.this.lastTimerCall + 5000000000L) {
                    DemoRadialBargraph.this.control.setValue(RND.nextDouble() * 100.0);
                    DemoRadialBargraph.this.lastTimerCall = now;
                }
            }
        };
    }

    public void start(Stage stage) throws Exception {
        StackPane pane = new StackPane();
        pane.setBackground(null);
        pane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        pane.getChildren().addAll((Object[])new Node[]{this.control});
        Scene scene = new Scene((Parent)pane, (Paint)Color.WHITE);
        stage.setTitle("RadialBargraph");
        stage.setScene(scene);
        stage.show();
        this.timer.start();
        DemoRadialBargraph.calcNoOfNodes((Node)scene.getRoot());
        System.out.println(noOfNodes + " Nodes in SceneGraph");
    }

    public void stop() {
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    private static void calcNoOfNodes(Node node) {
        if (node instanceof Parent && ((Parent)node).getChildrenUnmodifiable().size() != 0) {
            ObservableList tempChildren = ((Parent)node).getChildrenUnmodifiable();
            noOfNodes += tempChildren.size();
            for (Node n : tempChildren) {
                DemoRadialBargraph.calcNoOfNodes(n);
            }
        }
    }
}

