/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.gauge;

import eu.hansolo.enzo.common.Section;
import eu.hansolo.enzo.gauge.RectangularGauge;
import eu.hansolo.enzo.gauge.RectangularGaugeBuilder;
import java.util.Random;
import javafx.animation.AnimationTimer;
import javafx.application.Application;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;

public class DemoRectangularGauge
extends Application {
    private static final Random RND = new Random();
    private static int noOfNodes = 0;
    private RectangularGauge control;
    private long lastTimerCall;
    private AnimationTimer timer;

    public void init() {
        this.control = ((RectangularGaugeBuilder)((RectangularGaugeBuilder)((RectangularGaugeBuilder)((RectangularGaugeBuilder)((RectangularGaugeBuilder)((RectangularGaugeBuilder)((RectangularGaugeBuilder)RectangularGaugeBuilder.create().title("Temperature")).unit("\u00b0C")).tickLabelOrientation(RectangularGauge.TickLabelOrientation.ORTHOGONAL)).ledVisible(true)).sections(new Section(0.0, 25.0, Color.rgb((int)0, (int)0, (int)255, (double)0.5)), new Section(25.0, 50.0, Color.rgb((int)0, (int)255, (int)255, (double)0.5)), new Section(50.0, 75.0, Color.rgb((int)0, (int)255, (int)0, (double)0.5)), new Section(75.0, 100.0, Color.rgb((int)255, (int)255, (int)0, (double)0.5)))).sectionsVisible(true)).decimals(2)).build();
        this.lastTimerCall = System.nanoTime() + 50000000L;
        this.timer = new AnimationTimer(){

            public void handle(long now) {
                if (now > DemoRectangularGauge.this.lastTimerCall + 2000000000L) {
                    DemoRectangularGauge.this.control.setValue(RND.nextDouble() * 100.0);
                    DemoRectangularGauge.this.control.setBlinking(DemoRectangularGauge.this.control.getValue() > 50.0);
                    DemoRectangularGauge.this.lastTimerCall = now;
                }
            }
        };
    }

    public void start(Stage stage) throws Exception {
        StackPane pane = new StackPane(new Node[]{this.control});
        pane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        Scene scene = new Scene((Parent)pane, (Paint)Color.BLACK);
        stage.setTitle("RectangularGauge");
        stage.setScene(scene);
        stage.show();
        this.timer.start();
        DemoRectangularGauge.calcNoOfNodes((Node)scene.getRoot());
        System.out.println(noOfNodes + " Nodes in SceneGraph");
    }

    public void stop() {
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    private static void calcNoOfNodes(Node node) {
        if (node instanceof Parent && ((Parent)node).getChildrenUnmodifiable().size() != 0) {
            ObservableList tempChildren = ((Parent)node).getChildrenUnmodifiable();
            noOfNodes += tempChildren.size();
            for (Node n : tempChildren) {
                DemoRectangularGauge.calcNoOfNodes(n);
            }
        }
    }
}

