/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.gauge;

import eu.hansolo.enzo.common.Section;
import eu.hansolo.enzo.fonts.Fonts;
import eu.hansolo.enzo.gauge.skin.SimpleGaugeSkin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.util.Duration;

public class SimpleGauge
extends Control {
    public static final String STYLE_CLASS_BLUE_TO_RED_5 = "blue-to-red-5";
    public static final String STYLE_CLASS_RED_TO_BLUE_5 = "red-to-blue-5";
    public static final String STYLE_CLASS_GREEN_TO_DARKGREEN_6 = "green-to-darkgreen-6";
    public static final String STYLE_CLASS_GREEN_TO_RED_6 = "green-to-red-6";
    public static final String STYLE_CLASS_RED_TO_GREEN_6 = "red-to-green-6";
    public static final String STYLE_CLASS_BLUE_TO_RED_6 = "blue-to-red-6";
    public static final String STYLE_CLASS_PURPLE_TO_RED_6 = "purple-to-red-6";
    public static final String STYLE_CLASS_GREEN_TO_RED_7 = "green-to-red-7";
    public static final String STYLE_CLASS_RED_TO_GREEN_7 = "red-to-green-7";
    public static final String STYLE_CLASS_GREEN_TO_RED_10 = "green-to-red-10";
    public static final String STYLE_CLASS_RED_TO_GREEN_10 = "red-to-green-10";
    public static final String STYLE_CLASS_PURPLE_TO_CYAN_10 = "purple-to-cyan-10";
    private static final Color DEFAULT_NEEDLE_COLOR = Color.web((String)"#5a615f");
    private static final Color DEFAULT_BORDER_COLOR = Color.web((String)"#ffffff");
    private static final Color DEFAULT_VALUE_TEXT_COLOR = Color.web((String)"#ffffff");
    private static final Color DEFAULT_TITLE_TEXT_COLOR = Color.web((String)"#ffffff");
    private static final Color DEFAULT_SECTION_TEXT_COLOR = Color.web((String)"#ffffff");
    private static final Color DEFAULT_SECTION_FILL_0 = Color.web((String)"#f3622d");
    private static final Color DEFAULT_SECTION_FILL_1 = Color.web((String)"#fba71b");
    private static final Color DEFAULT_SECTION_FILL_2 = Color.web((String)"#57b757");
    private static final Color DEFAULT_SECTION_FILL_3 = Color.web((String)"#f5982b");
    private static final Color DEFAULT_SECTION_FILL_4 = Color.web((String)"#41a9c9");
    private static final Color DEFAULT_SECTION_FILL_5 = Color.web((String)"#4258c9");
    private static final Color DEFAULT_SECTION_FILL_6 = Color.web((String)"#9a42c8");
    private static final Color DEFAULT_SECTION_FILL_7 = Color.web((String)"#c84164");
    private static final Color DEFAULT_SECTION_FILL_8 = Color.web((String)"#888888");
    private static final Color DEFAULT_SECTION_FILL_9 = Color.web((String)"#aaaaaa");
    private static final Color DEFAULT_RANGE_FILL = Color.rgb((int)0, (int)0, (int)0, (double)0.25);
    private DoubleProperty value;
    private double oldValue;
    private DoubleProperty minValue;
    private double exactMinValue;
    private DoubleProperty maxValue;
    private double exactMaxValue;
    private double minMeasuredValue;
    private double maxMeasuredValue;
    private int _decimals;
    private IntegerProperty decimals;
    private String _unit;
    private StringProperty unit;
    private boolean _animated;
    private BooleanProperty animated;
    private double animationDuration;
    private double _startAngle;
    private DoubleProperty startAngle;
    private double _angleRange;
    private DoubleProperty angleRange;
    private boolean _clockwise;
    private BooleanProperty clockwise;
    private boolean _autoScale;
    private BooleanProperty autoScale;
    private BooleanProperty valueVisible;
    private BooleanProperty titleVisible;
    private boolean _sectionTextVisible;
    private BooleanProperty sectionTextVisible;
    private boolean _sectionIconVisible;
    private BooleanProperty sectionIconVisible;
    private boolean _measuredRangeVisible;
    private BooleanProperty measuredRangeVisible;
    private BooleanProperty customFontEnabled;
    private Font _customFont;
    private ObjectProperty<Font> customFont;
    private ObservableList<Section> sections;
    private double _majorTickSpace;
    private DoubleProperty majorTickSpace;
    private double _minorTickSpace;
    private DoubleProperty minorTickSpace;
    private String _title;
    private StringProperty title;
    private ObjectProperty<Paint> needleColor;
    private ObjectProperty<Paint> borderColor;
    private ObjectProperty<Paint> valueTextColor;
    private ObjectProperty<Paint> titleTextColor;
    private ObjectProperty<Paint> sectionTextColor;
    private ObjectProperty<Paint> sectionFill0;
    private ObjectProperty<Paint> sectionFill1;
    private ObjectProperty<Paint> sectionFill2;
    private ObjectProperty<Paint> sectionFill3;
    private ObjectProperty<Paint> sectionFill4;
    private ObjectProperty<Paint> sectionFill5;
    private ObjectProperty<Paint> sectionFill6;
    private ObjectProperty<Paint> sectionFill7;
    private ObjectProperty<Paint> sectionFill8;
    private ObjectProperty<Paint> sectionFill9;
    private ObjectProperty<Paint> rangeFill;

    public SimpleGauge() {
        this.getStyleClass().add((Object)"simple-gauge");
        this.minValue = new SimpleDoubleProperty((Object)this, "minValue", 0.0);
        this.maxValue = new SimpleDoubleProperty((Object)this, "maxValue", 100.0);
        this.value = new DoublePropertyBase(this.minValue.get()){

            public void set(double VALUE) {
                SimpleGauge.this.oldValue = this.get();
                super.set(SimpleGauge.this.clamp(SimpleGauge.this.getMinValue(), SimpleGauge.this.getMaxValue(), VALUE));
            }

            public Object getBean() {
                return this;
            }

            public String getName() {
                return "gaugeValue";
            }
        };
        this.oldValue = 0.0;
        this._decimals = 0;
        this._unit = "";
        this._animated = true;
        this._startAngle = 315.0;
        this._angleRange = 270.0;
        this._clockwise = true;
        this._autoScale = false;
        this.valueVisible = new SimpleBooleanProperty((Object)this, "valueVisible", true);
        this.titleVisible = new SimpleBooleanProperty((Object)this, "titleVisible", true);
        this._sectionTextVisible = false;
        this._sectionIconVisible = false;
        this._measuredRangeVisible = false;
        this._customFont = Fonts.robotoMedium(12.0);
        this.sections = FXCollections.observableArrayList();
        this._majorTickSpace = 10.0;
        this._minorTickSpace = 1.0;
        this._title = "";
        this.animationDuration = 3000.0;
    }

    public final double getValue() {
        return this.value.get();
    }

    public final void setValue(double VALUE) {
        this.value.set(VALUE);
    }

    public final DoubleProperty valueProperty() {
        return this.value;
    }

    public final double getOldValue() {
        return this.oldValue;
    }

    public final double getMinValue() {
        return this.minValue.get();
    }

    public final void setMinValue(double MIN_VALUE) {
        this.minValue.set(MIN_VALUE);
    }

    public final DoubleProperty minValueProperty() {
        return this.minValue;
    }

    public final double getMaxValue() {
        return this.maxValue.get();
    }

    public final void setMaxValue(double MAX_VALUE) {
        this.maxValue.set(MAX_VALUE);
    }

    public final DoubleProperty maxValueProperty() {
        return this.maxValue;
    }

    public final double getMinMeasuredValue() {
        return this.minMeasuredValue;
    }

    public final void setMinMeasuredValue(double MIN_MEASURED_VALUE) {
        this.minMeasuredValue = this.clamp(this.getMinValue(), this.getMaxValue(), MIN_MEASURED_VALUE);
    }

    public final double getMaxMeasuredValue() {
        return this.maxMeasuredValue;
    }

    public final void setMaxMeasuredValue(double MAX_MEASURED_VALUE) {
        this.maxMeasuredValue = this.clamp(this.getMinValue(), this.getMaxValue(), MAX_MEASURED_VALUE);
    }

    public final void resetMinMaxMeasuredValues() {
        this.minMeasuredValue = this.getValue();
        this.maxMeasuredValue = this.getValue();
    }

    public final int getDecimals() {
        return null == this.decimals ? this._decimals : this.decimals.get();
    }

    public final void setDecimals(int DECIMALS) {
        if (null == this.decimals) {
            this._decimals = this.clamp(0, 3, DECIMALS);
        } else {
            this.decimals.set(DECIMALS);
        }
    }

    public final IntegerProperty decimalsProperty() {
        if (null == this.decimals) {
            this.decimals = new IntegerPropertyBase(this._decimals){

                public void set(int DECIMALS) {
                    super.set(SimpleGauge.this.clamp(0, 3, this.get()));
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "decimals";
                }
            };
        }
        return this.decimals;
    }

    public final String getUnit() {
        return null == this.unit ? this._unit : (String)this.unit.get();
    }

    public final void setUnit(String UNIT) {
        if (null == this.unit) {
            this._unit = UNIT;
        } else {
            this.unit.set((Object)UNIT);
        }
    }

    public final StringProperty unitProperty() {
        if (null == this.unit) {
            this.unit = new SimpleStringProperty((Object)this, "unit", this._unit);
        }
        return this.unit;
    }

    public final boolean isAnimated() {
        return null == this.animated ? this._animated : this.animated.get();
    }

    public final void setAnimated(boolean ANIMATED) {
        if (null == this.animated) {
            this._animated = ANIMATED;
        } else {
            this.animated.set(ANIMATED);
        }
    }

    public final BooleanProperty animatedProperty() {
        if (null == this.animated) {
            this.animated = new SimpleBooleanProperty((Object)this, "animated", this._animated);
        }
        return this.animated;
    }

    public double getStartAngle() {
        return null == this.startAngle ? this._startAngle : this.startAngle.get();
    }

    public final void setStartAngle(double START_ANGLE) {
        if (null == this.startAngle) {
            this._startAngle = this.clamp(0.0, 360.0, START_ANGLE);
        } else {
            this.startAngle.set(START_ANGLE);
        }
    }

    public final DoubleProperty startAngleProperty() {
        if (null == this.startAngle) {
            this.startAngle = new DoublePropertyBase(this._startAngle){

                public void set(double START_ANGLE) {
                    super.set(SimpleGauge.this.clamp(0.0, 360.0, this.get()));
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "startAngle";
                }
            };
        }
        return this.startAngle;
    }

    public final double getAnimationDuration() {
        return this.animationDuration;
    }

    public final void setAnimationDuration(double ANIMATION_DURATION) {
        this.animationDuration = this.clamp(20.0, 5000.0, ANIMATION_DURATION);
    }

    public final double getAngleRange() {
        return null == this.angleRange ? this._angleRange : this.angleRange.get();
    }

    public final void setAngleRange(double ANGLE_RANGE) {
        if (null == this.angleRange) {
            this._angleRange = this.clamp(0.0, 360.0, ANGLE_RANGE);
        } else {
            this.angleRange.set(ANGLE_RANGE);
        }
    }

    public final DoubleProperty angleRangeProperty() {
        if (null == this.angleRange) {
            this.angleRange = new DoublePropertyBase(this._angleRange){

                public void set(double ANGLE_RANGE) {
                    super.set(SimpleGauge.this.clamp(0.0, 360.0, this.get()));
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "angleRange";
                }
            };
        }
        return this.angleRange;
    }

    public final boolean isClockwise() {
        return null == this.clockwise ? this._clockwise : this.clockwise.get();
    }

    public final void setClockwise(boolean CLOCKWISE) {
        if (null == this.clockwise) {
            this._clockwise = CLOCKWISE;
        } else {
            this.clockwise.set(CLOCKWISE);
        }
    }

    public final BooleanProperty clockwiseProperty() {
        if (null == this.clockwise) {
            this.clockwise = new SimpleBooleanProperty((Object)this, "clockwise", this._clockwise);
        }
        return this.clockwise;
    }

    public final boolean isAutoScale() {
        return null == this.autoScale ? this._autoScale : this.autoScale.get();
    }

    public final void setAutoScale(boolean AUTO_SCALE) {
        if (AUTO_SCALE) {
            this.exactMinValue = this.getMinValue();
            this.exactMaxValue = this.getMaxValue();
        } else {
            this.setMinValue(this.exactMinValue);
            this.setMaxValue(this.exactMaxValue);
        }
        if (null == this.autoScale) {
            this._autoScale = AUTO_SCALE;
        } else {
            this.autoScale.set(AUTO_SCALE);
        }
    }

    public final BooleanProperty autoScaleProperty() {
        if (null == this.autoScale) {
            this.autoScale = new SimpleBooleanProperty((Object)this, "autoScale", this._autoScale);
        }
        return this.autoScale;
    }

    public final ObservableList<Section> getSections() {
        return this.sections;
    }

    public final void setSections(List<Section> SECTIONS) {
        this.sections.setAll(SECTIONS);
    }

    public final void setSections(Section ... SECTIONS) {
        this.setSections(Arrays.asList(SECTIONS));
    }

    public final void addSection(Section SECTION) {
        if (!this.sections.contains((Object)SECTION)) {
            this.sections.add((Object)SECTION);
        }
    }

    public final void removeSection(Section SECTION) {
        if (this.sections.contains((Object)SECTION)) {
            this.sections.remove((Object)SECTION);
        }
    }

    public final double getMajorTickSpace() {
        return null == this.majorTickSpace ? this._majorTickSpace : this.majorTickSpace.get();
    }

    public final void setMajorTickSpace(double MAJOR_TICK_SPACE) {
        if (null == this.majorTickSpace) {
            this._majorTickSpace = MAJOR_TICK_SPACE;
        } else {
            this.majorTickSpace.set(MAJOR_TICK_SPACE);
        }
    }

    public final DoubleProperty majorTickSpaceProperty() {
        if (null == this.majorTickSpace) {
            this.majorTickSpace = new SimpleDoubleProperty((Object)this, "majorTickSpace", this._majorTickSpace);
        }
        return this.majorTickSpace;
    }

    public final double getMinorTickSpace() {
        return null == this.minorTickSpace ? this._minorTickSpace : this.minorTickSpace.get();
    }

    public final void setMinorTickSpace(double MINOR_TICK_SPACE) {
        if (null == this.minorTickSpace) {
            this._minorTickSpace = MINOR_TICK_SPACE;
        } else {
            this.minorTickSpace.set(MINOR_TICK_SPACE);
        }
    }

    public final DoubleProperty minorTickSpaceProperty() {
        if (null == this.minorTickSpace) {
            this.minorTickSpace = new SimpleDoubleProperty((Object)this, "minorTickSpace", this._minorTickSpace);
        }
        return this.minorTickSpace;
    }

    public final String getTitle() {
        return null == this.title ? this._title : (String)this.title.get();
    }

    public final void setTitle(String TITLE) {
        if (null == this.title) {
            this._title = TITLE;
        } else {
            this.title.set((Object)TITLE);
        }
    }

    public final StringProperty titleProperty() {
        if (null == this.title) {
            this.title = new SimpleStringProperty((Object)this, "title", this._title);
        }
        return this.title;
    }

    public final boolean isValueVisible() {
        return this.valueVisible.get();
    }

    public final void setValueVisible(boolean VALUE_VISIBLE) {
        this.valueVisible.set(VALUE_VISIBLE);
    }

    public final BooleanProperty valueVisibleProperty() {
        return this.valueVisible;
    }

    public final boolean isTitleVisible() {
        return this.titleVisible.get();
    }

    public final void setTitleVisible(boolean TITLE_VISIBLE) {
        this.titleVisible.set(TITLE_VISIBLE);
    }

    public final BooleanProperty titleVisibleProperty() {
        return this.titleVisible;
    }

    public final boolean isSectionTextVisible() {
        return null == this.sectionTextVisible ? this._sectionTextVisible : this.sectionTextVisible.get();
    }

    public final void setSectionTextVisible(boolean SECTION_TEXT_VISIBLE) {
        if (null == this.sectionTextVisible) {
            this._sectionTextVisible = SECTION_TEXT_VISIBLE;
        } else {
            this.sectionTextVisible.set(SECTION_TEXT_VISIBLE);
        }
    }

    public final BooleanProperty sectionTextVisibleProperty() {
        if (null == this.sectionTextVisible) {
            this.sectionTextVisible = new SimpleBooleanProperty((Object)this, "sectionTextVisible", this._sectionTextVisible);
        }
        return this.sectionTextVisible;
    }

    public final boolean isSectionIconVisible() {
        return null == this.sectionIconVisible ? this._sectionIconVisible : this.sectionIconVisible.get();
    }

    public final void setSectionIconVisible(boolean SECTION_ICON_VISIBLE) {
        if (null == this.sectionIconVisible) {
            this._sectionIconVisible = SECTION_ICON_VISIBLE;
        } else {
            this.sectionIconVisible.set(SECTION_ICON_VISIBLE);
        }
    }

    public final BooleanProperty sectionIconVisibleProperty() {
        if (null == this.sectionIconVisible) {
            this.sectionIconVisible = new SimpleBooleanProperty((Object)this, "sectionIconVisible", this._sectionIconVisible);
        }
        return this.sectionIconVisible;
    }

    public final boolean isMeasuredRangeVisible() {
        return null == this.measuredRangeVisible ? this._measuredRangeVisible : this.measuredRangeVisible.get();
    }

    public final void setMeasuredRangeVisible(boolean MEASURED_RANGE_VISIBLE) {
        if (null == this.measuredRangeVisible) {
            this._measuredRangeVisible = MEASURED_RANGE_VISIBLE;
        } else {
            this.measuredRangeVisible.set(MEASURED_RANGE_VISIBLE);
        }
    }

    public final ReadOnlyBooleanProperty measuredRangeVisibleProperty() {
        if (null == this.measuredRangeVisible) {
            this.measuredRangeVisible = new SimpleBooleanProperty((Object)this, "measuredRangeVisible", this._measuredRangeVisible);
        }
        return this.measuredRangeVisible;
    }

    public final boolean isCustomFontEnabled() {
        return this.customFontEnabledProperty().get();
    }

    public final void setCustomFontEnabled(boolean CUSTOM_FONT_ENABLED) {
        this.customFontEnabledProperty().set(CUSTOM_FONT_ENABLED);
    }

    public final BooleanProperty customFontEnabledProperty() {
        if (null == this.customFontEnabled) {
            this.customFontEnabled = new SimpleBooleanProperty((Object)this, "customFontEnabled", false);
        }
        return this.customFontEnabled;
    }

    public final Font getCustomFont() {
        return null == this.customFont ? this._customFont : (Font)this.customFont.get();
    }

    public final void setCustomFont(Font CUSTOM_FONT) {
        if (null == this.customFont) {
            this._customFont = CUSTOM_FONT;
        } else {
            this.customFont.set((Object)CUSTOM_FONT);
        }
    }

    public final ObjectProperty<Font> customFontProperty() {
        if (null == this.customFont) {
            this.customFont = new SimpleObjectProperty((Object)this, "customFont", (Object)this._customFont);
        }
        return this.customFont;
    }

    private double clamp(double MIN_VALUE, double MAX_VALUE, double VALUE) {
        if (VALUE < MIN_VALUE) {
            return MIN_VALUE;
        }
        if (VALUE > MAX_VALUE) {
            return MAX_VALUE;
        }
        return VALUE;
    }

    private int clamp(int MIN_VALUE, int MAX_VALUE, int VALUE) {
        if (VALUE < MIN_VALUE) {
            return MIN_VALUE;
        }
        if (VALUE > MAX_VALUE) {
            return MAX_VALUE;
        }
        return VALUE;
    }

    private Duration clamp(Duration MIN_VALUE, Duration MAX_VALUE, Duration VALUE) {
        if (VALUE.lessThan(MIN_VALUE)) {
            return MIN_VALUE;
        }
        if (VALUE.greaterThan(MAX_VALUE)) {
            return MAX_VALUE;
        }
        return VALUE;
    }

    public void calcAutoScale() {
        if (this.isAutoScale()) {
            double maxNoOfMajorTicks = 10.0;
            double maxNoOfMinorTicks = 10.0;
            double niceRange = this.calcNiceNumber(this.getMaxValue() - this.getMinValue(), false);
            this.majorTickSpace.set(this.calcNiceNumber(niceRange / (maxNoOfMajorTicks - 1.0), true));
            double niceMinValue = Math.floor(this.getMinValue() / this.majorTickSpace.doubleValue()) * this.majorTickSpace.doubleValue();
            double niceMaxValue = Math.ceil(this.getMaxValue() / this.majorTickSpace.doubleValue()) * this.majorTickSpace.doubleValue();
            this.minorTickSpace.set(this.calcNiceNumber(this.majorTickSpace.doubleValue() / (maxNoOfMinorTicks - 1.0), true));
            this.setMinValue(niceMinValue);
            this.setMaxValue(niceMaxValue);
        }
    }

    private double calcNiceNumber(double RANGE, boolean ROUND) {
        double EXPONENT = Math.floor(Math.log10(RANGE));
        double FRACTION = RANGE / Math.pow(10.0, EXPONENT);
        double niceFraction = ROUND ? (FRACTION < 1.5 ? 1.0 : (FRACTION < 3.0 ? 2.0 : (FRACTION < 7.0 ? 5.0 : 10.0))) : (Double.compare(FRACTION, 1.0) <= 0 ? 1.0 : (Double.compare(FRACTION, 2.0) <= 0 ? 2.0 : (Double.compare(FRACTION, 5.0) <= 0 ? 5.0 : 10.0)));
        return niceFraction * Math.pow(10.0, EXPONENT);
    }

    public void validate() {
        if (this.getValue() < this.getMinValue()) {
            this.setValue(this.getMinValue());
        }
        if (this.getValue() > this.getMaxValue()) {
            this.setValue(this.getMaxValue());
        }
        for (Section section : this.sections) {
            if (section.getStart() < this.getMinValue()) {
                section.setStart(this.getMinValue());
            }
            if (section.getStart() > this.getMaxValue()) {
                section.setStart(this.getMaxValue());
            }
            if (section.getStop() < this.getMinValue()) {
                section.setStop(this.getMinValue());
            }
            if (!(section.getStop() > this.getMaxValue())) continue;
            section.setStop(this.getMaxValue());
        }
    }

    public final Paint getNeedleColor() {
        return null == this.needleColor ? DEFAULT_NEEDLE_COLOR : (Paint)this.needleColor.get();
    }

    public final void setNeedleColor(Paint NEEDLE_COLOR) {
        this.needleColorProperty().set((Object)NEEDLE_COLOR);
    }

    public final ObjectProperty<Paint> needleColorProperty() {
        if (null == this.needleColor) {
            this.needleColor = new StyleableObjectProperty<Paint>(){

                public CssMetaData<? extends Styleable, Paint> getCssMetaData() {
                    return StyleableProperties.NEEDLE_COLOR;
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "needleColor";
                }
            };
        }
        return this.needleColor;
    }

    public final Paint getBorderColor() {
        return null == this.borderColor ? DEFAULT_BORDER_COLOR : (Paint)this.borderColor.get();
    }

    public final void setBorderColor(Paint BORDER_COLOR) {
        this.borderColorProperty().set((Object)BORDER_COLOR);
    }

    public final ObjectProperty<Paint> borderColorProperty() {
        if (null == this.borderColor) {
            this.borderColor = new StyleableObjectProperty<Paint>(){

                public CssMetaData<? extends Styleable, Paint> getCssMetaData() {
                    return StyleableProperties.BORDER_COLOR;
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "borderColor";
                }
            };
        }
        return this.borderColor;
    }

    public final Paint getValueTextColor() {
        return null == this.valueTextColor ? DEFAULT_VALUE_TEXT_COLOR : (Paint)this.valueTextColor.get();
    }

    public final void setValueTextColor(Paint value) {
        this.valueTextColorProperty().set((Object)value);
    }

    public final ObjectProperty<Paint> valueTextColorProperty() {
        if (null == this.valueTextColor) {
            this.valueTextColor = new StyleableObjectProperty<Paint>((Paint)DEFAULT_VALUE_TEXT_COLOR){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.VALUE_TEXT_COLOR;
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "valueTextColor";
                }
            };
        }
        return this.valueTextColor;
    }

    public final Paint getTitleTextColor() {
        return null == this.titleTextColor ? DEFAULT_TITLE_TEXT_COLOR : (Paint)this.titleTextColor.get();
    }

    public final void setTitleTextColor(Paint value) {
        this.titleTextColorProperty().set((Object)value);
    }

    public final ObjectProperty<Paint> titleTextColorProperty() {
        if (null == this.titleTextColor) {
            this.titleTextColor = new StyleableObjectProperty<Paint>((Paint)DEFAULT_TITLE_TEXT_COLOR){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.TITLE_TEXT_COLOR;
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "titleTextColor";
                }
            };
        }
        return this.titleTextColor;
    }

    public final Paint getSectionTextColor() {
        return null == this.sectionTextColor ? DEFAULT_SECTION_TEXT_COLOR : (Paint)this.sectionTextColor.get();
    }

    public final void setSectionTextColor(Paint value) {
        this.sectionTextColorProperty().set((Object)value);
    }

    public final ObjectProperty<Paint> sectionTextColorProperty() {
        if (null == this.sectionTextColor) {
            this.sectionTextColor = new StyleableObjectProperty<Paint>((Paint)DEFAULT_SECTION_TEXT_COLOR){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.SECTION_TEXT_COLOR;
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "sectionTextColor";
                }
            };
        }
        return this.sectionTextColor;
    }

    public final Paint getSectionFill0() {
        return null == this.sectionFill0 ? DEFAULT_SECTION_FILL_0 : (Paint)this.sectionFill0.get();
    }

    public final void setSectionFill0(Paint value) {
        this.sectionFill0Property().set((Object)value);
    }

    public final ObjectProperty<Paint> sectionFill0Property() {
        if (null == this.sectionFill0) {
            this.sectionFill0 = new StyleableObjectProperty<Paint>((Paint)DEFAULT_SECTION_FILL_0){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.SECTION_FILL_0;
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "sectionFill0";
                }
            };
        }
        return this.sectionFill0;
    }

    public final Paint getSectionFill1() {
        return null == this.sectionFill1 ? DEFAULT_SECTION_FILL_1 : (Paint)this.sectionFill1.get();
    }

    public final void setSectionFill1(Paint value) {
        this.sectionFill1Property().set((Object)value);
    }

    public final ObjectProperty<Paint> sectionFill1Property() {
        if (null == this.sectionFill1) {
            this.sectionFill1 = new StyleableObjectProperty<Paint>((Paint)DEFAULT_SECTION_FILL_1){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.SECTION_FILL_1;
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "sectionFill1";
                }
            };
        }
        return this.sectionFill1;
    }

    public final Paint getSectionFill2() {
        return null == this.sectionFill2 ? DEFAULT_SECTION_FILL_2 : (Paint)this.sectionFill2.get();
    }

    public final void setSectionFill2(Paint value) {
        this.sectionFill2Property().set((Object)value);
    }

    public final ObjectProperty<Paint> sectionFill2Property() {
        if (null == this.sectionFill2) {
            this.sectionFill2 = new StyleableObjectProperty<Paint>((Paint)DEFAULT_SECTION_FILL_2){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.SECTION_FILL_2;
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "sectionFill2";
                }
            };
        }
        return this.sectionFill2;
    }

    public final Paint getSectionFill3() {
        return null == this.sectionFill3 ? DEFAULT_SECTION_FILL_3 : (Paint)this.sectionFill3.get();
    }

    public final void setSectionFill3(Paint value) {
        this.sectionFill3Property().set((Object)value);
    }

    public final ObjectProperty<Paint> sectionFill3Property() {
        if (null == this.sectionFill3) {
            this.sectionFill3 = new StyleableObjectProperty<Paint>((Paint)DEFAULT_SECTION_FILL_3){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.SECTION_FILL_3;
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "sectionFill3";
                }
            };
        }
        return this.sectionFill3;
    }

    public final Paint getSectionFill4() {
        return null == this.sectionFill4 ? DEFAULT_SECTION_FILL_4 : (Paint)this.sectionFill4.get();
    }

    public final void setSectionFill4(Paint value) {
        this.sectionFill4Property().set((Object)value);
    }

    public final ObjectProperty<Paint> sectionFill4Property() {
        if (null == this.sectionFill4) {
            this.sectionFill4 = new StyleableObjectProperty<Paint>((Paint)DEFAULT_SECTION_FILL_4){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.SECTION_FILL_4;
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "sectionFill4";
                }
            };
        }
        return this.sectionFill4;
    }

    public final Paint getSectionFill5() {
        return null == this.sectionFill5 ? DEFAULT_SECTION_FILL_5 : (Paint)this.sectionFill5.get();
    }

    public final void setSectionFill5(Paint value) {
        this.sectionFill5Property().set((Object)value);
    }

    public final ObjectProperty<Paint> sectionFill5Property() {
        if (null == this.sectionFill5) {
            this.sectionFill5 = new StyleableObjectProperty<Paint>((Paint)DEFAULT_SECTION_FILL_5){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.SECTION_FILL_5;
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "sectionFill5";
                }
            };
        }
        return this.sectionFill5;
    }

    public final Paint getSectionFill6() {
        return null == this.sectionFill6 ? DEFAULT_SECTION_FILL_6 : (Paint)this.sectionFill6.get();
    }

    public final void setSectionFill6(Paint value) {
        this.sectionFill6Property().set((Object)value);
    }

    public final ObjectProperty<Paint> sectionFill6Property() {
        if (null == this.sectionFill6) {
            this.sectionFill6 = new StyleableObjectProperty<Paint>((Paint)DEFAULT_SECTION_FILL_6){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.SECTION_FILL_6;
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "sectionFill6";
                }
            };
        }
        return this.sectionFill6;
    }

    public final Paint getSectionFill7() {
        return null == this.sectionFill7 ? DEFAULT_SECTION_FILL_7 : (Paint)this.sectionFill7.get();
    }

    public final void setSectionFill7(Paint value) {
        this.sectionFill7Property().set((Object)value);
    }

    public final ObjectProperty<Paint> sectionFill7Property() {
        if (null == this.sectionFill7) {
            this.sectionFill7 = new StyleableObjectProperty<Paint>((Paint)DEFAULT_SECTION_FILL_7){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.SECTION_FILL_7;
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "sectionFill7";
                }
            };
        }
        return this.sectionFill7;
    }

    public final Paint getSectionFill8() {
        return null == this.sectionFill8 ? DEFAULT_SECTION_FILL_8 : (Paint)this.sectionFill8.get();
    }

    public final void setSectionFill8(Paint value) {
        this.sectionFill8Property().set((Object)value);
    }

    public final ObjectProperty<Paint> sectionFill8Property() {
        if (null == this.sectionFill8) {
            this.sectionFill8 = new StyleableObjectProperty<Paint>((Paint)DEFAULT_SECTION_FILL_8){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.SECTION_FILL_8;
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "sectionFill8";
                }
            };
        }
        return this.sectionFill8;
    }

    public final Paint getSectionFill9() {
        return null == this.sectionFill9 ? DEFAULT_SECTION_FILL_9 : (Paint)this.sectionFill9.get();
    }

    public final void setSectionFill9(Paint value) {
        this.sectionFill9Property().set((Object)value);
    }

    public final ObjectProperty<Paint> sectionFill9Property() {
        if (null == this.sectionFill9) {
            this.sectionFill9 = new StyleableObjectProperty<Paint>((Paint)DEFAULT_SECTION_FILL_9){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.SECTION_FILL_9;
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "sectionFill9";
                }
            };
        }
        return this.sectionFill9;
    }

    public final Paint getRangeFill() {
        return null == this.rangeFill ? DEFAULT_RANGE_FILL : (Paint)this.rangeFill.get();
    }

    public final void setRangeFill(Paint value) {
        this.rangeFillProperty().set((Object)value);
    }

    public final ObjectProperty<Paint> rangeFillProperty() {
        if (null == this.rangeFill) {
            this.rangeFill = new StyleableObjectProperty<Paint>((Paint)DEFAULT_RANGE_FILL){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.RANGE_FILL;
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "rangeFill";
                }
            };
        }
        return this.rangeFill;
    }

    protected Skin createDefaultSkin() {
        return new SimpleGaugeSkin(this);
    }

    public String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("simplegauge.css").toExternalForm();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return SimpleGauge.getClassCssMetaData();
    }

    static /* synthetic */ Color access$1900() {
        return DEFAULT_NEEDLE_COLOR;
    }

    static /* synthetic */ Color access$2100() {
        return DEFAULT_BORDER_COLOR;
    }

    static /* synthetic */ Color access$2300() {
        return DEFAULT_VALUE_TEXT_COLOR;
    }

    static /* synthetic */ Color access$2500() {
        return DEFAULT_TITLE_TEXT_COLOR;
    }

    static /* synthetic */ Color access$2700() {
        return DEFAULT_SECTION_TEXT_COLOR;
    }

    static /* synthetic */ Color access$2900() {
        return DEFAULT_SECTION_FILL_0;
    }

    static /* synthetic */ Color access$3100() {
        return DEFAULT_SECTION_FILL_1;
    }

    static /* synthetic */ Color access$3300() {
        return DEFAULT_SECTION_FILL_2;
    }

    static /* synthetic */ Color access$3500() {
        return DEFAULT_SECTION_FILL_3;
    }

    static /* synthetic */ Color access$3700() {
        return DEFAULT_SECTION_FILL_4;
    }

    static /* synthetic */ Color access$3900() {
        return DEFAULT_SECTION_FILL_5;
    }

    static /* synthetic */ Color access$4100() {
        return DEFAULT_SECTION_FILL_6;
    }

    static /* synthetic */ Color access$4300() {
        return DEFAULT_SECTION_FILL_7;
    }

    static /* synthetic */ Color access$4500() {
        return DEFAULT_SECTION_FILL_8;
    }

    static /* synthetic */ Color access$4700() {
        return DEFAULT_SECTION_FILL_9;
    }

    static /* synthetic */ Color access$4900() {
        return DEFAULT_RANGE_FILL;
    }

    private static class StyleableProperties {
        private static final CssMetaData<SimpleGauge, Paint> NEEDLE_COLOR = new CssMetaData<SimpleGauge, Paint>("-needle-color", StyleConverter.getPaintConverter(), (Paint)SimpleGauge.access$1900()){

            public boolean isSettable(SimpleGauge gauge) {
                return null == gauge.needleColor || !gauge.needleColor.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(SimpleGauge gauge) {
                return (StyleableProperty)gauge.needleColorProperty();
            }

            public Paint getInitialValue(SimpleGauge gauge) {
                return gauge.getNeedleColor();
            }
        };
        private static final CssMetaData<SimpleGauge, Paint> BORDER_COLOR = new CssMetaData<SimpleGauge, Paint>("-border-color", StyleConverter.getPaintConverter(), (Paint)SimpleGauge.access$2100()){

            public boolean isSettable(SimpleGauge gauge) {
                return null == gauge.borderColor || !gauge.borderColor.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(SimpleGauge gauge) {
                return (StyleableProperty)gauge.borderColorProperty();
            }

            public Paint getInitialValue(SimpleGauge gauge) {
                return gauge.getBorderColor();
            }
        };
        private static final CssMetaData<SimpleGauge, Paint> VALUE_TEXT_COLOR = new CssMetaData<SimpleGauge, Paint>("-value-text", StyleConverter.getPaintConverter(), (Paint)SimpleGauge.access$2300()){

            public boolean isSettable(SimpleGauge gauge) {
                return null == gauge.valueTextColor || !gauge.valueTextColor.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(SimpleGauge gauge) {
                return (StyleableProperty)gauge.valueTextColorProperty();
            }

            public Paint getInitialValue(SimpleGauge gauge) {
                return gauge.getValueTextColor();
            }
        };
        private static final CssMetaData<SimpleGauge, Paint> TITLE_TEXT_COLOR = new CssMetaData<SimpleGauge, Paint>("-title-text", StyleConverter.getPaintConverter(), (Paint)SimpleGauge.access$2500()){

            public boolean isSettable(SimpleGauge gauge) {
                return null == gauge.titleTextColor || !gauge.titleTextColor.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(SimpleGauge gauge) {
                return (StyleableProperty)gauge.titleTextColorProperty();
            }

            public Paint getInitialValue(SimpleGauge gauge) {
                return gauge.getTitleTextColor();
            }
        };
        private static final CssMetaData<SimpleGauge, Paint> SECTION_TEXT_COLOR = new CssMetaData<SimpleGauge, Paint>("-section-text", StyleConverter.getPaintConverter(), (Paint)SimpleGauge.access$2700()){

            public boolean isSettable(SimpleGauge gauge) {
                return null == gauge.sectionTextColor || !gauge.sectionTextColor.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(SimpleGauge gauge) {
                return (StyleableProperty)gauge.sectionTextColorProperty();
            }

            public Paint getInitialValue(SimpleGauge gauge) {
                return gauge.getSectionTextColor();
            }
        };
        private static final CssMetaData<SimpleGauge, Paint> SECTION_FILL_0 = new CssMetaData<SimpleGauge, Paint>("-section-fill-0", StyleConverter.getPaintConverter(), (Paint)SimpleGauge.access$2900()){

            public boolean isSettable(SimpleGauge gauge) {
                return null == gauge.sectionFill0 || !gauge.sectionFill0.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(SimpleGauge gauge) {
                return (StyleableProperty)gauge.sectionFill0Property();
            }

            public Paint getInitialValue(SimpleGauge gauge) {
                return gauge.getSectionFill0();
            }
        };
        private static final CssMetaData<SimpleGauge, Paint> SECTION_FILL_1 = new CssMetaData<SimpleGauge, Paint>("-section-fill-1", StyleConverter.getPaintConverter(), (Paint)SimpleGauge.access$3100()){

            public boolean isSettable(SimpleGauge gauge) {
                return null == gauge.sectionFill1 || !gauge.sectionFill1.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(SimpleGauge gauge) {
                return (StyleableProperty)gauge.sectionFill1Property();
            }

            public Paint getInitialValue(SimpleGauge gauge) {
                return gauge.getSectionFill1();
            }
        };
        private static final CssMetaData<SimpleGauge, Paint> SECTION_FILL_2 = new CssMetaData<SimpleGauge, Paint>("-section-fill-2", StyleConverter.getPaintConverter(), (Paint)SimpleGauge.access$3300()){

            public boolean isSettable(SimpleGauge gauge) {
                return null == gauge.sectionFill2 || !gauge.sectionFill2.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(SimpleGauge gauge) {
                return (StyleableProperty)gauge.sectionFill2Property();
            }

            public Paint getInitialValue(SimpleGauge gauge) {
                return gauge.getSectionFill2();
            }
        };
        private static final CssMetaData<SimpleGauge, Paint> SECTION_FILL_3 = new CssMetaData<SimpleGauge, Paint>("-section-fill-3", StyleConverter.getPaintConverter(), (Paint)SimpleGauge.access$3500()){

            public boolean isSettable(SimpleGauge gauge) {
                return null == gauge.sectionFill3 || !gauge.sectionFill3.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(SimpleGauge gauge) {
                return (StyleableProperty)gauge.sectionFill3Property();
            }

            public Paint getInitialValue(SimpleGauge gauge) {
                return gauge.getSectionFill3();
            }
        };
        private static final CssMetaData<SimpleGauge, Paint> SECTION_FILL_4 = new CssMetaData<SimpleGauge, Paint>("-section-fill-4", StyleConverter.getPaintConverter(), (Paint)SimpleGauge.access$3700()){

            public boolean isSettable(SimpleGauge gauge) {
                return null == gauge.sectionFill4 || !gauge.sectionFill4.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(SimpleGauge gauge) {
                return (StyleableProperty)gauge.sectionFill4Property();
            }

            public Paint getInitialValue(SimpleGauge gauge) {
                return gauge.getSectionFill4();
            }
        };
        private static final CssMetaData<SimpleGauge, Paint> SECTION_FILL_5 = new CssMetaData<SimpleGauge, Paint>("-section-fill-5", StyleConverter.getPaintConverter(), (Paint)SimpleGauge.access$3900()){

            public boolean isSettable(SimpleGauge gauge) {
                return null == gauge.sectionFill5 || !gauge.sectionFill5.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(SimpleGauge gauge) {
                return (StyleableProperty)gauge.sectionFill5Property();
            }

            public Paint getInitialValue(SimpleGauge gauge) {
                return gauge.getSectionFill5();
            }
        };
        private static final CssMetaData<SimpleGauge, Paint> SECTION_FILL_6 = new CssMetaData<SimpleGauge, Paint>("-section-fill-6", StyleConverter.getPaintConverter(), (Paint)SimpleGauge.access$4100()){

            public boolean isSettable(SimpleGauge gauge) {
                return null == gauge.sectionFill6 || !gauge.sectionFill6.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(SimpleGauge gauge) {
                return (StyleableProperty)gauge.sectionFill6Property();
            }

            public Paint getInitialValue(SimpleGauge gauge) {
                return gauge.getSectionFill6();
            }
        };
        private static final CssMetaData<SimpleGauge, Paint> SECTION_FILL_7 = new CssMetaData<SimpleGauge, Paint>("-section-fill-7", StyleConverter.getPaintConverter(), (Paint)SimpleGauge.access$4300()){

            public boolean isSettable(SimpleGauge gauge) {
                return null == gauge.sectionFill7 || !gauge.sectionFill7.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(SimpleGauge gauge) {
                return (StyleableProperty)gauge.sectionFill7Property();
            }

            public Paint getInitialValue(SimpleGauge gauge) {
                return gauge.getSectionFill7();
            }
        };
        private static final CssMetaData<SimpleGauge, Paint> SECTION_FILL_8 = new CssMetaData<SimpleGauge, Paint>("-section-fill-8", StyleConverter.getPaintConverter(), (Paint)SimpleGauge.access$4500()){

            public boolean isSettable(SimpleGauge gauge) {
                return null == gauge.sectionFill8 || !gauge.sectionFill8.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(SimpleGauge gauge) {
                return (StyleableProperty)gauge.sectionFill8Property();
            }

            public Paint getInitialValue(SimpleGauge gauge) {
                return gauge.getSectionFill8();
            }
        };
        private static final CssMetaData<SimpleGauge, Paint> SECTION_FILL_9 = new CssMetaData<SimpleGauge, Paint>("-section-fill-9", StyleConverter.getPaintConverter(), (Paint)SimpleGauge.access$4700()){

            public boolean isSettable(SimpleGauge gauge) {
                return null == gauge.sectionFill9 || !gauge.sectionFill9.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(SimpleGauge gauge) {
                return (StyleableProperty)gauge.sectionFill9Property();
            }

            public Paint getInitialValue(SimpleGauge gauge) {
                return gauge.getSectionFill9();
            }
        };
        private static final CssMetaData<SimpleGauge, Paint> RANGE_FILL = new CssMetaData<SimpleGauge, Paint>("-range-fill", StyleConverter.getPaintConverter(), (Paint)SimpleGauge.access$4900()){

            public boolean isSettable(SimpleGauge gauge) {
                return null == gauge.rangeFill || !gauge.rangeFill.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(SimpleGauge gauge) {
                return (StyleableProperty)gauge.rangeFillProperty();
            }

            public Paint getInitialValue(SimpleGauge gauge) {
                return gauge.getRangeFill();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            Collections.addAll(styleables, NEEDLE_COLOR, BORDER_COLOR, VALUE_TEXT_COLOR, TITLE_TEXT_COLOR, SECTION_TEXT_COLOR, SECTION_FILL_0, SECTION_FILL_1, SECTION_FILL_2, SECTION_FILL_3, SECTION_FILL_4, SECTION_FILL_5, SECTION_FILL_6, SECTION_FILL_7, SECTION_FILL_8, SECTION_FILL_9, RANGE_FILL);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

