/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.lcd;

import eu.hansolo.enzo.common.ValueEvent;
import eu.hansolo.enzo.lcd.skin.LcdSkin;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.Transition;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.css.PseudoClass;
import javafx.event.EventTarget;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.util.Duration;

public class Lcd
extends Control {
    public static final String STYLE_CLASS_BEIGE = "lcd-beige";
    public static final String STYLE_CLASS_BLUE = "lcd-blue";
    public static final String STYLE_CLASS_ORANGE = "lcd-orange";
    public static final String STYLE_CLASS_RED = "lcd-red";
    public static final String STYLE_CLASS_YELLOW = "lcd-yellow";
    public static final String STYLE_CLASS_WHITE = "lcd-white";
    public static final String STYLE_CLASS_GRAY = "lcd-gray";
    public static final String STYLE_CLASS_BLACK = "lcd-black";
    public static final String STYLE_CLASS_GREEN = "lcd-green";
    public static final String STYLE_CLASS_GREEN_DARKGREEN = "lcd-green-darkgreen";
    public static final String STYLE_CLASS_BLUE2 = "lcd-blue2";
    public static final String STYLE_CLASS_BLUE_BLACK = "lcd-blue-black";
    public static final String STYLE_CLASS_BLUE_DARKBLUE = "lcd-blue-darkblue";
    public static final String STYLE_CLASS_BLUE_LIGHTBLUE = "lcd-blue-lightblue";
    public static final String STYLE_CLASS_BLUE_GRAY = "lcd-blue-gray";
    public static final String STYLE_CLASS_STANDARD = "lcd-standard";
    public static final String STYLE_CLASS_LIGHTGREEN = "lcd-lightgreen";
    public static final String STYLE_CLASS_STANDARD_GREEN = "lcd-standard-green";
    public static final String STYLE_CLASS_BLUE_BLUE = "lcd-blue-blue";
    public static final String STYLE_CLASS_RED_DARKRED = "lcd-red-darkred";
    public static final String STYLE_CLASS_DARKBLUE = "lcd-darkblue";
    public static final String STYLE_CLASS_PURPLE = "lcd-purple";
    public static final String STYLE_CLASS_BLACK_RED = "lcd-black-red";
    public static final String STYLE_CLASS_DARKGREEN = "lcd-darkgreen";
    public static final String STYLE_CLASS_AMBER = "lcd-amber";
    public static final String STYLE_CLASS_LIGHTBLUE = "lcd-lightblue";
    public static final String STYLE_CLASS_GREEN_BLACK = "lcd-green-black";
    public static final String STYLE_CLASS_YELLOW_BLACK = "lcd-yellow-black";
    public static final String STYLE_CLASS_BLACK_YELLOW = "lcd-black-yellow";
    public static final String STYLE_CLASS_LIGHTGREEN_BLACK = "lcd-lightgreen-black";
    public static final String STYLE_CLASS_DARKPURPLE = "lcd-darkpurple";
    public static final String STYLE_CLASS_DARKAMBER = "lcd-darkamber";
    public static final String STYLE_CLASS_BLUE_LIGHTBLUE2 = "lcd-blue-lightblue2";
    public static final String STYLE_CLASS_GRAY_PURPLE = "lcd-gray-purple";
    public static final String STYLE_CLASS_SECTIONS = "lcd-sections";
    public static final String STYLE_CLASS_YOCTOPUCE = "lcd-yoctopuce";
    public static final String STYLE_CLASS_FLAT_TURQOISE = "lcd-flat-turqoise";
    public static final String STYLE_CLASS_FLAT_GREEN_SEA = "lcd-flat-green-sea";
    public static final String STYLE_CLASS_FLAT_EMERLAND = "lcd-flat-emerland";
    public static final String STYLE_CLASS_FLAT_NEPHRITIS = "lcd-flat-nephritis";
    public static final String STYLE_CLASS_FLAT_PETER_RIVER = "lcd-flat-peter-river";
    public static final String STYLE_CLASS_FLAT_BELIZE_HOLE = "lcd-flat-belize-hole";
    public static final String STYLE_CLASS_FLAT_AMETHYST = "lcd-flat-amethyst";
    public static final String STYLE_CLASS_FLAT_WISTERIA = "lcd-flat-wisteria";
    public static final String STYLE_CLASS_FLAT_SUNFLOWER = "lcd-flat-sunflower";
    public static final String STYLE_CLASS_FLAT_ORANGE = "lcd-flat-orange";
    public static final String STYLE_CLASS_FLAT_CARROT = "lcd-flat-carrot";
    public static final String STYLE_CLASS_FLAT_PUMPKIN = "lcd-flat-pumpkin";
    public static final String STYLE_CLASS_FLAT_ALIZARIN = "lcd-flat-alizarin";
    public static final String STYLE_CLASS_FLAT_POMEGRANATE = "lcd-flat-pomegranate";
    public static final String STYLE_CLASS_FLAT_CLOUDS = "lcd-flat-clouds";
    public static final String STYLE_CLASS_FLAT_SILVER = "lcd-flat-silver";
    public static final String STYLE_CLASS_FLAT_CONCRETE = "lcd-flat-concrete";
    public static final String STYLE_CLASS_FLAT_ASBESTOS = "lcd-flat-asbestos";
    public static final String STYLE_CLASS_FLAT_WET_ASPHALT = "lcd-flat-wet-asphalt";
    public static final String STYLE_CLASS_FLAT_MIDNIGHT_BLUE = "lcd-flat-midnight-blue";
    private static final PseudoClass NO_FRAME_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"no-frame");
    private BooleanProperty noFrame;
    private boolean firstTime;
    private boolean keepAspect;
    private boolean _textMode = false;
    private BooleanProperty textMode;
    private String _text = "";
    private StringProperty text;
    private DoubleProperty value;
    private DoubleProperty currentValue;
    private DoubleProperty formerValue;
    private double _minValue = 0.0;
    private DoubleProperty minValue;
    private double _maxValue = 100.0;
    private DoubleProperty maxValue;
    private boolean _animated = true;
    private BooleanProperty animated;
    private double _animationDuration = 800.0;
    private DoubleProperty animationDuration;
    private double _minMeasuredValue = 100.0;
    private DoubleProperty minMeasuredValue;
    private double _maxMeasuredValue = 0.0;
    private DoubleProperty maxMeasuredValue;
    private int _minMeasuredValueDecimals = 2;
    private IntegerProperty minMeasuredValueDecimals;
    private int _maxMeasuredValueDecimals = 2;
    private IntegerProperty maxMeasuredValueDecimals;
    private double _threshold = 50.0;
    private DoubleProperty threshold;
    private boolean _thresholdBehaviorInverted = false;
    private BooleanProperty thresholdBehaviorInverted;
    private boolean thresholdExceeded = false;
    private String _title = "";
    private StringProperty title;
    private String _unit = "";
    private StringProperty unit;
    private String _lowerCenterText = "";
    private StringProperty lowerCenterText;
    private boolean _lowerCenterCenterTextVisible = false;
    private BooleanProperty lowerCenterTextVisible;
    private String _lowerRightText = "";
    private StringProperty lowerRightText;
    private boolean _lowerRightTextVisible = false;
    private BooleanProperty lowerRightTextVisible;
    private String _upperLeftText = "";
    private StringProperty upperLeftText;
    private boolean _upperLeftTextVisible = false;
    private BooleanProperty upperLeftTextVisible;
    private String _upperRightText = "";
    private StringProperty upperRightText;
    private boolean _upperRightTextVisible = false;
    private BooleanProperty upperRightTextVisible;
    private NumberSystem _numberSystem = NumberSystem.DECIMAL;
    private ObjectProperty<NumberSystem> numberSystem;
    private Trend _trend = Trend.UNKNOWN;
    private ObjectProperty<Trend> trend;
    private double _batteryCharge = 0.0;
    private DoubleProperty batteryCharge;
    private double _signalStrength = 0.0;
    private DoubleProperty signalStrength;
    private boolean _valueVisible = true;
    private BooleanProperty valueVisible;
    private boolean _minMeasuredValueVisible = false;
    private BooleanProperty minMeasuredValueVisible;
    private boolean _maxMeasuredValueVisible = false;
    private BooleanProperty maxMeasuredValueVisible;
    private boolean _formerValueVisible = false;
    private BooleanProperty formerValueVisible;
    private boolean _thresholdVisible = false;
    private BooleanProperty thresholdVisible;
    private String _unitFont = "Open Sans";
    private StringProperty unitFont;
    private String _titleFont = "Open Sans";
    private StringProperty titleFont;
    private LcdFont _valueFont = LcdFont.LCD;
    private ObjectProperty<LcdFont> valueFont;
    private String _smallFont = "Open Sans";
    private StringProperty smallFont;
    private int _decimals = 0;
    private IntegerProperty decimals;
    private boolean _numberSystemVisible = false;
    private BooleanProperty numberSystemVisible;
    private boolean _blinking = false;
    private BooleanProperty blinking;
    private boolean _backgroundVisible = true;
    private BooleanProperty backgroundVisible;
    private boolean _crystalOverlayVisible = false;
    private BooleanProperty crystalOverlayVisible;
    private boolean _mainInnerShadowVisible = false;
    private BooleanProperty mainInnerShadowVisible;
    private boolean _foregroundShadowVisible = false;
    private BooleanProperty foregroundShadowVisible;
    private boolean _titleVisible = true;
    private BooleanProperty titleVisible;
    private boolean _unitVisible = true;
    private BooleanProperty unitVisible;
    private boolean _trendVisible = false;
    private BooleanProperty trendVisible;
    private boolean _batteryVisible = false;
    private BooleanProperty batteryVisible;
    private boolean _signalVisible = false;
    private BooleanProperty signalVisible;
    private boolean _alarmVisible = false;
    private ObjectProperty<LcdDesign> lcdDesign;
    private BooleanProperty alarmVisible;
    private Transition toValueAnimation;
    private boolean toggleValue;
    private boolean toggleThreshold;
    private long interval;
    private volatile ScheduledFuture<?> periodicBlinkTask;
    private static ScheduledExecutorService periodicBlinkExecutorService;

    public Lcd() {
        this.getStyleClass().add((Object)"lcd");
        this.value = new DoublePropertyBase(0.0){

            public void set(double VALUE) {
                Lcd.this.formerValue.set(Lcd.this.value.get());
                super.set(Lcd.clamp(Lcd.this.getMinValue(), Lcd.this.getMaxValue(), VALUE));
            }

            public Object getBean() {
                return this;
            }

            public String getName() {
                return "value";
            }
        };
        this.currentValue = new SimpleDoubleProperty(0.0);
        this.formerValue = new SimpleDoubleProperty(0.0);
        this.firstTime = true;
        this.keepAspect = true;
        this.toggleValue = false;
        this.toggleThreshold = false;
        this.interval = 500L;
        this.toValueAnimation = new Transition(){
            {
                this.setCycleDuration(Duration.millis((double)Lcd.this.getAnimationDuration()));
            }

            protected void interpolate(double frac) {
                Lcd.this.currentValue.set(Lcd.this.getFormerValue() + (Lcd.this.getValue() - Lcd.this.getFormerValue()) * frac);
            }
        };
        this.init();
    }

    private void init() {
        this.valueProperty().addListener((ov, oldValue, newValue) -> {
            this.formerValue.set(oldValue.doubleValue());
            if (this.toValueAnimation.getStatus() != Animation.Status.STOPPED) {
                this.toValueAnimation.stop();
            }
            if (this.getAnimated()) {
                this.toValueAnimation.setInterpolator(Interpolator.SPLINE((double)0.5, (double)0.4, (double)0.4, (double)1.0));
                this.toValueAnimation.play();
                this.toValueAnimation.setOnFinished(EVENT -> {
                    if (this.firstTime) {
                        this.resetMinMaxMeasuredValue();
                        this.firstTime = false;
                    }
                });
            } else {
                this.currentValue.set(newValue.doubleValue());
            }
        });
        this.currentValueProperty().addListener(observable -> {
            if (Double.compare(this.currentValue.get(), this.getMinMeasuredValue()) < 0 && !this.firstTime) {
                this.setMinMeasuredValue(this.currentValue.get());
            }
            if (Double.compare(this.currentValue.get(), this.getMaxMeasuredValue()) > 0 && !this.firstTime) {
                this.setMaxMeasuredValue(this.currentValue.get());
            }
            if (this.thresholdExceeded) {
                if (this.currentValue.get() < this.getThreshold()) {
                    this.fireEvent(new ValueEvent((Object)this, (EventTarget)this, ValueEvent.VALUE_UNDERRUN));
                    this.thresholdExceeded = false;
                }
            } else if (this.currentValue.get() > this.getThreshold()) {
                this.fireEvent(new ValueEvent((Object)this, (EventTarget)this, ValueEvent.VALUE_EXCEEDED));
                this.thresholdExceeded = true;
            }
        });
    }

    public final boolean isKeepAspect() {
        return this.keepAspect;
    }

    public final void setKeepAspect(boolean KEEP_ASPECT) {
        this.keepAspect = KEEP_ASPECT;
    }

    public boolean isResizable() {
        return true;
    }

    public final boolean isTextMode() {
        return null == this.textMode ? this._textMode : this.textMode.get();
    }

    public final void setTextMode(boolean TEXT_MODE) {
        if (null == this.textMode) {
            this._textMode = TEXT_MODE;
        } else {
            this.textMode.set(TEXT_MODE);
        }
    }

    public final BooleanProperty textModeProperty() {
        if (null == this.textMode) {
            this.textMode = new SimpleBooleanProperty((Object)this, "textMode", this._textMode);
        }
        return this.textMode;
    }

    public final String getText() {
        return null == this.text ? this._text : (String)this.text.get();
    }

    public final void setText(String TEXT) {
        if (null == this.text) {
            this._text = TEXT;
        } else {
            this.text.set((Object)TEXT);
        }
    }

    public final StringProperty textProperty() {
        if (null == this.text) {
            this.text = new SimpleStringProperty((Object)this, "text", this._text);
        }
        return this.text;
    }

    public final double getValue() {
        return this.value.get();
    }

    public final void setValue(double VALUE) {
        this.value.set(VALUE);
    }

    public final DoubleProperty valueProperty() {
        return this.value;
    }

    public final double getCurrentValue() {
        return this.currentValue.get();
    }

    public final ReadOnlyDoubleProperty currentValueProperty() {
        return this.currentValue;
    }

    public final double getFormerValue() {
        return this.formerValue.get();
    }

    public final ReadOnlyDoubleProperty formerValueProperty() {
        return this.formerValue;
    }

    public final boolean getAnimated() {
        return null == this.animated ? this._animated : this.animated.get();
    }

    public final void setAnimated(boolean ANIMATED) {
        if (null == this.animated) {
            this._animated = ANIMATED;
        } else {
            this.animated.set(ANIMATED);
        }
    }

    public final BooleanProperty animatedProperty() {
        if (null == this.animated) {
            this.animated = new SimpleBooleanProperty((Object)this, "animated", this._animated);
        }
        return this.animated;
    }

    public final double getAnimationDuration() {
        return null == this.animationDuration ? this._animationDuration : this.animationDuration.get();
    }

    public final void setAnimationDuration(double ANIMATION_DURATION) {
        if (null == this.animationDuration) {
            this._animationDuration = ANIMATION_DURATION;
        } else {
            this.animationDuration.set(ANIMATION_DURATION);
        }
    }

    public final DoubleProperty animationDurationProperty() {
        if (null == this.animationDuration) {
            this.animationDuration = new SimpleDoubleProperty((Object)this, "animationDuration", this._animationDuration);
        }
        return this.animationDuration;
    }

    public final double getMinValue() {
        return null == this.minValue ? this._minValue : this.minValue.get();
    }

    public final void setMinValue(double MIN_VALUE) {
        if (null == this.minValue) {
            this._minValue = Lcd.clamp(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, MIN_VALUE);
        } else {
            this.minValue.set(MIN_VALUE);
        }
    }

    public final DoubleProperty minValueProperty() {
        if (null == this.minValue) {
            this.minValue = new DoublePropertyBase(this._minValue){

                public void set(double MIN_VALUE) {
                    super.set(Lcd.clamp(Double.NEGATIVE_INFINITY, Lcd.this.getMaxValue(), this.get()));
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "minValue";
                }
            };
        }
        return this.minValue;
    }

    public final double getMaxValue() {
        return null == this.maxValue ? this._maxValue : this.maxValue.get();
    }

    public final void setMaxValue(double MAX_VALUE) {
        if (null == this.maxValue) {
            this._maxValue = Lcd.clamp(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, MAX_VALUE);
        } else {
            this.maxValue.set(MAX_VALUE);
        }
    }

    public final DoubleProperty maxValueProperty() {
        if (null == this.maxValue) {
            this.maxValue = new DoublePropertyBase(this._maxValue){

                public void set(double MAX_VALUE) {
                    super.set(Lcd.clamp(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, this.get()));
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "maxValue";
                }
            };
        }
        return this.maxValue;
    }

    public final double getRange() {
        if (null == this.maxValue && null != this.minValue) {
            return this._maxValue - this.minValue.get();
        }
        if (null != this.maxValue && null == this.minValue) {
            return this.maxValue.get() - this._minValue;
        }
        if (null == this.maxValue && null == this.minValue) {
            return this._maxValue - this._minValue;
        }
        return this.maxValue.subtract((ObservableNumberValue)this.minValue).get();
    }

    public final double getMinMeasuredValue() {
        return null == this.minMeasuredValue ? this._minMeasuredValue : this.minMeasuredValue.get();
    }

    public final void setMinMeasuredValue(double MIN_MEASURED_VALUE) {
        if (null == this.minMeasuredValue) {
            this._minMeasuredValue = MIN_MEASURED_VALUE;
        } else {
            this.minMeasuredValue.set(MIN_MEASURED_VALUE);
        }
    }

    public final DoubleProperty minMeasuredValueProperty() {
        if (null == this.minMeasuredValue) {
            this.minMeasuredValue = new SimpleDoubleProperty((Object)this, "minMeasuredValue", this._minMeasuredValue);
        }
        return this.minMeasuredValue;
    }

    public final void resetMinMeasuredValue() {
        this.setMinMeasuredValue(this.getValue());
    }

    public final double getMaxMeasuredValue() {
        return null == this.maxMeasuredValue ? this._minMeasuredValue : this.maxMeasuredValue.get();
    }

    public final void setMaxMeasuredValue(double MAX_MEASURED_VALUE) {
        if (null == this.maxMeasuredValue) {
            this._maxMeasuredValue = MAX_MEASURED_VALUE;
        } else {
            this.maxMeasuredValue.set(MAX_MEASURED_VALUE);
        }
    }

    public final DoubleProperty maxMeasuredValueProperty() {
        if (null == this.maxMeasuredValue) {
            this.maxMeasuredValue = new SimpleDoubleProperty((Object)this, "maxMeasuredValue", this._maxMeasuredValue);
        }
        return this.maxMeasuredValue;
    }

    public final void resetMaxMeasuredValue() {
        this.setMaxMeasuredValue(this.getValue());
    }

    public final void resetMinMaxMeasuredValue() {
        this.setMinMeasuredValue(this.getValue());
        this.setMaxMeasuredValue(this.getValue());
    }

    public final double getThreshold() {
        return null == this.threshold ? this._threshold : this.threshold.get();
    }

    public final void setThreshold(double THRESHOLD) {
        if (null == this.threshold) {
            this._threshold = Lcd.clamp(this.getMinValue(), this.getMaxValue(), THRESHOLD);
        } else {
            this.threshold.set(Lcd.clamp(this.getMinValue(), this.getMaxValue(), THRESHOLD));
        }
    }

    public final ReadOnlyDoubleProperty thresholdProperty() {
        if (null == this.threshold) {
            this.threshold = new SimpleDoubleProperty((Object)this, "threshold", this._threshold);
        }
        return this.threshold;
    }

    public final boolean isThresholdBehaviorInverted() {
        return null == this.thresholdBehaviorInverted ? this._thresholdBehaviorInverted : this.thresholdBehaviorInverted.get();
    }

    public final void setThresholdBehaviorInverted(boolean THRESHOLD_BEHAVIOR_INVERTED) {
        if (null == this.thresholdBehaviorInverted) {
            this._thresholdBehaviorInverted = THRESHOLD_BEHAVIOR_INVERTED;
        } else {
            this.thresholdBehaviorInverted.set(THRESHOLD_BEHAVIOR_INVERTED);
        }
    }

    public final BooleanProperty thresholdBehaviorInvertedProperty() {
        if (null == this.thresholdBehaviorInverted) {
            this.thresholdBehaviorInverted = new SimpleBooleanProperty((Object)this, "thresholdBehaviorInverted", this._thresholdBehaviorInverted);
        }
        return this.thresholdBehaviorInverted;
    }

    public final String getTitle() {
        return null == this.title ? this._title : (String)this.title.get();
    }

    public final void setTitle(String TITLE) {
        if (null == this.title) {
            this._title = TITLE;
        } else {
            this.title.set((Object)TITLE);
        }
    }

    public final StringProperty titleProperty() {
        if (null == this.title) {
            this.title = new SimpleStringProperty((Object)this, "title", this._title);
        }
        return this.title;
    }

    public final String getUnit() {
        return null == this.unit ? this._unit : (String)this.unit.get();
    }

    public final void setUnit(String UNIT) {
        if (null == this.unit) {
            this._unit = UNIT;
        } else {
            this.unit.set((Object)UNIT);
        }
    }

    public final StringProperty unitProperty() {
        if (null == this.unit) {
            this.unit = new SimpleStringProperty((Object)this, "unit", this._unit);
        }
        return this.unit;
    }

    public final String getLowerCenterText() {
        return null == this.lowerCenterText ? this._lowerCenterText : (String)this.lowerCenterText.get();
    }

    public final void setLowerCenterText(String LOWER_CENTER_TEXT) {
        if (null == this.lowerCenterText) {
            this._lowerCenterText = LOWER_CENTER_TEXT;
        } else {
            this.lowerCenterText.set((Object)LOWER_CENTER_TEXT);
        }
    }

    public final StringProperty lowerCenterTextProperty() {
        if (null == this.lowerCenterText) {
            this.lowerCenterText = new SimpleStringProperty((Object)this, "lowerCenterText", this._lowerCenterText);
        }
        return this.lowerCenterText;
    }

    public final boolean isLowerCenterTextVisible() {
        return null == this.lowerCenterTextVisible ? this._lowerCenterCenterTextVisible : this.lowerCenterTextVisible.get();
    }

    public final void setLowerCenterTextVisible(boolean LOWER_CENTER_TEXT_VISIBLE) {
        if (null == this.lowerCenterTextVisible) {
            this._lowerCenterCenterTextVisible = LOWER_CENTER_TEXT_VISIBLE;
        } else {
            this.lowerCenterTextVisible.set(LOWER_CENTER_TEXT_VISIBLE);
        }
    }

    public final BooleanProperty lowerCenterTextVisibleProperty() {
        if (null == this.lowerCenterTextVisible) {
            this.lowerCenterTextVisible = new SimpleBooleanProperty((Object)this, "lowerCenterTextVisible", this._lowerCenterCenterTextVisible);
        }
        return this.lowerCenterTextVisible;
    }

    public final String getLowerRightText() {
        return null == this.lowerRightText ? this._lowerRightText : (String)this.lowerRightText.get();
    }

    public final void setLowerRightText(String LOWER_RIGHT_TEXT) {
        if (null == this.lowerRightText) {
            this._lowerRightText = LOWER_RIGHT_TEXT;
        } else {
            this.lowerRightText.set((Object)LOWER_RIGHT_TEXT);
        }
    }

    public final StringProperty lowerRightTextProperty() {
        if (null == this.lowerRightText) {
            this.lowerRightText = new SimpleStringProperty((Object)this, "lowerRightText", this._lowerRightText);
        }
        return this.lowerRightText;
    }

    public final boolean isLowerRightTextVisible() {
        return null == this.lowerRightTextVisible ? this._lowerRightTextVisible : this.lowerRightTextVisible.get();
    }

    public final void setLowerRightTextVisible(boolean LOWER_RIGHT_TEXT_VISIBLE) {
        if (null == this.lowerRightTextVisible) {
            this._lowerRightTextVisible = LOWER_RIGHT_TEXT_VISIBLE;
        } else {
            this.lowerRightTextVisible.set(LOWER_RIGHT_TEXT_VISIBLE);
        }
    }

    public final BooleanProperty lowerRightTextVisibleProperty() {
        if (null == this.lowerRightTextVisible) {
            this.lowerRightTextVisible = new SimpleBooleanProperty((Object)this, "lowerRightTextVisible", this._lowerRightTextVisible);
        }
        return this.lowerRightTextVisible;
    }

    public final String getUpperLeftText() {
        return null == this.upperLeftText ? this._upperLeftText : (String)this.upperLeftText.get();
    }

    public final void setUpperLeftText(String UPPER_LEFT_TEXT) {
        if (null == this.upperLeftText) {
            this._upperLeftText = UPPER_LEFT_TEXT;
        } else {
            this.upperLeftText.set((Object)UPPER_LEFT_TEXT);
        }
    }

    public final StringProperty upperLeftTextProperty() {
        if (null == this.upperLeftText) {
            this.upperLeftText = new SimpleStringProperty((Object)this, "upperLeftText", this._upperLeftText);
        }
        return this.upperLeftText;
    }

    public final boolean isUpperLeftTextVisible() {
        return null == this.upperLeftTextVisible ? this._upperLeftTextVisible : this.upperLeftTextVisible.get();
    }

    public final void setUpperLeftTextVisible(boolean UPPER_LEFT_TEXT_VISIBLE) {
        if (null == this.upperLeftTextVisible) {
            this._upperLeftTextVisible = UPPER_LEFT_TEXT_VISIBLE;
        } else {
            this.upperLeftTextVisible.set(UPPER_LEFT_TEXT_VISIBLE);
        }
    }

    public final BooleanProperty upperLeftTextVisibleProperty() {
        if (null == this.upperLeftTextVisible) {
            this.upperLeftTextVisible = new SimpleBooleanProperty((Object)this, "upperLeftTextVisible", this._upperLeftTextVisible);
        }
        return this.upperLeftTextVisible;
    }

    public final String getUpperRightText() {
        return null == this.upperRightText ? this._upperRightText : (String)this.upperRightText.get();
    }

    public final void setUpperRightText(String UPPER_RIGHT_TEXT) {
        if (null == this.upperRightText) {
            this._upperRightText = UPPER_RIGHT_TEXT;
        } else {
            this.upperRightText.set((Object)UPPER_RIGHT_TEXT);
        }
    }

    public final StringProperty upperRightTextProperty() {
        if (null == this.upperRightText) {
            this.upperRightText = new SimpleStringProperty((Object)this, "upperRightText", this._upperRightText);
        }
        return this.upperRightText;
    }

    public final boolean isUpperRightTextVisible() {
        return null == this.upperRightTextVisible ? this._upperRightTextVisible : this.upperRightTextVisible.get();
    }

    public final void setUpperRightTextVisible(boolean UPPER_RIGHT_TEXT_VISIBLE) {
        if (null == this.upperRightTextVisible) {
            this._upperRightTextVisible = UPPER_RIGHT_TEXT_VISIBLE;
        } else {
            this.upperRightTextVisible.set(UPPER_RIGHT_TEXT_VISIBLE);
        }
    }

    public final BooleanProperty upperRightTextVisibleProperty() {
        if (null == this.upperRightTextVisible) {
            this.upperRightTextVisible = new SimpleBooleanProperty((Object)this, "upperRightTextVisible", this._upperRightTextVisible);
        }
        return this.upperRightTextVisible;
    }

    public final NumberSystem getNumberSystem() {
        return null == this.numberSystem ? this._numberSystem : (NumberSystem)((Object)this.numberSystem.get());
    }

    public final void setNumberSystem(NumberSystem NUMBER_SYSTEM) {
        if (null == this.numberSystem) {
            this._numberSystem = NUMBER_SYSTEM;
        } else {
            this.numberSystem.set((Object)NUMBER_SYSTEM);
        }
    }

    public final ObjectProperty<NumberSystem> numberSystemProperty() {
        if (null == this.numberSystem) {
            this.numberSystem = new SimpleObjectProperty((Object)this, "numberSystem", (Object)this._numberSystem);
        }
        return this.numberSystem;
    }

    public final Trend getTrend() {
        return null == this.trend ? this._trend : (Trend)((Object)this.trend.get());
    }

    public final void setTrend(Trend TREND) {
        if (null == this.trend) {
            this._trend = TREND;
        } else {
            this.trend.set((Object)TREND);
        }
    }

    public final ObjectProperty<Trend> trendProperty() {
        if (null == this.trend) {
            this.trend = new SimpleObjectProperty((Object)this, "trend", (Object)this._trend);
        }
        return this.trend;
    }

    public final double getBatteryCharge() {
        return null == this.batteryCharge ? this._batteryCharge : this.batteryCharge.get();
    }

    public final void setBatteryCharge(double BATTERY_CHARGE) {
        if (null == this.batteryCharge) {
            this._batteryCharge = Lcd.clamp(0.0, 1.0, BATTERY_CHARGE);
        } else {
            this.batteryCharge.set(Lcd.clamp(0.0, 1.0, BATTERY_CHARGE));
        }
    }

    public final DoubleProperty batteryChargeProperty() {
        if (null == this.batteryCharge) {
            this.batteryCharge = new SimpleDoubleProperty((Object)this, "batteryCharge", this._batteryCharge);
        }
        return this.batteryCharge;
    }

    public final double getSignalStrength() {
        return null == this.signalStrength ? this._signalStrength : this.signalStrength.get();
    }

    public final void setSignalStrength(double SIGNAL_STRENGTH) {
        if (null == this.signalStrength) {
            this._signalStrength = Lcd.clamp(0.0, 1.0, SIGNAL_STRENGTH);
        } else {
            this.signalStrength.set(Lcd.clamp(0.0, 1.0, SIGNAL_STRENGTH));
        }
    }

    public final DoubleProperty signalStrengthProperty() {
        if (null == this.signalStrength) {
            this.signalStrength = new SimpleDoubleProperty((Object)this, "signalStrength", this._signalStrength);
        }
        return this.signalStrength;
    }

    public final boolean isValueVisible() {
        return null == this.valueVisible ? this._valueVisible : this.valueVisible.get();
    }

    private void setValueVisible(boolean VALUE_VISIBLE) {
        if (null == this.valueVisible) {
            this._valueVisible = VALUE_VISIBLE;
        } else {
            this.valueVisible.set(VALUE_VISIBLE);
        }
    }

    public final ReadOnlyBooleanProperty valueVisibleProperty() {
        if (null == this.valueVisible) {
            this.valueVisible = new SimpleBooleanProperty((Object)this, "valueVisible", this._valueVisible);
        }
        return this.valueVisible;
    }

    public final boolean isMinMeasuredValueVisible() {
        return null == this.minMeasuredValueVisible ? this._minMeasuredValueVisible : this.minMeasuredValueVisible.get();
    }

    public final void setMinMeasuredValueVisible(boolean MIN_MEASURED_VALUE_VISIBLE) {
        if (null == this.minMeasuredValueVisible) {
            this._minMeasuredValueVisible = MIN_MEASURED_VALUE_VISIBLE;
        } else {
            this.minMeasuredValueVisible.set(MIN_MEASURED_VALUE_VISIBLE);
        }
    }

    public final BooleanProperty minMeasuredValueVisibleProperty() {
        if (null == this.minMeasuredValueVisible) {
            this.minMeasuredValueVisible = new SimpleBooleanProperty((Object)this, "minMeasuredValueVisible", this._minMeasuredValueVisible);
        }
        return this.minMeasuredValueVisible;
    }

    public final boolean isMaxMeasuredValueVisible() {
        return null == this.maxMeasuredValueVisible ? this._maxMeasuredValueVisible : this.maxMeasuredValueVisible.get();
    }

    public final void setMaxMeasuredValueVisible(boolean MAX_MEASURED_VALUE_VISIBLE) {
        if (null == this.maxMeasuredValueVisible) {
            this._maxMeasuredValueVisible = MAX_MEASURED_VALUE_VISIBLE;
        } else {
            this.maxMeasuredValueVisible.set(MAX_MEASURED_VALUE_VISIBLE);
        }
    }

    public final BooleanProperty maxMeasuredValueVisibleProperty() {
        if (null == this.maxMeasuredValueVisible) {
            this.maxMeasuredValueVisible = new SimpleBooleanProperty((Object)this, "maxMeasureValueVisible", this._maxMeasuredValueVisible);
        }
        return this.maxMeasuredValueVisible;
    }

    public final boolean isThresholdVisible() {
        return null == this.thresholdVisible ? this._thresholdVisible : this.thresholdVisible.get();
    }

    public final void setThresholdVisible(boolean THRESHOLD_VISIBLE) {
        if (null == this.thresholdVisible) {
            this._thresholdVisible = THRESHOLD_VISIBLE;
        } else {
            this.thresholdVisible.set(THRESHOLD_VISIBLE);
        }
    }

    public final BooleanProperty thresholdVisibleProperty() {
        if (null == this.thresholdVisible) {
            this.thresholdVisible = new SimpleBooleanProperty((Object)this, "thresholdVisible", this._thresholdVisible);
        }
        return this.thresholdVisible;
    }

    public final boolean isNoFrame() {
        return null == this.noFrame ? true : this.noFrame.get();
    }

    public final void setNoFrame(boolean NO_FRAME) {
        this.noFrameProperty().set(NO_FRAME);
    }

    public final BooleanProperty noFrameProperty() {
        if (null == this.noFrame) {
            this.noFrame = new BooleanPropertyBase(false){

                protected void invalidated() {
                    Lcd.this.pseudoClassStateChanged(NO_FRAME_PSEUDO_CLASS, this.get());
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "noFrame";
                }
            };
        }
        return this.noFrame;
    }

    public final boolean isBackgroundVisible() {
        return null == this.backgroundVisible ? this._backgroundVisible : this.backgroundVisible.get();
    }

    public final void setBackgroundVisible(boolean BACKGROUND_VISIBLE) {
        if (null == this.backgroundVisible) {
            this._backgroundVisible = BACKGROUND_VISIBLE;
        } else {
            this.backgroundVisible.set(BACKGROUND_VISIBLE);
        }
    }

    public final BooleanProperty backgroundVisibleProperty() {
        if (null == this.backgroundVisible) {
            this.backgroundVisible = new SimpleBooleanProperty((Object)this, "backgroundVisible", this._backgroundVisible);
        }
        return this.backgroundVisible;
    }

    public final boolean isCrystalOverlayVisible() {
        return null == this.crystalOverlayVisible ? this._crystalOverlayVisible : this.crystalOverlayVisible.get();
    }

    public final void setCrystalOverlayVisible(boolean CRYSTAL_OVERLAY_VISIBLE) {
        if (null == this.crystalOverlayVisible) {
            this._crystalOverlayVisible = CRYSTAL_OVERLAY_VISIBLE;
        } else {
            this.crystalOverlayVisible.set(CRYSTAL_OVERLAY_VISIBLE);
        }
    }

    public final BooleanProperty crystalOverlayVisibleProperty() {
        if (null == this.crystalOverlayVisible) {
            this.crystalOverlayVisible = new SimpleBooleanProperty((Object)this, "crystalOverlayVisible", this._crystalOverlayVisible);
        }
        return this.crystalOverlayVisible;
    }

    public final boolean isMainInnerShadowVisible() {
        return null == this.mainInnerShadowVisible ? this._mainInnerShadowVisible : this.mainInnerShadowVisible.get();
    }

    public final void setMainInnerShadowVisible(boolean MAIN_INNER_SHADOW_VISIBLE) {
        if (null == this.mainInnerShadowVisible) {
            this._mainInnerShadowVisible = MAIN_INNER_SHADOW_VISIBLE;
        } else {
            this.mainInnerShadowVisible.set(MAIN_INNER_SHADOW_VISIBLE);
        }
    }

    public final BooleanProperty mainInnerShadowVisibleProperty() {
        if (null == this.mainInnerShadowVisible) {
            this.mainInnerShadowVisible = new SimpleBooleanProperty((Object)this, "mainInnerShadowVisible", this._mainInnerShadowVisible);
        }
        return this.mainInnerShadowVisible;
    }

    public final boolean isForegroundShadowVisible() {
        return null == this.foregroundShadowVisible ? this._foregroundShadowVisible : this.foregroundShadowVisible.get();
    }

    public final void setForegroundShadowVisible(boolean FOREGROUND_SHADOW_VISIBLE) {
        if (null == this.foregroundShadowVisible) {
            this._foregroundShadowVisible = FOREGROUND_SHADOW_VISIBLE;
        } else {
            this.foregroundShadowVisible.set(FOREGROUND_SHADOW_VISIBLE);
        }
    }

    public final BooleanProperty foregroundShadowVisibleProperty() {
        if (null == this.foregroundShadowVisible) {
            this.foregroundShadowVisible = new SimpleBooleanProperty((Object)this, "foregroundShadowVisible", this._foregroundShadowVisible);
        }
        return this.foregroundShadowVisible;
    }

    public final String getTitleFont() {
        return null == this.titleFont ? this._titleFont : (String)this.titleFont.get();
    }

    public final void setTitleFont(String TITLE_FONT) {
        if (null == this.titleFont) {
            this._titleFont = TITLE_FONT;
        } else {
            this.titleFont.set((Object)TITLE_FONT);
        }
    }

    public final StringProperty titleFontProperty() {
        if (null == this.titleFont) {
            this.titleFont = new SimpleStringProperty((Object)this, "titleFont", this._titleFont);
        }
        return this.titleFont;
    }

    public final String getUnitFont() {
        return null == this.unitFont ? this._unitFont : (String)this.unitFont.get();
    }

    public final void setUnitFont(String UNIT_FONT) {
        if (null == this.unitFont) {
            this._unitFont = UNIT_FONT;
        } else {
            this.unitFont.set((Object)UNIT_FONT);
        }
    }

    public final StringProperty unitFontProperty() {
        if (null == this.unitFont) {
            this.unitFont = new SimpleStringProperty((Object)this, "unitFont", this._unitFont);
        }
        return this.unitFont;
    }

    public final LcdFont getValueFont() {
        return null == this.valueFont ? this._valueFont : (LcdFont)((Object)this.valueFont.get());
    }

    public final void setValueFont(LcdFont VALUE_FONT) {
        if (null == this.valueFont) {
            this._valueFont = VALUE_FONT;
        } else {
            this.valueFont.set((Object)VALUE_FONT);
        }
    }

    public final ObjectProperty<LcdFont> valueFontProperty() {
        if (null == this.valueFont) {
            this.valueFont = new SimpleObjectProperty((Object)this, "valueFont", (Object)this._valueFont);
        }
        return this.valueFont;
    }

    public final String getSmallFont() {
        return null == this.smallFont ? this._smallFont : (String)this.smallFont.get();
    }

    public final void setSmallFont(String SMALL_FONT) {
        if (null == this.smallFont) {
            this._smallFont = SMALL_FONT;
        } else {
            this.smallFont.set((Object)SMALL_FONT);
        }
    }

    public final StringProperty smallFontProperty() {
        if (null == this.smallFont) {
            this.smallFont = new SimpleStringProperty((Object)this, "smallFont", this._smallFont);
        }
        return this.smallFont;
    }

    public final int getDecimals() {
        return null == this.decimals ? this._decimals : this.decimals.get();
    }

    public final void setDecimals(int DECIMALS) {
        int dec;
        int n = DECIMALS > 5 ? 5 : (dec = DECIMALS < 0 ? 0 : DECIMALS);
        if (null == this.decimals) {
            this._decimals = dec;
        } else {
            this.decimals.set(dec);
        }
    }

    public final IntegerProperty decimalsProperty() {
        if (null == this.decimals) {
            this.decimals = new SimpleIntegerProperty((Object)this, "decimals", this._decimals);
        }
        return this.decimals;
    }

    public final boolean isNumberSystemVisible() {
        return null == this.numberSystemVisible ? this._numberSystemVisible : this.numberSystemVisible.get();
    }

    public final void setNumberSystemVisible(boolean NUMBER_SYSTEM_VISIBLE) {
        if (null == this.numberSystemVisible) {
            this._numberSystemVisible = NUMBER_SYSTEM_VISIBLE;
        } else {
            this.numberSystemVisible.set(NUMBER_SYSTEM_VISIBLE);
        }
    }

    public final BooleanProperty numberSystemVisibleProperty() {
        if (null == this.numberSystemVisible) {
            this.numberSystemVisible = new SimpleBooleanProperty((Object)this, "numberSystemVisible", this._numberSystemVisible);
        }
        return this.numberSystemVisible;
    }

    public final boolean isBlinking() {
        return null == this.blinking ? this._blinking : this.blinking.get();
    }

    public final void setBlinking(boolean BLINKING) {
        if (null == this.blinking) {
            this._blinking = BLINKING;
        } else {
            this.blinking.set(BLINKING);
        }
        if (BLINKING) {
            this.scheduleBlinkTask();
        } else {
            this.stopTask(this.periodicBlinkTask);
            this.setValueVisible(true);
        }
    }

    public final BooleanProperty blinkingProperty() {
        if (null == this.blinking) {
            this.blinking = new SimpleBooleanProperty((Object)this, "blinking", this._blinking);
        }
        return this.blinking;
    }

    public final boolean isTitleVisible() {
        return null == this.titleVisible ? this._titleVisible : this.titleVisible.get();
    }

    public final void setTitleVisible(boolean TITLE_VISIBLE) {
        if (null == this.titleVisible) {
            this._titleVisible = TITLE_VISIBLE;
        } else {
            this.titleVisible.set(TITLE_VISIBLE);
        }
    }

    public final BooleanProperty titleVisibleProperty() {
        if (null == this.titleVisible) {
            this.titleVisible = new SimpleBooleanProperty((Object)this, "titleVisible", this._titleVisible);
        }
        return this.titleVisible;
    }

    public final boolean isUnitVisible() {
        return null == this.unitVisible ? this._unitVisible : this.unitVisible.get();
    }

    public final void setUnitVisible(boolean UNIT_VISIBLE) {
        if (null == this.unitVisible) {
            this._unitVisible = UNIT_VISIBLE;
        } else {
            this.unitVisible.set(UNIT_VISIBLE);
        }
    }

    public final BooleanProperty unitVisibleProperty() {
        if (null == this.unitVisible) {
            this.unitVisible = new SimpleBooleanProperty((Object)this, "unitVisible", this._unitVisible);
        }
        return this.unitVisible;
    }

    public final boolean isTrendVisible() {
        return null == this.trendVisible ? this._trendVisible : this.trendVisible.get();
    }

    public final void setTrendVisible(boolean TREND_VISIBLE) {
        if (null == this.trendVisible) {
            this._trendVisible = TREND_VISIBLE;
        } else {
            this.trendVisible.set(TREND_VISIBLE);
        }
    }

    public final BooleanProperty trendVisibleProperty() {
        if (null == this.trendVisible) {
            this.trendVisible = new SimpleBooleanProperty((Object)this, "trendVisible", this._trendVisible);
        }
        return this.trendVisible;
    }

    public final boolean isBatteryVisible() {
        return null == this.batteryVisible ? this._batteryVisible : this.batteryVisible.get();
    }

    public final void setBatteryVisible(boolean BATTERY_VISIBLE) {
        if (null == this.batteryVisible) {
            this._batteryVisible = BATTERY_VISIBLE;
        } else {
            this.batteryVisible.set(BATTERY_VISIBLE);
        }
    }

    public final BooleanProperty batteryVisibleProperty() {
        if (null == this.batteryVisible) {
            this.batteryVisible = new SimpleBooleanProperty((Object)this, "batteryVisible", this._batteryVisible);
        }
        return this.batteryVisible;
    }

    public final boolean isSignalVisible() {
        return null == this.signalVisible ? this._signalVisible : this.signalVisible.get();
    }

    public final void setSignalVisible(boolean SIGNAL_VISIBLE) {
        if (null == this.signalVisible) {
            this._signalVisible = SIGNAL_VISIBLE;
        } else {
            this.signalVisible.set(SIGNAL_VISIBLE);
        }
    }

    public final BooleanProperty signalVisibleProperty() {
        if (null == this.signalVisible) {
            this.signalVisible = new SimpleBooleanProperty((Object)this, "signalVisible", this._signalVisible);
        }
        return this.signalVisible;
    }

    public final boolean isAlarmVisible() {
        return null == this.alarmVisible ? this._alarmVisible : this.alarmVisible.get();
    }

    public final void setAlarmVisible(boolean ALARM_VISIBLE) {
        if (null == this.alarmVisible) {
            this._alarmVisible = ALARM_VISIBLE;
        } else {
            this.alarmVisible.set(ALARM_VISIBLE);
        }
    }

    public final BooleanProperty alarmVisibleProperty() {
        if (null == this.alarmVisible) {
            this.alarmVisible = new SimpleBooleanProperty((Object)this, "alarmVisible", this._alarmVisible);
        }
        return this.alarmVisible;
    }

    public final LcdDesign getLcdDesign() {
        return null == this.lcdDesign ? LcdDesign.STANDARD : (LcdDesign)((Object)this.lcdDesign.get());
    }

    public final void setLcdDesign(LcdDesign LCD_DESIGN) {
        this.lcdDesignProperty().set((Object)LCD_DESIGN);
    }

    public final ObjectProperty<LcdDesign> lcdDesignProperty() {
        if (null == this.lcdDesign) {
            this.lcdDesign = new ObjectPropertyBase<LcdDesign>(LcdDesign.STANDARD){

                public void set(LcdDesign LCD_DESIGN) {
                    super.set((Object)LCD_DESIGN);
                    Lcd.this.getStyleClass().setAll((Object[])new String[]{"lcd", LCD_DESIGN.STYLE_CLASS});
                }

                public Object getBean() {
                    return Lcd.this;
                }

                public String getName() {
                    return "lcdDesign";
                }
            };
        }
        return this.lcdDesign;
    }

    public final boolean isFormerValueVisible() {
        return null == this.formerValueVisible ? this._formerValueVisible : this.formerValueVisible.get();
    }

    public final void setFormerValueVisible(boolean FORMER_VALUE_VISIBLE) {
        if (null == this.formerValueVisible) {
            this._formerValueVisible = FORMER_VALUE_VISIBLE;
        } else {
            this.formerValueVisible.set(FORMER_VALUE_VISIBLE);
        }
    }

    public final BooleanProperty formerValueVisibleProperty() {
        if (null == this.formerValueVisible) {
            this.formerValueVisible = new SimpleBooleanProperty((Object)this, "formerValueVisible", this._formerValueVisible);
        }
        return this.formerValueVisible;
    }

    public final int getMinMeasuredValueDecimals() {
        return null == this.minMeasuredValueDecimals ? this._minMeasuredValueDecimals : this.minMeasuredValueDecimals.get();
    }

    public final void setMinMeasuredValueDecimals(int MIN_MEASURED_VALUE_DECIMALS) {
        int DECIMALS;
        int n = MIN_MEASURED_VALUE_DECIMALS > 5 ? 5 : (DECIMALS = MIN_MEASURED_VALUE_DECIMALS < 0 ? 0 : MIN_MEASURED_VALUE_DECIMALS);
        if (null == this.minMeasuredValueDecimals) {
            this._minMeasuredValueDecimals = MIN_MEASURED_VALUE_DECIMALS;
        } else {
            this.minMeasuredValueDecimals.set(DECIMALS);
        }
    }

    public final IntegerProperty minMeasuredValueDecimalsProperty() {
        if (null == this.minMeasuredValueDecimals) {
            this.minMeasuredValueDecimals = new SimpleIntegerProperty((Object)this, "minMeasuredValueDecimals", this._minMeasuredValueDecimals);
        }
        return this.maxMeasuredValueDecimals;
    }

    public final int getMaxMeasuredValueDecimals() {
        return null == this.maxMeasuredValueDecimals ? this._maxMeasuredValueDecimals : this.maxMeasuredValueDecimals.get();
    }

    public final void setMaxMeasuredValueDecimals(int MAX_MEASURED_VALUE_DECIMALS) {
        int DECIMALS;
        int n = MAX_MEASURED_VALUE_DECIMALS > 5 ? 5 : (DECIMALS = MAX_MEASURED_VALUE_DECIMALS < 0 ? 0 : MAX_MEASURED_VALUE_DECIMALS);
        if (null == this.maxMeasuredValueDecimals) {
            this._maxMeasuredValueDecimals = MAX_MEASURED_VALUE_DECIMALS;
        } else {
            this.maxMeasuredValueDecimals.set(DECIMALS);
        }
    }

    public final IntegerProperty maxMeasuredValueDecimalsProperty() {
        if (null == this.maxMeasuredValueDecimals) {
            this.maxMeasuredValueDecimals = new SimpleIntegerProperty((Object)this, "maxMeasuredValueDecimals", this._maxMeasuredValueDecimals);
        }
        return this.maxMeasuredValueDecimals;
    }

    public static double clamp(double MIN, double MAX, double VALUE) {
        if (VALUE < MIN) {
            return MIN;
        }
        if (VALUE > MAX) {
            return MAX;
        }
        return VALUE;
    }

    private static synchronized void enableBlinkExecutorService() {
        if (null == periodicBlinkExecutorService) {
            periodicBlinkExecutorService = new ScheduledThreadPoolExecutor(1, Lcd.getThreadFactory("BlinkLCD", true));
        }
    }

    private synchronized void scheduleBlinkTask() {
        Lcd.enableBlinkExecutorService();
        this.stopTask(this.periodicBlinkTask);
        this.periodicBlinkTask = periodicBlinkExecutorService.scheduleAtFixedRate(() -> Platform.runLater(() -> {
            if (this.isBlinking()) {
                this.toggleValue ^= true;
                this.setValueVisible(this.toggleValue);
            }
            if (this.thresholdExceeded) {
                this.toggleThreshold ^= true;
                this.thresholdVisible.set(this.toggleThreshold);
            }
        }), 0L, this.interval, TimeUnit.MILLISECONDS);
    }

    private static ThreadFactory getThreadFactory(String THREAD_NAME, boolean IS_DAEMON) {
        return runnable -> {
            Thread thread = new Thread(runnable, THREAD_NAME);
            thread.setDaemon(IS_DAEMON);
            return thread;
        };
    }

    private void stopTask(ScheduledFuture<?> task) {
        if (null == task) {
            return;
        }
        task.cancel(true);
        task = null;
    }

    protected Skin createDefaultSkin() {
        return new LcdSkin(this);
    }

    public String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource(((Object)((Object)this)).getClass().getSimpleName().toLowerCase() + ".css").toExternalForm();
    }

    public static enum Trend {
        UP,
        RISING,
        STEADY,
        FALLING,
        DOWN,
        UNKNOWN;

    }

    public static enum NumberSystem {
        DECIMAL("dec"),
        HEXADECIMAL("hex"),
        OCTAL("oct");

        private String text;

        private NumberSystem(String TEXT) {
            this.text = TEXT;
        }

        public String toString() {
            return this.text;
        }
    }

    public static enum LcdFont {
        STANDARD,
        LCD,
        DIGITAL,
        DIGITAL_BOLD,
        ELEKTRA;

    }

    public static enum LcdDesign {
        BEIGE("lcd-beige"),
        BLUE("lcd-blue"),
        ORANGE("lcd-orange"),
        RED("lcd-red"),
        YELLOW("lcd-yellow"),
        WHITE("lcd-white"),
        GRAY("lcd-gray"),
        BLACK("lcd-black"),
        GREEN("lcd-green"),
        GREEN_DARKGREEN("lcd-green-darkgreen"),
        BLUE2("lcd-blue2"),
        BLUE_BLACK("lcd-blue-black"),
        BLUE_DARKBLUE("lcd-blue-darkblue"),
        BLUE_LIGHTBLUE("lcd-blue-lightblue"),
        BLUE_GRAY("lcd-blue-gray"),
        STANDARD("lcd-standard"),
        LIGHTGREEN("lcd-lightgreen"),
        STANDARD_GREEN("lcd-standard-green"),
        BLUE_BLUE("lcd-blue-blue"),
        RED_DARKRED("lcd-red-darkred"),
        DARKBLUE("lcd-darkblue"),
        PURPLE("lcd-purple"),
        BLACK_RED("lcd-black-red"),
        DARKGREEN("lcd-darkgreen"),
        AMBER("lcd-amber"),
        LIGHTBLUE("lcd-lightblue"),
        GREEN_BLACK("lcd-green-black"),
        YELLOW_BLACK("lcd-yellow-black"),
        BLACK_YELLOW("lcd-black-yellow"),
        LIGHTGREEN_BLACK("lcd-lightgreen-black"),
        DARKPURPLE("lcd-darkpurple"),
        DARKAMBER("lcd-darkamber"),
        BLUE_LIGHTBLUE2("lcd-blue-lightblue2"),
        GRAY_PURPLE("lcd-gray-purple"),
        SECTIONS("lcd-sections"),
        YOCTOPUCE("lcd-yoctopuce"),
        FLAT_TURQOISE("lcd-flat-turqoise"),
        FLAT_GREEN_SEA("lcd-flat-green-sea"),
        FLAT_EMERLAND("lcd-flat-emerland"),
        FLAT_NEPHRITIS("lcd-flat-nephritis"),
        FLAT_PETER_RIVER("lcd-flat-peter-river"),
        FLAT_BELIZE_HOLE("lcd-flat-belize-hole"),
        FLAT_AMETHYST("lcd-flat-amethyst"),
        FLAT_WISTERIA("lcd-flat-wisteria"),
        FLAT_SUNFLOWER("lcd-flat-sunflower"),
        FLAT_ORANGE("lcd-flat-orange"),
        FLAT_CARROT("lcd-flat-carrot"),
        FLAT_PUMPKIN("lcd-flat-pumpkin"),
        FLAT_ALIZARIN("lcd-flat-alizarin"),
        FLAT_POMEGRANATE("lcd-flat-pomegranate"),
        FLAT_CLOUDS("lcd-flat-clouds"),
        FLAT_SILVER("lcd-flat-silver"),
        FLAT_CONCRETE("lcd-flat-concrete"),
        FLAT_ASBESTOS("lcd-flat-asbestos"),
        FLAT_WET_ASPHALT("lcd-flat-wet-asphalt"),
        FLAT_MIDNIGHT_BLUE("lcd-flat-midnight-blue");

        public final String STYLE_CLASS;

        private LcdDesign(String STYLE_CLASS) {
            this.STYLE_CLASS = STYLE_CLASS;
        }
    }
}

