/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.lcd;

import eu.hansolo.enzo.lcd.Alarm;
import eu.hansolo.enzo.lcd.LcdClock;
import java.time.Clock;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.geometry.Dimension2D;

public class LcdClockBuilder<B extends LcdClockBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected LcdClockBuilder() {
    }

    public static final LcdClockBuilder create() {
        return new LcdClockBuilder();
    }

    public final LcdClockBuilder styleClass(String STYLE_CLASS) {
        this.properties.put("styleClass", (Property)new SimpleStringProperty(STYLE_CLASS));
        return this;
    }

    public final LcdClockBuilder clock(Clock CLOCK) {
        this.properties.put("clock", (Property)new SimpleObjectProperty((Object)CLOCK));
        return this;
    }

    public final LcdClockBuilder keepAspect(boolean KEEP_ASPECT) {
        this.properties.put("keepAspect", (Property)new SimpleBooleanProperty(KEEP_ASPECT));
        return this;
    }

    public final LcdClockBuilder noFrame(boolean NO_FRAME) {
        this.properties.put("noFrame", (Property)new SimpleBooleanProperty(NO_FRAME));
        return this;
    }

    public final LcdClockBuilder backgroundVisible(boolean BACKGROUND_VISIBLE) {
        this.properties.put("backgroundVisible", (Property)new SimpleBooleanProperty(BACKGROUND_VISIBLE));
        return this;
    }

    public final LcdClockBuilder crystalOverlayVisible(boolean CRYSTAL_OVERLAY_VISIBLE) {
        this.properties.put("crystalOverlayVisible", (Property)new SimpleBooleanProperty(CRYSTAL_OVERLAY_VISIBLE));
        return this;
    }

    public final LcdClockBuilder mainInnerShadowVisible(boolean MAIN_INNER_SHADOW_VISIBLE) {
        this.properties.put("mainInnerShadowVisible", (Property)new SimpleBooleanProperty(MAIN_INNER_SHADOW_VISIBLE));
        return this;
    }

    public final LcdClockBuilder foregroundShadowVisible(boolean FOREGROUND_SHADOW_VISIBLE) {
        this.properties.put("foregroundShadowVisible", (Property)new SimpleBooleanProperty(FOREGROUND_SHADOW_VISIBLE));
        return this;
    }

    public final LcdClockBuilder title(String TITLE) {
        this.properties.put("title", (Property)new SimpleStringProperty(TITLE));
        return this;
    }

    public final LcdClockBuilder alarms(Alarm ... ALARMS) {
        this.properties.put("alarmsArray", (Property)new SimpleObjectProperty((Object)ALARMS));
        return this;
    }

    public final LcdClockBuilder alarms(List<Alarm> ALARMS) {
        this.properties.put("alarmsList", (Property)new SimpleObjectProperty(ALARMS));
        return this;
    }

    public final LcdClockBuilder titleFont(String TITLE_FONT) {
        this.properties.put("titleFont", (Property)new SimpleStringProperty(TITLE_FONT));
        return this;
    }

    public final LcdClockBuilder secondFont(String SECOND_FONT) {
        this.properties.put("secondFont", (Property)new SimpleStringProperty(SECOND_FONT));
        return this;
    }

    public final LcdClockBuilder timeFont(LcdClock.LcdFont TIME_FONT) {
        this.properties.put("timeFont", (Property)new SimpleObjectProperty((Object)TIME_FONT));
        return this;
    }

    public final LcdClockBuilder smallFont(String SMALL_FONT) {
        this.properties.put("smallFont", (Property)new SimpleStringProperty(SMALL_FONT));
        return this;
    }

    public final LcdClockBuilder locale(Locale LOCALE) {
        this.properties.put("locale", (Property)new SimpleObjectProperty((Object)LOCALE));
        return this;
    }

    public final LcdClockBuilder dateFormat(LcdClock.DateFormat DATE_FORMAT) {
        this.properties.put("dateFormat", (Property)new SimpleObjectProperty((Object)DATE_FORMAT));
        return this;
    }

    public final LcdClockBuilder dateSeparator(LcdClock.DateSeparator DATE_SEPARATOR) {
        this.properties.put("dateSeparator", (Property)new SimpleObjectProperty((Object)DATE_SEPARATOR));
        return this;
    }

    public final B prefSize(double WIDTH, double HEIGHT) {
        this.properties.put("prefSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B minSize(double WIDTH, double HEIGHT) {
        this.properties.put("minSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B maxSize(double WIDTH, double HEIGHT) {
        this.properties.put("maxSize", (Property)new SimpleObjectProperty((Object)new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B prefWidth(double PREF_WIDTH) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(PREF_WIDTH));
        return (B)this;
    }

    public final B prefHeight(double PREF_HEIGHT) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(PREF_HEIGHT));
        return (B)this;
    }

    public final B minWidth(double MIN_WIDTH) {
        this.properties.put("minWidth", (Property)new SimpleDoubleProperty(MIN_WIDTH));
        return (B)this;
    }

    public final B minHeight(double MIN_HEIGHT) {
        this.properties.put("minHeight", (Property)new SimpleDoubleProperty(MIN_HEIGHT));
        return (B)this;
    }

    public final B maxWidth(double MAX_WIDTH) {
        this.properties.put("maxWidth", (Property)new SimpleDoubleProperty(MAX_WIDTH));
        return (B)this;
    }

    public final B maxHeight(double MAX_HEIGHT) {
        this.properties.put("maxHeight", (Property)new SimpleDoubleProperty(MAX_HEIGHT));
        return (B)this;
    }

    public final B scaleX(double SCALE_X) {
        this.properties.put("scaleX", (Property)new SimpleDoubleProperty(SCALE_X));
        return (B)this;
    }

    public final B scaleY(double SCALE_Y) {
        this.properties.put("scaleY", (Property)new SimpleDoubleProperty(SCALE_Y));
        return (B)this;
    }

    public final B layoutX(double LAYOUT_X) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(LAYOUT_X));
        return (B)this;
    }

    public final B layoutY(double LAYOUT_Y) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(LAYOUT_Y));
        return (B)this;
    }

    public final B translateX(double TRANSLATE_X) {
        this.properties.put("translateX", (Property)new SimpleDoubleProperty(TRANSLATE_X));
        return (B)this;
    }

    public final B translateY(double TRANSLATE_Y) {
        this.properties.put("translateY", (Property)new SimpleDoubleProperty(TRANSLATE_Y));
        return (B)this;
    }

    public final LcdClock build() {
        LcdClock CONTROL = new LcdClock();
        for (String key : this.properties.keySet()) {
            Dimension2D dim;
            if ("prefSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                CONTROL.setPrefSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("minSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                CONTROL.setPrefSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("maxSize".equals(key)) {
                dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                CONTROL.setPrefSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("prefWidth".equals(key)) {
                CONTROL.setPrefWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("prefHeight".equals(key)) {
                CONTROL.setPrefHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minWidth".equals(key)) {
                CONTROL.setMinWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minHeight".equals(key)) {
                CONTROL.setMinHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxWidth".equals(key)) {
                CONTROL.setMaxWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxHeight".equals(key)) {
                CONTROL.setMaxHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("scaleX".equals(key)) {
                CONTROL.setScaleX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("scaleY".equals(key)) {
                CONTROL.setScaleY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("layoutX".equals(key)) {
                CONTROL.setLayoutX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("layoutY".equals(key)) {
                CONTROL.setLayoutY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("translateX".equals(key)) {
                CONTROL.setTranslateX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("translateY".equals(key)) {
                CONTROL.setTranslateY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("styleClass".equals(key)) {
                CONTROL.getStyleClass().setAll((Object[])new String[]{"lcd-clock", (String)((StringProperty)this.properties.get(key)).get()});
                continue;
            }
            if ("keepAspect".equals(key)) {
                CONTROL.setKeepAspect(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("noFrame".equals(key)) {
                CONTROL.setNoFrame(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("backgroundVisible".equals(key)) {
                CONTROL.setBackgroundVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("crystalOverlayVisible".equals(key)) {
                CONTROL.setCrystalOverlayVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("mainInnerShadowVisible".equals(key)) {
                CONTROL.setMainInnerShadowVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("foregroundShadowVisible".equals(key)) {
                CONTROL.setForegroundShadowVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("title".equals(key)) {
                CONTROL.setTitle((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("titleFont".equals(key)) {
                CONTROL.setTitleFont((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("timeFont".equals(key)) {
                CONTROL.setTimeFont((LcdClock.LcdFont)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("smallFont".equals(key)) {
                CONTROL.setSmallFont((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("alarmsArray".equals(key)) {
                CONTROL.setAlarms((Alarm[])((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("alarmsList".equals(key)) {
                CONTROL.setAlarms((List)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("locale".equals(key)) {
                CONTROL.setLocale((Locale)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("dateFormat".equals(key)) {
                CONTROL.setDateFormat((LcdClock.DateFormat)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if (!"dateSeparator".equals(key)) continue;
            CONTROL.setDateSeparator((LcdClock.DateSeparator)((Object)((ObjectProperty)this.properties.get(key)).get()));
        }
        return CONTROL;
    }
}

