/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.lcd.skin;

import eu.hansolo.enzo.common.ValueEvent;
import eu.hansolo.enzo.fonts.Fonts;
import eu.hansolo.enzo.lcd.Lcd;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Random;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

public class LcdSkin
extends SkinBase<Lcd>
implements Skin<Lcd> {
    private static final double PREFERRED_WIDTH = 132.0;
    private static final double PREFERRED_HEIGHT = 48.0;
    private static final double MINIMUM_WIDTH = 5.0;
    private static final double MINIMUM_HEIGHT = 5.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private static double aspectRatio = 0.36363636363636365;
    private static Text oneSegment = new Text("8");
    private static Text dotSegment = new Text(".");
    private static final DecimalFormat DEC_FORMAT = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));
    private static final boolean SCIFI_FORMAT = false;
    private static final Color DARK_NOISE_COLOR = Color.rgb((int)100, (int)100, (int)100, (double)0.1);
    private static final Color BRIGHT_NOISE_COLOR = Color.rgb((int)200, (int)200, (int)200, (double)0.05);
    private static final DropShadow FOREGROUND_SHADOW = new DropShadow();
    private double width;
    private double height;
    private Pane pane;
    private Region main;
    private ImageView crystalOverlay;
    private Image crystalImage;
    private Rectangle crystalClip;
    private InnerShadow mainInnerShadow0;
    private InnerShadow mainInnerShadow1;
    private Region threshold;
    private Region trendDown;
    private Region trendFalling;
    private Region trendSteady;
    private Region trendRising;
    private Region trendUp;
    private Region battery;
    private Region signal;
    private Region alarm;
    private Text text;
    private Text backgroundText;
    private Text unitText;
    private Text title;
    private Text lowerRightText;
    private Text upperLeftText;
    private Text upperRightText;
    private Text lowerCenterText;
    private double valueOffsetLeft = 0.0;
    private double valueOffsetRight = 0.0;
    private double digitalFontSizeFactor = 1.0;
    private Font valueFont;
    private Font unitFont;
    private Font titleFont;
    private Font smallFont;
    private double oneSegmentWidth;
    private double dotSegmentWidth;
    private double widthOfDecimals;
    private double availableWidth;
    private int noOfSegments;
    private StringBuilder backgroundTextBuilder = new StringBuilder();
    private StringBuilder decBuffer = new StringBuilder(16);
    private Group shadowGroup;

    public LcdSkin(Lcd CONTROL) {
        super((Control)CONTROL);
        FOREGROUND_SHADOW.setOffsetX(0.0);
        FOREGROUND_SHADOW.setOffsetY(1.0);
        FOREGROUND_SHADOW.setColor(Color.rgb((int)0, (int)0, (int)0, (double)0.5));
        FOREGROUND_SHADOW.setBlurType(BlurType.TWO_PASS_BOX);
        FOREGROUND_SHADOW.setRadius(2.0);
        this.init();
        this.initGraphics();
        this.registerListeners();
    }

    private void init() {
        if (Double.compare(((Lcd)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((Lcd)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((Lcd)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((Lcd)this.getSkinnable()).getHeight(), 0.0) <= 0) {
            if (((Lcd)this.getSkinnable()).getPrefWidth() > 0.0 && ((Lcd)this.getSkinnable()).getPrefHeight() > 0.0) {
                ((Lcd)this.getSkinnable()).setPrefSize(((Lcd)this.getSkinnable()).getPrefWidth(), ((Lcd)this.getSkinnable()).getPrefHeight());
            } else {
                ((Lcd)this.getSkinnable()).setPrefSize(132.0, 48.0);
            }
        }
        if (Double.compare(((Lcd)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((Lcd)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((Lcd)this.getSkinnable()).setMinSize(5.0, 5.0);
        }
        if (Double.compare(((Lcd)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((Lcd)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((Lcd)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
        if (((Lcd)this.getSkinnable()).getPrefWidth() != 132.0 || ((Lcd)this.getSkinnable()).getPrefHeight() != 48.0) {
            aspectRatio = ((Lcd)this.getSkinnable()).getPrefHeight() / ((Lcd)this.getSkinnable()).getPrefWidth();
        }
    }

    private void initGraphics() {
        this.main = new Region();
        this.main.getStyleClass().setAll((Object[])new String[]{"main"});
        this.main.setOpacity(((Lcd)this.getSkinnable()).isBackgroundVisible() ? 1.0 : 0.0);
        this.mainInnerShadow0 = new InnerShadow();
        this.mainInnerShadow0.setOffsetX(0.0);
        this.mainInnerShadow0.setOffsetY(0.0);
        this.mainInnerShadow0.setRadius(3.0);
        this.mainInnerShadow0.setColor(Color.web((String)"0xffffff80"));
        this.mainInnerShadow0.setBlurType(BlurType.TWO_PASS_BOX);
        this.mainInnerShadow1 = new InnerShadow();
        this.mainInnerShadow1.setOffsetX(0.0);
        this.mainInnerShadow1.setOffsetY(1.0);
        this.mainInnerShadow1.setRadius(2.0);
        this.mainInnerShadow1.setColor(Color.web((String)"0x000000a6"));
        this.mainInnerShadow1.setBlurType(BlurType.TWO_PASS_BOX);
        this.mainInnerShadow1.setInput((Effect)this.mainInnerShadow0);
        this.main.setEffect((Effect)(((Lcd)this.getSkinnable()).isMainInnerShadowVisible() ? this.mainInnerShadow1 : null));
        this.crystalClip = new Rectangle(0.0, 0.0, this.width, this.height);
        this.crystalClip.setArcWidth(5.0);
        this.crystalClip.setArcHeight(5.0);
        this.crystalImage = this.createNoiseImage(132.0, 48.0, DARK_NOISE_COLOR, BRIGHT_NOISE_COLOR, 8.0);
        this.crystalOverlay = new ImageView(this.crystalImage);
        this.crystalOverlay.setClip((Node)this.crystalClip);
        this.crystalOverlay.setOpacity(((Lcd)this.getSkinnable()).isCrystalOverlayVisible() ? 1.0 : 0.0);
        this.threshold = new Region();
        this.threshold.getStyleClass().setAll((Object[])new String[]{"threshold"});
        this.threshold.setOpacity(0.0);
        this.trendDown = new Region();
        this.trendDown.getStyleClass().setAll((Object[])new String[]{"trend-down"});
        this.trendDown.setOpacity(((Lcd)this.getSkinnable()).isTrendVisible() && Lcd.Trend.DOWN == ((Lcd)this.getSkinnable()).getTrend() ? 1.0 : 0.0);
        this.trendFalling = new Region();
        this.trendFalling.getStyleClass().setAll((Object[])new String[]{"trend-falling"});
        this.trendFalling.setOpacity(((Lcd)this.getSkinnable()).isTrendVisible() && Lcd.Trend.FALLING == ((Lcd)this.getSkinnable()).getTrend() ? 1.0 : 0.0);
        this.trendSteady = new Region();
        this.trendSteady.getStyleClass().setAll((Object[])new String[]{"trend-steady"});
        this.trendSteady.setOpacity(((Lcd)this.getSkinnable()).isTrendVisible() && Lcd.Trend.STEADY == ((Lcd)this.getSkinnable()).getTrend() ? 1.0 : 0.0);
        this.trendRising = new Region();
        this.trendRising.getStyleClass().setAll((Object[])new String[]{"trend-rising"});
        this.trendRising.setOpacity(((Lcd)this.getSkinnable()).isTrendVisible() && Lcd.Trend.RISING == ((Lcd)this.getSkinnable()).getTrend() ? 1.0 : 0.0);
        this.trendUp = new Region();
        this.trendUp.getStyleClass().setAll((Object[])new String[]{"trend-up"});
        this.trendUp.setOpacity(((Lcd)this.getSkinnable()).isTrendVisible() && Lcd.Trend.UP == ((Lcd)this.getSkinnable()).getTrend() ? 1.0 : 0.0);
        this.battery = new Region();
        this.battery.getStyleClass().setAll((Object[])new String[]{"battery-empty"});
        this.battery.setOpacity(((Lcd)this.getSkinnable()).isBatteryVisible() ? 1.0 : 0.0);
        this.signal = new Region();
        this.signal.getStyleClass().setAll((Object[])new String[]{"signal"});
        this.signal.setOpacity(((Lcd)this.getSkinnable()).isSignalVisible() ? 1.0 : 0.0);
        this.alarm = new Region();
        this.alarm.getStyleClass().setAll((Object[])new String[]{"alarm"});
        this.alarm.setOpacity(((Lcd)this.getSkinnable()).isAlarmVisible() ? 1.0 : 0.0);
        if (((Lcd)this.getSkinnable()).isTextMode() && ((Lcd)this.getSkinnable()).getValueFont() == Lcd.LcdFont.LCD) {
            ((Lcd)this.getSkinnable()).setValueFont(Lcd.LcdFont.DIGITAL);
        }
        this.backgroundText = new Text(((Lcd)this.getSkinnable()).isTextMode() ? ((Lcd)this.getSkinnable()).getText() : Double.toString(((Lcd)this.getSkinnable()).getValue()));
        this.backgroundText.getStyleClass().setAll((Object[])new String[]{"fg-trsp"});
        this.backgroundText.setOpacity(Lcd.LcdFont.LCD == ((Lcd)this.getSkinnable()).getValueFont() || Lcd.LcdFont.ELEKTRA == ((Lcd)this.getSkinnable()).getValueFont() ? 1.0 : 0.0);
        this.text = new Text(((Lcd)this.getSkinnable()).isTextMode() ? ((Lcd)this.getSkinnable()).getText() : Double.toString(((Lcd)this.getSkinnable()).getValue()));
        this.text.getStyleClass().setAll((Object[])new String[]{"fg"});
        this.unitText = new Text(((Lcd)this.getSkinnable()).getUnit());
        this.unitText.getStyleClass().setAll((Object[])new String[]{"fg"});
        this.unitText.setOpacity(((Lcd)this.getSkinnable()).isUnitVisible() ? 1.0 : 0.0);
        this.unitText.visibleProperty().bind((ObservableValue)((Lcd)this.getSkinnable()).unitVisibleProperty());
        this.title = new Text(((Lcd)this.getSkinnable()).getTitle());
        this.title.getStyleClass().setAll((Object[])new String[]{"fg"});
        this.title.setOpacity(((Lcd)this.getSkinnable()).isTitleVisible() ? 1.0 : 0.0);
        this.lowerRightText = ((Lcd)this.getSkinnable()).isNumberSystemVisible() ? new Text(((Lcd)this.getSkinnable()).getNumberSystem().toString()) : new Text(((Lcd)this.getSkinnable()).getLowerRightText());
        this.lowerRightText.getStyleClass().setAll((Object[])new String[]{"fg"});
        this.lowerRightText.setOpacity(((Lcd)this.getSkinnable()).isLowerRightTextVisible() ? 1.0 : 0.0);
        this.upperLeftText = ((Lcd)this.getSkinnable()).isMinMeasuredValueVisible() ? new Text(Double.toString(((Lcd)this.getSkinnable()).getMaxValue())) : new Text(((Lcd)this.getSkinnable()).getUpperLeftText());
        this.upperLeftText.getStyleClass().setAll((Object[])new String[]{"fg"});
        this.upperLeftText.setOpacity(((Lcd)this.getSkinnable()).isMinMeasuredValueVisible() ? 1.0 : 0.0);
        this.upperRightText = ((Lcd)this.getSkinnable()).isMaxMeasuredValueVisible() ? new Text(Double.toString(((Lcd)this.getSkinnable()).getMinValue())) : new Text(((Lcd)this.getSkinnable()).getUpperRightText());
        this.upperRightText.getStyleClass().setAll((Object[])new String[]{"fg"});
        this.upperRightText.setOpacity(((Lcd)this.getSkinnable()).isMaxMeasuredValueVisible() ? 1.0 : 0.0);
        this.lowerCenterText = new Text(((Lcd)this.getSkinnable()).isFormerValueVisible() ? Double.toString(((Lcd)this.getSkinnable()).getFormerValue()) : ((Lcd)this.getSkinnable()).getLowerCenterText());
        this.lowerCenterText.getStyleClass().setAll((Object[])new String[]{"fg"});
        this.shadowGroup = new Group();
        this.shadowGroup.setEffect((Effect)(((Lcd)this.getSkinnable()).isForegroundShadowVisible() ? FOREGROUND_SHADOW : null));
        this.shadowGroup.getChildren().setAll((Object[])new Node[]{this.threshold, this.trendDown, this.trendFalling, this.trendSteady, this.trendRising, this.trendUp, this.battery, this.signal, this.alarm, this.text, this.unitText, this.title, this.lowerRightText, this.upperLeftText, this.upperRightText, this.lowerCenterText});
        this.pane = new Pane();
        this.pane.getChildren().setAll((Object[])new Node[]{this.main, this.crystalOverlay, this.backgroundText, this.shadowGroup});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        ((Lcd)this.getSkinnable()).widthProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((Lcd)this.getSkinnable()).heightProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((Lcd)this.getSkinnable()).lcdDesignProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((Lcd)this.getSkinnable()).titleProperty().addListener(observable -> this.handleControlPropertyChanged("UPDATE"));
        ((Lcd)this.getSkinnable()).unitProperty().addListener(observable -> this.handleControlPropertyChanged("UPDATE"));
        ((Lcd)this.getSkinnable()).lowerRightTextProperty().addListener(observable -> this.handleControlPropertyChanged("UPDATE"));
        ((Lcd)this.getSkinnable()).numberSystemProperty().addListener(observable -> this.handleControlPropertyChanged("UPDATE"));
        ((Lcd)this.getSkinnable()).textModeProperty().addListener(observable -> this.handleControlPropertyChanged("UPDATE"));
        ((Lcd)this.getSkinnable()).textProperty().addListener(observable -> this.handleControlPropertyChanged("UPDATE"));
        ((Lcd)this.getSkinnable()).valueProperty().addListener(observable -> this.handleControlPropertyChanged("UPDATE"));
        ((Lcd)this.getSkinnable()).currentValueProperty().addListener(observable -> this.handleControlPropertyChanged("UPDATE"));
        ((Lcd)this.getSkinnable()).lowerCenterTextProperty().addListener(observable -> this.handleControlPropertyChanged("UPDATE"));
        ((Lcd)this.getSkinnable()).minMeasuredValueProperty().addListener(observable -> this.handleControlPropertyChanged("UPDATE"));
        ((Lcd)this.getSkinnable()).maxMeasuredValueProperty().addListener(observable -> this.handleControlPropertyChanged("UPDATE"));
        ((Lcd)this.getSkinnable()).upperLeftTextProperty().addListener(observable -> this.handleControlPropertyChanged("UPDATE"));
        ((Lcd)this.getSkinnable()).upperRightTextProperty().addListener(observable -> this.handleControlPropertyChanged("UPDATE"));
        ((Lcd)this.getSkinnable()).batteryChargeProperty().addListener(observable -> this.handleControlPropertyChanged("UPDATE"));
        ((Lcd)this.getSkinnable()).signalStrengthProperty().addListener(observable -> this.handleControlPropertyChanged("UPDATE"));
        ((Lcd)this.getSkinnable()).prefWidthProperty().addListener(observable -> this.handleControlPropertyChanged("PREF_SIZE"));
        ((Lcd)this.getSkinnable()).prefHeightProperty().addListener(observable -> this.handleControlPropertyChanged("PREF_SIZE"));
        ((Lcd)this.getSkinnable()).valueFontProperty().addListener(observable -> this.handleControlPropertyChanged("FONT"));
        ((Lcd)this.getSkinnable()).smallFontProperty().addListener(observable -> this.handleControlPropertyChanged("FONT"));
        ((Lcd)this.getSkinnable()).unitFontProperty().addListener(observable -> this.handleControlPropertyChanged("FONT"));
        ((Lcd)this.getSkinnable()).numberSystemVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("NUMBER_SYSTEM_VISIBLE"));
        ((Lcd)this.getSkinnable()).backgroundVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("BACKGROUND_VISIBLE"));
        ((Lcd)this.getSkinnable()).crystalOverlayVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("CRYSTAL_OVERLAY_VISIBLE"));
        ((Lcd)this.getSkinnable()).mainInnerShadowVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("MAIN_INNER_SHADOW_VISIBLE"));
        ((Lcd)this.getSkinnable()).foregroundShadowVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("FOREGROUND_SHADOW_VISIBLE"));
        ((Lcd)this.getSkinnable()).animationDurationProperty().addListener(observable -> this.handleControlPropertyChanged("ANIMATION_DURATION"));
        ((Lcd)this.getSkinnable()).trendProperty().addListener(observable -> this.handleControlPropertyChanged("TREND"));
        ((Lcd)this.getSkinnable()).valueVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("VALUE_VISIBLE"));
        ((Lcd)this.getSkinnable()).unitVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("UNIT_VISIBLE"));
        ((Lcd)this.getSkinnable()).lowerCenterTextVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("LOWER_CENTER_VISIBLE"));
        ((Lcd)this.getSkinnable()).lowerRightTextVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("LOWER_RIGHT_VISIBLE"));
        ((Lcd)this.getSkinnable()).upperLeftTextVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("UPPER_LEFT_VISIBLE"));
        ((Lcd)this.getSkinnable()).upperRightTextVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("UPPER_RIGHT_VISIBLE"));
        ((Lcd)this.getSkinnable()).batteryVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("BATTERY_VISIBLE"));
        ((Lcd)this.getSkinnable()).signalVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("SIGNAL_VISIBLE"));
        ((Lcd)this.getSkinnable()).alarmVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("ALARM_VISIBLE"));
        ((Lcd)this.getSkinnable()).formerValueVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("FORMER_VALUE_VISIBLE"));
        ((Lcd)this.getSkinnable()).maxMeasuredValueVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("MAX_MEASURED_VISIBLE"));
        ((Lcd)this.getSkinnable()).minMeasuredValueVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("MIN_MEASURED_VISIBLE"));
        ((Lcd)this.getSkinnable()).addEventFilter(ValueEvent.VALUE_EXCEEDED, valueEvent -> this.handleControlPropertyChanged("THRESHOLD_EXCEEDED"));
        ((Lcd)this.getSkinnable()).addEventFilter(ValueEvent.VALUE_UNDERRUN, valueEvent -> this.handleControlPropertyChanged("THRESHOLD_UNDERRUN"));
        ((Lcd)this.getSkinnable()).getStyleClass().addListener((ListChangeListener)new ListChangeListener<String>(){

            public void onChanged(ListChangeListener.Change<? extends String> change) {
                LcdSkin.this.resize();
                LcdSkin.this.updateLcd();
            }
        });
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        if ("UPDATE".equals(PROPERTY)) {
            this.updateLcd();
        } else if ("RESIZE".equals(PROPERTY)) {
            this.resize();
            this.updateLcd();
        } else if ("PREF_SIZE".equals(PROPERTY)) {
            aspectRatio = ((Lcd)this.getSkinnable()).getPrefHeight() / ((Lcd)this.getSkinnable()).getPrefWidth();
        } else if ("BACKGROUND_VISIBLE".equals(PROPERTY)) {
            this.main.setOpacity(((Lcd)this.getSkinnable()).isBackgroundVisible() ? 1.0 : 0.0);
            this.main.setManaged(((Lcd)this.getSkinnable()).isBackgroundVisible());
            this.crystalOverlay.setOpacity(((Lcd)this.getSkinnable()).isBackgroundVisible() ? 1.0 : 0.0);
            this.crystalOverlay.setManaged(((Lcd)this.getSkinnable()).isBackgroundVisible());
        } else if ("CRYSTAL_OVERLAY_VISIBLE".equals(PROPERTY)) {
            this.crystalOverlay.setOpacity(((Lcd)this.getSkinnable()).isCrystalOverlayVisible() ? 1.0 : 0.0);
            this.crystalOverlay.setManaged(((Lcd)this.getSkinnable()).isCrystalOverlayVisible());
            this.resize();
        } else if ("MAIN_INNER_SHADOW_VISIBLE".equals(PROPERTY)) {
            this.main.setEffect((Effect)(((Lcd)this.getSkinnable()).isMainInnerShadowVisible() ? this.mainInnerShadow1 : null));
        } else if ("FOREGROUND_SHADOW_VISIBLE".equals(PROPERTY)) {
            this.shadowGroup.setEffect((Effect)(((Lcd)this.getSkinnable()).isForegroundShadowVisible() ? FOREGROUND_SHADOW : null));
        } else if ("TREND".equals(PROPERTY)) {
            this.updateTrend();
        } else if ("THRESHOLD_EXCEEDED".equals(PROPERTY)) {
            if (((Lcd)this.getSkinnable()).isThresholdVisible()) {
                this.threshold.setOpacity(((Lcd)this.getSkinnable()).isThresholdBehaviorInverted() ? 0.0 : 1.0);
            }
        } else if ("THRESHOLD_UNDERRUN".equals(PROPERTY)) {
            if (((Lcd)this.getSkinnable()).isThresholdVisible()) {
                this.threshold.setOpacity(((Lcd)this.getSkinnable()).isThresholdBehaviorInverted() ? 1.0 : 0.0);
            }
        } else if ("FONT".equals(PROPERTY)) {
            this.updateFonts();
        } else if ("VALUE_VISIBLE".equals(PROPERTY)) {
            this.text.setOpacity(((Lcd)this.getSkinnable()).isValueVisible() ? 1.0 : 0.0);
            this.text.setManaged(!((Lcd)this.getSkinnable()).isValueVisible());
        } else if ("UNIT_VISIBLE".equals(PROPERTY)) {
            this.unitText.setOpacity(((Lcd)this.getSkinnable()).isUnitVisible() ? 1.0 : 0.0);
            this.unitText.setManaged(((Lcd)this.getSkinnable()).isUnitVisible());
        } else if ("FORMER_VALUE_VISIBLE".equals(PROPERTY)) {
            this.lowerCenterText.setOpacity(((Lcd)this.getSkinnable()).isFormerValueVisible() ? 1.0 : 0.0);
            this.lowerCenterText.setManaged(((Lcd)this.getSkinnable()).isFormerValueVisible());
        } else if ("MAX_MEASURED_VISIBLE".equals(PROPERTY)) {
            this.upperRightText.setOpacity(((Lcd)this.getSkinnable()).isMaxMeasuredValueVisible() ? 1.0 : 0.0);
        } else if ("MIN_MEASURED_VISIBLE".equals(PROPERTY)) {
            this.upperLeftText.setOpacity(((Lcd)this.getSkinnable()).isMinMeasuredValueVisible() ? 1.0 : 0.0);
        } else if ("NUMBER_SYSTEM_VISIBLE".equals(PROPERTY)) {
            this.updateLcd();
        } else if ("LOWER_RIGHT_VISIBLE".equals(PROPERTY)) {
            this.lowerRightText.setOpacity(((Lcd)this.getSkinnable()).isLowerRightTextVisible() ? 1.0 : 0.0);
            this.lowerRightText.setManaged(((Lcd)this.getSkinnable()).isLowerRightTextVisible());
        } else if ("UPPER_LEFT_VISIBLE".equals(PROPERTY)) {
            this.upperLeftText.setOpacity(((Lcd)this.getSkinnable()).isUpperLeftTextVisible() ? 1.0 : 0.0);
        } else if ("UPPER_RIGHT_VISIBLE".equals(PROPERTY)) {
            this.upperRightText.setOpacity(((Lcd)this.getSkinnable()).isUpperRightTextVisible() ? 1.0 : 0.0);
        } else if ("BATTERY_VISIBLE".equals(PROPERTY)) {
            this.battery.setOpacity(((Lcd)this.getSkinnable()).isBatteryVisible() ? 1.0 : 0.0);
            this.battery.setManaged(((Lcd)this.getSkinnable()).isBatteryVisible());
        } else if ("SIGNAL_VISIBLE".equals(PROPERTY)) {
            this.signal.setOpacity(((Lcd)this.getSkinnable()).isSignalVisible() ? 1.0 : 0.0);
            this.signal.setManaged(((Lcd)this.getSkinnable()).isSignalVisible());
        } else if ("ALARM_VISIBLE".equals(PROPERTY)) {
            this.alarm.setOpacity(((Lcd)this.getSkinnable()).isAlarmVisible() ? 1.0 : 0.0);
            this.alarm.setManaged(((Lcd)this.getSkinnable()).isAlarmVisible());
        }
    }

    private boolean isNoOfDigitsInvalid() {
        double AVAILABLE_WIDTH = this.width - 2.0 - this.valueOffsetLeft - this.valueOffsetRight;
        double NEEDED_WIDTH = this.text.getLayoutBounds().getWidth();
        return Double.compare(AVAILABLE_WIDTH, NEEDED_WIDTH) < 0;
    }

    private String formatLcdValue(double VALUE, int DECIMALS) {
        this.decBuffer.setLength(0);
        this.decBuffer.append("0");
        if (DECIMALS > 0) {
            this.decBuffer.append(".");
        }
        for (int i = 0; i < DECIMALS; ++i) {
            this.decBuffer.append("0");
        }
        this.decBuffer.trimToSize();
        DEC_FORMAT.applyPattern(this.decBuffer.toString());
        return DEC_FORMAT.format(VALUE);
    }

    private Image createNoiseImage(double WIDTH, double HEIGHT, Color DARK_COLOR, Color BRIGHT_COLOR, double ALPHA_VARIATION_IN_PERCENT) {
        int width = WIDTH <= 0.0 ? 132 : (int)WIDTH;
        int height = HEIGHT <= 0.0 ? 48 : (int)HEIGHT;
        Lcd cfr_ignored_0 = (Lcd)this.getSkinnable();
        double alphaVariationInPercent = Lcd.clamp(0.0, 100.0, ALPHA_VARIATION_IN_PERCENT);
        WritableImage IMAGE = new WritableImage(width, height);
        PixelWriter PIXEL_WRITER = IMAGE.getPixelWriter();
        Random BW_RND = new Random();
        Random ALPHA_RND = new Random();
        double ALPHA_START = alphaVariationInPercent / 100.0 / 2.0;
        double ALPHA_VARIATION = alphaVariationInPercent / 100.0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Color NOISE_COLOR = BW_RND.nextBoolean() ? BRIGHT_COLOR : DARK_COLOR;
                Lcd cfr_ignored_1 = (Lcd)this.getSkinnable();
                double NOISE_ALPHA = Lcd.clamp(0.0, 1.0, ALPHA_START + ALPHA_RND.nextDouble() * ALPHA_VARIATION);
                PIXEL_WRITER.setColor(x, y, Color.color((double)NOISE_COLOR.getRed(), (double)NOISE_COLOR.getGreen(), (double)NOISE_COLOR.getBlue(), (double)NOISE_ALPHA));
            }
        }
        return IMAGE;
    }

    private void updateFonts() {
        this.digitalFontSizeFactor = 1.0;
        switch (((Lcd)this.getSkinnable()).getValueFont()) {
            case LCD: {
                this.valueFont = Fonts.digital(0.6 * this.height);
                this.digitalFontSizeFactor = 1.4;
                break;
            }
            case DIGITAL: {
                this.valueFont = Fonts.digitalReadout(0.5833333333 * this.height);
                break;
            }
            case DIGITAL_BOLD: {
                this.valueFont = Fonts.digitalReadoutBold(0.5833333333 * this.height);
                break;
            }
            case ELEKTRA: {
                this.valueFont = Fonts.elektra(0.62 * this.height);
                break;
            }
            default: {
                this.valueFont = Fonts.robotoMedium(0.5 * this.height);
            }
        }
        this.backgroundText.setFont(this.valueFont);
        this.backgroundText.setOpacity((Lcd.LcdFont.LCD == ((Lcd)this.getSkinnable()).getValueFont() || Lcd.LcdFont.DIGITAL == ((Lcd)this.getSkinnable()).getValueFont() || Lcd.LcdFont.DIGITAL_BOLD == ((Lcd)this.getSkinnable()).getValueFont() || Lcd.LcdFont.ELEKTRA == ((Lcd)this.getSkinnable()).getValueFont()) && !((Lcd)this.getSkinnable()).isTextMode() ? 1.0 : 0.0);
        this.text.setFont(this.valueFont);
        this.unitFont = Font.font((String)((Lcd)this.getSkinnable()).getUnitFont(), (FontWeight)FontWeight.NORMAL, (double)(0.26 * this.height));
        this.titleFont = Font.font((String)((Lcd)this.getSkinnable()).getTitleFont(), (FontWeight)FontWeight.BOLD, (double)(0.1666666667 * this.height));
        this.smallFont = Font.font((String)((Lcd)this.getSkinnable()).getSmallFont(), (FontWeight)FontWeight.NORMAL, (double)(0.1666666667 * this.height));
    }

    private void updateTrend() {
        if (((Lcd)this.getSkinnable()).isTrendVisible()) {
            switch (((Lcd)this.getSkinnable()).getTrend()) {
                case UP: {
                    this.trendUp.setOpacity(1.0);
                    this.trendRising.setOpacity(0.0);
                    this.trendSteady.setOpacity(0.0);
                    this.trendFalling.setOpacity(0.0);
                    this.trendDown.setOpacity(0.0);
                    break;
                }
                case RISING: {
                    this.trendUp.setOpacity(0.0);
                    this.trendRising.setOpacity(1.0);
                    this.trendSteady.setOpacity(0.0);
                    this.trendFalling.setOpacity(0.0);
                    this.trendDown.setOpacity(0.0);
                    break;
                }
                case STEADY: {
                    this.trendUp.setOpacity(0.0);
                    this.trendRising.setOpacity(0.0);
                    this.trendSteady.setOpacity(1.0);
                    this.trendFalling.setOpacity(0.0);
                    this.trendDown.setOpacity(0.0);
                    break;
                }
                case FALLING: {
                    this.trendUp.setOpacity(0.0);
                    this.trendRising.setOpacity(0.0);
                    this.trendSteady.setOpacity(0.0);
                    this.trendFalling.setOpacity(1.0);
                    this.trendDown.setOpacity(0.0);
                    break;
                }
                case DOWN: {
                    this.trendUp.setOpacity(0.0);
                    this.trendRising.setOpacity(0.0);
                    this.trendSteady.setOpacity(0.0);
                    this.trendFalling.setOpacity(0.0);
                    this.trendDown.setOpacity(1.0);
                    break;
                }
                default: {
                    this.trendUp.setOpacity(0.0);
                    this.trendRising.setOpacity(0.0);
                    this.trendSteady.setOpacity(0.0);
                    this.trendFalling.setOpacity(0.0);
                    this.trendDown.setOpacity(0.0);
                }
            }
        }
    }

    private void updateBackgroundText() {
        this.backgroundText.setCache(false);
        this.backgroundText.setTextOrigin(VPos.BASELINE);
        this.backgroundText.setTextAlignment(TextAlignment.RIGHT);
        oneSegment.setFont(this.valueFont);
        dotSegment.setText(".");
        if (Lcd.LcdFont.LCD == ((Lcd)this.getSkinnable()).getValueFont()) {
            oneSegment.setText("8");
        } else if (Lcd.LcdFont.DIGITAL == ((Lcd)this.getSkinnable()).getValueFont()) {
            oneSegment.setText("_");
        } else if (Lcd.LcdFont.DIGITAL_BOLD == ((Lcd)this.getSkinnable()).getValueFont()) {
            oneSegment.setText("_");
        } else if (Lcd.LcdFont.ELEKTRA == ((Lcd)this.getSkinnable()).getValueFont()) {
            oneSegment.setText("_");
        }
        this.oneSegmentWidth = oneSegment.getLayoutBounds().getWidth();
        this.dotSegmentWidth = dotSegment.getLayoutBounds().getWidth();
        if (Lcd.NumberSystem.DECIMAL == ((Lcd)this.getSkinnable()).getNumberSystem()) {
            int i;
            this.widthOfDecimals = 0 == ((Lcd)this.getSkinnable()).getDecimals() ? 0.0 : (double)((Lcd)this.getSkinnable()).getDecimals() * this.oneSegmentWidth + (Lcd.LcdFont.LCD == ((Lcd)this.getSkinnable()).getValueFont() ? this.oneSegmentWidth : this.dotSegmentWidth);
            this.availableWidth = this.width - 0.0151515152 * this.width - 0.0416666667 * this.height - 2.0 - this.valueOffsetRight - this.widthOfDecimals;
            this.noOfSegments = (int)Math.floor(this.availableWidth / this.oneSegmentWidth);
            this.backgroundTextBuilder.setLength(0);
            for (i = 0; i < ((Lcd)this.getSkinnable()).getDecimals(); ++i) {
                this.backgroundTextBuilder.append(oneSegment.getText());
            }
            if (((Lcd)this.getSkinnable()).getDecimals() != 0) {
                this.backgroundTextBuilder.insert(0, ".");
            }
            for (i = 0; i < this.noOfSegments; ++i) {
                this.backgroundTextBuilder.insert(0, oneSegment.getText());
            }
            this.backgroundText.setText(this.backgroundTextBuilder.toString());
        } else {
            this.availableWidth = this.width - 0.0151515152 * this.width - 0.0416666667 * this.height - 2.0 - this.valueOffsetRight;
            this.noOfSegments = (int)Math.floor(this.availableWidth / this.oneSegmentWidth);
            this.backgroundTextBuilder.setLength(0);
            for (int i = 0; i < this.noOfSegments; ++i) {
                this.backgroundTextBuilder.insert(0, oneSegment.getText());
            }
            this.backgroundText.setText(this.backgroundTextBuilder.toString());
        }
        this.backgroundText.setCache(true);
        this.backgroundText.setCacheHint(CacheHint.SCALE);
    }

    private void updateLcd() {
        if (((Lcd)this.getSkinnable()).isTextMode() && Lcd.LcdFont.LCD != ((Lcd)this.getSkinnable()).getValueFont()) {
            this.text.setText(((Lcd)this.getSkinnable()).getText());
        } else {
            switch (((Lcd)this.getSkinnable()).getNumberSystem()) {
                case HEXADECIMAL: {
                    this.text.setText(Integer.toHexString((int)((Lcd)this.getSkinnable()).getCurrentValue()).toUpperCase());
                    break;
                }
                case OCTAL: {
                    this.text.setText(Integer.toOctalString((int)((Lcd)this.getSkinnable()).getCurrentValue()).toUpperCase());
                    break;
                }
                default: {
                    this.text.setText(this.formatLcdValue(((Lcd)this.getSkinnable()).getCurrentValue(), ((Lcd)this.getSkinnable()).getDecimals()));
                }
            }
        }
        if (this.isNoOfDigitsInvalid()) {
            this.text.setText("-E-");
        }
        this.updateBackgroundText();
        if (((Lcd)this.getSkinnable()).isUnitVisible()) {
            this.backgroundText.setX(this.width - 2.0 - this.backgroundText.getLayoutBounds().getWidth() - this.valueOffsetRight);
        } else {
            this.backgroundText.setX(this.width - this.backgroundText.getLayoutBounds().getWidth() - this.valueOffsetRight);
        }
        this.backgroundText.setY(this.height - this.backgroundText.getLayoutBounds().getHeight() * this.digitalFontSizeFactor * 0.5);
        if (((Lcd)this.getSkinnable()).isUnitVisible()) {
            this.text.setX(this.width - 2.0 - this.text.getLayoutBounds().getWidth() - this.valueOffsetRight);
        } else {
            this.text.setX(this.width - this.text.getLayoutBounds().getWidth() - this.valueOffsetRight);
        }
        this.title.setText(((Lcd)this.getSkinnable()).getTitle());
        this.title.setX((this.width - this.title.getLayoutBounds().getWidth()) * 0.5);
        this.upperLeftText.setText(((Lcd)this.getSkinnable()).isMinMeasuredValueVisible() ? this.formatLcdValue(((Lcd)this.getSkinnable()).getMinMeasuredValue(), ((Lcd)this.getSkinnable()).getMinMeasuredValueDecimals()) : ((Lcd)this.getSkinnable()).getUpperLeftText());
        if (this.upperLeftText.getX() + this.upperLeftText.getLayoutBounds().getWidth() > this.title.getX()) {
            this.upperLeftText.setText("...");
        }
        this.upperRightText.setText(((Lcd)this.getSkinnable()).isMaxMeasuredValueVisible() ? this.formatLcdValue(((Lcd)this.getSkinnable()).getMaxMeasuredValue(), ((Lcd)this.getSkinnable()).getMaxMeasuredValueDecimals()) : ((Lcd)this.getSkinnable()).getUpperRightText());
        this.upperRightText.setX(this.width - this.upperRightText.getLayoutBounds().getWidth() - 0.0416666667 * this.height);
        if (this.upperRightText.getX() < this.title.getX() + this.title.getLayoutBounds().getWidth()) {
            this.upperRightText.setText("...");
            this.upperRightText.setX(this.width - this.upperRightText.getLayoutBounds().getWidth() - 0.0416666667 * this.height);
        }
        this.lowerCenterText.setText(((Lcd)this.getSkinnable()).isFormerValueVisible() ? this.formatLcdValue(((Lcd)this.getSkinnable()).getFormerValue(), ((Lcd)this.getSkinnable()).getDecimals()) : ((Lcd)this.getSkinnable()).getLowerCenterText());
        this.lowerCenterText.setX((this.width - this.lowerCenterText.getLayoutBounds().getWidth()) * 0.5);
        this.lowerRightText.setText(((Lcd)this.getSkinnable()).isNumberSystemVisible() ? ((Lcd)this.getSkinnable()).getNumberSystem().toString() : ((Lcd)this.getSkinnable()).getLowerRightText());
        this.lowerRightText.setX(this.width - this.lowerRightText.getLayoutBounds().getWidth() - 0.0416666667 * this.height);
        this.lowerRightText.setY(this.main.getLayoutY() + this.height - 3.0 - 0.0416666667 * this.height);
        if (this.lowerRightText.getX() < this.lowerCenterText.getX() + this.lowerCenterText.getLayoutBounds().getWidth()) {
            this.lowerRightText.setText("...");
            this.lowerRightText.setX(this.width - this.lowerRightText.getLayoutBounds().getWidth() - 0.0416666667 * this.height);
        }
        if (((Lcd)this.getSkinnable()).getBatteryCharge() < 0.01) {
            this.battery.getStyleClass().setAll((Object[])new String[]{"battery-empty"});
        } else if (((Lcd)this.getSkinnable()).getBatteryCharge() < 0.06) {
            this.battery.getStyleClass().setAll((Object[])new String[]{"battery-almost-empty"});
        } else if (((Lcd)this.getSkinnable()).getBatteryCharge() < 0.26) {
            this.battery.getStyleClass().setAll((Object[])new String[]{"battery-25"});
        } else if (((Lcd)this.getSkinnable()).getBatteryCharge() < 0.51) {
            this.battery.getStyleClass().setAll((Object[])new String[]{"battery-50"});
        } else if (((Lcd)this.getSkinnable()).getBatteryCharge() < 0.76) {
            this.battery.getStyleClass().setAll((Object[])new String[]{"battery-75"});
        } else if (((Lcd)this.getSkinnable()).getBatteryCharge() < 0.96) {
            this.battery.getStyleClass().setAll((Object[])new String[]{"battery-almost-full"});
        } else {
            this.battery.getStyleClass().setAll((Object[])new String[]{"battery-full"});
        }
        if (((Lcd)this.getSkinnable()).getSignalStrength() < 0.06) {
            this.signal.getStyleClass().setAll((Object[])new String[]{"signal", "signal-0"});
        } else if (((Lcd)this.getSkinnable()).getSignalStrength() < 0.26) {
            this.signal.getStyleClass().setAll((Object[])new String[]{"signal", "signal-25"});
        } else if (((Lcd)this.getSkinnable()).getSignalStrength() < 0.51) {
            this.signal.getStyleClass().setAll((Object[])new String[]{"signal", "signal-50"});
        } else if (((Lcd)this.getSkinnable()).getSignalStrength() < 0.85) {
            this.signal.getStyleClass().setAll((Object[])new String[]{"signal", "signal-75"});
        } else {
            this.signal.getStyleClass().setAll((Object[])new String[]{"signal", "signal-100"});
        }
    }

    private void resize() {
        this.width = ((Lcd)this.getSkinnable()).getWidth();
        this.height = ((Lcd)this.getSkinnable()).getHeight();
        if (((Lcd)this.getSkinnable()).isKeepAspect()) {
            if (aspectRatio * this.width > this.height) {
                this.width = 1.0 / (aspectRatio / this.height);
            } else if (1.0 / (aspectRatio / this.height) > this.width) {
                this.height = aspectRatio * this.width;
            }
        }
        if (this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.main.setPrefSize(this.width, this.height);
            this.mainInnerShadow0.setRadius(0.022727272727272728 * this.height);
            this.mainInnerShadow1.setRadius(0.015151515151515152 * this.height);
            if (this.crystalOverlay.isVisible()) {
                this.crystalClip.setWidth(this.width);
                this.crystalClip.setHeight(this.height);
                this.crystalOverlay.setImage(this.createNoiseImage(this.width, this.height, DARK_NOISE_COLOR, BRIGHT_NOISE_COLOR, 8.0));
                this.crystalOverlay.setCache(true);
            }
            this.threshold.setPrefSize(0.2 * this.height, 0.2 * this.height);
            this.threshold.setTranslateX(0.027961994662429348 * this.width);
            this.threshold.setTranslateY(0.75 * this.height - 2.0);
            this.threshold.setCacheShape(true);
            this.trendDown.setPrefSize(0.06718573425755356 * this.width, 0.1333622932434082 * this.height);
            this.trendDown.setTranslateX(0.1439393939 * this.width);
            this.trendDown.setTranslateY(0.8125 * this.height - 2.0);
            this.trendDown.setCacheShape(true);
            this.trendFalling.setPrefSize(0.06982171896732214 * this.width, 0.13879903157552084 * this.height);
            this.trendFalling.setTranslateX(0.1439393939 * this.width);
            this.trendFalling.setTranslateY(0.8061291376749674 * this.height - 2.0);
            this.trendFalling.setCacheShape(true);
            this.trendSteady.setPrefSize(0.0676060878869259 * this.width, 0.1342292626698812 * this.height);
            this.trendSteady.setTranslateX(0.1439393939 * this.width);
            this.trendSteady.setTranslateY(0.8078853289286295 * this.height - 2.0);
            this.trendSteady.setCacheShape(true);
            this.trendRising.setPrefSize(0.06982171896732214 * this.width, 0.13879903157552084 * this.height);
            this.trendRising.setTranslateX(0.1439393939 * this.width);
            this.trendRising.setTranslateY(0.8050718307495117 * this.height - 2.0);
            this.trendRising.setCacheShape(true);
            this.trendUp.setPrefSize(0.06718573425755356 * this.width, 0.1333622932434082 * this.height);
            this.trendUp.setTranslateX(0.1439393939 * this.width);
            this.trendUp.setTranslateY(0.8041377067565918 * this.height - 2.0);
            this.trendUp.setCacheShape(true);
            this.battery.setPrefSize(0.0833333333 * this.width, 0.1458333333 * this.height);
            this.battery.setTranslateX(0.6439393939 * this.width);
            this.battery.setTranslateY(0.81 * this.height - 2.0);
            this.battery.setCacheShape(true);
            this.signal.setPrefSize(0.0416666667 * this.height, 0.5 * this.height);
            this.signal.setTranslateX(0.0151515152 * this.width);
            this.signal.setTranslateY(0.25 * this.height);
            this.signal.setCacheShape(true);
            this.alarm.setPrefSize(0.1666666667 * this.height, 0.1666666667 * this.height);
            this.alarm.setTranslateX(0.2651515152 * this.width);
            this.alarm.setTranslateY(0.7916666667 * this.height - 2.0);
            this.alarm.setCacheShape(true);
            this.updateFonts();
            this.unitText.setFont(this.unitFont);
            this.unitText.setTextOrigin(VPos.BASELINE);
            this.unitText.setTextAlignment(TextAlignment.RIGHT);
            this.unitText.setText(((Lcd)this.getSkinnable()).getUnit());
            if (this.unitText.visibleProperty().isBound()) {
                this.unitText.visibleProperty().unbind();
            }
            this.valueOffsetLeft = this.height * 0.04;
            if (((Lcd)this.getSkinnable()).isUnitVisible()) {
                this.unitText.setX(this.width - this.unitText.getLayoutBounds().getWidth() - this.height * 0.04);
                this.unitText.setY(this.height - this.text.getLayoutBounds().getHeight() * this.digitalFontSizeFactor * 0.5);
                this.valueOffsetRight = this.unitText.getLayoutBounds().getWidth() + this.height * 0.0833333333;
                this.text.setX(this.width - 2.0 - this.text.getLayoutBounds().getWidth() - this.valueOffsetRight);
            } else {
                this.valueOffsetRight = this.height * 0.0833333333;
                this.text.setX(this.width - this.text.getLayoutBounds().getWidth() - this.valueOffsetRight);
            }
            this.text.setY(this.height - this.text.getLayoutBounds().getHeight() * this.digitalFontSizeFactor * 0.5);
            this.updateBackgroundText();
            if (((Lcd)this.getSkinnable()).isUnitVisible()) {
                this.backgroundText.setX(this.width - 2.0 - this.backgroundText.getLayoutBounds().getWidth() - this.valueOffsetRight);
            } else {
                this.backgroundText.setX(this.width - this.backgroundText.getLayoutBounds().getWidth() - this.valueOffsetRight);
            }
            this.backgroundText.setY(this.height - this.backgroundText.getLayoutBounds().getHeight() * this.digitalFontSizeFactor * 0.5);
            this.title.setFont(this.titleFont);
            this.title.setTextOrigin(VPos.BASELINE);
            this.title.setTextAlignment(TextAlignment.CENTER);
            this.title.setText(((Lcd)this.getSkinnable()).getTitle());
            this.title.setX((this.width - this.title.getLayoutBounds().getWidth()) * 0.5);
            this.title.setY(this.main.getLayoutY() + this.title.getLayoutBounds().getHeight() - 0.04 * this.height + 2.0);
            this.lowerRightText.setFont(this.smallFont);
            this.lowerRightText.setTextOrigin(VPos.BASELINE);
            this.lowerRightText.setTextAlignment(TextAlignment.RIGHT);
            this.lowerRightText.setText(((Lcd)this.getSkinnable()).getNumberSystem().toString());
            this.lowerRightText.setX(this.main.getLayoutX() + (this.main.getLayoutBounds().getWidth() - this.lowerRightText.getLayoutBounds().getWidth()) * 0.5);
            this.lowerRightText.setY(this.main.getLayoutY() + this.height - 3.0 - 0.0416666667 * this.height);
            this.upperLeftText.setFont(this.smallFont);
            this.upperLeftText.setTextOrigin(VPos.BASELINE);
            this.upperLeftText.setTextAlignment(TextAlignment.RIGHT);
            this.upperLeftText.setX(this.main.getLayoutX() + 0.0416666667 * this.height);
            this.upperLeftText.setY(this.main.getLayoutY() + this.upperLeftText.getLayoutBounds().getHeight() - 0.04 * this.height + 2.0);
            this.upperRightText.setFont(this.smallFont);
            this.upperRightText.setTextOrigin(VPos.BASELINE);
            this.upperRightText.setTextAlignment(TextAlignment.RIGHT);
            this.upperRightText.setY(this.main.getLayoutY() + this.upperRightText.getLayoutBounds().getHeight() - 0.04 * this.height + 2.0);
            this.lowerCenterText.setFont(this.smallFont);
            this.lowerCenterText.setTextOrigin(VPos.BASELINE);
            this.lowerCenterText.setTextAlignment(TextAlignment.CENTER);
            this.lowerCenterText.setX((this.width - this.lowerCenterText.getLayoutBounds().getWidth()) * 0.5);
            this.lowerCenterText.setY(this.main.getLayoutY() + this.height - 3.0 - 0.0416666667 * this.height);
        }
    }
}

