/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.ledbargraph.skin;

import eu.hansolo.enzo.led.Led;
import eu.hansolo.enzo.led.LedBuilder;
import eu.hansolo.enzo.ledbargraph.LedBargraph;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import javafx.animation.AnimationTimer;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Paint;

public class LedBargraphSkin
extends SkinBase<LedBargraph>
implements Skin<LedBargraph> {
    private static final double PREFERRED_SIZE = 16.0;
    private static final double MINIMUM_SIZE = 8.0;
    private static final double MAXIMUM_SIZE = 1024.0;
    public static final long PEAK_TIMEOUT = 1500000000L;
    private Pane bargraph;
    private List<Led> ledList = new ArrayList<Led>(((LedBargraph)this.getSkinnable()).getNoOfLeds());
    private long lastTimerCall = 0L;
    private DoubleProperty stepSize = new SimpleDoubleProperty(1.0 / (double)((LedBargraph)this.getSkinnable()).getNoOfLeds());
    private int peakLedIndex = 0;
    private AnimationTimer timer = new AnimationTimer(){

        public void handle(long NOW) {
            if (NOW > LedBargraphSkin.this.lastTimerCall + 1500000000L && Double.compare((double)LedBargraphSkin.this.peakLedIndex * LedBargraphSkin.this.stepSize.doubleValue(), ((LedBargraph)LedBargraphSkin.this.getSkinnable()).getValue()) > 0) {
                ((Led)((Object)LedBargraphSkin.this.ledList.get(LedBargraphSkin.this.peakLedIndex))).setOn(false);
                LedBargraphSkin.this.peakLedIndex = 0;
                LedBargraphSkin.this.timer.stop();
            }
        }
    };

    public LedBargraphSkin(LedBargraph CONTROL) {
        super((Control)CONTROL);
        this.init();
        this.initGraphics();
        this.registerListeners();
        this.setLedSizes();
    }

    private void init() {
        if (Double.compare(((LedBargraph)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((LedBargraph)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || ((LedBargraph)this.getSkinnable()).getWidth() <= 0.0 || ((LedBargraph)this.getSkinnable()).getHeight() <= 0.0) {
            ((LedBargraph)this.getSkinnable()).setPrefSize(16.0, 16.0);
        }
        if (Double.compare(((LedBargraph)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((LedBargraph)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((LedBargraph)this.getSkinnable()).setMinSize(8.0, 8.0);
        }
        if (Double.compare(((LedBargraph)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((LedBargraph)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((LedBargraph)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
        for (int i = 0; i < ((LedBargraph)this.getSkinnable()).getNoOfLeds(); ++i) {
            Led led = ((LedBuilder)((LedBuilder)LedBuilder.create().frameVisible(((LedBargraph)this.getSkinnable()).isFrameVisible()).prefWidth(((LedBargraph)this.getSkinnable()).getLedSize())).prefHeight(((LedBargraph)this.getSkinnable()).getLedSize())).build();
            this.ledList.add(led);
            if (!(((LedBargraph)this.getSkinnable()).getValue() > 0.0)) continue;
            if (Double.compare((double)i * this.stepSize.doubleValue(), ((LedBargraph)this.getSkinnable()).getValue()) <= 0) {
                this.ledList.get(i).setOn(true);
                continue;
            }
            this.ledList.get(i).setOn(false);
        }
        this.setLedColors();
        this.setLedTypes();
    }

    private void initGraphics() {
        int NO_OF_LEDS = ((LedBargraph)this.getSkinnable()).getNoOfLeds();
        if (((LedBargraph)this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
            this.bargraph = new VBox();
            ((VBox)this.bargraph).setSpacing(0.0);
            IntStream.range(0, NO_OF_LEDS).parallel().forEachOrdered(i -> this.bargraph.getChildren().add(i, (Object)this.ledList.get(NO_OF_LEDS - 1 - i)));
        } else {
            this.bargraph = new HBox();
            ((HBox)this.bargraph).setSpacing(0.0);
            IntStream.range(0, NO_OF_LEDS).parallel().forEachOrdered(i -> this.bargraph.getChildren().add(i, (Object)this.ledList.get(i)));
        }
        this.getChildren().setAll((Object[])new Node[]{this.bargraph});
    }

    private void registerListeners() {
        ((LedBargraph)this.getSkinnable()).widthProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((LedBargraph)this.getSkinnable()).heightProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((LedBargraph)this.getSkinnable()).valueProperty().addListener(observable -> this.handleControlPropertyChanged("VALUE"));
        ((LedBargraph)this.getSkinnable()).ledTypeProperty().addListener(observable -> this.handleControlPropertyChanged("LED_TYPE"));
        ((LedBargraph)this.getSkinnable()).frameVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("FRAME_VISIBLE"));
        ((LedBargraph)this.getSkinnable()).ledSizeProperty().addListener(observable -> this.handleControlPropertyChanged("LED_SIZE"));
        ((LedBargraph)this.getSkinnable()).orientationProperty().addListener(observable -> this.handleControlPropertyChanged("ORIENTATION"));
        ((LedBargraph)this.getSkinnable()).noOfLedsProperty().addListener(observable -> this.handleControlPropertyChanged("LED_NUMBER"));
        ((LedBargraph)this.getSkinnable()).ledColorsProperty().addListener(change -> this.handleControlPropertyChanged("LED_COLOR"));
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        super.layoutChildren(x, y, w, h);
        ((LedBargraph)this.getSkinnable()).getParent().requestLayout();
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        if ("VALUE".equals(PROPERTY)) {
            int currentLedPeakIndex = 0;
            for (int i = 0; i < ((LedBargraph)this.getSkinnable()).getNoOfLeds(); ++i) {
                if (Double.compare(((LedBargraph)this.getSkinnable()).getValue(), 0.0) == 0) {
                    this.ledList.get(i).setOn(false);
                } else if (Double.compare((double)i * this.stepSize.doubleValue(), ((LedBargraph)this.getSkinnable()).getValue()) < 0) {
                    this.ledList.get(i).setOn(true);
                    currentLedPeakIndex = i;
                } else {
                    this.ledList.get(i).setOn(false);
                }
                if (!(((LedBargraph)this.getSkinnable()).getValue() > 0.0)) continue;
                this.ledList.get(this.peakLedIndex).setOn(true);
            }
            if (((LedBargraph)this.getSkinnable()).isPeakValueVisible() && currentLedPeakIndex > this.peakLedIndex) {
                this.peakLedIndex = currentLedPeakIndex;
                this.timer.stop();
                this.lastTimerCall = System.nanoTime();
                this.timer.start();
            }
        } else if ("FRAME_VISIBLE".equals(PROPERTY)) {
            for (Led led : this.ledList) {
                led.setFrameVisible(((LedBargraph)this.getSkinnable()).isFrameVisible());
            }
        } else if ("LED_SIZE".equals(PROPERTY)) {
            this.setLedSizes();
            this.setLedColors();
        } else if ("ORIENTATION".equals(PROPERTY)) {
            this.initGraphics();
        } else if ("LED_NUMBER".equals(PROPERTY)) {
            this.stepSize.set(1.0 / (double)((LedBargraph)this.getSkinnable()).getNoOfLeds());
        } else if ("LED_COLOR".equals(PROPERTY)) {
            this.setLedColors();
        } else if ("LED_TYPE".equals(PROPERTY)) {
            this.setLedTypes();
        } else if ("RESIZE".equals(PROPERTY)) {
            this.setLedSizes();
        }
    }

    private final void setLedSizes() {
        this.ledList.forEach(led -> led.setPrefSize(((LedBargraph)this.getSkinnable()).getLedSize(), ((LedBargraph)this.getSkinnable()).getLedSize()));
        if (Orientation.HORIZONTAL == ((LedBargraph)this.getSkinnable()).getOrientation()) {
            ((LedBargraph)this.getSkinnable()).setMinSize(8.0 * (double)((LedBargraph)this.getSkinnable()).getNoOfLeds(), 8.0);
            ((LedBargraph)this.getSkinnable()).setPrefSize(((LedBargraph)this.getSkinnable()).getLedSize() * (double)((LedBargraph)this.getSkinnable()).getNoOfLeds(), ((LedBargraph)this.getSkinnable()).getLedSize());
            this.bargraph.setMaxSize(((LedBargraph)this.getSkinnable()).getLedSize() * (double)((LedBargraph)this.getSkinnable()).getNoOfLeds(), ((LedBargraph)this.getSkinnable()).getLedSize());
        } else {
            ((LedBargraph)this.getSkinnable()).setMinSize(8.0, 8.0 * (double)((LedBargraph)this.getSkinnable()).getNoOfLeds());
            ((LedBargraph)this.getSkinnable()).setPrefSize(((LedBargraph)this.getSkinnable()).getLedSize(), ((LedBargraph)this.getSkinnable()).getLedSize() * (double)((LedBargraph)this.getSkinnable()).getNoOfLeds());
            this.bargraph.setMaxSize(((LedBargraph)this.getSkinnable()).getLedSize(), ((LedBargraph)this.getSkinnable()).getLedSize() * (double)((LedBargraph)this.getSkinnable()).getNoOfLeds());
        }
        this.bargraph.relocate((((LedBargraph)this.getSkinnable()).getWidth() - this.bargraph.getLayoutBounds().getWidth()) * 0.5, (((LedBargraph)this.getSkinnable()).getHeight() - this.bargraph.getLayoutBounds().getHeight()) * 0.5);
    }

    private final void setLedColors() {
        IntStream.range(0, ((LedBargraph)this.getSkinnable()).getNoOfLeds()).parallel().forEachOrdered(i -> this.ledList.get(i).setLedColor((Paint)((LedBargraph)this.getSkinnable()).getLedColor(i)));
    }

    private final void setLedTypes() {
        this.ledList.forEach(led -> led.setLedType(((LedBargraph)this.getSkinnable()).getLedType()));
    }
}

