/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.sixteensegment;

import eu.hansolo.enzo.sixteensegment.skin.SixteenSegmentSkin;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;

public class SixteenSegment
extends Control {
    public static final String STYLE_CLASS_RED = "red";
    public static final String STYLE_CLASS_GREEN = "green";
    public static final String STYLE_CLASS_BLUE = "blue";
    public static final String STYLE_CLASS_YELLOW = "yellow";
    public static final String STYLE_CLASS_ORANGE = "orange";
    public static final String STYLE_CLASS_CYAN = "cyan";
    public static final String STYLE_CLASS_MAGENTA = "magenta";
    public static final String STYLE_CLASS_WHITE = "white";
    public static final String STYLE_CLASS_BLACK = "black";
    private boolean keepAspect;
    private String _character = " ";
    private StringProperty character;
    private boolean _dotOn = false;
    private BooleanProperty dotOn;
    private SegmentStyle _segmentStyle;
    private ObjectProperty<SegmentStyle> segmentStyle;
    private Map<Integer, List<Segment>> mapping;

    public SixteenSegment() {
        this(" ", SegmentStyle.RED);
    }

    public SixteenSegment(String CHARACTER) {
        this(CHARACTER, SegmentStyle.RED);
    }

    public SixteenSegment(Character CHARACTER) {
        this(CHARACTER, SegmentStyle.RED);
    }

    public SixteenSegment(int CHARACTER) {
        this(Integer.toString(CHARACTER < 0 ? 0 : (CHARACTER > 9 ? 9 : CHARACTER)), SegmentStyle.RED);
    }

    public SixteenSegment(Character CHARACTER, SegmentStyle SEGMENT_STYLE) {
        this(String.valueOf(CHARACTER), SEGMENT_STYLE);
    }

    public SixteenSegment(int CHARACTER, SegmentStyle SEGMENT_STYLE) {
        this(Integer.toString(CHARACTER < 0 ? 0 : (CHARACTER > 9 ? 9 : CHARACTER)), SEGMENT_STYLE);
    }

    public SixteenSegment(String CHARACTER, SegmentStyle SEGMENT_STYLE) {
        this.getStyleClass().add((Object)"sixteen-segment");
        this.keepAspect = true;
        this._character = CHARACTER.substring(0, 1);
        this._segmentStyle = SEGMENT_STYLE;
        this.mapping = new HashMap<Integer, List<Segment>>(48);
        this.initMapping();
    }

    private void initMapping() {
        this.mapping.put(20, Arrays.asList(new Segment[0]));
        this.mapping.put(42, Arrays.asList(Segment.G, Segment.H, Segment.I, Segment.L, Segment.M, Segment.N));
        this.mapping.put(43, Arrays.asList(Segment.H, Segment.K, Segment.M, Segment.P));
        this.mapping.put(44, Arrays.asList(Segment.N));
        this.mapping.put(45, Arrays.asList(Segment.P, Segment.K));
        this.mapping.put(46, Arrays.asList(Segment.DOT));
        this.mapping.put(47, Arrays.asList(Segment.I, Segment.N));
        this.mapping.put(48, Arrays.asList(Segment.A1, Segment.A2, Segment.B, Segment.C, Segment.D2, Segment.D1, Segment.E, Segment.F, Segment.I, Segment.N));
        this.mapping.put(49, Arrays.asList(Segment.I, Segment.B, Segment.C));
        this.mapping.put(50, Arrays.asList(Segment.A1, Segment.A2, Segment.B, Segment.D2, Segment.D1, Segment.E, Segment.P, Segment.K));
        this.mapping.put(51, Arrays.asList(Segment.A1, Segment.A2, Segment.B, Segment.C, Segment.D2, Segment.D1, Segment.K));
        this.mapping.put(52, Arrays.asList(Segment.B, Segment.C, Segment.F, Segment.P, Segment.K));
        this.mapping.put(53, Arrays.asList(Segment.A1, Segment.A2, Segment.C, Segment.D2, Segment.D1, Segment.F, Segment.P, Segment.K));
        this.mapping.put(54, Arrays.asList(Segment.A1, Segment.A2, Segment.C, Segment.D2, Segment.D1, Segment.E, Segment.F, Segment.P, Segment.K));
        this.mapping.put(55, Arrays.asList(Segment.A1, Segment.A2, Segment.I, Segment.M));
        this.mapping.put(56, Arrays.asList(Segment.A1, Segment.A2, Segment.B, Segment.C, Segment.D2, Segment.D1, Segment.E, Segment.F, Segment.P, Segment.K));
        this.mapping.put(57, Arrays.asList(Segment.A1, Segment.A2, Segment.B, Segment.C, Segment.F, Segment.P, Segment.K));
        this.mapping.put(65, Arrays.asList(Segment.A1, Segment.A2, Segment.B, Segment.C, Segment.E, Segment.F, Segment.P, Segment.K));
        this.mapping.put(66, Arrays.asList(Segment.A1, Segment.A2, Segment.B, Segment.C, Segment.D2, Segment.D1, Segment.H, Segment.M, Segment.K));
        this.mapping.put(67, Arrays.asList(Segment.A1, Segment.A2, Segment.D2, Segment.D1, Segment.E, Segment.F));
        this.mapping.put(68, Arrays.asList(Segment.A1, Segment.A2, Segment.B, Segment.C, Segment.D2, Segment.D1, Segment.H, Segment.M));
        this.mapping.put(69, Arrays.asList(Segment.A1, Segment.A2, Segment.D2, Segment.D1, Segment.E, Segment.F, Segment.P, Segment.K));
        this.mapping.put(70, Arrays.asList(Segment.A1, Segment.A2, Segment.E, Segment.F, Segment.P, Segment.K));
        this.mapping.put(71, Arrays.asList(Segment.A1, Segment.A2, Segment.C, Segment.D2, Segment.D1, Segment.E, Segment.F, Segment.K));
        this.mapping.put(72, Arrays.asList(Segment.B, Segment.C, Segment.E, Segment.F, Segment.P, Segment.K));
        this.mapping.put(73, Arrays.asList(Segment.A1, Segment.A2, Segment.D2, Segment.D1, Segment.M, Segment.H));
        this.mapping.put(74, Arrays.asList(Segment.B, Segment.C, Segment.D2, Segment.D1, Segment.E));
        this.mapping.put(75, Arrays.asList(Segment.E, Segment.F, Segment.I, Segment.L, Segment.P));
        this.mapping.put(76, Arrays.asList(Segment.D2, Segment.D1, Segment.E, Segment.F));
        this.mapping.put(77, Arrays.asList(Segment.B, Segment.C, Segment.E, Segment.F, Segment.G, Segment.I));
        this.mapping.put(78, Arrays.asList(Segment.B, Segment.C, Segment.E, Segment.F, Segment.G, Segment.L));
        this.mapping.put(79, Arrays.asList(Segment.A1, Segment.A2, Segment.B, Segment.C, Segment.D2, Segment.D1, Segment.E, Segment.F));
        this.mapping.put(80, Arrays.asList(Segment.A1, Segment.A2, Segment.B, Segment.E, Segment.F, Segment.P, Segment.K));
        this.mapping.put(81, Arrays.asList(Segment.A1, Segment.A2, Segment.B, Segment.C, Segment.D2, Segment.D1, Segment.E, Segment.F, Segment.L));
        this.mapping.put(82, Arrays.asList(Segment.A1, Segment.A2, Segment.B, Segment.E, Segment.F, Segment.P, Segment.K, Segment.L));
        this.mapping.put(83, Arrays.asList(Segment.A1, Segment.A2, Segment.C, Segment.D2, Segment.D1, Segment.G, Segment.K));
        this.mapping.put(84, Arrays.asList(Segment.A1, Segment.A2, Segment.H, Segment.M));
        this.mapping.put(85, Arrays.asList(Segment.B, Segment.C, Segment.D2, Segment.D1, Segment.E, Segment.F));
        this.mapping.put(86, Arrays.asList(Segment.E, Segment.F, Segment.I, Segment.N));
        this.mapping.put(87, Arrays.asList(Segment.B, Segment.C, Segment.E, Segment.F, Segment.L, Segment.N));
        this.mapping.put(88, Arrays.asList(Segment.G, Segment.I, Segment.L, Segment.N));
        this.mapping.put(89, Arrays.asList(Segment.G, Segment.I, Segment.M));
        this.mapping.put(90, Arrays.asList(Segment.A1, Segment.A2, Segment.D2, Segment.D1, Segment.I, Segment.N));
        this.mapping.put(186, Arrays.asList(Segment.A1, Segment.F, Segment.H, Segment.P));
    }

    public final boolean isKeepAspect() {
        return this.keepAspect;
    }

    public final void setKeepAspect(boolean KEEP_ASPECT) {
        this.keepAspect = KEEP_ASPECT;
    }

    public final String getCharacter() {
        return null == this.character ? this._character : (String)this.character.get();
    }

    public final void setCharacter(String CHARACTER) {
        if (null == this.character) {
            this._character = CHARACTER.substring(0, 1);
        } else {
            this.character.set((Object)CHARACTER.substring(0, 1));
        }
    }

    public final void setCharacter(Character CHARACTER) {
        if (null == this.character) {
            this._character = String.valueOf(CHARACTER);
        } else {
            this.character.set((Object)String.valueOf(CHARACTER));
        }
    }

    public final void setCharacter(int CHARACTER) {
        if (null == this.character) {
            this._character = Integer.toString(CHARACTER < 0 ? 0 : (CHARACTER > 9 ? 9 : CHARACTER));
        } else {
            this.character.set((Object)Integer.toString(CHARACTER < 0 ? 0 : (CHARACTER > 9 ? 9 : CHARACTER)));
        }
    }

    public final ReadOnlyStringProperty characterProperty() {
        if (null == this.character) {
            this.character = new SimpleStringProperty((Object)this, "character", this._character);
        }
        return this.character;
    }

    public final boolean isDotOn() {
        return null == this.dotOn ? this._dotOn : this.dotOn.get();
    }

    public final void setDotOn(boolean DOT_ON) {
        if (null == this.dotOn) {
            this._dotOn = DOT_ON;
        } else {
            this.dotOn.set(DOT_ON);
        }
    }

    public final BooleanProperty dotOnProperty() {
        if (null == this.dotOn) {
            this.dotOn = new SimpleBooleanProperty((Object)this, "dotOn", this._dotOn);
        }
        return this.dotOn;
    }

    public final SegmentStyle getSegmentStyle() {
        return null == this.segmentStyle ? this._segmentStyle : (SegmentStyle)((Object)this.segmentStyle.get());
    }

    public final void setSegmentStyle(SegmentStyle SEGMENT_STYLE) {
        if (null == this.segmentStyle) {
            this._segmentStyle = SEGMENT_STYLE;
        } else {
            this.segmentStyle.set((Object)SEGMENT_STYLE);
        }
    }

    public final ObjectProperty<SegmentStyle> segmentStyleProperty() {
        if (null == this.segmentStyle) {
            this.segmentStyle = new SimpleObjectProperty((Object)this, "segmentStyle", (Object)this._segmentStyle);
        }
        return this.segmentStyle;
    }

    public final Map<Integer, List<Segment>> getSegmentMapping() {
        HashMap<Integer, List<Segment>> segmentMapping = new HashMap<Integer, List<Segment>>(48);
        for (int key : this.mapping.keySet()) {
            segmentMapping.put(key, this.mapping.get(key));
        }
        return segmentMapping;
    }

    public boolean isResizable() {
        return true;
    }

    protected Skin createDefaultSkin() {
        return new SixteenSegmentSkin(this);
    }

    public String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource(((Object)((Object)this)).getClass().getSimpleName().toLowerCase() + ".css").toExternalForm();
    }

    public static enum SegmentStyle {
        RED("red"),
        GREEN("green"),
        BLUE("blue"),
        YELLOW("yellow"),
        ORANGE("orange"),
        CYAN("cyan"),
        MAGENTA("magenta"),
        WHITE("white"),
        BLACK("black");

        public final String ON_CLASS;
        public final String OFF_CLASS;

        private SegmentStyle(String CLASS_NAME) {
            this.ON_CLASS = CLASS_NAME;
            this.OFF_CLASS = CLASS_NAME + "-off";
        }
    }

    public static enum Segment {
        A1,
        A2,
        B,
        C,
        D2,
        D1,
        E,
        F,
        G,
        H,
        I,
        K,
        L,
        M,
        N,
        P,
        DOT;

    }
}

