/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.validationpane;

import eu.hansolo.enzo.validationpane.Validator;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.StringProperty;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Label;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.stage.Popup;
import javafx.util.Duration;

public class ValidationPane
extends Region {
    private Canvas canvas;
    private GraphicsContext ctx;
    private ObservableMap<Node, Validator> validatorMap;
    private ObservableMap<Node, Timeline> faderMap;
    private ObservableMap<Node, Popup> popupMap;
    private InvalidationListener visibilityListener;
    private EventHandler<MouseEvent> mouseHandler;
    private ObjectProperty<EventHandler<ValidationEvent>> onClear = new ObjectPropertyBase<EventHandler<ValidationEvent>>(){

        public Object getBean() {
            return this;
        }

        public String getName() {
            return "onClear";
        }
    };
    private ObjectProperty<EventHandler<ValidationEvent>> onOptional = new ObjectPropertyBase<EventHandler<ValidationEvent>>(){

        public Object getBean() {
            return this;
        }

        public String getName() {
            return "onOptional";
        }
    };
    private ObjectProperty<EventHandler<ValidationEvent>> onInfo = new ObjectPropertyBase<EventHandler<ValidationEvent>>(){

        public Object getBean() {
            return this;
        }

        public String getName() {
            return "onInfo";
        }
    };
    private ObjectProperty<EventHandler<ValidationEvent>> onValid = new ObjectPropertyBase<EventHandler<ValidationEvent>>(){

        public Object getBean() {
            return this;
        }

        public String getName() {
            return "onValid";
        }
    };
    private ObjectProperty<EventHandler<ValidationEvent>> onInvalid = new ObjectPropertyBase<EventHandler<ValidationEvent>>(){

        public Object getBean() {
            return this;
        }

        public String getName() {
            return "onInvalid";
        }
    };

    public ValidationPane() {
        this.init();
        this.initGraphics();
        this.registerListeners();
    }

    private void init() {
        this.validatorMap = FXCollections.observableHashMap();
        this.faderMap = FXCollections.observableHashMap();
        this.popupMap = FXCollections.observableHashMap();
        this.visibilityListener = observable -> this.draw();
        this.mouseHandler = mouseEvent -> {
            EventType TYPE = mouseEvent.getEventType();
            Object SRC = mouseEvent.getSource();
            if (MouseEvent.MOUSE_ENTERED == TYPE) {
                if (this.popupMap.containsKey(SRC) && !((Validator)this.validatorMap.get(SRC)).getInfoText().isEmpty()) {
                    Point2D pos = ((Node)SRC).localToScreen(((Node)SRC).getLayoutBounds().getMinX(), ((Node)SRC).getLayoutBounds().getMinY());
                    ((Popup)this.popupMap.get(SRC)).setX(pos.getX());
                    ((Popup)this.popupMap.get(SRC)).setY(pos.getY() + ((Node)SRC).getLayoutBounds().getHeight() + 5.0);
                    ((Popup)this.popupMap.get(SRC)).show(((Node)SRC).getScene().getWindow());
                }
            } else if (MouseEvent.MOUSE_EXITED == TYPE && this.popupMap.containsKey(SRC)) {
                ((Popup)this.popupMap.get(SRC)).hide();
            }
        };
    }

    private void initGraphics() {
        this.setMouseTransparent(true);
        this.canvas = new Canvas(this.getPrefWidth(), this.getPrefHeight());
        this.ctx = this.canvas.getGraphicsContext2D();
        DropShadow shadow = new DropShadow();
        shadow.setRadius(3.0);
        shadow.setColor(Color.rgb((int)0, (int)0, (int)0, (double)0.3));
        shadow.setBlurType(BlurType.TWO_PASS_BOX);
        shadow.setOffsetY(1.0);
        this.canvas.setEffect((Effect)shadow);
        this.getChildren().setAll((Object[])new Node[]{this.canvas});
    }

    private void registerListeners() {
        this.widthProperty().addListener(observable -> {
            this.canvas.setWidth(this.getWidth());
            this.ctx.clearRect(0.0, 0.0, this.getWidth(), this.getHeight());
            this.draw();
        });
        this.heightProperty().addListener(observable -> {
            this.canvas.setHeight(this.getHeight());
            this.ctx.clearRect(0.0, 0.0, this.getWidth(), this.getHeight());
            this.draw();
        });
        this.validatorMap.addListener(observable -> this.draw());
    }

    public void add(Node NODE) {
        this.add(Pos.TOP_LEFT, NODE);
    }

    public void add(Pos POSITION, Node NODE) {
        if (this.validatorMap.keySet().contains(NODE)) {
            return;
        }
        this.validatorMap.put((Object)NODE, (Object)new Validator(Validator.State.CLEAR, POSITION));
        NODE.visibleProperty().addListener(this.visibilityListener);
        NODE.setOnMouseEntered(this.mouseHandler);
        NODE.setOnMouseExited(this.mouseHandler);
    }

    public void addAll(Node ... NODES) {
        this.addAll(Pos.TOP_LEFT, NODES);
    }

    public void addAll(Pos POS, Node ... NODES) {
        for (Node node : NODES) {
            this.add(POS, node);
        }
    }

    public void remove(Node NODE) {
        if (this.validatorMap.containsKey((Object)NODE)) {
            if (((Validator)this.validatorMap.get((Object)NODE)).infoTextProperty().isBound()) {
                ((Validator)this.validatorMap.get((Object)NODE)).infoTextProperty().unbind();
            }
            NODE.removeEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseHandler);
            NODE.removeEventHandler(MouseEvent.MOUSE_EXITED, this.mouseHandler);
            this.validatorMap.remove((Object)NODE);
            this.popupMap.remove((Object)NODE);
        }
    }

    public void clear() {
        for (Node node : this.validatorMap.keySet()) {
            if (((Validator)this.validatorMap.get((Object)node)).infoTextProperty().isBound()) {
                ((Validator)this.validatorMap.get((Object)node)).infoTextProperty().unbind();
            }
            node.removeEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseHandler);
            node.removeEventHandler(MouseEvent.MOUSE_EXITED, this.mouseHandler);
        }
        this.validatorMap.clear();
        this.popupMap.clear();
    }

    public Validator.State getState(Node NODE) {
        return this.validatorMap.keySet().contains(NODE) ? ((Validator)this.validatorMap.get((Object)NODE)).getState() : Validator.State.CLEAR;
    }

    public void setState(Node NODE, Validator.State STATE) {
        this.setState(NODE, STATE, "");
    }

    public void setState(Node NODE, Validator.State STATE, String INFO_TEXT) {
        if (this.validatorMap.keySet().contains(NODE)) {
            ((Validator)this.validatorMap.get((Object)NODE)).setState(STATE);
            ((Validator)this.validatorMap.get((Object)NODE)).setInfoText(INFO_TEXT);
            ((Validator)this.validatorMap.get((Object)NODE)).setAlpha(1.0);
            if (this.popupMap.containsKey((Object)NODE)) {
                ((Popup)this.popupMap.get((Object)NODE)).getContent().setAll((Object[])new Node[]{this.createPopupContent(INFO_TEXT)});
            } else {
                this.popupMap.put((Object)NODE, (Object)this.createPopup(INFO_TEXT));
            }
            this.draw();
            if (Validator.State.VALID == STATE) {
                this.fireValidationEvent(new ValidationEvent(NODE, INFO_TEXT, (Object)this, null, ValidationEvent.VALID));
                this.fadeOut(NODE);
            } else if (Validator.State.INVALID == STATE) {
                this.fireValidationEvent(new ValidationEvent(NODE, INFO_TEXT, (Object)this, null, ValidationEvent.INVALID));
                this.stopFadingIfNeeded(NODE);
            } else if (Validator.State.INFO == STATE) {
                this.fireValidationEvent(new ValidationEvent(NODE, INFO_TEXT, (Object)this, null, ValidationEvent.INFO));
                this.stopFadingIfNeeded(NODE);
            } else if (Validator.State.OPTIONAL == STATE) {
                this.fireValidationEvent(new ValidationEvent(NODE, INFO_TEXT, (Object)this, null, ValidationEvent.OPTIONAL));
                this.stopFadingIfNeeded(NODE);
            } else {
                this.fireValidationEvent(new ValidationEvent(NODE, INFO_TEXT, (Object)this, null, ValidationEvent.CLEAR));
                this.stopFadingIfNeeded(NODE);
            }
        }
    }

    public String getInfoText(Node NODE) {
        return this.validatorMap.keySet().contains(NODE) ? ((Validator)this.validatorMap.get((Object)NODE)).getInfoText() : "";
    }

    public void setInfoText(Node NODE, String INFO_TEXT) {
        if (this.validatorMap.keySet().contains(NODE)) {
            ((Validator)this.validatorMap.get((Object)NODE)).setInfoText(INFO_TEXT);
        }
    }

    public StringProperty infoTextProperty(Node NODE) {
        if (this.validatorMap.keySet().contains(NODE)) {
            return ((Validator)this.validatorMap.get((Object)NODE)).infoTextProperty();
        }
        return null;
    }

    private void fadeOut(Node NODE) {
        ((Validator)this.validatorMap.get((Object)NODE)).alphaProperty().addListener(observable -> this.draw());
        KeyValue keyValueVisible = new KeyValue((WritableValue)((Validator)this.validatorMap.get((Object)NODE)).alphaProperty(), (Object)1);
        KeyValue keyValueInvisible = new KeyValue((WritableValue)((Validator)this.validatorMap.get((Object)NODE)).alphaProperty(), (Object)0, Interpolator.EASE_IN);
        KeyFrame kf1 = new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{keyValueVisible});
        KeyFrame kf2 = new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{keyValueVisible});
        KeyFrame kf3 = new KeyFrame(Duration.millis((double)1500.0), new KeyValue[]{keyValueInvisible});
        Timeline timeline = new Timeline();
        timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{kf1, kf2, kf3});
        this.faderMap.put((Object)NODE, (Object)timeline);
        timeline.setOnFinished(actionEvent -> this.faderMap.remove((Object)NODE));
        timeline.play();
    }

    private void stopFadingIfNeeded(Node NODE) {
        if (this.faderMap.keySet().contains(NODE)) {
            ((Timeline)this.faderMap.get((Object)NODE)).stop();
            this.faderMap.remove((Object)NODE);
        }
    }

    private void draw() {
        if (this.validatorMap.isEmpty()) {
            return;
        }
        double[] indicatorPos = new double[2];
        for (Node node : this.validatorMap.keySet()) {
            Validator validator = (Validator)this.validatorMap.get((Object)node);
            this.ctx.save();
            this.ctx.setGlobalAlpha(validator.getAlpha());
            Point2D nodeMinPos = node.localToScene(node.getLayoutBounds().getMinX(), node.getLayoutBounds().getMinY());
            Point2D nodeMaxPos = node.localToScene(node.getLayoutBounds().getMaxX(), node.getLayoutBounds().getMaxY());
            if (!(nodeMinPos.getX() > 0.0) || !(nodeMinPos.getY() > 0.0)) continue;
            if (Pos.CENTER_LEFT == validator.getValidatorPosition()) {
                indicatorPos[0] = nodeMinPos.getX() - 6.0;
                indicatorPos[1] = nodeMinPos.getY() + (node.getLayoutBounds().getHeight() - 12.0) * 0.5;
            } else if (Pos.BOTTOM_LEFT == validator.getValidatorPosition()) {
                indicatorPos[0] = nodeMinPos.getX() - 6.0;
                indicatorPos[1] = nodeMaxPos.getY() - 6.0;
            } else if (Pos.TOP_RIGHT == validator.getValidatorPosition()) {
                indicatorPos[0] = nodeMaxPos.getX() - 6.0;
                indicatorPos[1] = nodeMinPos.getY() - 6.0;
            } else if (Pos.CENTER_RIGHT == validator.getValidatorPosition()) {
                indicatorPos[0] = nodeMaxPos.getX() - 6.0;
                indicatorPos[1] = nodeMinPos.getY() + (node.getLayoutBounds().getHeight() - 12.0) * 0.5;
            } else if (Pos.BOTTOM_RIGHT == validator.getValidatorPosition()) {
                indicatorPos[0] = nodeMaxPos.getX() - 6.0;
                indicatorPos[1] = nodeMaxPos.getY() - 6.0;
            } else if (Pos.TOP_CENTER == validator.getValidatorPosition()) {
                indicatorPos[0] = nodeMinPos.getX() + node.getLayoutBounds().getWidth() * 0.5 - 6.0;
                indicatorPos[1] = nodeMinPos.getY() - 6.0;
            } else if (Pos.BOTTOM_CENTER == validator.getValidatorPosition()) {
                indicatorPos[0] = nodeMinPos.getX() + node.getLayoutBounds().getWidth() * 0.5 - 6.0;
                indicatorPos[1] = nodeMaxPos.getY() - 6.0;
            } else {
                indicatorPos[0] = nodeMinPos.getX() - 6.0;
                indicatorPos[1] = nodeMinPos.getY() - 6.0;
            }
            validator.setIconLocation(indicatorPos[0], indicatorPos[1]);
            Validator.State state = ((Validator)this.validatorMap.get((Object)node)).getState();
            this.ctx.clearRect(validator.getIconLocationX(), validator.getIconLocationY(), 12.0, 12.0);
            if (!node.isVisible() || null == state.IMAGE) continue;
            this.ctx.drawImage(((Validator)this.validatorMap.get((Object)node)).getState().IMAGE, validator.getIconLocationX(), validator.getIconLocationY());
            this.ctx.restore();
        }
    }

    private Popup createPopup(String INFO_TEXT) {
        Popup popup = new Popup();
        popup.setAutoHide(true);
        popup.setAutoFix(true);
        popup.setHideOnEscape(true);
        popup.getContent().setAll((Object[])new Node[]{this.createPopupContent(INFO_TEXT)});
        return popup;
    }

    private Node createPopupContent(String INFO_TEXT) {
        StackPane popupPane = new StackPane();
        popupPane.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("validationpane.css").toExternalForm());
        popupPane.getStyleClass().add((Object)"popup");
        Label label = new Label(INFO_TEXT);
        label.getStyleClass().add((Object)"info-text");
        popupPane.getChildren().setAll((Object[])new Node[]{label});
        return popupPane;
    }

    public final ObjectProperty<EventHandler<ValidationEvent>> onClearProperty() {
        return this.onClear;
    }

    public final void setOnClear(EventHandler<ValidationEvent> value) {
        this.onClearProperty().set(value);
    }

    public final EventHandler<ValidationEvent> getOnClear() {
        return (EventHandler)this.onClearProperty().get();
    }

    public final ObjectProperty<EventHandler<ValidationEvent>> onOptionalProperty() {
        return this.onOptional;
    }

    public final void setOnOptional(EventHandler<ValidationEvent> value) {
        this.onOptionalProperty().set(value);
    }

    public final EventHandler<ValidationEvent> getOnOptional() {
        return (EventHandler)this.onOptionalProperty().get();
    }

    public final ObjectProperty<EventHandler<ValidationEvent>> onInfoProperty() {
        return this.onInfo;
    }

    public final void setOnInfo(EventHandler<ValidationEvent> value) {
        this.onInfoProperty().set(value);
    }

    public final EventHandler<ValidationEvent> getOnInfo() {
        return (EventHandler)this.onInfoProperty().get();
    }

    public final ObjectProperty<EventHandler<ValidationEvent>> onValidProperty() {
        return this.onValid;
    }

    public final void setOnValid(EventHandler<ValidationEvent> value) {
        this.onValidProperty().set(value);
    }

    public final EventHandler<ValidationEvent> getOnValid() {
        return (EventHandler)this.onValidProperty().get();
    }

    public final ObjectProperty<EventHandler<ValidationEvent>> onInvalidProperty() {
        return this.onInvalid;
    }

    public final void setOnInvalid(EventHandler<ValidationEvent> value) {
        this.onInvalidProperty().set(value);
    }

    public final EventHandler<ValidationEvent> getOnInvalid() {
        return (EventHandler)this.onInvalidProperty().get();
    }

    public void fireValidationEvent(ValidationEvent EVENT) {
        this.fireEvent(EVENT);
        EventType TYPE = EVENT.getEventType();
        Object HANDLER = ValidationEvent.VALID == TYPE ? this.getOnValid() : (ValidationEvent.INVALID == TYPE ? this.getOnInvalid() : (ValidationEvent.INFO == TYPE ? this.getOnInfo() : (ValidationEvent.OPTIONAL == TYPE ? this.getOnOptional() : (ValidationEvent.CLEAR == TYPE ? this.getOnClear() : null))));
        if (HANDLER != null) {
            HANDLER.handle((Event)EVENT);
        }
    }

    public static class ValidationEvent
    extends Event {
        public static final EventType<ValidationEvent> VALID = new EventType(ANY, "valid");
        public static final EventType<ValidationEvent> INVALID = new EventType(ANY, "invalid");
        public static final EventType<ValidationEvent> INFO = new EventType(ANY, "info");
        public static final EventType<ValidationEvent> OPTIONAL = new EventType(ANY, "optional");
        public static final EventType<ValidationEvent> CLEAR = new EventType(ANY, "clear");
        private Node node;
        private String infoText;

        public ValidationEvent(Node NODE, String INFO_TEXT, Object SOURCE, EventTarget TARGET, EventType<ValidationEvent> EVENT_TYPE) {
            super(SOURCE, TARGET, EVENT_TYPE);
            this.node = NODE;
            this.infoText = INFO_TEXT;
        }

        public Node getNode() {
            return this.node;
        }

        public String getInfoText() {
            return this.infoText;
        }
    }
}

