/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.function.Predicate;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.IModuleAwareNameEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import org.eclipse.jdt.internal.compiler.lookup.PlainPackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SplitPackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.util.HashtableOfPackage;
import org.eclipse.jdt.internal.compiler.util.HashtableOfType;

public abstract class PackageBinding
extends Binding
implements TypeConstants {
    public long tagBits = 0L;
    public char[][] compoundName;
    PackageBinding parent;
    ArrayList<SplitPackageBinding> wrappingSplitPackageBindings;
    public LookupEnvironment environment;
    public HashtableOfType knownTypes;
    HashtableOfPackage<PackageBinding> knownPackages;
    private int defaultNullness = -1;
    public ModuleBinding enclosingModule;
    Boolean isExported;

    protected PackageBinding(char[][] cArray, LookupEnvironment lookupEnvironment) {
        this.compoundName = cArray;
        this.environment = lookupEnvironment;
    }

    public PackageBinding(char[][] cArray, PackageBinding packageBinding, LookupEnvironment lookupEnvironment, ModuleBinding moduleBinding) {
        this.compoundName = cArray;
        this.parent = packageBinding;
        this.environment = lookupEnvironment;
        this.knownTypes = null;
        this.knownPackages = new HashtableOfPackage(3);
        if (cArray != CharOperation.NO_CHAR_CHAR) {
            this.checkIfNullAnnotationPackage();
        }
        if (moduleBinding != null) {
            this.enclosingModule = moduleBinding;
        } else if (packageBinding != null) {
            this.enclosingModule = packageBinding.enclosingModule;
        }
        if (this.enclosingModule == null) {
            throw new IllegalStateException("Package should have an enclosing module");
        }
    }

    protected void addNotFoundPackage(char[] cArray) {
        if (!this.environment.suppressImportErrors) {
            this.knownPackages.put(cArray, LookupEnvironment.TheNotFoundPackage);
        }
    }

    private void addNotFoundType(char[] cArray) {
        if (this.environment.suppressImportErrors) {
            return;
        }
        if (this.knownTypes == null) {
            this.knownTypes = new HashtableOfType(25);
        }
        this.knownTypes.put(cArray, LookupEnvironment.TheNotFoundType);
    }

    PackageBinding addPackage(PackageBinding packageBinding, ModuleBinding moduleBinding) {
        if ((packageBinding.tagBits & 0x80L) == 0L) {
            this.clearMissingTagBit();
        }
        this.knownPackages.put(packageBinding.compoundName[packageBinding.compoundName.length - 1], packageBinding);
        return packageBinding;
    }

    void addType(ReferenceBinding referenceBinding) {
        char[] cArray;
        ReferenceBinding referenceBinding2;
        if ((referenceBinding.tagBits & 0x80L) == 0L) {
            this.clearMissingTagBit();
        }
        if (this.knownTypes == null) {
            this.knownTypes = new HashtableOfType(25);
        }
        if ((referenceBinding2 = this.knownTypes.getput(cArray = referenceBinding.compoundName[referenceBinding.compoundName.length - 1], referenceBinding)) != null && referenceBinding2.isUnresolvedType() && !referenceBinding.isUnresolvedType()) {
            ((UnresolvedReferenceBinding)referenceBinding2).setResolvedType(referenceBinding, this.environment);
        }
        if (this.environment.globalOptions.isAnnotationBasedNullAnalysisEnabled && (referenceBinding.isAnnotationType() || referenceBinding instanceof UnresolvedReferenceBinding)) {
            this.checkIfNullAnnotationType(referenceBinding);
        }
        if (!referenceBinding.isUnresolvedType() && this.wrappingSplitPackageBindings != null) {
            for (SplitPackageBinding splitPackageBinding : this.wrappingSplitPackageBindings) {
                ReferenceBinding referenceBinding3;
                if (splitPackageBinding.knownTypes == null || (referenceBinding3 = splitPackageBinding.knownTypes.get(cArray)) == null || !referenceBinding3.isUnresolvedType() || referenceBinding.isUnresolvedType()) continue;
                ((UnresolvedReferenceBinding)referenceBinding3).setResolvedType(referenceBinding, this.environment);
                splitPackageBinding.knownTypes.put(cArray, null);
            }
        }
    }

    ModuleBinding[] getDeclaringModules() {
        return new ModuleBinding[]{this.enclosingModule};
    }

    void clearMissingTagBit() {
        PackageBinding packageBinding = this;
        do {
            packageBinding.tagBits &= 0xFFFFFFFFFFFFFF7FL;
        } while ((packageBinding = packageBinding.parent) != null);
    }

    @Override
    public char[] computeUniqueKey(boolean bl) {
        return CharOperation.concatWith(this.compoundName, '/');
    }

    protected PackageBinding findPackage(char[] cArray, ModuleBinding moduleBinding) {
        return moduleBinding.getVisiblePackage(CharOperation.arrayConcat(this.compoundName, cArray));
    }

    PackageBinding getPackage(char[] cArray, ModuleBinding moduleBinding) {
        PackageBinding packageBinding = this.getPackage0(cArray);
        if (packageBinding != null) {
            if (packageBinding == LookupEnvironment.TheNotFoundPackage) {
                return null;
            }
            return packageBinding;
        }
        packageBinding = this.findPackage(cArray, moduleBinding);
        if (packageBinding != null) {
            return packageBinding;
        }
        this.addNotFoundPackage(cArray);
        return null;
    }

    PackageBinding getPackage0(char[] cArray) {
        return this.knownPackages.get(cArray);
    }

    PackageBinding getPackage0Any(char[] cArray) {
        return this.knownPackages.get(cArray);
    }

    ReferenceBinding getType(char[] cArray, ModuleBinding moduleBinding) {
        ReferenceBinding referenceBinding = this.getType0(cArray);
        if (referenceBinding == null && (referenceBinding = this.environment.askForType(this, cArray, moduleBinding)) == null) {
            this.addNotFoundType(cArray);
            return null;
        }
        if (referenceBinding == LookupEnvironment.TheNotFoundType) {
            return null;
        }
        if ((referenceBinding = (ReferenceBinding)BinaryTypeBinding.resolveType(referenceBinding, this.environment, false)).isNestedType()) {
            return new ProblemReferenceBinding(new char[][]{cArray}, referenceBinding, 4);
        }
        if (!moduleBinding.canAccess(this)) {
            return new ProblemReferenceBinding(referenceBinding.compoundName, referenceBinding, 30);
        }
        return referenceBinding;
    }

    ReferenceBinding getType0(char[] cArray) {
        if (this.knownTypes == null) {
            return null;
        }
        return this.knownTypes.get(cArray);
    }

    boolean hasType0Any(char[] cArray) {
        ReferenceBinding referenceBinding = this.getType0(cArray);
        return referenceBinding != null && referenceBinding.isValidBinding() && !(referenceBinding instanceof UnresolvedReferenceBinding);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Binding getTypeOrPackage(char[] cArray, ModuleBinding moduleBinding, boolean bl) {
        PackageBinding packageBinding;
        ProblemReferenceBinding problemReferenceBinding = null;
        ReferenceBinding referenceBinding = this.getType0(cArray);
        if (referenceBinding != null && referenceBinding != LookupEnvironment.TheNotFoundType) {
            boolean bl2;
            if ((referenceBinding = (ReferenceBinding)BinaryTypeBinding.resolveType(referenceBinding, this.environment, false)).isNestedType()) {
                return new ProblemReferenceBinding(new char[][]{cArray}, referenceBinding, 4);
            }
            boolean bl3 = this instanceof SplitPackageBinding ? referenceBinding.module() == moduleBinding : (bl2 = this.enclosingModule == moduleBinding);
            if (!bl2 && referenceBinding.isValidBinding() && !moduleBinding.canAccess(referenceBinding.fPackage)) {
                problemReferenceBinding = new ProblemReferenceBinding(referenceBinding.compoundName, referenceBinding, 30);
            } else if ((referenceBinding.tagBits & 0x80L) == 0L) {
                return referenceBinding;
            }
        }
        if ((packageBinding = this.getPackage0(cArray)) != null && packageBinding != LookupEnvironment.TheNotFoundPackage) {
            if (bl) return packageBinding;
            return packageBinding.getVisibleFor(moduleBinding, false);
        }
        if (referenceBinding == null && problemReferenceBinding == null) {
            referenceBinding = this.environment.askForType(this, cArray, moduleBinding);
            if (referenceBinding != null) {
                if (referenceBinding.isNestedType()) {
                    return new ProblemReferenceBinding(new char[][]{cArray}, referenceBinding, 4);
                }
                if (!referenceBinding.isValidBinding() || moduleBinding.canAccess(referenceBinding.fPackage)) return referenceBinding;
                problemReferenceBinding = new ProblemReferenceBinding(referenceBinding.compoundName, referenceBinding, 30);
            } else {
                this.addNotFoundType(cArray);
            }
        }
        if (packageBinding != null) return problemReferenceBinding;
        packageBinding = this.findPackage(cArray, moduleBinding);
        if (packageBinding != null) {
            if (bl) return packageBinding;
            return packageBinding.getVisibleFor(moduleBinding, false);
        }
        if (referenceBinding != null && referenceBinding != LookupEnvironment.TheNotFoundType) {
            if (problemReferenceBinding == null) return referenceBinding;
            return problemReferenceBinding;
        }
        this.addNotFoundPackage(cArray);
        return problemReferenceBinding;
    }

    public final boolean isViewedAsDeprecated() {
        if ((this.tagBits & 0x400000000L) == 0L) {
            ReferenceBinding referenceBinding;
            this.tagBits |= 0x400000000L;
            if (this.compoundName != CharOperation.NO_CHAR_CHAR && (referenceBinding = this.getType(TypeConstants.PACKAGE_INFO_NAME, this.enclosingModule)) != null) {
                referenceBinding.initializeDeprecatedAnnotationTagBits();
                this.tagBits |= referenceBinding.tagBits & 0x77FFFFF840000000L;
            }
        }
        return (this.tagBits & 0x400000000000L) != 0L;
    }

    private void initDefaultNullness() {
        if (this.defaultNullness == -1) {
            ReferenceBinding referenceBinding = this.getType(TypeConstants.PACKAGE_INFO_NAME, this.enclosingModule);
            if (referenceBinding != null) {
                referenceBinding.getAnnotationTagBits();
                this.defaultNullness = referenceBinding instanceof SourceTypeBinding ? ((SourceTypeBinding)referenceBinding).defaultNullness : ((BinaryTypeBinding)referenceBinding).defaultNullness;
            } else {
                this.defaultNullness = 0;
            }
        }
    }

    public int getDefaultNullness() {
        this.initDefaultNullness();
        if (this.defaultNullness == 0) {
            return this.enclosingModule.getDefaultNullness();
        }
        return this.defaultNullness;
    }

    public void setDefaultNullness(int n) {
        this.defaultNullness = n;
    }

    public Binding findDefaultNullnessTarget(Predicate<Integer> predicate) {
        this.initDefaultNullness();
        if (predicate.test(this.defaultNullness)) {
            return this;
        }
        if (this.defaultNullness == 0 && predicate.test(this.enclosingModule.getDefaultNullness())) {
            return this.enclosingModule;
        }
        return null;
    }

    @Override
    public final int kind() {
        return 16;
    }

    @Override
    public int problemId() {
        if ((this.tagBits & 0x80L) != 0L) {
            return 1;
        }
        return 0;
    }

    void checkIfNullAnnotationPackage() {
        LookupEnvironment lookupEnvironment = this.environment;
        if (lookupEnvironment.globalOptions.isAnnotationBasedNullAnalysisEnabled) {
            if (this.isPackageOfQualifiedTypeName(this.compoundName, lookupEnvironment.getNullableAnnotationName())) {
                lookupEnvironment.nullableAnnotationPackage = this;
            }
            if (this.isPackageOfQualifiedTypeName(this.compoundName, lookupEnvironment.getNonNullAnnotationName())) {
                lookupEnvironment.nonnullAnnotationPackage = this;
            }
            if (this.isPackageOfQualifiedTypeName(this.compoundName, lookupEnvironment.getNonNullByDefaultAnnotationName())) {
                lookupEnvironment.nonnullByDefaultAnnotationPackage = this;
            }
        }
    }

    private boolean isPackageOfQualifiedTypeName(char[][] cArray, char[][] cArray2) {
        int n;
        if (cArray2 == null || (n = cArray.length) != cArray2.length - 1) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (CharOperation.equals(cArray[i], cArray2[i])) continue;
            return false;
        }
        return true;
    }

    void checkIfNullAnnotationType(ReferenceBinding referenceBinding) {
        if (this.environment.nullableAnnotationPackage == this && CharOperation.equals(referenceBinding.compoundName, this.environment.getNullableAnnotationName())) {
            referenceBinding.typeBits |= 0x40;
            if (!(referenceBinding instanceof UnresolvedReferenceBinding)) {
                this.environment.nullableAnnotationPackage = null;
            }
        } else if (this.environment.nonnullAnnotationPackage == this && CharOperation.equals(referenceBinding.compoundName, this.environment.getNonNullAnnotationName())) {
            referenceBinding.typeBits |= 0x20;
            if (!(referenceBinding instanceof UnresolvedReferenceBinding)) {
                this.environment.nonnullAnnotationPackage = null;
            }
        } else if (this.environment.nonnullByDefaultAnnotationPackage == this && CharOperation.equals(referenceBinding.compoundName, this.environment.getNonNullByDefaultAnnotationName())) {
            referenceBinding.typeBits |= 0x80;
            if (!(referenceBinding instanceof UnresolvedReferenceBinding)) {
                this.environment.nonnullByDefaultAnnotationPackage = null;
            }
        } else {
            referenceBinding.typeBits |= this.environment.getNullAnnotationBit(referenceBinding.compoundName);
        }
    }

    @Override
    public char[] readableName() {
        return CharOperation.concatWith(this.compoundName, '.');
    }

    public String toString() {
        String string = this.compoundName == CharOperation.NO_CHAR_CHAR ? "The Default Package" : "package " + (this.compoundName != null ? CharOperation.toString(this.compoundName) : "UNNAMED");
        if ((this.tagBits & 0x80L) != 0L) {
            string = string + "[MISSING]";
        }
        return string;
    }

    public boolean isDeclaredIn(ModuleBinding moduleBinding) {
        return this.enclosingModule == moduleBinding;
    }

    public boolean subsumes(PackageBinding packageBinding) {
        return packageBinding == this;
    }

    public boolean isExported() {
        if (this.isExported == null) {
            if (this.enclosingModule.isAuto) {
                this.isExported = Boolean.TRUE;
            } else {
                this.enclosingModule.getExports();
                if (this.isExported == null) {
                    this.isExported = Boolean.FALSE;
                }
            }
        }
        return this.isExported == Boolean.TRUE;
    }

    public PackageBinding getVisibleFor(ModuleBinding moduleBinding, boolean bl) {
        return this;
    }

    public abstract PlainPackageBinding getIncarnation(ModuleBinding var1);

    public boolean hasCompilationUnit(boolean bl) {
        if (this.knownTypes != null) {
            for (ReferenceBinding referenceBinding : this.knownTypes.valueTable) {
                if (referenceBinding == null || referenceBinding == LookupEnvironment.TheNotFoundType || referenceBinding.isUnresolvedType()) continue;
                return true;
            }
        }
        if (this.environment.useModuleSystem) {
            IModuleAwareNameEnvironment iModuleAwareNameEnvironment = (IModuleAwareNameEnvironment)this.environment.nameEnvironment;
            return iModuleAwareNameEnvironment.hasCompilationUnit(this.compoundName, this.enclosingModule.nameForCUCheck(), bl);
        }
        return false;
    }

    public void addWrappingSplitPackageBinding(SplitPackageBinding splitPackageBinding) {
        if (this.wrappingSplitPackageBindings == null) {
            this.wrappingSplitPackageBindings = new ArrayList();
        }
        this.wrappingSplitPackageBindings.add(splitPackageBinding);
    }
}

