/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.util;

public final class HashtableOfInteger {
    public Integer[] keyTable;
    public Object[] valueTable;
    public int elementSize = 0;
    int threshold;

    public HashtableOfInteger() {
        this(13);
    }

    public HashtableOfInteger(int n) {
        this.threshold = n;
        int n2 = (int)((float)n * 1.75f);
        if (this.threshold == n2) {
            ++n2;
        }
        this.keyTable = new Integer[n2];
        this.valueTable = new Object[n2];
    }

    public void clear() {
        int n = this.keyTable.length;
        while (--n >= 0) {
            this.keyTable[n] = null;
            this.valueTable[n] = null;
        }
        this.elementSize = 0;
    }

    public Object clone() throws CloneNotSupportedException {
        HashtableOfInteger hashtableOfInteger = (HashtableOfInteger)super.clone();
        hashtableOfInteger.elementSize = this.elementSize;
        hashtableOfInteger.threshold = this.threshold;
        int n = this.keyTable.length;
        hashtableOfInteger.keyTable = new Integer[n];
        System.arraycopy(this.keyTable, 0, hashtableOfInteger.keyTable, 0, n);
        n = this.valueTable.length;
        hashtableOfInteger.valueTable = new Object[n];
        System.arraycopy(this.valueTable, 0, hashtableOfInteger.valueTable, 0, n);
        return hashtableOfInteger;
    }

    public boolean containsKey(int n) {
        Integer n2;
        Integer n3 = n;
        int n4 = this.keyTable.length;
        int n5 = n3.hashCode() % n4;
        while ((n2 = this.keyTable[n5]) != null) {
            if (n2.equals(n3)) {
                return true;
            }
            if (++n5 != n4) continue;
            n5 = 0;
        }
        return false;
    }

    public Object get(int n) {
        Integer n2;
        Integer n3 = n;
        int n4 = this.keyTable.length;
        int n5 = n3.hashCode() % n4;
        while ((n2 = this.keyTable[n5]) != null) {
            if (n2.equals(n3)) {
                return this.valueTable[n5];
            }
            if (++n5 != n4) continue;
            n5 = 0;
        }
        return null;
    }

    public Object put(int n, Object object) {
        Integer n2;
        Integer n3 = n;
        int n4 = this.keyTable.length;
        int n5 = n3.hashCode() % n4;
        while ((n2 = this.keyTable[n5]) != null) {
            if (n2.equals(n3)) {
                this.valueTable[n5] = object;
                return this.valueTable[n5];
            }
            if (++n5 != n4) continue;
            n5 = 0;
        }
        this.keyTable[n5] = n3;
        this.valueTable[n5] = object;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return object;
    }

    public void putUnsafely(int n, Object object) {
        Integer n2 = n;
        int n3 = this.keyTable.length;
        int n4 = n2.hashCode() % n3;
        while (this.keyTable[n4] != null) {
            if (++n4 != n3) continue;
            n4 = 0;
        }
        this.keyTable[n4] = n2;
        this.valueTable[n4] = object;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
    }

    public Object removeKey(int n) {
        Integer n2;
        Integer n3 = n;
        int n4 = this.keyTable.length;
        int n5 = n3.hashCode() % n4;
        while ((n2 = this.keyTable[n5]) != null) {
            if (n2.equals(n3)) {
                Object object = this.valueTable[n5];
                --this.elementSize;
                this.keyTable[n5] = null;
                this.valueTable[n5] = null;
                this.rehash();
                return object;
            }
            if (++n5 != n4) continue;
            n5 = 0;
        }
        return null;
    }

    private void rehash() {
        HashtableOfInteger hashtableOfInteger = new HashtableOfInteger(this.elementSize * 2);
        int n = this.keyTable.length;
        while (--n >= 0) {
            Integer n2 = this.keyTable[n];
            if (n2 == null) continue;
            hashtableOfInteger.putUnsafely(n2, this.valueTable[n]);
        }
        this.keyTable = hashtableOfInteger.keyTable;
        this.valueTable = hashtableOfInteger.valueTable;
        this.threshold = hashtableOfInteger.threshold;
    }

    public int size() {
        return this.elementSize;
    }

    public String toString() {
        String string = "";
        int n = this.valueTable.length;
        for (int i = 0; i < n; ++i) {
            Object object = this.valueTable[i];
            if (object == null) continue;
            string = string + this.keyTable[i] + " -> " + object.toString() + "\n";
        }
        return string;
    }
}

