/*
 * Decompiled with CFR 0.152.
 */
package netrexx.lang;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentLinkedDeque;
import netrexx.lang.LineHandler;
import netrexx.lang.Rexx;

public class RexxIO
implements Serializable {
    private static final String $0 = "RexxIO.nrx";
    private static BufferedReader StdIn = new BufferedReader(new InputStreamReader(System.in));
    private static ConcurrentLinkedDeque StdOut = new ConcurrentLinkedDeque();
    private static BufferedReader fileIn;
    private static final long serialVersionUID = 2781762092115528702L;

    public static Rexx Ask() {
        String string = null;
        try {
            string = StdIn.readLine();
            if (string == null) {
                return null;
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return new Rexx(string);
    }

    public static Rexx AskDark() {
        char[] cArray = System.console().readPassword();
        if (cArray == null) {
            return null;
        }
        return new Rexx(cArray);
    }

    public static Rexx AskOne() {
        char c = '\u0000';
        try {
            c = (char)StdIn.read();
        }
        catch (IOException iOException) {
            return null;
        }
        return new Rexx(c);
    }

    public static boolean Say(Object object) {
        if (object == null) {
            return RexxIO.Say((char[])null);
        }
        return RexxIO.Say(object.toString().toCharArray());
    }

    public static boolean Say(String string) {
        if (string == null) {
            return RexxIO.Say((char[])null);
        }
        return RexxIO.Say(string.toCharArray());
    }

    public static boolean Say(Rexx rexx) {
        return RexxIO.Say(Rexx.tochararray(rexx));
    }

    public static boolean Say(char c) {
        char[] cArray = new char[]{c};
        return RexxIO.Say(cArray);
    }

    public static boolean Say(long l2) {
        return RexxIO.Say(Long.toString(l2).toCharArray());
    }

    public static boolean Say(float f) {
        return RexxIO.Say(new Rexx(f));
    }

    public static boolean Say(double d) {
        return RexxIO.Say(new Rexx(d));
    }

    public static boolean Say(boolean bl) {
        return RexxIO.Say(new Rexx(bl));
    }

    public static boolean Say(char[] cArray) {
        PrintWriter printWriter2 = null;
        char[] cArray2 = null;
        if (StdOut.size() == 0) {
            StdOut.push(new PrintWriter(System.out));
        }
        for (PrintWriter printWriter2 : StdOut) {
            if (cArray == null) {
                printWriter2.println();
            } else if (cArray.length == 0) {
                printWriter2.println();
            } else if (cArray[cArray.length - 1] != '\u0000') {
                printWriter2.println(cArray);
            } else {
                cArray2 = new char[cArray.length - 1];
                System.arraycopy(cArray, 0, cArray2, 0, cArray2.length);
                printWriter2.print(cArray2);
            }
            printWriter2.flush();
        }
        return false;
    }

    public static boolean pipeSay(Object object) {
        if (object == null) {
            return RexxIO.pipeSay((char[])null);
        }
        return RexxIO.pipeSay(object.toString().toCharArray());
    }

    public static boolean pipeSay(String string) {
        if (string == null) {
            return RexxIO.pipeSay((char[])null);
        }
        return RexxIO.pipeSay(string.toCharArray());
    }

    public static boolean pipeSay(Rexx rexx) {
        return RexxIO.pipeSay(Rexx.tochararray(rexx));
    }

    public static boolean pipeSay(char c) {
        char[] cArray = new char[]{c};
        return RexxIO.pipeSay(cArray);
    }

    public static boolean pipeSay(long l2) {
        return RexxIO.pipeSay(Long.toString(l2).toCharArray());
    }

    public static boolean pipeSay(float f) {
        return RexxIO.pipeSay(new Rexx(f));
    }

    public static boolean pipeSay(double d) {
        return RexxIO.pipeSay(new Rexx(d));
    }

    public static boolean pipeSay(boolean bl) {
        return RexxIO.pipeSay(new Rexx(bl));
    }

    public static boolean pipeSay(char[] cArray) {
        char[] cArray2 = null;
        PrintWriter printWriter = new PrintWriter(System.out);
        if (cArray == null) {
            printWriter.println();
        } else if (cArray.length == 0) {
            printWriter.println();
        } else if (cArray[cArray.length - 1] != '\u0000') {
            printWriter.println(cArray);
        } else {
            cArray2 = new char[cArray.length - 1];
            System.arraycopy(cArray, 0, cArray2, 0, cArray2.length);
            printWriter.print(cArray2);
        }
        printWriter.flush();
        return false;
    }

    public static void setOutputStream(OutputStream outputStream) {
        StdOut.clear();
        StdOut.push(new PrintWriter(outputStream));
    }

    public static void pushOutputStream(OutputStream outputStream) {
        StdOut.push(new PrintWriter(outputStream));
    }

    public static void popOutputStream() {
        try {
            StdOut.pop();
        }
        catch (NoSuchElementException noSuchElementException) {
            StdOut.push(new PrintWriter(System.out));
        }
    }

    public RexxIO File(Rexx rexx) {
        try {
            fileIn = new BufferedReader(new FileReader(Rexx.toString(rexx)));
        }
        catch (IOException iOException) {
            return null;
        }
        return this;
    }

    public void forEachline(LineHandler lineHandler) {
        Rexx rexx = null;
        try {
            while ((rexx = Rexx.toRexx(fileIn.readLine())) != null) {
                lineHandler.handle(rexx);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void forEachline(LineHandler lineHandler, Rexx rexx) {
        int n = 0;
        Rexx rexx2 = null;
        try {
            int n2 = rexx.toint();
            for (n = 0; n <= n2 && (rexx2 = Rexx.toRexx(fileIn.readLine())) != null; ++n) {
                lineHandler.handle(rexx2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

