/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ExpressionContext;
import org.eclipse.jdt.internal.compiler.ast.IPolyExpression;
import org.eclipse.jdt.internal.compiler.ast.NullAnnotationMatching;
import org.eclipse.jdt.internal.compiler.ast.OperatorExpression;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.PolyTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ConditionalExpression
extends OperatorExpression
implements IPolyExpression {
    public Expression condition;
    public Expression valueIfTrue;
    public Expression valueIfFalse;
    public Constant optimizedBooleanConstant;
    public Constant optimizedIfTrueConstant;
    public Constant optimizedIfFalseConstant;
    int trueInitStateIndex = -1;
    int falseInitStateIndex = -1;
    int mergedInitStateIndex = -1;
    private int nullStatus = 1;
    int ifFalseNullStatus;
    int ifTrueNullStatus;
    private TypeBinding expectedType;
    private ExpressionContext expressionContext = ExpressionContext.VANILLA_CONTEXT;
    private boolean isPolyExpression = false;
    private TypeBinding originalValueIfTrueType;
    private TypeBinding originalValueIfFalseType;
    private boolean use18specifics;

    public ConditionalExpression(Expression expression, Expression expression2, Expression expression3) {
        this.condition = expression;
        this.valueIfTrue = expression2;
        this.valueIfFalse = expression3;
        this.sourceStart = expression.sourceStart;
        this.sourceEnd = expression3.sourceEnd;
    }

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        FlowInfo flowInfo2;
        int n = (flowInfo.reachMode() & 3) != 0 ? 1 : 0;
        Constant constant = this.condition.optimizedBooleanConstant();
        boolean bl = constant != Constant.NotAConstant && constant.booleanValue();
        boolean bl2 = constant != Constant.NotAConstant && !constant.booleanValue();
        int n2 = flowInfo.reachMode();
        flowInfo = this.condition.analyseCode(blockScope, flowContext, flowInfo, constant == Constant.NotAConstant);
        ++flowContext.conditionalLevel;
        FlowInfo flowInfo3 = flowInfo.initsWhenTrue().copy();
        CompilerOptions compilerOptions = blockScope.compilerOptions();
        if (bl2) {
            if ((n2 & 3) == 0) {
                flowInfo3.setReachMode(1);
            }
            if (!ConditionalExpression.isKnowDeadCodePattern(this.condition) || compilerOptions.reportDeadCodeInTrivialIfStatement) {
                this.valueIfTrue.complainIfUnreachable(flowInfo3, blockScope, n, false);
            }
        }
        this.trueInitStateIndex = blockScope.methodScope().recordInitializationStates(flowInfo3);
        this.condition.updateFlowOnBooleanResult(flowInfo3, true);
        flowInfo3 = this.valueIfTrue.analyseCode(blockScope, flowContext, flowInfo3);
        this.valueIfTrue.checkNPEbyUnboxing(blockScope, flowContext, flowInfo3);
        this.ifTrueNullStatus = -1;
        if (compilerOptions.enableSyntacticNullAnalysisForFields) {
            this.ifTrueNullStatus = this.valueIfTrue.nullStatus(flowInfo3, flowContext);
            flowContext.expireNullCheckedFieldInfo();
        }
        FlowInfo flowInfo4 = flowInfo.initsWhenFalse().copy();
        if (bl) {
            if ((n2 & 3) == 0) {
                flowInfo4.setReachMode(1);
            }
            if (!ConditionalExpression.isKnowDeadCodePattern(this.condition) || compilerOptions.reportDeadCodeInTrivialIfStatement) {
                this.valueIfFalse.complainIfUnreachable(flowInfo4, blockScope, n, true);
            }
        }
        this.falseInitStateIndex = blockScope.methodScope().recordInitializationStates(flowInfo4);
        this.condition.updateFlowOnBooleanResult(flowInfo4, false);
        flowInfo4 = this.valueIfFalse.analyseCode(blockScope, flowContext, flowInfo4);
        this.valueIfFalse.checkNPEbyUnboxing(blockScope, flowContext, flowInfo4);
        --flowContext.conditionalLevel;
        if (bl) {
            flowInfo2 = flowInfo3.addPotentialInitializationsFrom(flowInfo4);
            this.nullStatus = this.ifTrueNullStatus != -1 ? this.ifTrueNullStatus : this.valueIfTrue.nullStatus(flowInfo3, flowContext);
        } else if (bl2) {
            flowInfo2 = flowInfo4.addPotentialInitializationsFrom(flowInfo3);
            this.nullStatus = this.valueIfFalse.nullStatus(flowInfo4, flowContext);
        } else {
            this.computeNullStatus(flowInfo3, flowInfo4, flowContext);
            constant = this.optimizedIfTrueConstant;
            boolean bl3 = constant != null && constant != Constant.NotAConstant && constant.booleanValue();
            boolean bl4 = constant != null && constant != Constant.NotAConstant && !constant.booleanValue();
            constant = this.optimizedIfFalseConstant;
            boolean bl5 = constant != null && constant != Constant.NotAConstant && constant.booleanValue();
            boolean bl6 = constant != null && constant != Constant.NotAConstant && !constant.booleanValue();
            UnconditionalFlowInfo unconditionalFlowInfo = flowInfo3.initsWhenTrue().unconditionalCopy();
            UnconditionalFlowInfo unconditionalFlowInfo2 = flowInfo4.initsWhenTrue().unconditionalCopy();
            UnconditionalFlowInfo unconditionalFlowInfo3 = flowInfo3.initsWhenFalse().unconditionalInits();
            UnconditionalFlowInfo unconditionalFlowInfo4 = flowInfo4.initsWhenFalse().unconditionalInits();
            if (bl4) {
                unconditionalFlowInfo.setReachMode(1);
            }
            if (bl6) {
                unconditionalFlowInfo2.setReachMode(1);
            }
            if (bl3) {
                unconditionalFlowInfo3.setReachMode(1);
            }
            if (bl5) {
                unconditionalFlowInfo4.setReachMode(1);
            }
            flowInfo2 = FlowInfo.conditional(unconditionalFlowInfo.mergedWith(unconditionalFlowInfo2), unconditionalFlowInfo3.mergedWith(unconditionalFlowInfo4));
        }
        this.mergedInitStateIndex = blockScope.methodScope().recordInitializationStates(flowInfo2);
        flowInfo2.setReachMode(n2);
        return flowInfo2;
    }

    @Override
    public boolean checkNPE(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo, int n) {
        if ((this.nullStatus & 2) != 0) {
            blockScope.problemReporter().expressionNullReference(this);
        } else if ((this.nullStatus & 0x10) != 0) {
            blockScope.problemReporter().expressionPotentialNullReference(this);
        }
        return true;
    }

    private void computeNullStatus(FlowInfo flowInfo, FlowInfo flowInfo2, FlowContext flowContext) {
        if (this.ifTrueNullStatus == -1) {
            this.ifTrueNullStatus = this.valueIfTrue.nullStatus(flowInfo, flowContext);
        }
        this.ifFalseNullStatus = this.valueIfFalse.nullStatus(flowInfo2, flowContext);
        if (this.ifTrueNullStatus == this.ifFalseNullStatus) {
            this.nullStatus = this.ifTrueNullStatus;
            return;
        }
        if (flowInfo.reachMode() != 0) {
            this.nullStatus = this.ifFalseNullStatus;
            return;
        }
        if (flowInfo2.reachMode() != 0) {
            this.nullStatus = this.ifTrueNullStatus;
            return;
        }
        int n = this.ifTrueNullStatus | this.ifFalseNullStatus;
        int n2 = Expression.computeNullStatus(0, n);
        if (n2 > 0) {
            this.nullStatus = n2;
        }
    }

    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        int n = codeStream.position;
        if (this.constant != Constant.NotAConstant) {
            if (bl) {
                codeStream.generateConstant(this.constant, this.implicitConversion);
            }
            codeStream.recordPositionsFrom(n, this.sourceStart);
            return;
        }
        Constant constant = this.condition.optimizedBooleanConstant();
        if (constant == Constant.NotAConstant) {
            constant = this.condition.optimizedNullComparisonConstant();
        }
        boolean bl2 = constant == Constant.NotAConstant || constant.booleanValue();
        boolean bl3 = constant == Constant.NotAConstant || !constant.booleanValue();
        BranchLabel branchLabel = new BranchLabel(codeStream);
        BranchLabel branchLabel2 = new BranchLabel(codeStream);
        branchLabel2.tagBits |= 2;
        this.condition.generateOptimizedBoolean(blockScope, codeStream, null, branchLabel2, constant == Constant.NotAConstant);
        if (this.trueInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.trueInitStateIndex);
            codeStream.addDefinitelyAssignedVariables(blockScope, this.trueInitStateIndex);
        }
        if (bl2) {
            this.valueIfTrue.generateCode(blockScope, codeStream, bl);
            if (bl3) {
                int n2 = codeStream.position;
                codeStream.goto_(branchLabel);
                codeStream.recordPositionsFrom(n2, this.valueIfTrue.sourceEnd);
                if (bl) {
                    switch (this.resolvedType.id) {
                        case 7: 
                        case 8: {
                            codeStream.decrStackSize(2);
                            break;
                        }
                        default: {
                            codeStream.decrStackSize(1);
                        }
                    }
                }
            }
        }
        if (bl3) {
            if (this.falseInitStateIndex != -1) {
                codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.falseInitStateIndex);
                codeStream.addDefinitelyAssignedVariables(blockScope, this.falseInitStateIndex);
            }
            if (branchLabel2.forwardReferenceCount() > 0) {
                branchLabel2.place();
            }
            this.valueIfFalse.generateCode(blockScope, codeStream, bl);
            if (bl) {
                codeStream.recordExpressionType(this.resolvedType);
            }
            if (bl2) {
                branchLabel.place();
            }
        }
        if (this.mergedInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.mergedInitStateIndex);
        }
        if (bl) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    @Override
    public void generateOptimizedBoolean(BlockScope blockScope, CodeStream codeStream, BranchLabel branchLabel, BranchLabel branchLabel2, boolean bl) {
        BranchLabel branchLabel3;
        BranchLabel branchLabel4;
        boolean bl2;
        int n;
        block8: {
            int n2;
            block10: {
                Constant constant;
                block9: {
                    n = codeStream.position;
                    if (this.constant != Constant.NotAConstant && this.constant.typeID() == 5 || (this.valueIfTrue.implicitConversion & 0xFF) >> 4 != 5 || (this.valueIfFalse.implicitConversion & 0xFF) >> 4 != 5) {
                        super.generateOptimizedBoolean(blockScope, codeStream, branchLabel, branchLabel2, bl);
                        return;
                    }
                    constant = this.condition.constant;
                    Constant constant2 = this.condition.optimizedBooleanConstant();
                    boolean bl3 = !(constant != Constant.NotAConstant && !constant.booleanValue() || constant2 != Constant.NotAConstant && !constant2.booleanValue());
                    bl2 = !(constant != Constant.NotAConstant && constant.booleanValue() || constant2 != Constant.NotAConstant && constant2.booleanValue());
                    branchLabel4 = new BranchLabel(codeStream);
                    boolean bl4 = constant == Constant.NotAConstant && constant2 == Constant.NotAConstant;
                    branchLabel3 = new BranchLabel(codeStream);
                    this.condition.generateOptimizedBoolean(blockScope, codeStream, null, branchLabel3, bl4);
                    if (this.trueInitStateIndex != -1) {
                        codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.trueInitStateIndex);
                        codeStream.addDefinitelyAssignedVariables(blockScope, this.trueInitStateIndex);
                    }
                    if (!bl3) break block8;
                    this.valueIfTrue.generateOptimizedBoolean(blockScope, codeStream, branchLabel, branchLabel2, bl);
                    if (!bl2) break block8;
                    if (branchLabel2 != null) break block9;
                    if (branchLabel == null) break block10;
                    constant = this.optimizedIfTrueConstant;
                    int n3 = n2 = constant != null && constant != Constant.NotAConstant && constant.booleanValue() ? 1 : 0;
                    if (n2 == 0) break block10;
                    break block8;
                }
                if (branchLabel != null) break block10;
                constant = this.optimizedIfTrueConstant;
                int n4 = n2 = constant != null && constant != Constant.NotAConstant && !constant.booleanValue() ? 1 : 0;
                if (n2 != 0) break block8;
            }
            n2 = codeStream.position;
            codeStream.goto_(branchLabel4);
            codeStream.recordPositionsFrom(n2, this.valueIfTrue.sourceEnd);
        }
        if (bl2) {
            branchLabel3.place();
            if (this.falseInitStateIndex != -1) {
                codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.falseInitStateIndex);
                codeStream.addDefinitelyAssignedVariables(blockScope, this.falseInitStateIndex);
            }
            this.valueIfFalse.generateOptimizedBoolean(blockScope, codeStream, branchLabel, branchLabel2, bl);
            branchLabel4.place();
        }
        if (this.mergedInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.mergedInitStateIndex);
        }
        codeStream.recordPositionsFrom(n, this.sourceEnd);
    }

    @Override
    public int nullStatus(FlowInfo flowInfo, FlowContext flowContext) {
        if ((this.implicitConversion & 0x200) != 0) {
            return 4;
        }
        return this.nullStatus;
    }

    @Override
    public Constant optimizedBooleanConstant() {
        return this.optimizedBooleanConstant == null ? this.constant : this.optimizedBooleanConstant;
    }

    @Override
    public StringBuffer printExpressionNoParenthesis(int n, StringBuffer stringBuffer) {
        this.condition.printExpression(n, stringBuffer).append(" ? ");
        this.valueIfTrue.printExpression(0, stringBuffer).append(" : ");
        return this.valueIfFalse.printExpression(0, stringBuffer);
    }

    @Override
    public void addPatternVariables(BlockScope blockScope, CodeStream codeStream) {
        this.condition.addPatternVariables(blockScope, codeStream);
        this.valueIfTrue.addPatternVariables(blockScope, codeStream);
        this.valueIfFalse.addPatternVariables(blockScope, codeStream);
    }

    @Override
    public void collectPatternVariablesToScope(LocalVariableBinding[] localVariableBindingArray, BlockScope blockScope) {
        this.condition.collectPatternVariablesToScope(this.patternVarsWhenTrue, blockScope);
        localVariableBindingArray = this.condition.getPatternVariablesWhenTrue();
        this.valueIfTrue.addPatternVariablesWhenTrue(localVariableBindingArray);
        this.valueIfFalse.addPatternVariablesWhenFalse(localVariableBindingArray);
        this.valueIfTrue.collectPatternVariablesToScope(localVariableBindingArray, blockScope);
        localVariableBindingArray = this.condition.getPatternVariablesWhenFalse();
        this.valueIfTrue.addPatternVariablesWhenFalse(localVariableBindingArray);
        this.valueIfFalse.addPatternVariablesWhenTrue(localVariableBindingArray);
        this.valueIfFalse.collectPatternVariablesToScope(localVariableBindingArray, blockScope);
    }

    @Override
    public TypeBinding resolveType(BlockScope blockScope) {
        TypeBinding typeBinding;
        Constant constant;
        Constant constant2;
        Object object;
        LookupEnvironment lookupEnvironment = blockScope.environment();
        long l2 = blockScope.compilerOptions().sourceLevel;
        boolean bl = l2 >= 0x310000L;
        boolean bl2 = this.use18specifics = l2 >= 0x340000L;
        if (this.use18specifics && (this.expressionContext == ExpressionContext.ASSIGNMENT_CONTEXT || this.expressionContext == ExpressionContext.INVOCATION_CONTEXT)) {
            this.valueIfTrue.setExpressionContext(this.expressionContext);
            this.valueIfTrue.setExpectedType(this.expectedType);
            this.valueIfFalse.setExpressionContext(this.expressionContext);
            this.valueIfFalse.setExpectedType(this.expectedType);
        }
        if (this.condition.containsPatternVariable()) {
            this.collectPatternVariablesToScope(null, blockScope);
        }
        if (this.constant != Constant.NotAConstant) {
            this.constant = Constant.NotAConstant;
            object = this.condition.resolveTypeExpecting(blockScope, TypeBinding.BOOLEAN);
            this.condition.computeConversion(blockScope, TypeBinding.BOOLEAN, (TypeBinding)object);
            if (this.valueIfTrue instanceof CastExpression) {
                this.valueIfTrue.bits |= 0x20;
            }
            this.originalValueIfTrueType = this.valueIfTrue.resolveType(blockScope);
            if (this.valueIfFalse instanceof CastExpression) {
                this.valueIfFalse.bits |= 0x20;
            }
            this.originalValueIfFalseType = this.valueIfFalse.resolveType(blockScope);
            if (object == null || this.originalValueIfTrueType == null || this.originalValueIfFalseType == null) {
                return null;
            }
        } else {
            if (this.originalValueIfTrueType.kind() == 65540) {
                this.originalValueIfTrueType = this.valueIfTrue.resolveType(blockScope);
            }
            if (this.originalValueIfFalseType.kind() == 65540) {
                this.originalValueIfFalseType = this.valueIfFalse.resolveType(blockScope);
            }
            if (this.originalValueIfTrueType == null || !this.originalValueIfTrueType.isValidBinding()) {
                this.resolvedType = null;
                return null;
            }
            if (this.originalValueIfFalseType == null || !this.originalValueIfFalseType.isValidBinding()) {
                this.resolvedType = null;
                return null;
            }
        }
        if ((object = this.condition.constant) != Constant.NotAConstant && (constant2 = this.valueIfTrue.constant) != Constant.NotAConstant && (constant = this.valueIfFalse.constant) != Constant.NotAConstant) {
            Constant constant3 = this.constant = ((Constant)object).booleanValue() ? constant2 : constant;
        }
        if (this.isPolyExpression()) {
            if (this.expectedType == null || !this.expectedType.isProperType(true)) {
                this.constant = Constant.NotAConstant;
                return new PolyTypeBinding(this);
            }
            this.resolvedType = this.computeConversions(blockScope, this.expectedType) ? this.expectedType : null;
            return this.resolvedType;
        }
        TypeBinding typeBinding2 = this.originalValueIfTrueType;
        TypeBinding typeBinding3 = this.originalValueIfFalseType;
        if (bl && TypeBinding.notEquals(typeBinding2, typeBinding3)) {
            if (typeBinding2.isBaseType()) {
                if (typeBinding3.isBaseType()) {
                    if (typeBinding2 == TypeBinding.NULL) {
                        typeBinding3 = lookupEnvironment.computeBoxingType(typeBinding3);
                    } else if (typeBinding3 == TypeBinding.NULL) {
                        typeBinding2 = lookupEnvironment.computeBoxingType(typeBinding2);
                    }
                } else {
                    TypeBinding typeBinding4 = typeBinding = typeBinding3.isBaseType() ? typeBinding3 : lookupEnvironment.computeBoxingType(typeBinding3);
                    if (typeBinding2.isNumericType() && typeBinding.isNumericType()) {
                        typeBinding3 = typeBinding;
                    } else if (typeBinding2 != TypeBinding.NULL) {
                        typeBinding3 = lookupEnvironment.computeBoxingType(typeBinding3);
                    }
                }
            } else if (typeBinding3.isBaseType()) {
                TypeBinding typeBinding5 = typeBinding = typeBinding2.isBaseType() ? typeBinding2 : lookupEnvironment.computeBoxingType(typeBinding2);
                if (typeBinding.isNumericType() && typeBinding3.isNumericType()) {
                    typeBinding2 = typeBinding;
                } else if (typeBinding3 != TypeBinding.NULL) {
                    typeBinding2 = lookupEnvironment.computeBoxingType(typeBinding2);
                }
            } else {
                typeBinding = lookupEnvironment.computeBoxingType(typeBinding2);
                TypeBinding typeBinding6 = lookupEnvironment.computeBoxingType(typeBinding3);
                if (typeBinding.isNumericType() && typeBinding6.isNumericType()) {
                    typeBinding2 = typeBinding;
                    typeBinding3 = typeBinding6;
                }
            }
        }
        if (TypeBinding.equalsEquals(typeBinding2, typeBinding3)) {
            this.valueIfTrue.computeConversion(blockScope, typeBinding2, this.originalValueIfTrueType);
            this.valueIfFalse.computeConversion(blockScope, typeBinding3, this.originalValueIfFalseType);
            if (TypeBinding.equalsEquals(typeBinding2, TypeBinding.BOOLEAN)) {
                this.optimizedIfTrueConstant = this.valueIfTrue.optimizedBooleanConstant();
                this.optimizedIfFalseConstant = this.valueIfFalse.optimizedBooleanConstant();
                if (this.optimizedIfTrueConstant != Constant.NotAConstant && this.optimizedIfFalseConstant != Constant.NotAConstant && this.optimizedIfTrueConstant.booleanValue() == this.optimizedIfFalseConstant.booleanValue()) {
                    this.optimizedBooleanConstant = this.optimizedIfTrueConstant;
                } else {
                    object = this.condition.optimizedBooleanConstant();
                    if (object != Constant.NotAConstant) {
                        this.optimizedBooleanConstant = ((Constant)object).booleanValue() ? this.optimizedIfTrueConstant : this.optimizedIfFalseConstant;
                    }
                }
            }
            this.resolvedType = NullAnnotationMatching.moreDangerousType(typeBinding2, typeBinding3);
            return this.resolvedType;
        }
        if (typeBinding2.isNumericType() && typeBinding3.isNumericType()) {
            if (TypeBinding.equalsEquals(typeBinding2, TypeBinding.BYTE) && TypeBinding.equalsEquals(typeBinding3, TypeBinding.SHORT) || TypeBinding.equalsEquals(typeBinding2, TypeBinding.SHORT) && TypeBinding.equalsEquals(typeBinding3, TypeBinding.BYTE)) {
                this.valueIfTrue.computeConversion(blockScope, TypeBinding.SHORT, this.originalValueIfTrueType);
                this.valueIfFalse.computeConversion(blockScope, TypeBinding.SHORT, this.originalValueIfFalseType);
                this.resolvedType = TypeBinding.SHORT;
                return this.resolvedType;
            }
            if ((TypeBinding.equalsEquals(typeBinding2, TypeBinding.BYTE) || TypeBinding.equalsEquals(typeBinding2, TypeBinding.SHORT) || TypeBinding.equalsEquals(typeBinding2, TypeBinding.CHAR)) && TypeBinding.equalsEquals(typeBinding3, TypeBinding.INT) && this.valueIfFalse.isConstantValueOfTypeAssignableToType(typeBinding3, typeBinding2)) {
                this.valueIfTrue.computeConversion(blockScope, typeBinding2, this.originalValueIfTrueType);
                this.valueIfFalse.computeConversion(blockScope, typeBinding2, this.originalValueIfFalseType);
                this.resolvedType = typeBinding2;
                return this.resolvedType;
            }
            if ((TypeBinding.equalsEquals(typeBinding3, TypeBinding.BYTE) || TypeBinding.equalsEquals(typeBinding3, TypeBinding.SHORT) || TypeBinding.equalsEquals(typeBinding3, TypeBinding.CHAR)) && TypeBinding.equalsEquals(typeBinding2, TypeBinding.INT) && this.valueIfTrue.isConstantValueOfTypeAssignableToType(typeBinding2, typeBinding3)) {
                this.valueIfTrue.computeConversion(blockScope, typeBinding3, this.originalValueIfTrueType);
                this.valueIfFalse.computeConversion(blockScope, typeBinding3, this.originalValueIfFalseType);
                this.resolvedType = typeBinding3;
                return this.resolvedType;
            }
            if (BaseTypeBinding.isNarrowing(typeBinding2.id, 10) && BaseTypeBinding.isNarrowing(typeBinding3.id, 10)) {
                this.valueIfTrue.computeConversion(blockScope, TypeBinding.INT, this.originalValueIfTrueType);
                this.valueIfFalse.computeConversion(blockScope, TypeBinding.INT, this.originalValueIfFalseType);
                this.resolvedType = TypeBinding.INT;
                return this.resolvedType;
            }
            if (BaseTypeBinding.isNarrowing(typeBinding2.id, 7) && BaseTypeBinding.isNarrowing(typeBinding3.id, 7)) {
                this.valueIfTrue.computeConversion(blockScope, TypeBinding.LONG, this.originalValueIfTrueType);
                this.valueIfFalse.computeConversion(blockScope, TypeBinding.LONG, this.originalValueIfFalseType);
                this.resolvedType = TypeBinding.LONG;
                return this.resolvedType;
            }
            if (BaseTypeBinding.isNarrowing(typeBinding2.id, 9) && BaseTypeBinding.isNarrowing(typeBinding3.id, 9)) {
                this.valueIfTrue.computeConversion(blockScope, TypeBinding.FLOAT, this.originalValueIfTrueType);
                this.valueIfFalse.computeConversion(blockScope, TypeBinding.FLOAT, this.originalValueIfFalseType);
                this.resolvedType = TypeBinding.FLOAT;
                return this.resolvedType;
            }
            this.valueIfTrue.computeConversion(blockScope, TypeBinding.DOUBLE, this.originalValueIfTrueType);
            this.valueIfFalse.computeConversion(blockScope, TypeBinding.DOUBLE, this.originalValueIfFalseType);
            this.resolvedType = TypeBinding.DOUBLE;
            return this.resolvedType;
        }
        if (typeBinding2.isBaseType() && typeBinding2 != TypeBinding.NULL) {
            if (bl) {
                typeBinding2 = lookupEnvironment.computeBoxingType(typeBinding2);
            } else {
                blockScope.problemReporter().conditionalArgumentsIncompatibleTypes(this, typeBinding2, typeBinding3);
                return null;
            }
        }
        if (typeBinding3.isBaseType() && typeBinding3 != TypeBinding.NULL) {
            if (bl) {
                typeBinding3 = lookupEnvironment.computeBoxingType(typeBinding3);
            } else {
                blockScope.problemReporter().conditionalArgumentsIncompatibleTypes(this, typeBinding2, typeBinding3);
                return null;
            }
        }
        if (bl) {
            typeBinding = null;
            typeBinding = typeBinding2 == TypeBinding.NULL ? typeBinding3 : (typeBinding3 == TypeBinding.NULL ? typeBinding2 : blockScope.lowerUpperBound(new TypeBinding[]{typeBinding2, typeBinding3}));
            if (typeBinding != null) {
                this.valueIfTrue.computeConversion(blockScope, typeBinding, this.originalValueIfTrueType);
                this.valueIfFalse.computeConversion(blockScope, typeBinding, this.originalValueIfFalseType);
                this.resolvedType = typeBinding.capture(blockScope, this.sourceStart, this.sourceEnd);
                return this.resolvedType;
            }
        } else {
            if (typeBinding3.isCompatibleWith(typeBinding2)) {
                this.valueIfTrue.computeConversion(blockScope, typeBinding2, this.originalValueIfTrueType);
                this.valueIfFalse.computeConversion(blockScope, typeBinding2, this.originalValueIfFalseType);
                this.resolvedType = typeBinding2;
                return this.resolvedType;
            }
            if (typeBinding2.isCompatibleWith(typeBinding3)) {
                this.valueIfTrue.computeConversion(blockScope, typeBinding3, this.originalValueIfTrueType);
                this.valueIfFalse.computeConversion(blockScope, typeBinding3, this.originalValueIfFalseType);
                this.resolvedType = typeBinding3;
                return this.resolvedType;
            }
        }
        blockScope.problemReporter().conditionalArgumentsIncompatibleTypes(this, typeBinding2, typeBinding3);
        return null;
    }

    protected boolean computeConversions(BlockScope blockScope, TypeBinding typeBinding) {
        boolean bl = true;
        if (this.originalValueIfTrueType != null && this.originalValueIfTrueType.isValidBinding()) {
            if (this.valueIfTrue.isConstantValueOfTypeAssignableToType(this.originalValueIfTrueType, typeBinding) || this.originalValueIfTrueType.isCompatibleWith(typeBinding)) {
                this.valueIfTrue.computeConversion(blockScope, typeBinding, this.originalValueIfTrueType);
                if (this.originalValueIfTrueType.needsUncheckedConversion(typeBinding)) {
                    blockScope.problemReporter().unsafeTypeConversion(this.valueIfTrue, this.originalValueIfTrueType, typeBinding);
                }
                if (this.valueIfTrue instanceof CastExpression && (this.valueIfTrue.bits & 0x4020) == 0) {
                    CastExpression.checkNeedForAssignedCast(blockScope, typeBinding, (CastExpression)this.valueIfTrue);
                }
            } else if (this.isBoxingCompatible(this.originalValueIfTrueType, typeBinding, this.valueIfTrue, blockScope)) {
                this.valueIfTrue.computeConversion(blockScope, typeBinding, this.originalValueIfTrueType);
                if (this.valueIfTrue instanceof CastExpression && (this.valueIfTrue.bits & 0x4020) == 0) {
                    CastExpression.checkNeedForAssignedCast(blockScope, typeBinding, (CastExpression)this.valueIfTrue);
                }
            } else {
                blockScope.problemReporter().typeMismatchError(this.originalValueIfTrueType, typeBinding, this.valueIfTrue, null);
                bl = false;
            }
        }
        if (this.originalValueIfFalseType != null && this.originalValueIfFalseType.isValidBinding()) {
            if (this.valueIfFalse.isConstantValueOfTypeAssignableToType(this.originalValueIfFalseType, typeBinding) || this.originalValueIfFalseType.isCompatibleWith(typeBinding)) {
                this.valueIfFalse.computeConversion(blockScope, typeBinding, this.originalValueIfFalseType);
                if (this.originalValueIfFalseType.needsUncheckedConversion(typeBinding)) {
                    blockScope.problemReporter().unsafeTypeConversion(this.valueIfFalse, this.originalValueIfFalseType, typeBinding);
                }
                if (this.valueIfFalse instanceof CastExpression && (this.valueIfFalse.bits & 0x4020) == 0) {
                    CastExpression.checkNeedForAssignedCast(blockScope, typeBinding, (CastExpression)this.valueIfFalse);
                }
            } else if (this.isBoxingCompatible(this.originalValueIfFalseType, typeBinding, this.valueIfFalse, blockScope)) {
                this.valueIfFalse.computeConversion(blockScope, typeBinding, this.originalValueIfFalseType);
                if (this.valueIfFalse instanceof CastExpression && (this.valueIfFalse.bits & 0x4020) == 0) {
                    CastExpression.checkNeedForAssignedCast(blockScope, typeBinding, (CastExpression)this.valueIfFalse);
                }
            } else {
                blockScope.problemReporter().typeMismatchError(this.originalValueIfFalseType, typeBinding, this.valueIfFalse, null);
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public void setExpectedType(TypeBinding typeBinding) {
        this.expectedType = typeBinding;
    }

    @Override
    public void setExpressionContext(ExpressionContext expressionContext) {
        this.expressionContext = expressionContext;
    }

    @Override
    public ExpressionContext getExpressionContext() {
        return this.expressionContext;
    }

    @Override
    public Expression[] getPolyExpressions() {
        Expression[] expressionArray = this.valueIfTrue.getPolyExpressions();
        Expression[] expressionArray2 = this.valueIfFalse.getPolyExpressions();
        if (expressionArray.length == 0) {
            return expressionArray2;
        }
        if (expressionArray2.length == 0) {
            return expressionArray;
        }
        Expression[] expressionArray3 = new Expression[expressionArray.length + expressionArray2.length];
        System.arraycopy(expressionArray, 0, expressionArray3, 0, expressionArray.length);
        System.arraycopy(expressionArray2, 0, expressionArray3, expressionArray.length, expressionArray2.length);
        return expressionArray3;
    }

    @Override
    public boolean isPertinentToApplicability(TypeBinding typeBinding, MethodBinding methodBinding) {
        return this.valueIfTrue.isPertinentToApplicability(typeBinding, methodBinding) && this.valueIfFalse.isPertinentToApplicability(typeBinding, methodBinding);
    }

    @Override
    public boolean isPotentiallyCompatibleWith(TypeBinding typeBinding, Scope scope) {
        return this.valueIfTrue.isPotentiallyCompatibleWith(typeBinding, scope) && this.valueIfFalse.isPotentiallyCompatibleWith(typeBinding, scope);
    }

    @Override
    public boolean isFunctionalType() {
        return this.valueIfTrue.isFunctionalType() || this.valueIfFalse.isFunctionalType();
    }

    @Override
    public boolean isPolyExpression() throws UnsupportedOperationException {
        if (!this.use18specifics) {
            return false;
        }
        if (this.isPolyExpression) {
            return true;
        }
        if (this.expressionContext != ExpressionContext.ASSIGNMENT_CONTEXT && this.expressionContext != ExpressionContext.INVOCATION_CONTEXT) {
            return false;
        }
        if (this.originalValueIfTrueType == null || this.originalValueIfFalseType == null) {
            return false;
        }
        if (this.valueIfTrue.isPolyExpression() || this.valueIfFalse.isPolyExpression()) {
            return true;
        }
        if ((this.originalValueIfTrueType.isBaseType() || this.originalValueIfTrueType.id >= 26 && this.originalValueIfTrueType.id <= 33) && (this.originalValueIfFalseType.isBaseType() || this.originalValueIfFalseType.id >= 26 && this.originalValueIfFalseType.id <= 33)) {
            return false;
        }
        this.isPolyExpression = true;
        return true;
    }

    @Override
    public boolean isCompatibleWith(TypeBinding typeBinding, Scope scope) {
        return this.isPolyExpression() ? this.valueIfTrue.isCompatibleWith(typeBinding, scope) && this.valueIfFalse.isCompatibleWith(typeBinding, scope) : super.isCompatibleWith(typeBinding, scope);
    }

    @Override
    public boolean isBoxingCompatibleWith(TypeBinding typeBinding, Scope scope) {
        return this.isPolyExpression() ? (this.valueIfTrue.isCompatibleWith(typeBinding, scope) || this.valueIfTrue.isBoxingCompatibleWith(typeBinding, scope)) && (this.valueIfFalse.isCompatibleWith(typeBinding, scope) || this.valueIfFalse.isBoxingCompatibleWith(typeBinding, scope)) : super.isBoxingCompatibleWith(typeBinding, scope);
    }

    @Override
    public boolean sIsMoreSpecific(TypeBinding typeBinding, TypeBinding typeBinding2, Scope scope) {
        if (super.sIsMoreSpecific(typeBinding, typeBinding2, scope)) {
            return true;
        }
        return this.isPolyExpression() ? this.valueIfTrue.sIsMoreSpecific(typeBinding, typeBinding2, scope) && this.valueIfFalse.sIsMoreSpecific(typeBinding, typeBinding2, scope) : false;
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.condition.traverse(aSTVisitor, blockScope);
            this.valueIfTrue.traverse(aSTVisitor, blockScope);
            this.valueIfFalse.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

