/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.batch;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.batch.ClasspathLocation;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.parser.ScannerHelper;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.Util;

public class ClasspathDirectory
extends ClasspathLocation {
    private Hashtable directoryCache;
    private String[] missingPackageHolder = new String[1];
    private int mode;
    private String encoding;
    private Hashtable<String, Hashtable<String, String>> packageSecondaryTypes = null;
    Map options;

    ClasspathDirectory(File file2, String string, int n, AccessRuleSet accessRuleSet, String string2, Map map) {
        super(accessRuleSet, string2);
        this.mode = n;
        this.options = map;
        try {
            this.path = file2.getCanonicalPath();
        }
        catch (IOException iOException) {
            this.path = file2.getAbsolutePath();
        }
        if (!this.path.endsWith(File.separator)) {
            this.path = this.path + File.separator;
        }
        this.directoryCache = new Hashtable(11);
        this.encoding = string;
    }

    String[] directoryList(String string) {
        String[] stringArray = (String[])this.directoryCache.get(string);
        if (stringArray == this.missingPackageHolder) {
            return null;
        }
        if (stringArray != null) {
            return stringArray;
        }
        File file2 = new File(this.path + string);
        if (file2.isDirectory()) {
            String string2;
            String string3;
            int n = string.length();
            int n2 = string.lastIndexOf(File.separatorChar);
            while (--n > n2 && !ScannerHelper.isUpperCase(string.charAt(n))) {
            }
            if (n <= n2 || !(n2 != -1 ? !this.doesFileExist(string3 = string.substring(n2 + 1), string2 = string.substring(0, n2)) : !this.doesFileExist(string, Util.EMPTY_STRING))) {
                stringArray = file2.list();
                if (stringArray == null) {
                    stringArray = CharOperation.NO_STRINGS;
                }
                this.directoryCache.put(string, stringArray);
                return stringArray;
            }
        }
        this.directoryCache.put(string, this.missingPackageHolder);
        return null;
    }

    boolean doesFileExist(String string, String string2) {
        String[] stringArray = this.directoryList(string2);
        if (stringArray == null) {
            return false;
        }
        int n = stringArray.length;
        while (--n >= 0) {
            if (!string.equals(stringArray[n])) continue;
            return true;
        }
        return false;
    }

    public List fetchLinkedJars(FileSystem.ClasspathSectionProblemReporter classpathSectionProblemReporter) {
        return null;
    }

    private NameEnvironmentAnswer findClassInternal(char[] cArray, String string, String string2, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        boolean bl2;
        if (!this.isPackage(string, null)) {
            return null;
        }
        String string3 = new String(cArray);
        boolean bl3 = (this.mode & 2) != 0 && this.doesFileExist(string3 + ".class", string);
        boolean bl4 = bl2 = (this.mode & 1) != 0 && this.doesFileExist(string3 + ".java", string);
        if (bl2 && !bl) {
            object3 = this.path + string2.substring(0, string2.length() - 6) + ".java";
            object2 = new CompilationUnit(null, (String)object3, this.encoding, this.destinationPath);
            char[] cArray2 = ((CompilationUnit)object2).module = this.module == null ? null : this.module.name();
            if (!bl3) {
                return new NameEnvironmentAnswer((ICompilationUnit)object2, this.fetchAccessRestriction(string2));
            }
            object = this.path + string2;
            long l2 = new File((String)object).lastModified();
            long l3 = new File((String)object3).lastModified();
            if (l3 > l2) {
                return new NameEnvironmentAnswer((ICompilationUnit)object2, this.fetchAccessRestriction(string2));
            }
        }
        if (bl3) {
            try {
                object3 = ClassFileReader.read(this.path + string2);
                Object object4 = object2 = string.length() > 0 ? string.replace(File.separatorChar, '/') + "/" + string3 : string3;
                if (!CharOperation.equals(((ClassFileReader)object3).getName(), ((String)object2).toCharArray())) {
                    object3 = null;
                }
                if (object3 != null) {
                    object = ((ClassFileReader)object3).moduleName != null ? ((ClassFileReader)object3).moduleName : (char[])(this.module != null ? this.module.name() : null);
                    return new NameEnvironmentAnswer((IBinaryType)object3, this.fetchAccessRestriction(string2), (char[])object);
                }
            }
            catch (IOException | ClassFormatException exception) {
                // empty catch block
            }
        }
        return null;
    }

    public NameEnvironmentAnswer findSecondaryInClass(char[] cArray, String string, String string2) {
        if (CharOperation.equals(TypeConstants.PACKAGE_INFO_NAME, cArray)) {
            return null;
        }
        String string3 = new String(cArray);
        String string4 = this.module != null ? String.valueOf(this.module.name()) : null;
        boolean bl = this.options != null && this.isPackage(string, string4) && (this.mode & 1) != 0 && this.doesFileExist(string3 + ".java", string);
        return bl ? null : this.findSourceSecondaryType(string3, string, string2);
    }

    @Override
    public boolean hasAnnotationFileFor(String string) {
        int n = string.lastIndexOf(47);
        if (n != -1 && n + 1 < string.length()) {
            String string2 = string.substring(n + 1) + ".eea";
            return this.doesFileExist(string2, string.substring(0, n));
        }
        return false;
    }

    @Override
    public NameEnvironmentAnswer findClass(char[] cArray, String string, String string2, String string3) {
        return this.findClass(cArray, string, string2, string3, false);
    }

    @Override
    public NameEnvironmentAnswer findClass(char[] cArray, String string, String string2, String string3, boolean bl) {
        if (File.separatorChar == '/') {
            return this.findClassInternal(cArray, string, string3, bl);
        }
        return this.findClassInternal(cArray, string.replace('/', File.separatorChar), string3.replace('/', File.separatorChar), bl);
    }

    private Hashtable<String, String> getSecondaryTypes(String string) {
        File[] fileArray;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String[] stringArray = (String[])this.directoryCache.get(string);
        if (stringArray == this.missingPackageHolder || stringArray == null) {
            return hashtable;
        }
        File file2 = new File(this.path + string);
        File[] fileArray2 = fileArray = file2.isDirectory() ? file2.listFiles() : null;
        if (fileArray == null) {
            return hashtable;
        }
        for (File file3 : fileArray) {
            TypeDeclaration[] typeDeclarationArray;
            String string2;
            if (file3.isDirectory() || (string2 = file3.getAbsolutePath()) == null || !string2.endsWith(".java") && !string2.endsWith(".JAVA")) continue;
            CompilationUnit compilationUnit = new CompilationUnit(null, string2, this.encoding, this.destinationPath);
            CompilationResult compilationResult = new CompilationResult(string2.toCharArray(), 1, 1, 10);
            ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), new CompilerOptions(this.options), new DefaultProblemFactory());
            Parser parser = new Parser(problemReporter, false);
            parser.reportSyntaxErrorIsRequired = false;
            CompilationUnitDeclaration compilationUnitDeclaration = parser.parse(compilationUnit, compilationResult);
            TypeDeclaration[] typeDeclarationArray2 = typeDeclarationArray = compilationUnitDeclaration != null ? compilationUnitDeclaration.types : null;
            if (typeDeclarationArray == null) continue;
            int n = typeDeclarationArray.length;
            for (int i = 0; i < n; ++i) {
                char[] cArray;
                TypeDeclaration typeDeclaration = typeDeclarationArray[i];
                char[] cArray2 = cArray = typeDeclaration.isSecondary() ? typeDeclaration.name : null;
                if (cArray == null) continue;
                hashtable.put(new String(cArray), string2);
            }
        }
        return hashtable;
    }

    private NameEnvironmentAnswer findSourceSecondaryType(String string, String string2, String string3) {
        String string4;
        Hashtable<String, String> hashtable;
        if (this.packageSecondaryTypes == null) {
            this.packageSecondaryTypes = new Hashtable();
        }
        if ((hashtable = this.packageSecondaryTypes.get(string2)) == null) {
            hashtable = this.getSecondaryTypes(string2);
            this.packageSecondaryTypes.put(string2, hashtable);
        }
        return (string4 = hashtable.get(string)) != null ? new NameEnvironmentAnswer(new CompilationUnit(null, string4, this.encoding, this.destinationPath), this.fetchAccessRestriction(string3)) : null;
    }

    @Override
    public char[][][] findTypeNames(String string, String string2) {
        int n;
        int n2;
        if (!this.isPackage(string, string2)) {
            return null;
        }
        File file2 = new File(this.path + string);
        if (!file2.exists() || !file2.isDirectory()) {
            return null;
        }
        String[] stringArray = file2.list(new FilenameFilter(){

            @Override
            public boolean accept(File file2, String string) {
                String string2 = string.toLowerCase();
                return string2.endsWith(".class") || string2.endsWith(".java");
            }
        });
        if (stringArray == null || (n2 = stringArray.length) == 0) {
            return null;
        }
        Set<String> set = this.getSecondaryTypes(string).keySet();
        char[][][] cArrayArray = new char[n2 + set.size()][][];
        char[][] cArray = CharOperation.splitOn(File.separatorChar, string.toCharArray());
        for (n = 0; n < n2; ++n) {
            String string3 = stringArray[n];
            int n3 = string3.indexOf(46);
            String string4 = n3 > 0 ? string3.substring(0, n3) : string3;
            cArrayArray[n] = CharOperation.arrayConcat(cArray, string4.toCharArray());
        }
        if (set.size() > 0) {
            n = n2;
            for (String string5 : set) {
                cArrayArray[n++] = CharOperation.arrayConcat(cArray, string5.toCharArray());
            }
        }
        return cArrayArray;
    }

    @Override
    public void initialize() throws IOException {
    }

    @Override
    public char[][] getModulesDeclaringPackage(String string, String string2) {
        String string3 = File.separatorChar == '/' ? string : string.replace('/', File.separatorChar);
        return this.singletonModuleNameIf(this.directoryList(string3) != null);
    }

    @Override
    public boolean hasCompilationUnit(String string, String string2) {
        String string3 = File.separatorChar == '/' ? string : string.replace('/', File.separatorChar);
        String[] stringArray = this.directoryList(string3);
        if (stringArray != null) {
            for (String string4 : stringArray) {
                String string5 = string4.toLowerCase();
                if (!string5.endsWith(".java") && !string5.endsWith(".class")) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasCUDeclaringPackage(String string, Function<CompilationUnit, String> function) {
        String string3 = File.separatorChar == '/' ? string : string.replace('/', File.separatorChar);
        String[] stringArray = this.directoryList(string3);
        if (stringArray == null) {
            return false;
        }
        return Stream.of(stringArray).anyMatch(string2 -> {
            String string3 = string2.toLowerCase();
            boolean bl = false;
            String string4 = this.path + string3 + "/" + string2;
            String string5 = null;
            if (string3.endsWith(".class")) {
                return true;
            }
            if (string3.endsWith(".java")) {
                CompilationUnit compilationUnit = new CompilationUnit(null, string4, this.encoding);
                string5 = (String)function.apply(compilationUnit);
            }
            if (string5 != null && string5.equals(string3.replace(File.separatorChar, '.'))) {
                bl = true;
            }
            return bl;
        });
    }

    @Override
    public char[][] listPackages() {
        final HashSet hashSet = new HashSet();
        try {
            final Path path = FileSystems.getDefault().getPath(this.path, new String[0]);
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path2, BasicFileAttributes basicFileAttributes) {
                    if (path2.toString().toLowerCase().endsWith(".class")) {
                        hashSet.add(path2.getParent().relativize(path).toString().replace('/', '.'));
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return (char[][])hashSet.stream().map(String::toCharArray).toArray(n -> new char[n][]);
    }

    @Override
    public void reset() {
        super.reset();
        this.directoryCache = new Hashtable(11);
    }

    public String toString() {
        return "ClasspathDirectory " + this.path;
    }

    @Override
    public char[] normalizedPath() {
        if (this.normalizedPath == null) {
            this.normalizedPath = this.path.toCharArray();
            if (File.separatorChar == '\\') {
                CharOperation.replace(this.normalizedPath, '\\', '/');
            }
        }
        return this.normalizedPath;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    @Override
    public IModule getModule() {
        return this.module;
    }
}

