/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.impl;

import org.eclipse.jdt.internal.compiler.impl.Constant;

public class LongConstant
extends Constant {
    private static final LongConstant ZERO = new LongConstant(0L);
    private static final LongConstant MIN_VALUE = new LongConstant(Long.MIN_VALUE);
    private long value;

    public static Constant fromValue(long l2) {
        if (l2 == 0L) {
            return ZERO;
        }
        if (l2 == Long.MIN_VALUE) {
            return MIN_VALUE;
        }
        return new LongConstant(l2);
    }

    private LongConstant(long l2) {
        this.value = l2;
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public char charValue() {
        return (char)this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public String stringValue() {
        return String.valueOf(this.value);
    }

    @Override
    public String toString() {
        return "(long)" + this.value;
    }

    @Override
    public int typeID() {
        return 7;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        LongConstant longConstant = (LongConstant)object;
        return this.value == longConstant.value;
    }
}

