/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.tool;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.JavaFileObject;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.tool.Util;

public class ArchiveFileObject
implements JavaFileObject {
    protected String entryName;
    protected File file;
    private ZipFile zipFile;
    protected Charset charset;

    public ArchiveFileObject(File file2, String string, Charset charset) {
        this.entryName = string;
        this.file = file2;
        this.charset = charset;
    }

    protected void finalize() throws Throwable {
        if (this.zipFile != null) {
            try {
                this.zipFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.finalize();
    }

    @Override
    public Modifier getAccessLevel() {
        if (this.getKind() != JavaFileObject.Kind.CLASS) {
            return null;
        }
        ClassFileReader classFileReader = this.getClassReader();
        if (classFileReader == null) {
            return null;
        }
        int n = classFileReader.accessFlags();
        if ((n & 1) != 0) {
            return Modifier.PUBLIC;
        }
        if ((n & 0x400) != 0) {
            return Modifier.ABSTRACT;
        }
        if ((n & 0x10) != 0) {
            return Modifier.FINAL;
        }
        return null;
    }

    protected ClassFileReader getClassReader() {
        ClassFileReader classFileReader = null;
        try (ZipFile zipFile = new ZipFile(this.file);){
            classFileReader = ClassFileReader.read(zipFile, this.entryName);
        }
        catch (ClassFormatException classFormatException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return classFileReader;
    }

    @Override
    public JavaFileObject.Kind getKind() {
        String string = this.entryName.toLowerCase();
        if (string.endsWith(JavaFileObject.Kind.CLASS.extension)) {
            return JavaFileObject.Kind.CLASS;
        }
        if (string.endsWith(JavaFileObject.Kind.SOURCE.extension)) {
            return JavaFileObject.Kind.SOURCE;
        }
        if (string.endsWith(JavaFileObject.Kind.HTML.extension)) {
            return JavaFileObject.Kind.HTML;
        }
        return JavaFileObject.Kind.OTHER;
    }

    @Override
    public NestingKind getNestingKind() {
        switch (this.getKind()) {
            case SOURCE: {
                return NestingKind.TOP_LEVEL;
            }
            case CLASS: {
                ClassFileReader classFileReader = this.getClassReader();
                if (classFileReader == null) {
                    return null;
                }
                if (classFileReader.isAnonymous()) {
                    return NestingKind.ANONYMOUS;
                }
                if (classFileReader.isLocal()) {
                    return NestingKind.LOCAL;
                }
                if (classFileReader.isMember()) {
                    return NestingKind.MEMBER;
                }
                return NestingKind.TOP_LEVEL;
            }
        }
        return null;
    }

    @Override
    public boolean isNameCompatible(String string, JavaFileObject.Kind kind) {
        return this.entryName.endsWith(string + kind.extension);
    }

    @Override
    public boolean delete() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ArchiveFileObject)) {
            return false;
        }
        ArchiveFileObject archiveFileObject = (ArchiveFileObject)object;
        return archiveFileObject.toUri().equals(this.toUri());
    }

    public int hashCode() {
        return this.toUri().hashCode();
    }

    @Override
    public CharSequence getCharContent(boolean bl) throws IOException {
        if (this.getKind() == JavaFileObject.Kind.SOURCE) {
            try (ZipFile zipFile = new ZipFile(this.file);){
                ZipEntry zipEntry = zipFile.getEntry(this.entryName);
                CharSequence charSequence = Util.getCharContents(this, bl, org.eclipse.jdt.internal.compiler.util.Util.getZipEntryByteContent(zipEntry, zipFile), this.charset.name());
                return charSequence;
            }
        }
        return null;
    }

    @Override
    public long getLastModified() {
        long l2;
        ZipFile zipFile = new ZipFile(this.file);
        try {
            ZipEntry zipEntry = zipFile.getEntry(this.entryName);
            l2 = zipEntry.getTime();
        }
        catch (Throwable throwable) {
            try {
                try {
                    zipFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                return 0L;
            }
        }
        zipFile.close();
        return l2;
    }

    @Override
    public String getName() {
        return this.entryName;
    }

    @Override
    public InputStream openInputStream() throws IOException {
        if (this.zipFile == null) {
            this.zipFile = new ZipFile(this.file);
        }
        ZipEntry zipEntry = this.zipFile.getEntry(this.entryName);
        return this.zipFile.getInputStream(zipEntry);
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reader openReader(boolean bl) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Writer openWriter() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public URI toUri() {
        try {
            return new URI("jar:" + this.file.toURI().getPath() + "!" + this.entryName);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public String toString() {
        return this.file.getAbsolutePath() + "[" + this.entryName + "]";
    }
}

