/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.tool;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.ZipException;
import javax.lang.model.SourceVersion;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.batch.Main;
import org.eclipse.jdt.internal.compiler.batch.ModuleFinder;
import org.eclipse.jdt.internal.compiler.env.AccessRule;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.tool.Archive;
import org.eclipse.jdt.internal.compiler.tool.ArchiveFileObject;
import org.eclipse.jdt.internal.compiler.tool.EclipseFileObject;
import org.eclipse.jdt.internal.compiler.tool.JrtFileSystem;
import org.eclipse.jdt.internal.compiler.tool.ModuleLocationHandler;
import org.eclipse.jdt.internal.compiler.tool.Options;
import org.eclipse.jdt.internal.compiler.util.Util;

public class EclipseFileManager
implements StandardJavaFileManager {
    private static final String NO_EXTENSION = "";
    static final int HAS_EXT_DIRS = 1;
    static final int HAS_BOOTCLASSPATH = 2;
    static final int HAS_ENDORSED_DIRS = 4;
    static final int HAS_PROCESSORPATH = 8;
    static final int HAS_PROC_MODULEPATH = 16;
    Map<File, Archive> archivesCache;
    Charset charset;
    Locale locale;
    ModuleLocationHandler locationHandler;
    final Map<JavaFileManager.Location, URLClassLoader> classloaders;
    int flags;
    boolean isOnJvm9;
    File jrtHome;
    JrtFileSystem jrtSystem;
    public ResourceBundle bundle;
    private String releaseVersion;

    public EclipseFileManager(Locale locale, Charset charset) {
        this.locale = locale == null ? Locale.getDefault() : locale;
        this.charset = charset == null ? Charset.defaultCharset() : charset;
        this.locationHandler = new ModuleLocationHandler();
        this.classloaders = new HashMap<JavaFileManager.Location, URLClassLoader>();
        this.archivesCache = new HashMap<File, Archive>();
        this.isOnJvm9 = this.isRunningJvm9();
        try {
            this.initialize(Util.getJavaHome());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            this.bundle = Main.ResourceBundleFactory.getBundle(this.locale);
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println("Missing resource : " + "org.eclipse.jdt.internal.compiler.batch.messages".replace('.', '/') + ".properties for locale " + locale);
        }
    }

    protected void initialize(File file2) throws IOException {
        if (this.isOnJvm9) {
            this.jrtSystem = new JrtFileSystem(file2);
            this.archivesCache.put(file2, this.jrtSystem);
            this.jrtHome = file2;
            this.locationHandler.newSystemLocation((JavaFileManager.Location)StandardLocation.SYSTEM_MODULES, this.jrtSystem);
        } else {
            this.setLocation(StandardLocation.PLATFORM_CLASS_PATH, this.getDefaultBootclasspath());
        }
        Iterable<? extends File> iterable = this.getDefaultClasspath();
        this.setLocation(StandardLocation.CLASS_PATH, iterable);
        this.setLocation(StandardLocation.ANNOTATION_PROCESSOR_PATH, iterable);
    }

    @Override
    public void close() throws IOException {
        this.locationHandler.close();
        for (Archive object : this.archivesCache.values()) {
            object.close();
        }
        this.archivesCache.clear();
        for (URLClassLoader uRLClassLoader : this.classloaders.values()) {
            uRLClassLoader.close();
        }
        this.classloaders.clear();
    }

    private void collectAllMatchingFiles(JavaFileManager.Location location, File file2, String string, Set<JavaFileObject.Kind> set, boolean bl, ArrayList<JavaFileObject> arrayList) {
        block14: {
            String string2;
            block15: {
                String string3;
                Archive archive;
                block16: {
                    block13: {
                        if (!file2.equals(this.jrtHome)) break block13;
                        if (!(location instanceof ModuleLocationHandler.ModuleLocationWrapper)) break block14;
                        List<JrtFileSystem.JrtFileObject> list = this.jrtSystem.list((ModuleLocationHandler.ModuleLocationWrapper)location, string, set, bl, this.charset);
                        for (JrtFileSystem.JrtFileObject jrtFileObject : list) {
                            JavaFileObject.Kind kind = this.getKind(this.getExtension(jrtFileObject.entryName));
                            if (!set.contains((Object)kind)) continue;
                            arrayList.add(jrtFileObject);
                        }
                        break block14;
                    }
                    if (!this.isArchive(file2)) break block15;
                    archive = this.getArchive(file2);
                    if (archive == Archive.UNKNOWN_ARCHIVE) {
                        return;
                    }
                    string3 = string;
                    if (!string.endsWith("/")) {
                        string3 = string3 + '/';
                    }
                    if (!bl) break block16;
                    for (String string4 : archive.allPackages()) {
                        List<String[]> list;
                        if (!string4.startsWith(string3) || (list = archive.getTypes(string4)) == null) continue;
                        for (String[] stringArray : list) {
                            JavaFileObject.Kind kind = this.getKind(this.getExtension(stringArray[0]));
                            if (!set.contains((Object)kind)) continue;
                            arrayList.add(archive.getArchiveFileObject(string4 + stringArray[0], stringArray[1], this.charset));
                        }
                    }
                    break block14;
                }
                List<String[]> list = archive.getTypes(string3);
                if (list == null) break block14;
                for (String[] stringArray : list) {
                    JavaFileObject.Kind kind = this.getKind(this.getExtension(stringArray[0]));
                    if (!set.contains((Object)kind)) continue;
                    arrayList.add(archive.getArchiveFileObject(string3 + stringArray[0], stringArray[1], this.charset));
                }
                break block14;
            }
            File file3 = new File(file2, string);
            if (!file3.exists()) {
                return;
            }
            try {
                string2 = file3.getCanonicalPath();
            }
            catch (IOException iOException) {
                return;
            }
            if (File.separatorChar == '/' ? !string2.endsWith(string) : !string2.endsWith(string.replace('/', File.separatorChar))) {
                return;
            }
            File[] fileArray = file3.listFiles();
            if (fileArray != null) {
                for (File file4 : fileArray) {
                    if (file4.isDirectory() && bl) {
                        this.collectAllMatchingFiles(location, file2, string + '/' + file4.getName(), set, bl, arrayList);
                        continue;
                    }
                    JavaFileObject.Kind kind = this.getKind(file4);
                    if (!set.contains((Object)kind)) continue;
                    arrayList.add(new EclipseFileObject(string + file4.getName(), file4.toURI(), kind, this.charset));
                }
            }
        }
    }

    private Iterable<? extends File> concatFiles(Iterable<? extends File> iterable, Iterable<? extends File> iterable2) {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (iterable2 == null) {
            return iterable;
        }
        Iterator<? extends File> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        iterator = iterable2.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    @Override
    public void flush() throws IOException {
        for (Archive archive : this.archivesCache.values()) {
            archive.flush();
        }
    }

    private Archive getArchive(File file2) {
        Archive archive = this.archivesCache.get(file2);
        if (archive == null) {
            archive = Archive.UNKNOWN_ARCHIVE;
            if (file2.exists()) {
                try {
                    archive = this.isJrt(file2) ? new JrtFileSystem(file2) : new Archive(file2);
                }
                catch (ZipException zipException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (archive != null) {
                    this.archivesCache.put(file2, archive);
                }
            }
            this.archivesCache.put(file2, archive);
        }
        return archive;
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        this.validateNonModuleLocation(location);
        Iterable<? extends File> iterable = this.getLocation(location);
        if (iterable == null) {
            return null;
        }
        URLClassLoader uRLClassLoader = this.classloaders.get(location);
        if (uRLClassLoader == null) {
            ArrayList<URL> arrayList = new ArrayList<URL>();
            for (File file2 : iterable) {
                try {
                    arrayList.add(file2.toURI().toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    throw new RuntimeException(malformedURLException);
                }
            }
            URL[] uRLArray = new URL[arrayList.size()];
            uRLClassLoader = new URLClassLoader(arrayList.toArray(uRLArray), this.getClass().getClassLoader());
            this.classloaders.put(location, uRLClassLoader);
        }
        return uRLClassLoader;
    }

    private Iterable<? extends File> getPathsFrom(String string) {
        ArrayList arrayList = new ArrayList();
        ArrayList<File> arrayList2 = new ArrayList<File>();
        try {
            this.processPathEntries(4, arrayList, string, this.charset.name(), false, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        for (FileSystem.Classpath classpath : arrayList) {
            arrayList2.add(new File(classpath.getPath()));
        }
        return arrayList2;
    }

    Iterable<? extends File> getDefaultBootclasspath() {
        long l2;
        ArrayList<File> arrayList = new ArrayList<File>();
        String string = System.getProperty("java.version");
        if (string.length() > 3) {
            string = string.substring(0, 3);
        }
        if ((l2 = CompilerOptions.versionToJdkLevel(string)) < 0x320000L) {
            return null;
        }
        for (FileSystem.Classpath classpath : Util.collectFilesNames()) {
            arrayList.add(new File(classpath.getPath()));
        }
        return arrayList;
    }

    Iterable<? extends File> getDefaultClasspath() {
        ArrayList<File> arrayList = new ArrayList<File>();
        String string = System.getProperty("java.class.path");
        if (string == null || string.length() == 0) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            File file2 = new File(string2);
            if (!file2.exists()) continue;
            arrayList.add(file2);
        }
        return arrayList;
    }

    private Iterable<? extends File> getEndorsedDirsFrom(String string) {
        ArrayList arrayList = new ArrayList();
        ArrayList<File> arrayList2 = new ArrayList<File>();
        try {
            this.processPathEntries(4, arrayList, string, this.charset.name(), false, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        for (FileSystem.Classpath classpath : arrayList) {
            arrayList2.add(new File(classpath.getPath()));
        }
        return arrayList2;
    }

    private Iterable<? extends File> getExtdirsFrom(String string) {
        ArrayList arrayList = new ArrayList();
        ArrayList<File> arrayList2 = new ArrayList<File>();
        try {
            this.processPathEntries(4, arrayList, string, this.charset.name(), false, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        for (FileSystem.Classpath classpath : arrayList) {
            arrayList2.add(new File(classpath.getPath()));
        }
        return arrayList2;
    }

    private String getExtension(File file2) {
        String string = file2.getName();
        return this.getExtension(string);
    }

    private String getExtension(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return NO_EXTENSION;
        }
        return string.substring(n);
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String string, String string2) throws IOException {
        this.validateNonModuleLocation(location);
        Iterable<? extends File> iterable = this.getLocation(location);
        if (iterable == null) {
            throw new IllegalArgumentException("Unknown location : " + location);
        }
        String string3 = this.normalized(string) + '/' + string2.replace('\\', '/');
        for (File file2 : iterable) {
            Object object;
            if (file2.isDirectory()) {
                object = new File(file2, string3);
                if (!((File)object).exists()) continue;
                return new EclipseFileObject(string + File.separator + string2, ((File)object).toURI(), this.getKind((File)object), this.charset);
            }
            if (!this.isArchive(file2) || (object = this.getArchive(file2)) == Archive.UNKNOWN_ARCHIVE || !((Archive)object).contains(string3)) continue;
            return ((Archive)object).getArchiveFileObject(string3, null, this.charset);
        }
        return null;
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String string, String string2, FileObject fileObject) throws IOException {
        this.validateOutputLocation(location);
        Iterable<? extends File> iterable = this.getLocation(location);
        if (iterable == null) {
            throw new IllegalArgumentException("Unknown location : " + location);
        }
        Iterator<? extends File> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            File file2 = iterator.next();
            String string3 = this.normalized(string) + '/' + string2.replace('\\', '/');
            File file3 = new File(file2, string3);
            return new EclipseFileObject(string + File.separator + string2, file3.toURI(), this.getKind(file3), this.charset);
        }
        throw new IllegalArgumentException("location is empty : " + location);
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind) throws IOException {
        this.validateNonModuleLocation(location);
        if (kind != JavaFileObject.Kind.CLASS && kind != JavaFileObject.Kind.SOURCE) {
            throw new IllegalArgumentException("Invalid kind : " + (Object)((Object)kind));
        }
        Iterable<? extends File> iterable = this.getLocation(location);
        if (iterable == null) {
            throw new IllegalArgumentException("Unknown location : " + location);
        }
        String string2 = this.normalized(string);
        string2 = string2 + kind.extension;
        for (File file2 : iterable) {
            Object object;
            if (file2.equals(this.jrtHome)) {
                object = location instanceof ModuleLocationHandler.ModuleLocationWrapper ? ((ModuleLocationHandler.ModuleLocationWrapper)location).modName : NO_EXTENSION;
                return this.jrtSystem.getArchiveFileObject(string2, (String)object, this.charset);
            }
            if (file2.isDirectory()) {
                object = new File(file2, string2);
                if (!((File)object).exists()) continue;
                return new EclipseFileObject(string, ((File)object).toURI(), kind, this.charset);
            }
            if (!this.isArchive(file2) || (object = this.getArchive(file2)) == Archive.UNKNOWN_ARCHIVE || !((Archive)object).contains(string2)) continue;
            return ((Archive)object).getArchiveFileObject(string2, null, this.charset);
        }
        return null;
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind, FileObject fileObject) throws IOException {
        this.validateOutputLocation(location);
        if (kind != JavaFileObject.Kind.CLASS && kind != JavaFileObject.Kind.SOURCE) {
            throw new IllegalArgumentException("Invalid kind : " + (Object)((Object)kind));
        }
        Iterable<? extends File> iterable = this.getLocation(location);
        if (iterable == null) {
            if (!location.equals(StandardLocation.CLASS_OUTPUT) && !location.equals(StandardLocation.SOURCE_OUTPUT)) {
                throw new IllegalArgumentException("Unknown location : " + location);
            }
            if (fileObject != null) {
                String string2 = this.normalized(string);
                int n = string2.lastIndexOf(47);
                if (n != -1) {
                    string2 = string2.substring(n + 1);
                }
                string2 = string2 + kind.extension;
                URI uRI = fileObject.toUri();
                URI uRI2 = null;
                try {
                    String string3 = uRI.getPath();
                    n = string3.lastIndexOf(47);
                    if (n != -1) {
                        string3 = string3.substring(0, n + 1);
                        string3 = string3 + string2;
                    }
                    uRI2 = new URI(uRI.getScheme(), uRI.getHost(), string3, uRI.getFragment());
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new IllegalArgumentException("invalid sibling", uRISyntaxException);
                }
                return new EclipseFileObject(string, uRI2, kind, this.charset);
            }
            String string4 = this.normalized(string);
            string4 = string4 + kind.extension;
            File file2 = new File(System.getProperty("user.dir"), string4);
            return new EclipseFileObject(string, file2.toURI(), kind, this.charset);
        }
        Iterator<? extends File> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            File file3 = iterator.next();
            String string5 = this.normalized(string);
            string5 = string5 + kind.extension;
            File file4 = new File(file3, string5);
            return new EclipseFileObject(string, file4.toURI(), kind, this.charset);
        }
        throw new IllegalArgumentException("location is empty : " + location);
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(File ... fileArray) {
        return this.getJavaFileObjectsFromFiles(Arrays.asList(fileArray));
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(String ... stringArray) {
        return this.getJavaFileObjectsFromStrings(Arrays.asList(stringArray));
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromFiles(Iterable<? extends File> iterable) {
        ArrayList<EclipseFileObject> arrayList = new ArrayList<EclipseFileObject>();
        for (File file2 : iterable) {
            if (file2.isDirectory()) {
                throw new IllegalArgumentException("file : " + file2.getAbsolutePath() + " is a directory");
            }
            arrayList.add(new EclipseFileObject(file2.getAbsolutePath(), file2.toURI(), this.getKind(file2), this.charset));
        }
        return arrayList;
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromStrings(Iterable<String> iterable) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (String string : iterable) {
            arrayList.add(new File(string));
        }
        return this.getJavaFileObjectsFromFiles(arrayList);
    }

    public JavaFileObject.Kind getKind(File file2) {
        return this.getKind(this.getExtension(file2));
    }

    private JavaFileObject.Kind getKind(String string) {
        if (JavaFileObject.Kind.CLASS.extension.equals(string)) {
            return JavaFileObject.Kind.CLASS;
        }
        if (JavaFileObject.Kind.SOURCE.extension.equals(string)) {
            return JavaFileObject.Kind.SOURCE;
        }
        if (JavaFileObject.Kind.HTML.extension.equals(string)) {
            return JavaFileObject.Kind.HTML;
        }
        return JavaFileObject.Kind.OTHER;
    }

    @Override
    public Iterable<? extends File> getLocation(JavaFileManager.Location location) {
        if (location instanceof ModuleLocationHandler.LocationWrapper) {
            return this.getFiles(((ModuleLocationHandler.LocationWrapper)location).paths);
        }
        ModuleLocationHandler.LocationContainer locationContainer = this.locationHandler.getLocation(location);
        if (locationContainer == null) {
            return null;
        }
        return this.getFiles(((ModuleLocationHandler.LocationWrapper)locationContainer).getPaths());
    }

    private Iterable<? extends File> getOutputDir(String string) {
        if ("none".equals(string)) {
            return null;
        }
        File file2 = new File(string);
        if (file2.exists() && !file2.isDirectory()) {
            throw new IllegalArgumentException("file : " + file2.getAbsolutePath() + " is not a directory");
        }
        ArrayList<File> arrayList = new ArrayList<File>(1);
        arrayList.add(file2);
        return arrayList;
    }

    @Override
    public boolean handleOption(String string, Iterator<String> iterator) {
        try {
            switch (string) {
                case "-bootclasspath": {
                    if (iterator.hasNext()) {
                        Iterable<? extends File> iterable = this.getPathsFrom(iterator.next());
                        if (iterable != null) {
                            Iterable<? extends File> iterable2 = this.getLocation(StandardLocation.PLATFORM_CLASS_PATH);
                            if ((this.flags & 4) == 0 && (this.flags & 1) == 0) {
                                this.setLocation(StandardLocation.PLATFORM_CLASS_PATH, iterable);
                            } else if ((this.flags & 4) != 0) {
                                this.setLocation(StandardLocation.PLATFORM_CLASS_PATH, this.concatFiles(iterable2, iterable));
                            } else {
                                this.setLocation(StandardLocation.PLATFORM_CLASS_PATH, this.prependFiles(iterable2, iterable));
                            }
                        }
                        this.flags |= 2;
                        return true;
                    }
                    throw new IllegalArgumentException();
                }
                case "--system": {
                    if (iterator.hasNext()) {
                        Iterable<? extends File> iterable = this.getPathsFrom(iterator.next());
                        if (iterable != null) {
                            Iterable<? extends File> iterable3 = this.getLocation(StandardLocation.SYSTEM_MODULES);
                            if (iterable3 != null) {
                                this.setLocation(StandardLocation.SYSTEM_MODULES, this.concatFiles(iterable3, iterable));
                            } else {
                                this.setLocation(StandardLocation.SYSTEM_MODULES, iterable);
                            }
                        }
                        return true;
                    }
                    throw new IllegalArgumentException();
                }
                case "--upgrade-module-path": {
                    if (iterator.hasNext()) {
                        Iterable<? extends File> iterable = this.getPathsFrom(iterator.next());
                        if (iterable != null) {
                            Iterable<? extends File> iterable4 = this.getLocation(StandardLocation.UPGRADE_MODULE_PATH);
                            if (iterable4 != null) {
                                this.setLocation(StandardLocation.UPGRADE_MODULE_PATH, this.concatFiles(iterable4, iterable));
                            } else {
                                this.setLocation(StandardLocation.UPGRADE_MODULE_PATH, iterable);
                            }
                        }
                        return true;
                    }
                    throw new IllegalArgumentException();
                }
                case "-classpath": 
                case "-cp": {
                    if (iterator.hasNext()) {
                        Iterable<? extends File> iterable = this.getPathsFrom(iterator.next());
                        if (iterable != null) {
                            Iterable<? extends File> iterable5 = this.getLocation(StandardLocation.CLASS_PATH);
                            if (iterable5 != null) {
                                this.setLocation(StandardLocation.CLASS_PATH, this.concatFiles(iterable5, iterable));
                            } else {
                                this.setLocation(StandardLocation.CLASS_PATH, iterable);
                            }
                            if ((this.flags & 8) == 0) {
                                this.setLocation(StandardLocation.ANNOTATION_PROCESSOR_PATH, iterable);
                            } else if ((this.flags & 0x10) == 0 && this.isOnJvm9) {
                                this.setLocation(StandardLocation.ANNOTATION_PROCESSOR_MODULE_PATH, iterable);
                            }
                        }
                        return true;
                    }
                    throw new IllegalArgumentException();
                }
                case "--module-path": 
                case "-p": {
                    Iterable<? extends File> iterable = this.getPathsFrom(iterator.next());
                    if (iterable != null) {
                        Iterable<? extends File> iterable6 = this.getLocation(StandardLocation.MODULE_PATH);
                        if (iterable6 != null) {
                            this.setLocation(StandardLocation.MODULE_PATH, this.concatFiles(iterable6, iterable));
                        } else {
                            this.setLocation(StandardLocation.MODULE_PATH, iterable);
                        }
                        if ((this.flags & 8) == 0) {
                            this.setLocation(StandardLocation.ANNOTATION_PROCESSOR_PATH, iterable);
                        } else if ((this.flags & 0x10) == 0 && this.isOnJvm9) {
                            this.setLocation(StandardLocation.ANNOTATION_PROCESSOR_MODULE_PATH, iterable);
                        }
                    }
                    return true;
                }
                case "-encoding": {
                    if (iterator.hasNext()) {
                        this.charset = Charset.forName(iterator.next());
                        return true;
                    }
                    throw new IllegalArgumentException();
                }
                case "-sourcepath": {
                    if (iterator.hasNext()) {
                        Iterable<? extends File> iterable = this.getPathsFrom(iterator.next());
                        if (iterable != null) {
                            this.setLocation(StandardLocation.SOURCE_PATH, iterable);
                        }
                        return true;
                    }
                    throw new IllegalArgumentException();
                }
                case "--module-source-path": {
                    if (iterator.hasNext()) {
                        Iterable<? extends File> iterable = this.getPathsFrom(iterator.next());
                        if (iterable != null && this.isOnJvm9) {
                            this.setLocation(StandardLocation.MODULE_SOURCE_PATH, iterable);
                        }
                        return true;
                    }
                    throw new IllegalArgumentException();
                }
                case "-extdirs": {
                    if (this.isOnJvm9) {
                        throw new IllegalArgumentException();
                    }
                    if (iterator.hasNext()) {
                        Iterable<? extends File> iterable = this.getLocation(StandardLocation.PLATFORM_CLASS_PATH);
                        this.setLocation(StandardLocation.PLATFORM_CLASS_PATH, this.concatFiles(iterable, this.getExtdirsFrom(iterator.next())));
                        this.flags |= 1;
                        return true;
                    }
                    throw new IllegalArgumentException();
                }
                case "-endorseddirs": {
                    if (iterator.hasNext()) {
                        Iterable<? extends File> iterable = this.getLocation(StandardLocation.PLATFORM_CLASS_PATH);
                        this.setLocation(StandardLocation.PLATFORM_CLASS_PATH, this.prependFiles(iterable, this.getEndorsedDirsFrom(iterator.next())));
                        this.flags |= 4;
                        return true;
                    }
                    throw new IllegalArgumentException();
                }
                case "-d": {
                    if (iterator.hasNext()) {
                        Iterable<? extends File> iterable = this.getOutputDir(iterator.next());
                        if (iterable != null) {
                            this.setLocation(StandardLocation.CLASS_OUTPUT, iterable);
                        }
                        return true;
                    }
                    throw new IllegalArgumentException();
                }
                case "-s": {
                    if (iterator.hasNext()) {
                        Iterable<? extends File> iterable = this.getOutputDir(iterator.next());
                        if (iterable != null) {
                            this.setLocation(StandardLocation.SOURCE_OUTPUT, iterable);
                        }
                        return true;
                    }
                    throw new IllegalArgumentException();
                }
                case "-processorpath": {
                    if (iterator.hasNext()) {
                        Iterable<? extends File> iterable = this.getPathsFrom(iterator.next());
                        if (iterable != null) {
                            this.setLocation(StandardLocation.ANNOTATION_PROCESSOR_PATH, iterable);
                        }
                        this.flags |= 8;
                        return true;
                    }
                    throw new IllegalArgumentException();
                }
                case "--processor-module-path": {
                    if (iterator.hasNext()) {
                        Iterable<? extends File> iterable = this.getPathsFrom(iterator.next());
                        if (iterable != null && this.isOnJvm9) {
                            this.setLocation(StandardLocation.ANNOTATION_PROCESSOR_MODULE_PATH, iterable);
                            this.flags |= 0x10;
                        }
                        return true;
                    }
                    throw new IllegalArgumentException();
                }
                case "--release": {
                    if (iterator.hasNext()) {
                        this.releaseVersion = iterator.next();
                        return true;
                    }
                    throw new IllegalArgumentException();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        String string = null;
        if (location instanceof ModuleLocationHandler.ModuleLocationWrapper) {
            string = ((ModuleLocationHandler.ModuleLocationWrapper)location).modName;
        }
        ModuleLocationHandler.LocationWrapper locationWrapper = null;
        locationWrapper = string == null ? this.locationHandler.getLocation(location) : this.locationHandler.getLocation(location, string);
        return locationWrapper != null;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject javaFileObject) {
        this.validateNonModuleLocation(location);
        Iterable<? extends Path> iterable = this.getLocationAsPaths(location);
        if (iterable == null) {
            return null;
        }
        if (javaFileObject instanceof JrtFileSystem.JrtFileObject) {
            Path path = ((JrtFileSystem.JrtFileObject)javaFileObject).path;
            String string = (path = path.subpath(2, path.getNameCount())).toString();
            int n = string.lastIndexOf(46);
            if (n != -1) {
                string = string.substring(0, n);
            }
            return string.replace('/', '.');
        }
        String string = javaFileObject.getName();
        JavaFileObject javaFileObject2 = null;
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string = string.substring(0, n);
        }
        try {
            javaFileObject2 = this.getJavaFileForInput(location, string, javaFileObject.getKind());
        }
        catch (IOException iOException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        if (javaFileObject2 == null) {
            return null;
        }
        return string.replace('/', '.');
    }

    private boolean isArchive(File file2) {
        if (this.isJrt(file2)) {
            return false;
        }
        String string = this.getExtension(file2);
        return string.equalsIgnoreCase(".jar") || string.equalsIgnoreCase(".zip");
    }

    private boolean isJrt(File file2) {
        return file2.getName().toLowerCase().equals("jrt-fs.jar");
    }

    @Override
    public boolean isSameFile(FileObject fileObject, FileObject fileObject2) {
        if (!(fileObject instanceof EclipseFileObject)) {
            throw new IllegalArgumentException("Unsupported file object class : " + fileObject.getClass());
        }
        if (!(fileObject2 instanceof EclipseFileObject)) {
            throw new IllegalArgumentException("Unsupported file object class : " + fileObject2.getClass());
        }
        return fileObject.equals(fileObject2);
    }

    @Override
    public int isSupportedOption(String string) {
        return Options.processOptionsFileManager(string);
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String string, Set<JavaFileObject.Kind> set, boolean bl) throws IOException {
        this.validateNonModuleLocation(location);
        Iterable<? extends Path> iterable = this.getLocationAsPaths(location);
        if (iterable == null) {
            throw new IllegalArgumentException("Unknown location : " + location);
        }
        ArrayList<JavaFileObject> arrayList = new ArrayList<JavaFileObject>();
        String string2 = this.normalized(string);
        for (Path path : iterable) {
            this.collectAllMatchingFiles(location, path.toFile(), string2, set, bl, arrayList);
        }
        return arrayList;
    }

    private String normalized(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        block4: for (int i = 0; i < n; ++i) {
            switch (cArray[i]) {
                case '\\': {
                    cArray[i] = 47;
                    continue block4;
                }
                case '.': {
                    cArray[i] = 47;
                }
            }
        }
        return new String(cArray);
    }

    private Iterable<? extends File> prependFiles(Iterable<? extends File> iterable, Iterable<? extends File> iterable2) {
        if (iterable2 == null) {
            return iterable;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        Iterator<? extends File> iterator = iterable2.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        if (iterable != null) {
            iterator = iterable.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
        }
        return arrayList;
    }

    private boolean isRunningJvm9() {
        return SourceVersion.latest().compareTo(SourceVersion.RELEASE_8) > 0;
    }

    @Override
    public void setLocation(JavaFileManager.Location location, Iterable<? extends File> iterable) throws IOException {
        if (location.isOutputLocation() && iterable != null) {
            int n = 0;
            Iterator<? extends File> iterator = iterable.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                ++n;
            }
            if (n != 1) {
                throw new IllegalArgumentException("output location can only have one path");
            }
        }
        this.locationHandler.setLocation(location, this.getPaths(iterable));
    }

    public void setLocale(Locale locale) {
        this.locale = locale == null ? Locale.getDefault() : locale;
        try {
            this.bundle = Main.ResourceBundleFactory.getBundle(this.locale);
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println("Missing resource : " + "org.eclipse.jdt.internal.compiler.batch.messages".replace('.', '/') + ".properties for locale " + locale);
            throw missingResourceException;
        }
    }

    public void processPathEntries(int n, ArrayList arrayList, String string, String string2, boolean bl, boolean bl2) {
        String string3 = null;
        String string4 = null;
        ArrayList<String> arrayList2 = new ArrayList<String>(n);
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator + "[]", true);
        ArrayList<String> arrayList3 = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList3.add(stringTokenizer.nextToken());
        }
        int n2 = 0;
        String string5 = null;
        int n3 = 0;
        int n4 = arrayList3.size();
        int n5 = -1;
        while (n3 < n4 && n2 != 99) {
            if ((string5 = (String)arrayList3.get(n3++)).equals(File.pathSeparator)) {
                switch (n2) {
                    case 0: 
                    case 3: 
                    case 10: {
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 8: {
                        n2 = 3;
                        this.addNewEntry(arrayList, string3, arrayList2, string2, string4, bl, bl2);
                        arrayList2.clear();
                        break;
                    }
                    case 6: {
                        n2 = 4;
                        break;
                    }
                    case 7: {
                        throw new IllegalArgumentException(this.bind("configure.incorrectDestinationPathEntry", string));
                    }
                    case 11: {
                        n3 = n5 + 1;
                        n2 = 5;
                        break;
                    }
                    default: {
                        n2 = 99;
                        break;
                    }
                }
            } else if (string5.equals("[")) {
                switch (n2) {
                    case 0: {
                        string3 = NO_EXTENSION;
                    }
                    case 1: {
                        n5 = n3 - 1;
                    }
                    case 11: {
                        n2 = 10;
                        break;
                    }
                    case 2: {
                        n2 = 9;
                        break;
                    }
                    case 8: {
                        n2 = 5;
                        break;
                    }
                    default: {
                        n2 = 99;
                        break;
                    }
                }
            } else if (string5.equals("]")) {
                switch (n2) {
                    case 6: {
                        n2 = 2;
                        break;
                    }
                    case 7: {
                        n2 = 8;
                        break;
                    }
                    case 10: {
                        n2 = 11;
                        break;
                    }
                    default: {
                        n2 = 99;
                        break;
                    }
                }
            } else {
                switch (n2) {
                    case 0: 
                    case 3: {
                        n2 = 1;
                        string3 = string5;
                        break;
                    }
                    case 5: {
                        if (string5.startsWith("-d ")) {
                            if (string4 != null) {
                                throw new IllegalArgumentException(this.bind("configure.duplicateDestinationPathEntry", string));
                            }
                            string4 = string5.substring(3).trim();
                            n2 = 7;
                            break;
                        }
                    }
                    case 4: {
                        if (string4 != null) {
                            throw new IllegalArgumentException(this.bind("configure.accessRuleAfterDestinationPath", string));
                        }
                        n2 = 6;
                        arrayList2.add(string5);
                        break;
                    }
                    case 9: {
                        if (!string5.startsWith("-d ")) {
                            n2 = 99;
                            break;
                        }
                        string4 = string5.substring(3).trim();
                        n2 = 7;
                        break;
                    }
                    case 11: {
                        for (int i = n5; i < n3; ++i) {
                            string3 = string3 + (String)arrayList3.get(i);
                        }
                        n2 = 1;
                        break;
                    }
                    case 10: {
                        break;
                    }
                    default: {
                        n2 = 99;
                    }
                }
            }
            if (n2 != 11 || n3 != n4) continue;
            n3 = n5 + 1;
            n2 = 5;
        }
        switch (n2) {
            case 3: {
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                this.addNewEntry(arrayList, string3, arrayList2, string2, string4, bl, bl2);
                break;
            }
        }
    }

    protected void addNewEntry(ArrayList arrayList, String string, ArrayList arrayList2, String string2, String string3, boolean bl, boolean bl2) {
        Object object;
        int n = arrayList2.size();
        AccessRuleSet accessRuleSet = null;
        if (n != 0) {
            object = new AccessRule[arrayList2.size()];
            boolean bl3 = true;
            Iterator iterator = arrayList2.iterator();
            int n2 = 0;
            block6: while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                char c = string4.charAt(0);
                String string5 = string4.substring(1);
                if (string5.length() > 0) {
                    switch (c) {
                        case '+': {
                            object[n2++] = new AccessRule(string5.toCharArray(), 0);
                            continue block6;
                        }
                        case '~': {
                            object[n2++] = new AccessRule(string5.toCharArray(), 0x1000118);
                            continue block6;
                        }
                        case '-': {
                            object[n2++] = new AccessRule(string5.toCharArray(), 0x1000133);
                            continue block6;
                        }
                        case '?': {
                            object[n2++] = new AccessRule(string5.toCharArray(), 0x1000133, true);
                            continue block6;
                        }
                    }
                    bl3 = false;
                    continue;
                }
                bl3 = false;
            }
            if (bl3) {
                accessRuleSet = new AccessRuleSet((AccessRule[])object, 0, string);
            } else {
                return;
            }
        }
        if ("none".equals(string3)) {
            string3 = "none";
        }
        if (bl2 && string3 != null && (string.endsWith(".jar") || string.endsWith(".zip"))) {
            throw new IllegalArgumentException(this.bind("configure.unexpectedDestinationPathEntryFile", string));
        }
        object = FileSystem.getClasspath(string, string2, bl, accessRuleSet, string3, null, this.releaseVersion);
        if (object != null) {
            arrayList.add(object);
        }
    }

    private String bind(String string, String string2) {
        return this.bind(string, new String[]{string2});
    }

    private String bind(String string, String[] stringArray) {
        if (string == null) {
            return "No message available";
        }
        String string2 = null;
        try {
            string2 = this.bundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return "Missing message: " + string + " in: " + "org.eclipse.jdt.internal.compiler.batch.messages";
        }
        return MessageFormat.format(string2, stringArray);
    }

    private Iterable<? extends File> getFiles(final Iterable<? extends Path> iterable) {
        if (iterable == null) {
            return null;
        }
        return () -> new Iterator<File>(){
            Iterator<? extends Path> original;
            {
                this.original = iterable.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.original.hasNext();
            }

            @Override
            public File next() {
                return this.original.next().toFile();
            }
        };
    }

    private Iterable<? extends Path> getPaths(final Iterable<? extends File> iterable) {
        if (iterable == null) {
            return null;
        }
        return () -> new Iterator<Path>(){
            Iterator<? extends File> original;
            {
                this.original = iterable.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.original.hasNext();
            }

            @Override
            public Path next() {
                return this.original.next().toPath();
            }
        };
    }

    private void validateFileObject(FileObject fileObject) {
    }

    private void validateModuleLocation(JavaFileManager.Location location, String string) {
        Objects.requireNonNull(location);
        if (string == null) {
            throw new IllegalArgumentException("module must not be null");
        }
        if (this.isOnJvm9 && !location.isModuleOrientedLocation() && !location.isOutputLocation()) {
            throw new IllegalArgumentException("location is module related :" + location.getName());
        }
    }

    private void validateNonModuleLocation(JavaFileManager.Location location) {
        Objects.requireNonNull(location);
        if (this.isOnJvm9 && location.isModuleOrientedLocation() && location.isOutputLocation()) {
            throw new IllegalArgumentException("location is module related :" + location.getName());
        }
    }

    private void validateOutputLocation(JavaFileManager.Location location) {
        Objects.requireNonNull(location);
        if (!location.isOutputLocation()) {
            throw new IllegalArgumentException("location is not output location :" + location.getName());
        }
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(Path ... pathArray) {
        return this.getJavaFileObjectsFromPaths((Collection<? extends Path>)Arrays.asList(pathArray));
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromPaths(Iterable<? extends Path> iterable) {
        return this.getJavaFileObjectsFromFiles(this.getFiles(iterable));
    }

    @Override
    public Iterable<? extends Path> getLocationAsPaths(JavaFileManager.Location location) {
        if (location instanceof ModuleLocationHandler.LocationWrapper) {
            return ((ModuleLocationHandler.LocationWrapper)location).paths;
        }
        ModuleLocationHandler.LocationContainer locationContainer = this.locationHandler.getLocation(location);
        if (locationContainer == null) {
            return null;
        }
        return ((ModuleLocationHandler.LocationWrapper)locationContainer).getPaths();
    }

    @Override
    public void setLocationFromPaths(JavaFileManager.Location location, Collection<? extends Path> collection) throws IOException {
        this.setLocation(location, this.getFiles(collection));
        if (location == StandardLocation.MODULE_PATH || location == StandardLocation.MODULE_SOURCE_PATH) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string = CompilerOptions.getLatestVersion();
            hashMap.put("org.eclipse.jdt.core.compiler.compliance", string);
            hashMap.put("org.eclipse.jdt.core.compiler.source", string);
            hashMap.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", string);
            CompilerOptions compilerOptions = new CompilerOptions(hashMap);
            ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), compilerOptions, new DefaultProblemFactory());
            for (Path path : collection) {
                List<FileSystem.Classpath> list = ModuleFinder.findModules(path.toFile(), null, new Parser(problemReporter, true), null, true, this.releaseVersion);
                for (FileSystem.Classpath classpath : list) {
                    Collection<String> collection2 = classpath.getModuleNames(null);
                    for (String string2 : collection2) {
                        Path path2 = Paths.get(classpath.getPath(), new String[0]);
                        this.setLocationForModule(location, string2, Collections.singletonList(path2));
                    }
                }
            }
        }
    }

    @Override
    public boolean contains(JavaFileManager.Location location, FileObject fileObject) throws IOException {
        this.validateFileObject(fileObject);
        Iterable<? extends File> iterable = this.getLocation(location);
        if (iterable == null) {
            throw new IllegalArgumentException("Unknown location : " + location);
        }
        for (File file2 : iterable) {
            Object object;
            if (!(file2.isDirectory() ? fileObject instanceof EclipseFileObject && (object = ((EclipseFileObject)fileObject).f.toPath()).startsWith(Paths.get(file2.toURI()).toAbsolutePath()) : this.isArchive(file2) && fileObject instanceof ArchiveFileObject && (object = this.getArchive(file2)) != Archive.UNKNOWN_ARCHIVE && ((Archive)object).contains(((ArchiveFileObject)fileObject).entryName))) continue;
            return true;
        }
        return false;
    }

    @Override
    public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, String string) throws IOException {
        this.validateModuleLocation(location, string);
        JavaFileManager.Location location2 = this.locationHandler.getLocation(location, string);
        if (location2 == null && location == StandardLocation.CLASS_OUTPUT) {
            ModuleLocationHandler.LocationWrapper locationWrapper = this.locationHandler.getLocation((JavaFileManager.Location)StandardLocation.MODULE_SOURCE_PATH, string);
            if (locationWrapper == null) {
                location2 = location;
            } else {
                this.deriveOutputLocationForModules(string, locationWrapper.paths);
                location2 = this.getLocationForModule(location, string);
            }
        } else if (location2 == null && location == StandardLocation.SOURCE_OUTPUT) {
            ModuleLocationHandler.LocationWrapper locationWrapper = this.locationHandler.getLocation((JavaFileManager.Location)StandardLocation.MODULE_SOURCE_PATH, string);
            this.deriveSourceOutputLocationForModules(string, locationWrapper.paths);
            location2 = this.getLocationForModule(location, string);
        }
        return location2;
    }

    @Override
    public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, JavaFileObject javaFileObject) {
        this.validateModuleLocation(location, NO_EXTENSION);
        Path path = null;
        if (javaFileObject instanceof ArchiveFileObject) {
            path = ((ArchiveFileObject)javaFileObject).file.toPath();
            return this.locationHandler.getLocation(location, path);
        }
        if (javaFileObject instanceof EclipseFileObject) {
            path = ((EclipseFileObject)javaFileObject).f.toPath();
            try {
                path = path.toRealPath(new LinkOption[0]);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            ModuleLocationHandler.LocationContainer locationContainer = this.locationHandler.getLocation(location);
            while (path != null) {
                JavaFileManager.Location location2 = locationContainer.get(path);
                if (location2 != null) {
                    return location2;
                }
                path = path.getParent();
            }
        }
        return null;
    }

    @Override
    public <S> ServiceLoader<S> getServiceLoader(JavaFileManager.Location location, Class<S> clazz) throws IOException {
        return ServiceLoader.load(clazz, this.getClassLoader(location));
    }

    @Override
    public String inferModuleName(JavaFileManager.Location location) throws IOException {
        if (location instanceof ModuleLocationHandler.ModuleLocationWrapper) {
            ModuleLocationHandler.ModuleLocationWrapper moduleLocationWrapper = (ModuleLocationHandler.ModuleLocationWrapper)location;
            return moduleLocationWrapper.modName;
        }
        return null;
    }

    @Override
    public Iterable<Set<JavaFileManager.Location>> listLocationsForModules(JavaFileManager.Location location) {
        this.validateModuleLocation(location, NO_EXTENSION);
        return this.locationHandler.listLocationsForModules(location);
    }

    @Override
    public Path asPath(FileObject fileObject) {
        this.validateFileObject(fileObject);
        EclipseFileObject eclipseFileObject = (EclipseFileObject)fileObject;
        if (eclipseFileObject.f != null) {
            return eclipseFileObject.f.toPath();
        }
        return null;
    }

    private void deriveOutputLocationForModules(String string, Collection<? extends Path> collection) {
        ModuleLocationHandler.LocationWrapper locationWrapper = this.locationHandler.getLocation((JavaFileManager.Location)StandardLocation.CLASS_OUTPUT, string);
        if (locationWrapper == null) {
            Iterator<? extends Path> iterator;
            locationWrapper = this.locationHandler.getLocation((JavaFileManager.Location)StandardLocation.CLASS_OUTPUT, NO_EXTENSION);
            if (locationWrapper == null) {
                locationWrapper = this.locationHandler.getLocation(StandardLocation.CLASS_OUTPUT);
            }
            if (locationWrapper != null && (iterator = locationWrapper.paths.iterator()).hasNext()) {
                try {
                    Path path = iterator.next().resolve(string);
                    this.locationHandler.setLocation(StandardLocation.CLASS_OUTPUT, string, Collections.singletonList(path));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private void deriveSourceOutputLocationForModules(String string, Collection<? extends Path> collection) {
        ModuleLocationHandler.LocationWrapper locationWrapper = this.locationHandler.getLocation((JavaFileManager.Location)StandardLocation.SOURCE_OUTPUT, string);
        if (locationWrapper == null) {
            Iterator<? extends Path> iterator;
            locationWrapper = this.locationHandler.getLocation((JavaFileManager.Location)StandardLocation.SOURCE_OUTPUT, NO_EXTENSION);
            if (locationWrapper == null) {
                locationWrapper = this.locationHandler.getLocation(StandardLocation.SOURCE_OUTPUT);
            }
            if (locationWrapper != null && (iterator = locationWrapper.paths.iterator()).hasNext()) {
                try {
                    Path path = iterator.next().resolve(string);
                    this.locationHandler.setLocation(StandardLocation.SOURCE_OUTPUT, string, Collections.singletonList(path));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    @Override
    public void setLocationForModule(JavaFileManager.Location location, String string, Collection<? extends Path> collection) throws IOException {
        this.validateModuleLocation(location, string);
        this.locationHandler.setLocation(location, string, collection);
        if (location == StandardLocation.MODULE_SOURCE_PATH) {
            this.deriveOutputLocationForModules(string, collection);
        }
    }
}

