# Release notes for version 0.2, 20230726

```
/******************************************************************************
 * This file is part of The Unicode Tools Of Rexx (TUTOR)                     *
 * See https://rexx.epbcn.com/TUTOR/                                          *
 *     and https://github.com/JosepMariaBlasco/TUTOR                          *
 * Copyright © 2023-2025 Josep Maria Blasco <josep.maria.blasco@epbcn.com>    *
 * License: Apache License 2.0 (https://www.apache.org/licenses/LICENSE-2.0)  *
 ******************************************************************************/
```

I have just uploaded the 0.2 release of the Unicode Toys for Rexx. They contain many new changes and additions, too numerous to document here. I have selected the following highlights:

`LOWER` and `UPPER` are implemented for `RUNES` and `TEXT` strings (for `BYTES` strings they also work, but they give the usual, Classic Rexx, results),
implementing full case mappings (but no locales). Some examples (please note the special, automatic, handling of the medial and final sigma):

```rexx {unicode}
Say Upper("áéíóúýàèìòùäëïöüâêîôûñãõç"T)         -- "ÁÉÍÓÚÝÀÈÌÒÙÄËÏÖÜÂÊÎÔÛÑÃÕÇ"
Say Lower("ÁÉÍÓÚÝÀÈÌÒÙÄËÏÖÜÂÊÎÔÛÑÃÕÇ"T)         -- "áéíóúýàèìòùäëïöüâêîôûñãõç"
Say Lower("ὈΔΥΣΣΕΎΣ"T)                          -- "ὀδυσσεύς"
Lower('Aİ'R) = 'ai̇'                             -- Some operations are
Length('Aİ'R) = 2                               -- not one-to-one,
Length(Lower('Aİ'R)) = 3                        -- the string has grown!
Say Upper("Straße"T)                            -- "STRASSE", also not one-to-one.
```

A new `OPTIONS DEFAULTSTRING` _default_ instruction is implemented. It allows determining the handling and processing of unsuffixed strings. Possible values for _default_ are `BYTES`, `RUNES` and `TEXT`.

A new `OPTIONS CONVERSIONS [NONE | PROMOTE | DEMOTE | RIGHT | LEFT]` has been implemented, as discussed in a previous email.

Since the preprocessor is using a tokenizer instead of a full AST parser, `OPTIONS` instructions have to appear on their own line,
without comments, and they can not be part of conditional or repetitive instructions, subroutines or methods, etc. (rxu.rex will not complain, but behaviour is undefined).

I will copy the corresponding entry of the diary below my signature. As always, all remarks, comments, etc. are very welcome.

  Josep Maria

-----------------------------------------------------------------------------
20230726: 0.2 - Numerous changes, too many to report in complete detail here:

Extensive refactoring.
I'm beginning to work on abstracting the persistence level (persistent limited StringTable).
Allow for three-stage tables in addition to two-stage tables.
Implement LOWER and UPPER, using full case mappings (i.e., use SpecialCasing.txt in addition to UnicodeData.txt).
Relocate binary file building routines to the build subdirectory, and self-tests to the tests subdirectory.
Delete the demo directory and create instead a new samples directory.
Add OPTIONS CONVERSIONS and OPTIONS DEFAULTSTRING handling to the rxu command.
Store numerous binary properties (see case.cls in the properties subdirectory). These will come handy to implement normalization, full case folding, etc.
Check that everything works under Linux (checked under Ubuntu 22.04 LTS) (thanks Marc!).
