# The Unicode Tools Of Rexx (TUTOR)

The TUTOR package is hosted on:

- <https://rexx.epbcn.com/TUTOR/> (daily builds and releases).
- <https://github.com/JosepMariaBlasco/TUTOR/> (releases only).

The copy at <https://rexx.epbcn.com/TUTOR/> uses
the Rexx Highlighter to display Rexx programs, while
the copy at <https://github.com/JosepMariaBlasco/TUTOR/>
uses the (limited) highlighting provided by GitHub.

---

Version 0.6a, 20250325, 20250510 refresh.

```
/******************************************************************************
 * This file is part of The Unicode Tools Of Rexx (TUTOR)                     *
 * See https://rexx.epbcn.com/TUTOR/                                          *
 *     and https://github.com/JosepMariaBlasco/TUTOR                          *
 * Copyright © 2023-2025 Josep Maria Blasco <josep.maria.blasco@epbcn.com>    *
 * License: Apache License 2.0 (https://www.apache.org/licenses/LICENSE-2.0)  *
 ******************************************************************************/
```

```
/******************************************************************************
 * => TUTOR is a prototype, not a finished product. Use at your own risk. <═  *
 *                                                                            *
 *      Interfaces and specifications are proposals to be discussed,          *
 *       and can be changed at any moment without previous notice.            *
 ******************************************************************************/
```

---

## Quick installation

Download [Tutor.zip](/TUTOR/TUTOR.zip), unzip it in some directory of your choice,
and run `setenv` to set the path
(for Linux users: use `. ./setenv.sh`, not `./setenv.sh`, or your path will not be set).

If you intend to use RXU, the Rexx Preprocessor for Unicode, you will need to
download and install the Rexx Parser
(available at <https://rexx.epbcn.com/rexx-parser/> and <https://github.com/JosepMariaBlasco/rexx-parser/>)
and also run `setenv` in the parser installation directory.

You can then navigate to the `samples` directory and try the samples by using `[rexx] rxu filename`, or experiment interactively with the `rxutry` utility.

## Documentation

* [For The Unicode Tools Of Rexx (TUTOR, this file)](.).
* [For RXU, the Rexx Preprocessor for Unicode](./rxu/)
  * [New types of strings](./string-types/)
  * [Revised built-in functions](./built-in/)
    * [Stream functions for Unicode](./stream/)
    * [The encoding/decoding model](./encodings/)
  * [New built-in functions](./new-functions/)
    * [The properties model](./properties/)
      * [The Unicode.Normalization class](./properties/normalization/).
  * [New classes](./new-classes/)
  * [New values for the OPTIONS instruction](./options/)
  * Utility packages
    * [The MultiStageTable class](./multi-stage-table/)
    * [The PersistentStringTable class](./persistent-string-table/)
* [Using TUTOR from Classic Rexx](./using-tutor-from-classic-rexx/)

## Publications

* [Unicode and Rexx. A brief introduction to TUTOR](https://www.epbcn.com/pdf/josep-maria-blasco/2025-05-04-Unicode-and-Rexx.pdf) (20250504;
  see also [as a web page](/TUTOR/doc/publications/36/2025-05-04-Unicode-and-Rexx/)). Presented to the
  [36th International Rexx Language Symposium -- Vienna, Austria and online](https://www.rexxla.org/events/schedule.rsp?year=2025).
* [The Unicode Tools of Rexx (TUTOR)](https://www.epbcn.com/pdf/josep-maria-blasco/2024-03-04-The-Unicode-Tools-Of-Rexx.pdf) (20240304).
  Presented to the
  [35th International Rexx Language Symposium -- Brisbane, Australia and online](https://www.rexxla.org/events/schedule.rsp?year=2024).

## Release notes for version 0.6a, 20250215

Version 0.6a includes some small changes to allow running RXU,
the Rexx Preprocessor for Unicode, under Jean Louis Faucher's ooRexxShell
(thanks to Jean Louis for suggesting the changes).

## Components of TUTOR which can be used independently

* [The UTF8](/TUTOR/bin/utf8.cls) routine can be used independently of TUTOR. UTF8 detects whether Unicode.cls has been loaded (by looking for the existence of a .Bytes class that subclasses .String), and returns .Bytes strings or standard ooRexx strings as appropriate.

---

## \[Cumulative change log since release 0.6a\]

+ 20250510 - Add a "publications" section to the main readme.md page.
+ 20250405 - Add references to net-oo-rexx and to ooRexxShell in the
appropriate places.

---

[Release notes for version 0.6a, 20250323](0.6a-release-notes.md)<br>
[Release notes for version 0.6, 20250215](0.6-release-notes.md)<br>
[Release notes for version 0.5, 20240307](0.5-release-notes.md)<br>
[Release notes for version 0.4a, 20231002](0.4a-release-notes.md)<br>
[Release notes for version 0.4, 20230901](0.4-release-notes.md)<br>
[Release notes for version 0.3b, 20230817](0.3b-release-notes.md)<br>
[Release notes for version 0.3, 20230811](0.3-release-notes.md)<br>
[Release notes for version 0.2, 20230726](0.2-release-notes.md)<br>
[Release notes for version 0.1d, 20230719](0.1d-release-notes.md)<br>
[Release notes for version 0.1, 20230716](0.1-release-notes.md)<br>
[A toy ooRexx implementation of the General_Category Unicode property (20230711)](pre-0.1-release-notes.md)
