/*----------------------------------------------------------------------------*/
/*                                                                            */
/* Copyright (c) 2010-2010 Rexx Language Association. All rights reserved.    */
/*                                                                            */
/* This program and the accompanying materials are made available under       */
/* the terms of the Common Public License v1.0 which accompanies this         */
/* distribution. A copy is also available at the following address:           */
/* http://www.oorexx.org/license.html                                         */
/*                                                                            */
/* Redistribution and use in source and binary forms, with or                 */
/* without modification, are permitted provided that the following            */
/* conditions are met:                                                        */
/*                                                                            */
/* Redistributions of source code must retain the above copyright             */
/* notice, this list of conditions and the following disclaimer.              */
/* Redistributions in binary form must reproduce the above copyright          */
/* notice, this list of conditions and the following disclaimer in            */
/* the documentation and/or other materials provided with the distribution.   */
/*                                                                            */
/* Neither the name of Rexx Language Association nor the names                */
/* of its contributors may be used to endorse or promote products             */
/* derived from this software without specific prior written permission.      */
/*                                                                            */
/* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS        */
/* "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT          */
/* LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS          */
/* FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT   */
/* OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,      */
/* SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED   */
/* TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,        */
/* OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY     */
/* OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING    */
/* NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS         */
/* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.               */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/**
 * Test to see if librexx.so and librexxapi.so can be dynamically loaded and
 * used.
 *
 * To compile use
 *
 *   gcc -o dlOpenTest dlOpenTest.c -ldl
 */
#include <stdlib.h>
#include <stdio.h>
#include <dlfcn.h>
#include <oorexxapi.h>

int main(int argc, char **argv) {
   void *hRexx, *hRxapi;
   char *str;
   char *rexxLibName = "librexx.so";
   char *rexxapiLibName = "librexxapi.so";
   PFNGETVERSIONINFORMATION getVer;

   hRexx = dlopen(rexxLibName, RTLD_LAZY);
   if ( !hRexx ) {
       fputs(dlerror(), stderr);
       exit(1);
   }
   printf("dlopen worked for %s, handle=%p\n", rexxLibName, hRexx);

   hRxapi = dlopen(rexxapiLibName, RTLD_LAZY);
   if ( !hRxapi ) {
       fputs (dlerror(), stderr);
       dlclose(hRexx);
       exit(1);
   }
   printf("dlopen worked for %s, handle=%p\n", rexxapiLibName, hRxapi);

   getVer = dlsym(hRexx, "RexxGetVersionInformation");
   str = dlerror();
   if ( !getVer )  {
       printf("dlsym getVer=%p error=%s\n", getVer, str);
       exit(1);
   }
   printf("dlsy worked for RexxGetVersionInformation, function pointer=%p\n", getVer);

   str = (getVer)();
   printf("\nooRexx Version Information:\n\n%s\n\n", str);

   dlclose(hRexx);
   dlclose(hRxapi);

   return 0;
}

