
   use arg testCase, arrDefaultOptions, arrTestOptions

   str_options = "::OPTIONS" arrDefaultOptions~toString('L',' ')

   thisPkg=.context~package
   initialOptions    = thisPkg~options('I')  -- returns the initial ::OPTIONS string
   definedOptions    = thisPgk~options('X')  -- returns a string of explicitly set option names
   currentOptions    = thisPkg~options       -- returns an ::OPTIONS string

      -- note: the testdata do not contain PROLOG as an option name in the test options
   option_names = "DIGITS", "FUZZ", "FORM", "NUMERIC", "ERROR", "FAILURE", "LOSTDIGITS", -
                  "NOSTRING", "NOTREADY", "NOVALUE", "PROLOG", "NOPROLOG", "TRACE"
   option_names_all = "ERROR", "FAILURE", "LOSTDIGITS", "NOSTRING", "NOTREADY", "NOVALUE"

   do xOpt over definedOptions
      initialWPos = wordPos(xOpt, initialOptions)
      testCase~assertNotEqual(initialWPos,0)       -- option name must be contained

      currWPos = wordPos(xOpt, currentOptions)
      testCase~assertNotEqual(currentWPos,0)       -- option name must be contained

      definedWPos = wordPos(xOpt, definedOptions)
      testCase~assertNotEqual(definedWPos,0)       -- option name must be contained

      testWPos = wordPos(xOpt, arrTestOptions[2])  -- defined option must be the same as test option used
      testCase~assertNotEqual(testWPos,0)

      -- twoParts? = (wordPos(xOpt, "PROLOG NOPROLOG")=0)  -- option has argument?

         -- must not be overridden with defaultOptions
      parse value arrTestOptions[1] with . optionName optionValue
      if optionName="ALL", wordpos(xopt,"ERROR FAILURE LOSTDIGITS NOSTRING NOTREADY NOVALUE")>0 then
      do
         testCase~assertEqual(word(currWPos+1, 1), optionValue)
      end
      else
      do
         if xopt="NOPROLOG" then    -- testoptions do not define "PROLOG"
         do
            testCase~assertEqual(xopt, word(currentOptions, currWpos, 1))  -- must not be overridden
         end
         else
         do
            testCase~assertEqual(word(currentOptions, currWPos, 2), word(arrTestOptions[1], 2, 2))
         end
      end

         -- must be overridden with defaultOptions
      do tmpOpt over option_names
         if tmpOpt="ALL", wordpos(xopt,"ERROR FAILURE LOSTDIGITS NOSTRING NOTREADY NOVALUE")>0 then
            iterate  -- will be checked one by one above

         if tmpOpt=xopt then iterate   -- we just handled this special case already above

         if tmpOpt="PROLOG"then
         do
            if xopt<>"NOPROLOG" then
               testCase~assertEqual(.true, wordPos(' PROLOG', currentOptions)>0, "currentOptions must have PROLOG set")
         end
         else
         do
            currValue   =word(currentOptions, currWPos, 2)
            initialValue=word(initialOptions, initialWpos, 2)
            testCase~assertEqual(currValue, optionValue, "currValue must be the same as default optionValue")
         end
      end
   end
