#!/usr/bin/env rexx
/*
   author:  rgf
   date:    2012-01-15
   purpose: list all .java-files in BSF4ooRexx' project and show ASF's BSF 2.4 as well;
            ease judging which files need a diff compare
*/


b4r_dir="F:\work\svn\bsf4oorexx\trunk\org\apache\bsf\"

asf_dir="F:\work\svn\commons-bsf-all\trunk\src\main\java\org\apache\bsf\"

b4r_files=sysFileTree(b4r_dir"*.java", "b4r.", "fls")
call bsfList b4r_dir, b4r.
asf_files=sysFileTree(asf_dir"*.java", "asf.", "fls")
call bsfList asf_dir, asf.
say
say "--- Compare: begins ---"
res=bsfCompare( b4r_dir, b4r., asf_dir, asf. )
say "--- Compare: ended ---"
say res~makeString

call makeHtml res



::routine bsfList
   use arg dir, stem.
   say "dir:" dir "# files:" stem.0
   do i=1 to stem.0
         say i"." stem.i
   end
   say "dir:" dir "# files:" stem.0
   say "---"


::routine bsfCompare
   use arg b4r_dir, b4r., asf_dir, asf.

   -- get starting pos of "org\"
   needle="bsf\"
   b4r_pos=pos(needle,b4r_dir)
   asf_pos=pos(needle,asf_dir)
say "needle=["needle"]" "b4r.999="||b4r.999 "asf.999="asf.999
say "b4r_dir="||b4r_dir
say "asf_dir="||asf_dir
say "b4r_pos="||b4r_pos "asf_pos="asf_pos

   b4r0=b4r.0
   asf0=asf.0
   max=max(b4r0,asf0)
   say "max="max "b4r0="||b4r.0 "asf0="asf0

   b4rName=getName(1,b4r0,b4r.,b4r_pos)
   -- oldB4rName=b4rName
   asfName=getName(1,asf0,asf.,asf_pos)
   -- oldAsfName=asfName
say "b4rName="||b4rName
say "asfName="||asfName
say "---"
-- pause

   res=.array~new

   b4rCur=1   -- cursors
   asfCur=1

   do while b4rCur<= b4r0 | asfCur<=asf0
-- say
      if b4rName<>.nil, asfName<>.nil then       -- both point to the same
      do
         if b4rName<asfName then
         do
-- say "b<a ..."  b4rName"<"asfName
            call show b4rCur, b4r.b4rCur, .nil , needle, res
            b4rCur+=1
            if b4rCur>b4r0 then b4rName=.nil
                           else b4rName=getName(b4rCur,b4r0,b4r.,b4r_pos)
         end
         else if b4rName=asfName then
         do
-- say "b=a ..."  b4rName"="asfName
            call show b4rCur, b4r.b4rCur, asf.asfCur, needle, res
            b4rCur+=1
            if b4rCur>b4r0 then b4rName=.nil
                           else b4rName=getName(b4rCur,b4r0,b4r.,b4r_pos)
            asfCur+=1
            if asfCur>asf0 then asfName=.nil
                           else asfName=getName(asfCur,asf0,asf.,asf_pos)
         end
         else  -- additional asf-file
         do
-- say "b>a ..." b4rName">"asfName
            call show asfCur, .nil , asf.asfCur, needle, res
            asfCur+=1
            if asfCur>asf0 then asfName=.nil
                           else asfName=getName(asfCur,asf0,asf.,asf_pos)
         end
-- say "..." "b4rName="||b4rName "asfName="asfName
      end
      else if b4rName=.nil then  -- show asf
      do
         call show b4rCur, b4r.b4rCur, .nil , needle
         b4rCur+=1
         if b4rCur>b4r0 then b4rName=.nil
                        else b4rName=getName(b4rCur,b4r0,b4r.,b4r_pos)
      end
      else -- show b4r
      do
         call show asfCur, .nil , asf.asfCur, needle
         asfCur+=1
         if asfCur>asf0 then asfName=.nil
                        else asfName=getName(asfCur,asf0,asf.,asf_pos)
      end

   end
   return res

::routine getName
  use arg i, fileNum, file., file_pos, needle="bsf\"
-- say "i="i "file.i=["file.i"]" "fileNum="fileNum "file.0="file.0 "file_pos="file_pos "["substr(file.i,file_pos)"] <<<--"
  if i>fileNum then return .nil

  parse value file.i with (needle) fn
  return fn


::routine getNameOld
  use arg i, fileNum, file., file_pos
say "i="i "file.i=["file.i"]" "fileNum="fileNum "file.0="file.0 "file_pos="file_pos "["substr(file.i,file_pos)"] <<<--"
  if i>fileNum then return .nil

--- say "     returning: ["substr(file.i,file_pos)"]"
  return substr(file.i,file_pos)


::routine show
   use arg i, b4r, asf, needle, res

-- say ">>> i="i "b4r=["fileSpec("N",b4r)"]" "asf=["fileSpec("N",asf)"]"

   preCmd ="vsdiff"
   postCmd=""

   preCmd ="diff -wu"
   postCmd="| gvim -"

   if b4r<>.nil then
      parse var b4r date1 time1 size1 attr1 path1
   else
      parse value "" with date1 time1 size1 attr1 path1

   if asf<>.nil then
      parse var asf date2 time2 size2 attr2 path2
   else
      parse value "" with date2 time2 size2 attr2 path2

   w=6
        if size1=size2 then
        do
           flag=""~right(w)    " == " ""~right(w)
           res~append(preCmd qq(path1~strip) qq(path2~strip) postCmd)
        end
   else if size1<size2 then
   do
      if size1="" then
         flag=size1~right(w) "--->" size2~right(w)
      else
      do
         flag=size1~right(w) " <A " size2~right(w)
         res~append(preCmd  qq(path1~strip) qq(path2~strip) postCmd)
      end
   end
   else
   do
      if size2="" then
         flag=size1~right(w) "<---" size2~right(w)
      else
      do
         flag=size1~right(w) " B> " size2~right(w)
         res~append(preCmd  qq(path1~strip) qq(path2~strip) postCmd)
      end
   end



        if path1="" then say flag i"." substr(path2, path2~pos(needle))
   else if path2="" then say flag i"." substr(path1, path1~pos(needle))
   else                  say flag i"." substr(path1, path1~pos(needle))


::routine qq
  use arg str, quote='"'
  return quote || str~changeStr(quote,quote||quote) || quote


::routine makeHtml
  use arg res

  fn="vsdiff.html"
  call sysFileDelete fn
  call lineout fn, "<html><title>".DateTime~new "vsdiff Commands for BSF4ooRexx-BSF and ASF-BSF</title>"
  call lineout fn, "<body><ol>"
  do i over res
     -- call lineout fn, "   <li><pre>"i"</pre>"
     call lineout fn, "   <li> "
     call lineout fn, i
     -- call lineout fn, "   <li><pre>"i"</pre>"
  end
  call lineout fn, "</ol></body>"
  call lineout fn, "</html>"
  call lineout fn

