// https://howtodoinjava.com/java/library/readingwriting-excel-files-in-java-poi-tutorial/
// WriteExcelDemo.java, rgf, 20260201

import org.apache.poi.hssf.usermodel.HSSFWorkbook;  // .xls (older)
import org.apache.poi.xssf.usermodel.XSSFWorkbook;  // .xlsx (newer)

// import org.apache.poi.xssf.streaming.SXSSFWorkbook;

import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Cell;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Map;
import java.util.TreeMap;
import java.util.Set;

public class WriteExcelDemo {
    public static void main (String args[])
    {
        //Blank workbook

        // HSSFWorkbook workbook = new HSSFWorkbook();  // for .xsl (older) format
        XSSFWorkbook workbook = new XSSFWorkbook();     // for .xslx (newer) format

        //Create a blank sheet

        Sheet sheet = workbook.createSheet("Employee Data");

        //Prepare data to be written as an Object[]

        Map<String, Object[]> data = new TreeMap<String, Object[]>();
        data.put("1", new Object[] {"ID", "NAME", "LASTNAME"});
        data.put("2", new Object[] {1, "Amit", "Shukla"});
        data.put("3", new Object[] {2, "Lokesh", "Gupta"});
        data.put("4", new Object[] {3, "John", "Adwards"});
        data.put("5", new Object[] {4, "Brian", "Schultz"});

        //Iterate over data and write to sheet

        Set<String> keyset = data.keySet();
        int rownum = 0;
        for (String key : keyset) {

          Row row = sheet.createRow(rownum++);
          Object [] objArr = data.get(key);
          int cellnum = 0;
          for (Object obj : objArr)
          {
             Cell cell = row.createCell(cellnum++);
             if(obj instanceof String)
                  cell.setCellValue((String)obj);
              else if(obj instanceof Integer)
                  cell.setCellValue((Integer)obj);
          }
        }

        //Write the workbook in file system

        try {
          // String ftype = ".xls";    // org.apache.poi.hssf.usermodel.HSSFWorkbook
          String ftype = ".xlsx";    // org.apache.poi.xssf.usermodel.XSSFWorkbook
          FileOutputStream out = new FileOutputStream(new File("howtodoinjava_demo"+ftype));
          workbook.write(out);
          out.close();
          System.out.println("howtodoinjava_demo"+ftype+" written successfully on disk.");
        }
        catch (Exception e) {
          e.printStackTrace();
        }
    }

}

