// https://howtodoinjava.com/java/library/readingwriting-excel-files-in-java-poi-tutorial/
// WriteExcelDemo.java

import org.apache.poi.hssf.usermodel.HSSFWorkbook;  // .xls (older)
import org.apache.poi.xssf.usermodel.XSSFWorkbook;  // .xlsx (newer)

// import org.apache.poi.xssf.streaming.SXSSFWorkbook;

import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import java.util.Set;

public class WriteFormulaDemo {
    public static void main (String args[])
    {
        XSSFWorkbook workbook = new XSSFWorkbook();
        Sheet sheet = workbook.createSheet("Calculate Simple Interest");

        Row header = sheet.createRow(0);
        header.createCell(0).setCellValue("Principal");
        header.createCell(1).setCellValue("RoI");
        header.createCell(2).setCellValue("T");
        header.createCell(3).setCellValue("Interest (P r t)");

        Row dataRow = sheet.createRow(1);
        dataRow.createCell(0).setCellValue(14500d);
        dataRow.createCell(1).setCellValue(9.25);
        dataRow.createCell(2).setCellValue(3d);
        dataRow.createCell(3).setCellFormula("A2*B2*C2");

        try {
          FileOutputStream out =  new FileOutputStream(new File("formulaDemo.xlsx"));
          workbook.write(out);
          out.close();
          System.out.println("Excel with formula cells written successfully");
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

}

