/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules;

import weka.classifiers.AbstractClassifier;
import weka.classifiers.Sourcable;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class ZeroR
extends AbstractClassifier
implements WeightedInstancesHandler,
Sourcable {
    static final long serialVersionUID = 48055541465867954L;
    private double m_ClassValue;
    private double[] m_Counts;
    private Attribute m_Class;

    public String globalInfo() {
        return "Class for building and using a 0-R classifier. Predicts the mean (for a numeric class) or the mode (for a nominal class).";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.STRING_ATTRIBUTES);
        result.enable(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(0);
        return result;
    }

    @Override
    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        double sumOfWeights = 0.0;
        this.m_Class = instances.classAttribute();
        this.m_ClassValue = 0.0;
        switch (instances.classAttribute().type()) {
            case 0: {
                this.m_Counts = null;
                break;
            }
            case 1: {
                this.m_Counts = new double[instances.numClasses()];
                for (int i = 0; i < this.m_Counts.length; ++i) {
                    this.m_Counts[i] = 1.0;
                }
                sumOfWeights = instances.numClasses();
            }
        }
        for (Instance instance : instances) {
            double classValue = instance.classValue();
            if (Utils.isMissingValue(classValue)) continue;
            if (instances.classAttribute().isNominal()) {
                int n = (int)classValue;
                this.m_Counts[n] = this.m_Counts[n] + instance.weight();
            } else {
                this.m_ClassValue += instance.weight() * classValue;
            }
            sumOfWeights += instance.weight();
        }
        if (instances.classAttribute().isNumeric()) {
            if (Utils.gr(sumOfWeights, 0.0)) {
                this.m_ClassValue /= sumOfWeights;
            }
        } else {
            this.m_ClassValue = Utils.maxIndex(this.m_Counts);
            Utils.normalize(this.m_Counts, sumOfWeights);
        }
    }

    @Override
    public double classifyInstance(Instance instance) {
        return this.m_ClassValue;
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        if (this.m_Counts == null) {
            double[] result = new double[]{this.m_ClassValue};
            return result;
        }
        return (double[])this.m_Counts.clone();
    }

    @Override
    public String toSource(String className) throws Exception {
        StringBuffer result = new StringBuffer();
        result.append("class " + className + " {\n");
        result.append("  public static double classify(Object[] i) {\n");
        if (this.m_Counts != null) {
            result.append("    // always predicts label '" + this.m_Class.value((int)this.m_ClassValue) + "'\n");
        }
        result.append("    return " + this.m_ClassValue + ";\n");
        result.append("  }\n");
        result.append("}\n");
        return result.toString();
    }

    public String toString() {
        if (this.m_Class == null) {
            return "ZeroR: No model built yet.";
        }
        if (this.m_Counts == null) {
            return "ZeroR predicts class value: " + this.m_ClassValue;
        }
        return "ZeroR predicts class value: " + this.m_Class.value((int)this.m_ClassValue);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision$");
    }

    public static void main(String[] argv) {
        ZeroR.runClassifier(new ZeroR(), argv);
    }
}

