/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.m5;

import java.util.ArrayList;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Evaluation;
import weka.classifiers.functions.LinearRegression;
import weka.classifiers.trees.m5.PreConstructedLinearModel;
import weka.classifiers.trees.m5.RidgeRegressionSplitInfo;
import weka.classifiers.trees.m5.Rule;
import weka.classifiers.trees.m5.SplitEvaluate;
import weka.classifiers.trees.m5.YongSplitInfo;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;

public class RuleNode
extends AbstractClassifier {
    static final long serialVersionUID = 1979807611124337144L;
    private Instances m_instances;
    private int m_classIndex;
    protected int m_numInstances;
    private int m_numAttributes;
    private boolean m_isLeaf;
    private int m_splitAtt;
    private double m_splitValue;
    private PreConstructedLinearModel m_nodeModel = null;
    public int m_numParameters;
    private double m_rootMeanSquaredError;
    protected RuleNode m_left = null;
    protected RuleNode m_right = null;
    private final RuleNode m_parent;
    private double m_splitNum = 4.0;
    private final double m_devFraction = 0.05;
    private final double m_pruningMultiplier = 2.0;
    private int m_leafModelNum;
    private final double m_globalDeviation;
    private final double m_globalAbsDeviation;
    private int[] m_indices;
    private static final double SMOOTHING_CONSTANT = 15.0;
    private int m_id;
    private boolean m_saveInstances = false;
    private boolean m_regressionTree;
    protected boolean m_useKuenzelEtAlSplitSelection = false;

    public RuleNode(double globalDev, double globalAbsDev, RuleNode parent) {
        this.m_parent = parent;
        this.m_globalDeviation = globalDev;
        this.m_globalAbsDeviation = globalAbsDev;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        this.m_rootMeanSquaredError = Double.MAX_VALUE;
        this.m_instances = data;
        this.m_classIndex = this.m_instances.classIndex();
        this.m_numInstances = this.m_instances.numInstances();
        this.m_numAttributes = this.m_instances.numAttributes();
        this.m_nodeModel = null;
        this.m_right = null;
        this.m_left = null;
        this.m_isLeaf = (double)this.m_numInstances < this.m_splitNum || Rule.stdDev(this.m_classIndex, this.m_instances) < this.m_globalDeviation * 0.05;
        this.split();
    }

    @Override
    public double classifyInstance(Instance inst) throws Exception {
        if (this.m_isLeaf) {
            if (this.m_nodeModel == null) {
                throw new Exception("Classifier has not been built correctly.");
            }
            return this.m_nodeModel.classifyInstance(inst);
        }
        if (inst.value(this.m_splitAtt) <= this.m_splitValue) {
            return this.m_left.classifyInstance(inst);
        }
        return this.m_right.classifyInstance(inst);
    }

    protected static double smoothingOriginal(double n, double pred, double supportPred) throws Exception {
        double smoothed = (n * pred + 15.0 * supportPred) / (n + 15.0);
        return smoothed;
    }

    public void split() throws Exception {
        if (!this.m_isLeaf) {
            int i;
            SplitEvaluate currentSplit;
            SplitEvaluate bestSplit;
            if (!this.getKuenzelEtAlSplitSelection()) {
                bestSplit = new YongSplitInfo(0, this.m_numInstances - 1, -1);
                currentSplit = new YongSplitInfo(0, this.m_numInstances - 1, -1);
            } else {
                bestSplit = new RidgeRegressionSplitInfo(0, this.m_numInstances - 1, -1);
                currentSplit = new RidgeRegressionSplitInfo(0, this.m_numInstances - 1, -1);
            }
            for (i = 0; i < this.m_numAttributes; ++i) {
                if (i == this.m_classIndex) continue;
                this.m_instances.sort(i);
                currentSplit.attrSplit(i, this.m_instances);
                if (!(Math.abs(currentSplit.maxImpurity() - bestSplit.maxImpurity()) > 1.0E-6) || !(currentSplit.maxImpurity() > bestSplit.maxImpurity() + 1.0E-6)) continue;
                bestSplit = currentSplit.copy();
            }
            if (bestSplit.splitAttr() < 0 || bestSplit.position() < 1 || bestSplit.position() > this.m_numInstances - 1) {
                this.m_isLeaf = true;
            } else {
                this.m_splitAtt = bestSplit.splitAttr();
                this.m_splitValue = bestSplit.splitValue();
                Instances leftSubset = new Instances(this.m_instances, this.m_numInstances);
                Instances rightSubset = new Instances(this.m_instances, this.m_numInstances);
                for (i = 0; i < this.m_numInstances; ++i) {
                    if (this.m_instances.instance(i).value(this.m_splitAtt) <= this.m_splitValue) {
                        leftSubset.add(this.m_instances.instance(i));
                        continue;
                    }
                    rightSubset.add(this.m_instances.instance(i));
                }
                leftSubset.compactify();
                rightSubset.compactify();
                this.m_left = new RuleNode(this.m_globalDeviation, this.m_globalAbsDeviation, this);
                this.m_left.setMinNumInstances(this.m_splitNum);
                this.m_left.setRegressionTree(this.m_regressionTree);
                this.m_left.setSaveInstances(this.m_saveInstances);
                this.m_left.setNumDecimalPlaces(this.getNumDecimalPlaces());
                this.m_left.setKuenzelEtAlSplitSelection(this.getKuenzelEtAlSplitSelection());
                this.m_left.buildClassifier(leftSubset);
                this.m_right = new RuleNode(this.m_globalDeviation, this.m_globalAbsDeviation, this);
                this.m_right.setMinNumInstances(this.m_splitNum);
                this.m_right.setRegressionTree(this.m_regressionTree);
                this.m_right.setSaveInstances(this.m_saveInstances);
                this.m_right.setNumDecimalPlaces(this.getNumDecimalPlaces());
                this.m_right.setKuenzelEtAlSplitSelection(this.getKuenzelEtAlSplitSelection());
                this.m_right.buildClassifier(rightSubset);
                if (!this.m_regressionTree) {
                    int j;
                    boolean[] attsBelow = this.attsTestedBelow();
                    attsBelow[this.m_classIndex] = true;
                    int count = 0;
                    for (j = 0; j < this.m_numAttributes; ++j) {
                        if (!attsBelow[j]) continue;
                        ++count;
                    }
                    int[] indices = new int[count];
                    count = 0;
                    for (j = 0; j < this.m_numAttributes; ++j) {
                        if (!attsBelow[j] || j == this.m_classIndex) continue;
                        indices[count++] = j;
                    }
                    indices[count] = this.m_classIndex;
                    this.m_indices = indices;
                } else {
                    this.m_indices = new int[1];
                    this.m_indices[0] = this.m_classIndex;
                    this.m_numParameters = 1;
                }
            }
        }
        if (this.m_isLeaf) {
            int[] indices = new int[]{this.m_classIndex};
            this.m_indices = indices;
            this.m_numParameters = 1;
        }
    }

    private void buildLinearModel(int[] indices) throws Exception {
        Instances reducedInst = new Instances(this.m_instances);
        Remove attributeFilter = new Remove();
        attributeFilter.setInvertSelection(true);
        attributeFilter.setAttributeIndicesArray(indices);
        attributeFilter.setInputFormat(reducedInst);
        reducedInst = Filter.useFilter(reducedInst, attributeFilter);
        LinearRegression temp = new LinearRegression();
        temp.setDoNotCheckCapabilities(true);
        temp.setMinimal(true);
        temp.buildClassifier(reducedInst);
        double[] lmCoeffs = temp.coefficients();
        double[] coeffs = new double[this.m_instances.numAttributes()];
        for (int i = 0; i < lmCoeffs.length - 1; ++i) {
            if (indices[i] == this.m_classIndex) continue;
            coeffs[indices[i]] = lmCoeffs[i];
        }
        this.m_nodeModel = new PreConstructedLinearModel(coeffs, lmCoeffs[lmCoeffs.length - 1]);
        this.m_nodeModel.setNumDecimalPlaces(this.getNumDecimalPlaces());
        this.m_nodeModel.buildClassifier(this.m_instances);
    }

    private boolean[] attsTestedBelow() {
        boolean[] attsBelow = new boolean[this.m_numAttributes];
        boolean[] attsBelowLeft = null;
        boolean[] attsBelowRight = null;
        if (this.m_right != null) {
            attsBelowRight = this.m_right.attsTestedBelow();
        }
        if (this.m_left != null) {
            attsBelowLeft = this.m_left.attsTestedBelow();
        }
        for (int i = 0; i < this.m_numAttributes; ++i) {
            if (attsBelowLeft != null) {
                boolean bl = attsBelow[i] = attsBelow[i] || attsBelowLeft[i];
            }
            if (attsBelowRight == null) continue;
            attsBelow[i] = attsBelow[i] || attsBelowRight[i];
        }
        if (!this.m_isLeaf) {
            attsBelow[this.m_splitAtt] = true;
        }
        return attsBelow;
    }

    public int numLeaves(int leafCounter) {
        if (!this.m_isLeaf) {
            this.m_leafModelNum = 0;
            if (this.m_left != null) {
                leafCounter = this.m_left.numLeaves(leafCounter);
            }
            if (this.m_right != null) {
                leafCounter = this.m_right.numLeaves(leafCounter);
            }
        } else {
            this.m_leafModelNum = ++leafCounter;
        }
        return leafCounter;
    }

    public String toString() {
        return this.printNodeLinearModel();
    }

    public String printNodeLinearModel() {
        return this.m_nodeModel.toString();
    }

    public String printLeafModels() {
        StringBuffer text = new StringBuffer();
        if (this.m_isLeaf) {
            text.append("\nLM num: " + this.m_leafModelNum);
            text.append(this.m_nodeModel.toString());
            text.append("\n");
        } else {
            text.append(this.m_left.printLeafModels());
            text.append(this.m_right.printLeafModels());
        }
        return text.toString();
    }

    public String nodeToString() {
        StringBuffer text = new StringBuffer();
        System.out.println("In to string");
        text.append("Node:\n\tnum inst: " + this.m_numInstances);
        if (this.m_isLeaf) {
            text.append("\n\tleaf");
        } else {
            text.append("\tnode");
        }
        text.append("\n\tSplit att: " + this.m_instances.attribute(this.m_splitAtt).name());
        text.append("\n\tSplit val: " + Utils.doubleToString(this.m_splitValue, 1, this.getNumDecimalPlaces() - 1));
        text.append("\n\tLM num: " + this.m_leafModelNum);
        text.append("\n\tLinear model\n" + this.m_nodeModel.toString());
        text.append("\n\n");
        if (this.m_left != null) {
            text.append(this.m_left.nodeToString());
        }
        if (this.m_right != null) {
            text.append(this.m_right.nodeToString());
        }
        return text.toString();
    }

    public String treeToString(int level) {
        StringBuffer text = new StringBuffer();
        if (!this.m_isLeaf) {
            int i;
            text.append("\n");
            for (i = 1; i <= level; ++i) {
                text.append("|   ");
            }
            if (this.m_instances.attribute(this.m_splitAtt).name().charAt(0) != '[') {
                text.append(this.m_instances.attribute(this.m_splitAtt).name() + " <= " + Utils.doubleToString(this.m_splitValue, 1, this.getNumDecimalPlaces() - 1) + " : ");
            } else {
                text.append(this.m_instances.attribute(this.m_splitAtt).name() + " false : ");
            }
            if (this.m_left != null) {
                text.append(this.m_left.treeToString(level + 1));
            } else {
                text.append("NULL\n");
            }
            for (i = 1; i <= level; ++i) {
                text.append("|   ");
            }
            if (this.m_instances.attribute(this.m_splitAtt).name().charAt(0) != '[') {
                text.append(this.m_instances.attribute(this.m_splitAtt).name() + " >  " + Utils.doubleToString(this.m_splitValue, 1, this.getNumDecimalPlaces() - 1) + " : ");
            } else {
                text.append(this.m_instances.attribute(this.m_splitAtt).name() + " true : ");
            }
            if (this.m_right != null) {
                text.append(this.m_right.treeToString(level + 1));
            } else {
                text.append("NULL\n");
            }
        } else {
            text.append("LM" + this.m_leafModelNum);
            if (this.m_globalDeviation > 0.0) {
                text.append(" (" + this.m_numInstances + "/" + Utils.doubleToString(100.0 * this.m_rootMeanSquaredError / this.m_globalDeviation, 1, this.getNumDecimalPlaces() - 1) + "%)\n");
            } else {
                text.append(" (" + this.m_numInstances + ")\n");
            }
        }
        return text.toString();
    }

    public void installLinearModels() throws Exception {
        if (this.m_isLeaf) {
            this.buildLinearModel(this.m_indices);
        } else {
            if (this.m_left != null) {
                this.m_left.installLinearModels();
            }
            if (this.m_right != null) {
                this.m_right.installLinearModels();
            }
            this.buildLinearModel(this.m_indices);
        }
        Evaluation nodeModelEval = new Evaluation(this.m_instances);
        nodeModelEval.evaluateModel(this.m_nodeModel, this.m_instances, new Object[0]);
        this.m_rootMeanSquaredError = nodeModelEval.rootMeanSquaredError();
        if (!this.m_saveInstances) {
            this.m_instances = new Instances(this.m_instances, 0);
        }
    }

    public void installSmoothedModels() throws Exception {
        if (this.m_isLeaf) {
            double[] coefficients = new double[this.m_numAttributes];
            double[] coeffsUsedByLinearModel = this.m_nodeModel.coefficients();
            RuleNode current = this;
            for (int i = 0; i < coeffsUsedByLinearModel.length; ++i) {
                if (i == this.m_classIndex) continue;
                coefficients[i] = coeffsUsedByLinearModel[i];
            }
            double intercept = this.m_nodeModel.intercept();
            do {
                int i;
                if (current.m_parent == null) continue;
                double n = current.m_numInstances;
                for (i = 0; i < coefficients.length; ++i) {
                    coefficients[i] = coefficients[i] * n / (n + 15.0);
                }
                intercept = intercept * n / (n + 15.0);
                coeffsUsedByLinearModel = current.m_parent.getModel().coefficients();
                for (i = 0; i < coeffsUsedByLinearModel.length; ++i) {
                    if (i == this.m_classIndex) continue;
                    int n2 = i;
                    coefficients[n2] = coefficients[n2] + 15.0 * coeffsUsedByLinearModel[i] / (n + 15.0);
                }
                intercept += 15.0 * current.m_parent.getModel().intercept() / (n + 15.0);
                current = current.m_parent;
            } while (current.m_parent != null);
            this.m_nodeModel = new PreConstructedLinearModel(coefficients, intercept);
            this.m_nodeModel.setNumDecimalPlaces(this.getNumDecimalPlaces());
            this.m_nodeModel.buildClassifier(this.m_instances);
        }
        if (this.m_left != null) {
            this.m_left.installSmoothedModels();
        }
        if (this.m_right != null) {
            this.m_right.installSmoothedModels();
        }
    }

    public void prune() throws Exception {
        Evaluation nodeModelEval = null;
        if (this.m_isLeaf) {
            this.buildLinearModel(this.m_indices);
            nodeModelEval = new Evaluation(this.m_instances);
            nodeModelEval.evaluateModel(this.m_nodeModel, this.m_instances, new Object[0]);
            this.m_rootMeanSquaredError = nodeModelEval.rootMeanSquaredError();
        } else {
            double adjustedErrorNode;
            if (this.m_left != null) {
                this.m_left.prune();
            }
            if (this.m_right != null) {
                this.m_right.prune();
            }
            this.buildLinearModel(this.m_indices);
            nodeModelEval = new Evaluation(this.m_instances);
            nodeModelEval.evaluateModel(this.m_nodeModel, this.m_instances, new Object[0]);
            double rmsModel = nodeModelEval.rootMeanSquaredError();
            double adjustedErrorModel = rmsModel * this.pruningFactor(this.m_numInstances, this.m_nodeModel.numParameters() + 1);
            Evaluation nodeEval = new Evaluation(this.m_instances);
            int l_params = 0;
            int r_params = 0;
            nodeEval.evaluateModel(this, this.m_instances, new Object[0]);
            double rmsSubTree = nodeEval.rootMeanSquaredError();
            if (this.m_left != null) {
                l_params = this.m_left.numParameters();
            }
            if (this.m_right != null) {
                r_params = this.m_right.numParameters();
            }
            if (adjustedErrorModel <= (adjustedErrorNode = rmsSubTree * this.pruningFactor(this.m_numInstances, l_params + r_params + 1)) || adjustedErrorModel < this.m_globalDeviation * 1.0E-5) {
                this.m_isLeaf = true;
                this.m_right = null;
                this.m_left = null;
                this.m_numParameters = this.m_nodeModel.numParameters() + 1;
                this.m_rootMeanSquaredError = rmsModel;
            } else {
                this.m_numParameters = l_params + r_params + 1;
                this.m_rootMeanSquaredError = rmsSubTree;
            }
        }
        if (!this.m_saveInstances) {
            this.m_instances = new Instances(this.m_instances, 0);
        }
    }

    private double pruningFactor(int num_instances, int num_params) {
        if (num_instances <= num_params) {
            return 10.0;
        }
        return ((double)num_instances + 2.0 * (double)num_params) / (double)(num_instances - num_params);
    }

    public void findBestLeaf(double[] maxCoverage, RuleNode[] bestLeaf) {
        if (!this.m_isLeaf) {
            if (this.m_left != null) {
                this.m_left.findBestLeaf(maxCoverage, bestLeaf);
            }
            if (this.m_right != null) {
                this.m_right.findBestLeaf(maxCoverage, bestLeaf);
            }
        } else if ((double)this.m_numInstances > maxCoverage[0]) {
            maxCoverage[0] = this.m_numInstances;
            bestLeaf[0] = this;
        }
    }

    public void returnLeaves(ArrayList<RuleNode>[] v) {
        if (this.m_isLeaf) {
            v[0].add(this);
        } else {
            if (this.m_left != null) {
                this.m_left.returnLeaves(v);
            }
            if (this.m_right != null) {
                this.m_right.returnLeaves(v);
            }
        }
    }

    public RuleNode parentNode() {
        return this.m_parent;
    }

    public RuleNode leftNode() {
        return this.m_left;
    }

    public RuleNode rightNode() {
        return this.m_right;
    }

    public int splitAtt() {
        return this.m_splitAtt;
    }

    public double splitVal() {
        return this.m_splitValue;
    }

    public int numberOfLinearModels() {
        if (this.m_isLeaf) {
            return 1;
        }
        return this.m_left.numberOfLinearModels() + this.m_right.numberOfLinearModels();
    }

    public boolean isLeaf() {
        return this.m_isLeaf;
    }

    protected double rootMeanSquaredError() {
        return this.m_rootMeanSquaredError;
    }

    public PreConstructedLinearModel getModel() {
        return this.m_nodeModel;
    }

    public int getNumInstances() {
        return this.m_numInstances;
    }

    private int numParameters() {
        return this.m_numParameters;
    }

    public boolean getRegressionTree() {
        return this.m_regressionTree;
    }

    public void setKuenzelEtAlSplitSelection(boolean unpruned) {
        this.m_useKuenzelEtAlSplitSelection = unpruned;
    }

    public boolean getKuenzelEtAlSplitSelection() {
        return this.m_useKuenzelEtAlSplitSelection;
    }

    public void setMinNumInstances(double minNum) {
        this.m_splitNum = minNum;
    }

    public double getMinNumInstances() {
        return this.m_splitNum;
    }

    public void setRegressionTree(boolean newregressionTree) {
        this.m_regressionTree = newregressionTree;
    }

    public void printAllModels() {
        if (this.m_isLeaf) {
            System.out.println(this.m_nodeModel.toString());
        } else {
            System.out.println(this.m_nodeModel.toString());
            this.m_left.printAllModels();
            this.m_right.printAllModels();
        }
    }

    protected int assignIDs(int lastID) {
        int currLastID;
        this.m_id = currLastID = lastID + 1;
        if (this.m_left != null) {
            currLastID = this.m_left.assignIDs(currLastID);
        }
        if (this.m_right != null) {
            currLastID = this.m_right.assignIDs(currLastID);
        }
        return currLastID;
    }

    public void graph(StringBuffer text) {
        this.assignIDs(-1);
        this.graphTree(text);
    }

    protected void graphTree(StringBuffer text) {
        text.append("N" + this.m_id + (this.m_isLeaf ? " [label=\"LM " + this.m_leafModelNum : " [label=\"" + Utils.backQuoteChars(this.m_instances.attribute(this.m_splitAtt).name())) + (this.m_isLeaf ? " (" + (this.m_globalDeviation > 0.0 ? this.m_numInstances + "/" + Utils.doubleToString(100.0 * this.m_rootMeanSquaredError / this.m_globalDeviation, 1, this.getNumDecimalPlaces() - 1) + "%)" : this.m_numInstances + ")") + "\" shape=box style=filled " : "\"") + (this.m_saveInstances ? "data=\n" + this.m_instances + "\n,\n" : "") + "]\n");
        if (this.m_left != null) {
            text.append("N" + this.m_id + "->N" + this.m_left.m_id + " [label=\"<=" + Utils.doubleToString(this.m_splitValue, 1, this.getNumDecimalPlaces() - 1) + "\"]\n");
            this.m_left.graphTree(text);
        }
        if (this.m_right != null) {
            text.append("N" + this.m_id + "->N" + this.m_right.m_id + " [label=\">" + Utils.doubleToString(this.m_splitValue, 1, this.getNumDecimalPlaces() - 1) + "\"]\n");
            this.m_right.graphTree(text);
        }
    }

    protected void setSaveInstances(boolean save) {
        this.m_saveInstances = save;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision$");
    }
}

