/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.AbstractInstance;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.BatchConverter;
import weka.core.converters.FileSourcedConverter;
import weka.core.converters.IncrementalConverter;

public class CSVSaver
extends AbstractFileSaver
implements BatchConverter,
IncrementalConverter,
FileSourcedConverter {
    static final long serialVersionUID = 476636654410701807L;
    protected String m_FieldSeparator = ",";
    protected String m_MissingValue = "?";
    protected int m_MaxDecimalPlaces = AbstractInstance.s_numericAfterDecimalPoint;
    protected boolean m_noHeaderRow = false;

    public CSVSaver() {
        this.resetOptions();
    }

    public String globalInfo() {
        return "Writes to a destination that is in CSV (comma-separated values) format. The column separator can be chosen (default is ',') as well as the value representing missing values (default is '?').";
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tThe field separator to be used.\n\t'\\t' can be used as well.\n\t(default: ',')", "F", 1, "-F <separator>"));
        result.addElement(new Option("\tThe string representing a missing value.\n\t(default: ?)", "M", 1, "-M <str>"));
        result.addElement(new Option("\tDon't write a header row.", "N", 0, "-N"));
        result.addElement(new Option("\tThe maximum number of digits to print after the decimal\n\tplace for numeric values (default: 6)", "decimal", 1, "-decimal <num>"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('F', options);
        if (tmpStr.length() != 0) {
            this.setFieldSeparator(tmpStr);
        } else {
            this.setFieldSeparator(",");
        }
        tmpStr = Utils.getOption('M', options);
        if (tmpStr.length() != 0) {
            this.setMissingValue(tmpStr);
        } else {
            this.setMissingValue("?");
        }
        this.setNoHeaderRow(Utils.getFlag('N', options));
        tmpStr = Utils.getOption("decimal", options);
        if (tmpStr.length() > 0) {
            this.setMaxDecimalPlaces(Integer.parseInt(tmpStr));
        }
        super.setOptions(options);
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-F");
        result.add(this.getFieldSeparator());
        result.add("-M");
        result.add(this.getMissingValue());
        if (this.getNoHeaderRow()) {
            result.add("-N");
        }
        result.add("-decimal");
        result.add("" + this.getMaxDecimalPlaces());
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    public String noHeaderRowTipText() {
        return "If true then the header row is not written";
    }

    public void setNoHeaderRow(boolean b) {
        this.m_noHeaderRow = b;
    }

    public boolean getNoHeaderRow() {
        return this.m_noHeaderRow;
    }

    public void setMaxDecimalPlaces(int maxDecimal) {
        this.m_MaxDecimalPlaces = maxDecimal;
    }

    public int getMaxDecimalPlaces() {
        return this.m_MaxDecimalPlaces;
    }

    public String maxDecimalPlacesTipText() {
        return "The maximum number of digits to print after the decimal point for numeric values";
    }

    public void setFieldSeparator(String value) {
        this.m_FieldSeparator = Utils.unbackQuoteChars(value);
    }

    public String getFieldSeparator() {
        return Utils.backQuoteChars(this.m_FieldSeparator);
    }

    public String fieldSeparatorTipText() {
        return "The character to use as separator for the columns/fields (use '\\t' for TAB).";
    }

    public void setMissingValue(String value) {
        this.m_MissingValue = value;
    }

    public String getMissingValue() {
        return this.m_MissingValue;
    }

    public String missingValueTipText() {
        return "The placeholder for missing values, default is '?'.";
    }

    @Override
    public String getFileDescription() {
        return "CSV file: comma separated files";
    }

    @Override
    public void resetOptions() {
        super.resetOptions();
        this.setFileExtension(".csv");
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.STRING_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.STRING_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public void writeIncremental(Instance inst) throws IOException {
        int writeMode = this.getWriteMode();
        Instances structure = this.getInstances();
        PrintWriter outW = null;
        if (this.getRetrieval() == 1 || this.getRetrieval() == 0) {
            throw new IOException("Batch and incremental saving cannot be mixed.");
        }
        if (this.getWriter() != null) {
            outW = new PrintWriter(this.getWriter());
        }
        if (writeMode == 1) {
            if (structure == null) {
                this.setWriteMode(2);
                if (inst != null) {
                    System.err.println("Structure(Header Information) has to be set in advance");
                }
            } else {
                this.setWriteMode(3);
            }
            writeMode = this.getWriteMode();
        }
        if (writeMode == 2) {
            if (outW != null) {
                outW.close();
            }
            this.cancel();
        }
        if (writeMode == 3) {
            this.setWriteMode(0);
            if (!this.getNoHeaderRow()) {
                if (this.retrieveFile() == null && outW == null) {
                    for (int i = 0; i < structure.numAttributes(); ++i) {
                        System.out.print(structure.attribute(i).name());
                        if (i < structure.numAttributes() - 1) {
                            System.out.print(this.m_FieldSeparator);
                            continue;
                        }
                        System.out.println();
                    }
                } else {
                    for (int i = 0; i < structure.numAttributes(); ++i) {
                        outW.print(structure.attribute(i).name());
                        if (i < structure.numAttributes() - 1) {
                            outW.print(this.m_FieldSeparator);
                            continue;
                        }
                        outW.println();
                    }
                    outW.flush();
                }
            }
            writeMode = this.getWriteMode();
        }
        if (writeMode == 0) {
            if (structure == null) {
                throw new IOException("No instances information available.");
            }
            if (inst != null) {
                if (this.retrieveFile() == null && outW == null) {
                    System.out.println(inst);
                } else {
                    outW.println(this.instanceToString(inst));
                    ++this.m_incrementalCounter;
                    if (this.m_incrementalCounter > 100) {
                        this.m_incrementalCounter = 0;
                        outW.flush();
                    }
                }
            } else {
                if (outW != null) {
                    outW.flush();
                    outW.close();
                }
                this.m_incrementalCounter = 0;
                this.resetStructure();
                outW = null;
                this.resetWriter();
            }
        }
    }

    @Override
    public void writeBatch() throws IOException {
        int i;
        if (this.getInstances() == null) {
            throw new IOException("No instances to save");
        }
        if (this.getRetrieval() == 2) {
            throw new IOException("Batch and incremental saving cannot be mixed.");
        }
        this.setRetrieval(1);
        this.setWriteMode(0);
        if (this.retrieveFile() == null && this.getWriter() == null) {
            int i2;
            if (!this.getNoHeaderRow()) {
                for (i2 = 0; i2 < this.getInstances().numAttributes(); ++i2) {
                    System.out.print(this.getInstances().attribute(i2).name());
                    if (i2 < this.getInstances().numAttributes() - 1) {
                        System.out.print(this.m_FieldSeparator);
                        continue;
                    }
                    System.out.println();
                }
            }
            for (i2 = 0; i2 < this.getInstances().numInstances(); ++i2) {
                System.out.println(this.instanceToString(this.getInstances().instance(i2)));
            }
            this.setWriteMode(1);
            return;
        }
        PrintWriter outW = new PrintWriter(this.getWriter());
        if (!this.getNoHeaderRow()) {
            for (i = 0; i < this.getInstances().numAttributes(); ++i) {
                outW.print(Utils.quote(this.getInstances().attribute(i).name()));
                if (i < this.getInstances().numAttributes() - 1) {
                    outW.print(this.m_FieldSeparator);
                    continue;
                }
                outW.println();
            }
        }
        for (i = 0; i < this.getInstances().numInstances(); ++i) {
            outW.println(this.instanceToString(this.getInstances().instance(i)));
        }
        outW.flush();
        outW.close();
        this.setWriteMode(1);
        outW = null;
        this.resetWriter();
        this.setWriteMode(2);
    }

    protected String instanceToString(Instance inst) {
        Instance outInst;
        StringBuffer result = new StringBuffer();
        if (inst instanceof SparseInstance) {
            outInst = new DenseInstance(inst.weight(), inst.toDoubleArray());
            outInst.setDataset(inst.dataset());
        } else {
            outInst = inst;
        }
        for (int i = 0; i < outInst.numAttributes(); ++i) {
            if (i > 0) {
                result.append(this.m_FieldSeparator);
            }
            String field = outInst.isMissing(i) ? this.m_MissingValue : outInst.toString(i, this.m_MaxDecimalPlaces);
            if (this.m_FieldSeparator.length() == 1 && field.indexOf(this.m_FieldSeparator) > -1 && !field.startsWith("'") && !field.endsWith("'")) {
                field = "'" + field + "'";
            }
            result.append(field);
        }
        return result.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision$");
    }

    public static void main(String[] args) {
        CSVSaver.runFileSaver(new CSVSaver(), args);
    }
}

