/*
 * Decompiled with CFR 0.152.
 */
package weka.core.xml;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class PropertyHandler
implements RevisionHandler {
    protected Hashtable<Object, HashSet<String>> m_Ignored = new Hashtable();
    protected Hashtable<Object, HashSet<String>> m_Allowed = new Hashtable();

    public Enumeration<Object> ignored() {
        return this.m_Ignored.keys();
    }

    public void addIgnored(String displayName) {
        HashSet<String> list = new HashSet<String>();
        list.add(displayName);
        this.m_Ignored.put(displayName, list);
    }

    public void addIgnored(Class<?> c, String displayName) {
        HashSet<Object> list;
        if (this.m_Ignored.containsKey(c)) {
            list = this.m_Ignored.get(c);
        } else {
            list = new HashSet();
            this.m_Ignored.put(c, list);
        }
        list.add(displayName);
    }

    public boolean removeIgnored(String displayName) {
        return this.m_Ignored.remove(displayName) != null;
    }

    public boolean removeIgnored(Class<?> c, String displayName) {
        HashSet<Object> list = this.m_Ignored.containsKey(c) ? this.m_Ignored.get(c) : new HashSet();
        return list.remove(displayName);
    }

    public boolean isIgnored(String displayName) {
        return this.m_Ignored.containsKey(displayName);
    }

    public boolean isIgnored(Class<?> c, String displayName) {
        HashSet<Object> list = this.m_Ignored.containsKey(c) ? this.m_Ignored.get(c) : new HashSet();
        return list.contains(displayName);
    }

    public boolean isIgnored(Object o, String displayName) {
        boolean result = false;
        Enumeration<Object> enm = this.ignored();
        while (enm.hasMoreElements()) {
            Class c;
            Object element = enm.nextElement();
            if (!(element instanceof Class) || !(c = (Class)element).isInstance(o)) continue;
            HashSet<String> list = this.m_Ignored.get(c);
            result = list.contains(displayName);
            break;
        }
        return result;
    }

    public Enumeration<Object> allowed() {
        return this.m_Allowed.keys();
    }

    public void addAllowed(Class<?> c, String displayName) {
        HashSet<String> list = this.m_Allowed.get(c);
        if (list == null) {
            list = new HashSet();
            this.m_Allowed.put(c, list);
        }
        list.add(displayName);
    }

    public boolean removeAllowed(Class<?> c, String displayName) {
        boolean result = false;
        HashSet<String> list = this.m_Allowed.get(c);
        if (list != null) {
            result = list.remove(displayName);
        }
        return result;
    }

    public boolean isAllowed(Class<?> c, String displayName) {
        boolean result = true;
        HashSet<String> list = this.m_Allowed.get(c);
        if (list != null) {
            result = list.contains(displayName);
        }
        return result;
    }

    public boolean isAllowed(Object o, String displayName) {
        boolean result = true;
        Enumeration<Object> enm = this.allowed();
        while (enm.hasMoreElements()) {
            Class c = (Class)enm.nextElement();
            if (!c.isInstance(o)) continue;
            HashSet<String> list = this.m_Allowed.get(c);
            result = list.contains(displayName);
            break;
        }
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision$");
    }
}

