/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.core.WeightedAttributesHandler;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;

public class NonSparseToSparse
extends Filter
implements UnsupervisedFilter,
StreamableFilter,
OptionHandler,
WeightedAttributesHandler,
WeightedInstancesHandler {
    static final long serialVersionUID = 4694489111366063852L;
    protected boolean m_encodeMissingAsZero = false;

    public String globalInfo() {
        return "An instance filter that converts all incoming instances into sparse format.";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.add(new Option("\tTreat missing values as zero.", "M", 0, "-M"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.m_encodeMissingAsZero = Utils.getFlag('M', options);
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        if (this.m_encodeMissingAsZero) {
            result.add("-M");
        }
        return result.toArray(new String[result.size()]);
    }

    public void setTreatMissingValuesAsZero(boolean m) {
        this.m_encodeMissingAsZero = m;
    }

    public boolean getTreatMissingValuesAsZero() {
        return this.m_encodeMissingAsZero;
    }

    public String treatMissingValuesAsZeroTipText() {
        return "Treat missing values in the same way as zeros.";
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        Instances instNew = instanceInfo;
        this.setOutputFormat(instNew);
        return true;
    }

    @Override
    public boolean input(Instance instance) {
        SparseInstance newInstance = null;
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.m_encodeMissingAsZero) {
            Instance tempInst = (Instance)instance.copy();
            tempInst.setDataset(this.getInputFormat());
            for (int i = 0; i < tempInst.numAttributes(); ++i) {
                if (!tempInst.isMissing(i)) continue;
                tempInst.setValue(i, 0.0);
            }
            instance = tempInst;
        }
        newInstance = new SparseInstance(instance);
        newInstance.setDataset(instance.dataset());
        this.push(newInstance, false);
        return true;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision$");
    }

    public static void main(String[] argv) {
        NonSparseToSparse.runFilter(new NonSparseToSparse(), argv);
    }
}

