/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WeightedAttributesHandler;
import weka.filters.Filter;
import weka.filters.UnsupervisedFilter;

public class RemovePercentage
extends Filter
implements UnsupervisedFilter,
OptionHandler,
WeightedAttributesHandler {
    static final long serialVersionUID = 2150341191158533133L;
    private double m_Percentage = 50.0;
    private boolean m_Inverse = false;

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(2);
        newVector.addElement(new Option("\tSpecifies percentage of instances to select. (default 50)\n", "P", 1, "-P <percentage>"));
        newVector.addElement(new Option("\tSpecifies if inverse of selection is to be output.\n", "V", 0, "-V"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String percent = Utils.getOption('P', options);
        if (percent.length() != 0) {
            this.setPercentage(Double.parseDouble(percent));
        } else {
            this.setPercentage(50.0);
        }
        this.setInvertSelection(Utils.getFlag('V', options));
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        options.add("-P");
        options.add("" + this.getPercentage());
        if (this.getInvertSelection()) {
            options.add("-V");
        }
        return options.toArray(new String[0]);
    }

    public String globalInfo() {
        return "A filter that removes a given percentage of a dataset.";
    }

    public String percentageTipText() {
        return "The percentage of the data to select.";
    }

    public double getPercentage() {
        return this.m_Percentage;
    }

    public void setPercentage(double percent) {
        if (percent < 0.0 || percent > 100.0) {
            throw new IllegalArgumentException("Percentage must be between 0 and 100.");
        }
        this.m_Percentage = percent;
    }

    public String invertSelectionTipText() {
        return "Whether to invert the selection.";
    }

    public boolean getInvertSelection() {
        return this.m_Inverse;
    }

    public void setInvertSelection(boolean inverse) {
        this.m_Inverse = inverse;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        this.setOutputFormat(instanceInfo);
        return true;
    }

    @Override
    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.isFirstBatchDone()) {
            this.push(instance);
            return true;
        }
        this.bufferInput(instance);
        return false;
    }

    @Override
    public boolean batchFinished() {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        Instances toFilter = this.getInputFormat();
        int cutOff = (int)Math.round((double)toFilter.numInstances() * this.m_Percentage / 100.0);
        if (this.m_Inverse) {
            for (int i = 0; i < cutOff; ++i) {
                this.push(toFilter.instance(i), false);
            }
        } else {
            for (int i = cutOff; i < toFilter.numInstances(); ++i) {
                this.push(toFilter.instance(i), false);
            }
        }
        this.flushInput();
        this.m_NewBatch = true;
        this.m_FirstBatchDone = true;
        return this.numPendingOutput() != 0;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision$");
    }

    public static void main(String[] argv) {
        RemovePercentage.runFilter(new RemovePercentage(), argv);
    }
}

