import weka.classifiers.Evaluation;
import weka.classifiers.trees.J48;
import weka.core.Instances;
import weka.core.WekaPackageManager;
import weka.core.converters.ConverterUtils.DataSource;
import java.util.Random;


public class decision_tree {
    public static void main(String args[]) throws Exception {

        WekaPackageManager wk = new WekaPackageManager();   //create Package Manager instance
        wk.loadPackages(false);   //load the packages (false = output should not be the loading progress)

        //Import Data set
        DataSource src = new DataSource("./weather.nominal.arff");   //create DataSource pointing to data set
        Instances weather = src.getDataSet();   //load data set into instances

        //Split Data set into training/test data set
        int seed = 0;      //set seed for randomization

        double trainPercentage = 60.0;   //set percentage size of training data

        weather.randomize(new Random(seed));   //randomize data with seed

        int trainSize = (int) Math.round(weather.numInstances() * trainPercentage / 100.0);   //calculate training data size
        int testSize = weather.numInstances() - trainSize;   //calculate testing data size

        Instances trainData = new Instances(weather, 0, trainSize);   //create training data
        Instances testData = new Instances(weather, trainSize, testSize);   //create testing data

        //System.out.println(trainData);   //print out training data
        //System.out.println(testData);   //print out testing data

        //Compute Decision Tree
        J48 dt = new J48();   //create decision tree instance
        trainData.setClassIndex(testData.numAttributes()-1);    //set the dependant variable of the training data (in this case the last column)
        dt.buildClassifier(trainData);   //build the model
        System.out.println(dt);   //print out the result

        //Evaluate Model
        Evaluation eval = new Evaluation(trainData);   //create evaluation instance
        testData.setClassIndex(testData.numAttributes()-1);   //set the dependant variable of the testing data (in this case the last column)
        eval.evaluateModel(dt, testData);   //evaluate the model
        System.out.println(eval.toMatrixString());   //print out the confusion matrix
    }
}
