import weka.core.Instances;
import weka.core.converters.ConverterUtils.DataSource;
import weka.core.WekaPackageManager;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.PrincipalComponents;


public class principal_components_analysis {
    public static void main(String args[]) throws Exception {

        WekaPackageManager wk = new WekaPackageManager();   //create Package Manager instance
        wk.loadPackages(false);   //load the packages (false = output should not be the loading progress)

        //Import data set
        DataSource src = new DataSource("./house_prices.csv");   //create DataSource pointing to data set
        Instances housing = src.getDataSet();   //load data set into instances

        //Compute Principal Components Analysis
        PrincipalComponents pca = new PrincipalComponents();   //create principal components analysis instance

        pca.setInputFormat(housing);   //set input for Filter (data set)
        Instances transformedData = Filter.useFilter(housing, pca);   //use the filter
        System.out.println(transformedData);   //print out new data set
    }
}