/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.evaluation;

import java.util.ArrayList;
import weka.classifiers.CostMatrix;
import weka.classifiers.evaluation.NominalPrediction;
import weka.classifiers.evaluation.Prediction;
import weka.classifiers.evaluation.TwoClassStats;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.matrix.Matrix;

public class ConfusionMatrix
extends Matrix {
    private static final long serialVersionUID = -181789981401504090L;
    protected String[] m_ClassNames;

    public ConfusionMatrix(String[] classNames) {
        super(classNames.length, classNames.length);
        this.m_ClassNames = (String[])classNames.clone();
    }

    public ConfusionMatrix makeWeighted(CostMatrix costs) throws Exception {
        if (costs.size() != this.size()) {
            throw new Exception("Cost and confusion matrices must be the same size");
        }
        ConfusionMatrix weighted = new ConfusionMatrix(this.m_ClassNames);
        for (int row = 0; row < this.size(); ++row) {
            for (int col = 0; col < this.size(); ++col) {
                weighted.set(row, col, this.get(row, col) * costs.getElement(row, col));
            }
        }
        return weighted;
    }

    @Override
    public Object clone() {
        ConfusionMatrix m = (ConfusionMatrix)super.clone();
        m.m_ClassNames = (String[])this.m_ClassNames.clone();
        return m;
    }

    public int size() {
        return this.m_ClassNames.length;
    }

    public String className(int index) {
        return this.m_ClassNames[index];
    }

    public void addPrediction(NominalPrediction pred) throws Exception {
        if (pred.predicted() == NominalPrediction.MISSING_VALUE) {
            throw new Exception("No predicted value given.");
        }
        if (pred.actual() == NominalPrediction.MISSING_VALUE) {
            throw new Exception("No actual value given.");
        }
        this.set((int)pred.actual(), (int)pred.predicted(), this.get((int)pred.actual(), (int)pred.predicted()) + pred.weight());
    }

    public void addPredictions(ArrayList<Prediction> predictions) throws Exception {
        for (int i = 0; i < predictions.size(); ++i) {
            this.addPrediction((NominalPrediction)predictions.get(i));
        }
    }

    public TwoClassStats getTwoClassStats(int classIndex) {
        double fp = 0.0;
        double tp = 0.0;
        double fn = 0.0;
        double tn = 0.0;
        for (int row = 0; row < this.size(); ++row) {
            for (int col = 0; col < this.size(); ++col) {
                if (row == classIndex) {
                    if (col == classIndex) {
                        tp += this.get(row, col);
                        continue;
                    }
                    fn += this.get(row, col);
                    continue;
                }
                if (col == classIndex) {
                    fp += this.get(row, col);
                    continue;
                }
                tn += this.get(row, col);
            }
        }
        return new TwoClassStats(tp, fp, tn, fn);
    }

    public double correct() {
        double correct = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            correct += this.get(i, i);
        }
        return correct;
    }

    public double incorrect() {
        double incorrect = 0.0;
        for (int row = 0; row < this.size(); ++row) {
            for (int col = 0; col < this.size(); ++col) {
                if (row == col) continue;
                incorrect += this.get(row, col);
            }
        }
        return incorrect;
    }

    public double total() {
        double total = 0.0;
        for (int row = 0; row < this.size(); ++row) {
            for (int col = 0; col < this.size(); ++col) {
                total += this.get(row, col);
            }
        }
        return total;
    }

    public double errorRate() {
        return this.incorrect() / this.total();
    }

    @Override
    public String toString() {
        return this.toString("=== Confusion Matrix ===\n");
    }

    public String toString(String title) {
        int j;
        int i;
        StringBuffer text = new StringBuffer();
        char[] IDChars = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        boolean fractional = false;
        double maxval = 0.0;
        for (i = 0; i < this.size(); ++i) {
            for (j = 0; j < this.size(); ++j) {
                double current = this.get(i, j);
                if (current < 0.0) {
                    current *= -10.0;
                }
                if (current > maxval) {
                    maxval = current;
                }
                double fract = current - Math.rint(current);
                if (fractional || !(Math.log(fract) / Math.log(10.0) >= -2.0)) continue;
                fractional = true;
            }
        }
        int IDWidth = 1 + Math.max((int)(Math.log(maxval) / Math.log(10.0) + (double)(fractional ? 3 : 0)), (int)(Math.log(this.size()) / Math.log(IDChars.length)));
        text.append(title).append("\n");
        for (i = 0; i < this.size(); ++i) {
            if (fractional) {
                text.append(" ").append(ConfusionMatrix.num2ShortID(i, IDChars, IDWidth - 3)).append("   ");
                continue;
            }
            text.append(" ").append(ConfusionMatrix.num2ShortID(i, IDChars, IDWidth));
        }
        text.append("     actual class\n");
        for (i = 0; i < this.size(); ++i) {
            for (j = 0; j < this.size(); ++j) {
                text.append(" ").append(Utils.doubleToString(this.get(i, j), IDWidth, fractional ? 2 : 0));
            }
            text.append(" | ").append(ConfusionMatrix.num2ShortID(i, IDChars, IDWidth)).append(" = ").append(this.m_ClassNames[i]).append("\n");
        }
        return text.toString();
    }

    private static String num2ShortID(int num, char[] IDChars, int IDWidth) {
        int i;
        char[] ID2 = new char[IDWidth];
        for (i = IDWidth - 1; i >= 0; --i) {
            ID2[i] = IDChars[num % IDChars.length];
            if ((num = num / IDChars.length - 1) < 0) break;
        }
        --i;
        while (i >= 0) {
            ID2[i] = 32;
            --i;
        }
        return new String(ID2);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision$");
    }
}

