/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.supportVector;

import weka.classifiers.functions.supportVector.PolyKernel;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;

public class NormalizedPolyKernel
extends PolyKernel {
    static final long serialVersionUID = 1248574185532130851L;
    protected double[] m_diagDotproducts = null;

    public NormalizedPolyKernel() {
    }

    public NormalizedPolyKernel(Instances dataset, int cacheSize, double exponent, boolean lowerOrder) throws Exception {
        super(dataset, cacheSize, exponent, lowerOrder);
    }

    @Override
    public void buildKernel(Instances data) throws Exception {
        super.buildKernel(data);
        this.m_diagDotproducts = new double[data.numInstances()];
        for (int i = 0; i < data.numInstances(); ++i) {
            this.m_diagDotproducts[i] = this.dotProd(this.m_data.instance(i), this.m_data.instance(i));
        }
    }

    @Override
    public void clean() {
        super.clean();
        this.m_diagDotproducts = null;
    }

    @Override
    public String globalInfo() {
        return "The normalized polynomial kernel.\nK(x,y) = <x,y>/sqrt(<x,x><y,y>) where <x,y> = PolyKernel(x,y)";
    }

    @Override
    protected double evaluate(int id1, int id2, Instance inst1) throws Exception {
        double denominatorSquared;
        double denom1;
        double denom2;
        if (id1 == id2) {
            return 1.0;
        }
        double numerator = this.dotProd(inst1, this.m_data.instance(id2));
        if (this.m_diagDotproducts != null) {
            denom2 = this.m_diagDotproducts[id2];
            denom1 = id1 < 0 ? this.dotProd(inst1, inst1) : this.m_diagDotproducts[id1];
        } else {
            denom1 = this.dotProd(inst1, inst1);
            denom2 = this.dotProd(this.m_data.instance(id2), this.m_data.instance(id2));
        }
        if (this.m_lowerOrder) {
            numerator += 1.0;
            denom1 += 1.0;
            denom2 += 1.0;
        }
        double result = (denominatorSquared = denom1 * denom2) <= 0.0 ? 0.0 : numerator / Math.sqrt(denominatorSquared);
        if (this.m_exponent != 1.0) {
            result = Math.pow(result, this.m_exponent);
        }
        return result;
    }

    @Override
    public String toString() {
        String result = this.getUseLowerOrder() ? "Normalized Poly Kernel with lower order: K(x,y) = (<x,y>+1)^" + this.getExponent() + "/((<x,x>+1)^" + this.getExponent() + "*(<y,y>+1)^" + this.getExponent() + ")^(1/2)" : "Normalized Poly Kernel: K(x,y) = <x,y>^" + this.getExponent() + "/(<x,x>^" + this.getExponent() + "*<y,y>^" + this.getExponent() + ")^(1/2)";
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision$");
    }
}

