/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.supportVector;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.functions.supportVector.RegSMO;
import weka.classifiers.functions.supportVector.SMOset;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class RegSMOImproved
extends RegSMO
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 471692841446029784L;
    public static final int I0 = 3;
    public static final int I0a = 1;
    public static final int I0b = 2;
    public static final int I1 = 4;
    public static final int I2 = 8;
    public static final int I3 = 16;
    protected SMOset m_I0;
    protected int[] m_iSet;
    protected double m_bUp;
    protected double m_bLow;
    protected int m_iUp;
    protected int m_iLow;
    double m_fTolerance = 0.001;
    boolean m_bUseVariant1 = true;

    @Override
    public String globalInfo() {
        return "Learn SVM for regression using SMO with Shevade, Keerthi, et al. adaption of the stopping criterion.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "S.K. Shevade and S.S. Keerthi and C. Bhattacharyya and K.R.K. Murthy");
        result.setValue(TechnicalInformation.Field.TITLE, "Improvements to the SMO Algorithm for SVM Regression");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "IEEE Transactions on Neural Networks");
        result.setValue(TechnicalInformation.Field.YEAR, "1999");
        result.setValue(TechnicalInformation.Field.PS, "http://guppy.mpe.nus.edu.sg/~mpessk/svm/ieee_smo_reg.ps.gz");
        TechnicalInformation additional = result.add(TechnicalInformation.Type.TECHREPORT);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "S.K. Shevade and S.S. Keerthi and C. Bhattacharyya and K.R.K. Murthy");
        additional.setValue(TechnicalInformation.Field.TITLE, "Improvements to the SMO Algorithm for SVM Regression");
        additional.setValue(TechnicalInformation.Field.INSTITUTION, "National University of Singapore");
        additional.setValue(TechnicalInformation.Field.ADDRESS, "Control Division, Dept. of Mechanical Engineering");
        additional.setValue(TechnicalInformation.Field.NUMBER, "CD-99-16");
        additional.setValue(TechnicalInformation.Field.YEAR, "1999");
        additional.setValue(TechnicalInformation.Field.PS, "http://guppy.mpe.nus.edu.sg/~mpessk/svm/smoreg_mod.ps.gz");
        return result;
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tThe tolerance parameter for checking the stopping criterion.\n\t(default 0.001)", "T", 1, "-T <double>"));
        result.addElement(new Option("\tUse variant 1 of the algorithm when true, otherwise use variant 2.\n\t(default true)", "V", 0, "-V"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('T', options);
        if (tmpStr.length() != 0) {
            this.setTolerance(Double.parseDouble(tmpStr));
        } else {
            this.setTolerance(0.001);
        }
        this.setUseVariant1(Utils.getFlag('V', options));
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-T");
        result.add("" + this.getTolerance());
        if (this.m_bUseVariant1) {
            result.add("-V");
        }
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    public String toleranceTipText() {
        return "tolerance parameter used for checking stopping criterion b.up < b.low + 2 tol";
    }

    public double getTolerance() {
        return this.m_fTolerance;
    }

    public void setTolerance(double d) {
        this.m_fTolerance = d;
    }

    public String useVariant1TipText() {
        return "set true to use variant 1 of the paper, otherwise use variant 2.";
    }

    public boolean isUseVariant1() {
        return this.m_bUseVariant1;
    }

    public void setUseVariant1(boolean b) {
        this.m_bUseVariant1 = b;
    }

    @Override
    protected int takeStep(int i1, int i2, double alpha2, double alpha2Star, double phi2) throws Exception {
        if (i1 == i2) {
            return 0;
        }
        double C1 = this.m_C * this.m_data.instance(i1).weight();
        double C2 = this.m_C * this.m_data.instance(i2).weight();
        double alpha1 = this.m_alpha[i1];
        double alpha1Star = this.m_alphaStar[i1];
        double phi1 = this.m_error[i1];
        double k11 = this.m_kernel.eval(i1, i1, this.m_data.instance(i1));
        double k12 = this.m_kernel.eval(i1, i2, this.m_data.instance(i1));
        double k22 = this.m_kernel.eval(i2, i2, this.m_data.instance(i2));
        double eta = -2.0 * k12 + k11 + k22;
        double gamma = alpha1 - alpha1Star + alpha2 - alpha2Star;
        double alpha1old = alpha1;
        double alpha1Starold = alpha1Star;
        double alpha2old = alpha2;
        double alpha2Starold = alpha2Star;
        double deltaPhi = phi1 - phi2;
        if (this.findOptimalPointOnLine(i1, alpha1, alpha1Star, C1, i2, alpha2, alpha2Star, C2, gamma, eta, deltaPhi)) {
            alpha1 = this.m_alpha[i1];
            alpha1Star = this.m_alphaStar[i1];
            alpha2 = this.m_alpha[i2];
            alpha2Star = this.m_alphaStar[i2];
            double dAlpha1 = alpha1 - alpha1old - (alpha1Star - alpha1Starold);
            double dAlpha2 = alpha2 - alpha2old - (alpha2Star - alpha2Starold);
            int j = this.m_I0.getNext(-1);
            while (j != -1) {
                if (j != i1 && j != i2) {
                    int n = j;
                    this.m_error[n] = this.m_error[n] - (dAlpha1 * this.m_kernel.eval(i1, j, this.m_data.instance(i1)) + dAlpha2 * this.m_kernel.eval(i2, j, this.m_data.instance(i2)));
                }
                j = this.m_I0.getNext(j);
            }
            int n = i1;
            this.m_error[n] = this.m_error[n] - (dAlpha1 * k11 + dAlpha2 * k12);
            int n2 = i2;
            this.m_error[n2] = this.m_error[n2] - (dAlpha1 * k12 + dAlpha2 * k22);
            this.updateIndexSetFor(i1, C1);
            this.updateIndexSetFor(i2, C2);
            this.m_bUp = Double.MAX_VALUE;
            this.m_bLow = -1.7976931348623157E308;
            j = this.m_I0.getNext(-1);
            while (j != -1) {
                this.updateBoundaries(j, this.m_error[j]);
                j = this.m_I0.getNext(j);
            }
            if (!this.m_I0.contains(i1)) {
                this.updateBoundaries(i1, this.m_error[i1]);
            }
            if (!this.m_I0.contains(i2)) {
                this.updateBoundaries(i2, this.m_error[i2]);
            }
            return 1;
        }
        return 0;
    }

    protected void updateIndexSetFor(int i, double C) throws Exception {
        if (this.m_alpha[i] == 0.0 && this.m_alphaStar[i] == 0.0) {
            this.m_iSet[i] = 4;
            this.m_I0.delete(i);
        } else if (this.m_alpha[i] > 0.0) {
            if (this.m_alpha[i] < C) {
                if ((this.m_iSet[i] & 3) == 0) {
                    this.m_I0.insert(i);
                }
                this.m_iSet[i] = 1;
            } else {
                this.m_iSet[i] = 16;
                this.m_I0.delete(i);
            }
        } else if (this.m_alphaStar[i] < C) {
            if ((this.m_iSet[i] & 3) == 0) {
                this.m_I0.insert(i);
            }
            this.m_iSet[i] = 2;
        } else {
            this.m_iSet[i] = 8;
            this.m_I0.delete(i);
        }
    }

    protected void updateBoundaries(int i2, double F2) {
        int iSet = this.m_iSet[i2];
        double FLow = this.m_bLow;
        if ((iSet & 0xA) > 0) {
            FLow = F2 + this.m_epsilon;
        } else if ((iSet & 5) > 0) {
            FLow = F2 - this.m_epsilon;
        }
        if (this.m_bLow < FLow) {
            this.m_bLow = FLow;
            this.m_iLow = i2;
        }
        double FUp = this.m_bUp;
        if ((iSet & 0x11) > 0) {
            FUp = F2 - this.m_epsilon;
        } else if ((iSet & 6) > 0) {
            FUp = F2 + this.m_epsilon;
        }
        if (this.m_bUp > FUp) {
            this.m_bUp = FUp;
            this.m_iUp = i2;
        }
    }

    @Override
    protected int examineExample(int i2) throws Exception {
        int iSet = this.m_iSet[i2];
        double F2 = this.m_error[i2];
        if (!this.m_I0.contains(i2)) {
            this.m_error[i2] = F2 = -this.SVMOutput(i2) - this.m_b + this.m_target[i2];
            if (iSet == 4) {
                if (F2 + this.m_epsilon < this.m_bUp) {
                    this.m_bUp = F2 + this.m_epsilon;
                    this.m_iUp = i2;
                } else if (F2 - this.m_epsilon > this.m_bLow) {
                    this.m_bLow = F2 - this.m_epsilon;
                    this.m_iLow = i2;
                }
            } else if (iSet == 8 && F2 + this.m_epsilon > this.m_bLow) {
                this.m_bLow = F2 + this.m_epsilon;
                this.m_iLow = i2;
            } else if (iSet == 16 && F2 - this.m_epsilon < this.m_bUp) {
                this.m_bUp = F2 - this.m_epsilon;
                this.m_iUp = i2;
            }
        }
        int i1 = i2;
        boolean bOptimality = true;
        if (iSet == 1) {
            if (this.m_bLow - (F2 - this.m_epsilon) > 2.0 * this.m_fTolerance) {
                bOptimality = false;
                i1 = this.m_iLow;
                if (F2 - this.m_epsilon - this.m_bUp > this.m_bLow - (F2 - this.m_epsilon)) {
                    i1 = this.m_iUp;
                }
            } else if (F2 - this.m_epsilon - this.m_bUp > 2.0 * this.m_fTolerance) {
                bOptimality = false;
                i1 = this.m_iUp;
                if (this.m_bLow - (F2 - this.m_epsilon) > F2 - this.m_epsilon - this.m_bUp) {
                    i1 = this.m_iLow;
                }
            }
        } else if (iSet == 2) {
            if (this.m_bLow - (F2 + this.m_epsilon) > 2.0 * this.m_fTolerance) {
                bOptimality = false;
                i1 = this.m_iLow;
                if (F2 + this.m_epsilon - this.m_bUp > this.m_bLow - (F2 + this.m_epsilon)) {
                    i1 = this.m_iUp;
                }
            } else if (F2 + this.m_epsilon - this.m_bUp > 2.0 * this.m_fTolerance) {
                bOptimality = false;
                i1 = this.m_iUp;
                if (this.m_bLow - (F2 + this.m_epsilon) > F2 + this.m_epsilon - this.m_bUp) {
                    i1 = this.m_iLow;
                }
            }
        } else if (iSet == 4) {
            if (this.m_bLow - (F2 + this.m_epsilon) > 2.0 * this.m_fTolerance) {
                bOptimality = false;
                i1 = this.m_iLow;
                if (F2 + this.m_epsilon - this.m_bUp > this.m_bLow - (F2 + this.m_epsilon)) {
                    i1 = this.m_iUp;
                }
            } else if (F2 - this.m_epsilon - this.m_bUp > 2.0 * this.m_fTolerance) {
                bOptimality = false;
                i1 = this.m_iUp;
                if (this.m_bLow - (F2 - this.m_epsilon) > F2 - this.m_epsilon - this.m_bUp) {
                    i1 = this.m_iLow;
                }
            }
        } else if (iSet == 8) {
            if (F2 + this.m_epsilon - this.m_bUp > 2.0 * this.m_fTolerance) {
                bOptimality = false;
                i1 = this.m_iUp;
            }
        } else if (iSet == 16 && this.m_bLow - (F2 - this.m_epsilon) > 2.0 * this.m_fTolerance) {
            bOptimality = false;
            i1 = this.m_iLow;
        }
        if (bOptimality) {
            return 0;
        }
        return this.takeStep(i1, i2, this.m_alpha[i2], this.m_alphaStar[i2], F2);
    }

    @Override
    protected void init(Instances data) throws Exception {
        int i;
        super.init(data);
        this.m_I0 = new SMOset(this.m_data.numInstances());
        this.m_iSet = new int[this.m_data.numInstances()];
        for (i = 0; i < this.m_nInstances; ++i) {
            this.m_iSet[i] = 4;
        }
        this.m_iUp = 0;
        this.m_bUp = this.m_target[this.m_iUp] + this.m_epsilon;
        this.m_iLow = this.m_iUp;
        this.m_bLow = this.m_target[this.m_iLow] - this.m_epsilon;
        this.m_error = new double[this.m_nInstances];
        for (i = 0; i < this.m_nInstances; ++i) {
            this.m_error[i] = this.m_target[i];
        }
    }

    protected void optimize1() throws Exception {
        int nNumChanged = 0;
        boolean bExamineAll = true;
        while (nNumChanged > 0 || bExamineAll) {
            int i;
            nNumChanged = 0;
            if (bExamineAll) {
                for (i = 0; i < this.m_nInstances; ++i) {
                    nNumChanged += this.examineExample(i);
                }
            } else {
                i = this.m_I0.getNext(-1);
                while (i != -1) {
                    nNumChanged += this.examineExample(i);
                    if (this.m_bLow - this.m_bUp < 2.0 * this.m_fTolerance) {
                        nNumChanged = 0;
                        break;
                    }
                    i = this.m_I0.getNext(i);
                }
            }
            if (bExamineAll) {
                bExamineAll = false;
                continue;
            }
            if (nNumChanged != 0) continue;
            bExamineAll = true;
        }
    }

    protected void optimize2() throws Exception {
        int nNumChanged = 0;
        boolean bExamineAll = true;
        while (nNumChanged > 0 || bExamineAll) {
            nNumChanged = 0;
            if (bExamineAll) {
                for (int i = 0; i < this.m_nInstances; ++i) {
                    nNumChanged += this.examineExample(i);
                }
            } else {
                boolean bInnerLoopSuccess = true;
                do {
                    if (this.takeStep(this.m_iUp, this.m_iLow, this.m_alpha[this.m_iLow], this.m_alphaStar[this.m_iLow], this.m_error[this.m_iLow]) > 0) {
                        bInnerLoopSuccess = true;
                        ++nNumChanged;
                        continue;
                    }
                    bInnerLoopSuccess = false;
                } while (this.m_bUp <= this.m_bLow - 2.0 * this.m_fTolerance && bInnerLoopSuccess);
                nNumChanged = 0;
            }
            if (bExamineAll) {
                bExamineAll = false;
                continue;
            }
            if (nNumChanged != 0) continue;
            bExamineAll = true;
        }
    }

    @Override
    protected void wrapUp() throws Exception {
        this.m_b = -(this.m_bLow + this.m_bUp) / 2.0;
        this.m_target = null;
        this.m_error = null;
        super.wrapUp();
    }

    @Override
    public void buildClassifier(Instances instances) throws Exception {
        this.init(instances);
        if (this.m_bUseVariant1) {
            this.optimize1();
        } else {
            this.optimize2();
        }
        this.wrapUp();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision$");
    }
}

