/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.pmml.consumer;

import java.io.Serializable;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weka.classifiers.pmml.consumer.PMMLClassifier;
import weka.classifiers.pmml.consumer.TreeModel;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.pmml.MiningSchema;

public class RuleSetModel
extends PMMLClassifier {
    private static final long serialVersionUID = 1993161168811020547L;
    protected TreeModel.MiningFunction m_functionType = TreeModel.MiningFunction.CLASSIFICATION;
    protected String m_modelName;
    protected String m_algorithmName;
    protected RuleSet m_ruleSet;

    public RuleSetModel(Element model, Instances dataDictionary, MiningSchema miningSchema) throws Exception {
        super(dataDictionary, miningSchema);
        NodeList ruleset;
        String algoName;
        String modelName;
        String fn;
        if (!this.getPMMLVersion().equals("3.2")) {
            // empty if block
        }
        if ((fn = model.getAttribute("functionName")).equals("regression")) {
            this.m_functionType = TreeModel.MiningFunction.REGRESSION;
        }
        if ((modelName = model.getAttribute("modelName")) != null && modelName.length() > 0) {
            this.m_modelName = modelName;
        }
        if ((algoName = model.getAttribute("algorithmName")) != null && algoName.length() > 0) {
            this.m_algorithmName = algoName;
        }
        if ((ruleset = model.getElementsByTagName("RuleSet")).getLength() == 1) {
            Node ruleSetNode = ruleset.item(0);
            if (ruleSetNode.getNodeType() == 1) {
                this.m_ruleSet = new RuleSet((Element)ruleSetNode, miningSchema);
            }
        } else {
            throw new Exception("[RuleSetModel] Should only have a single RuleSet!");
        }
    }

    @Override
    public double[] distributionForInstance(Instance inst) throws Exception {
        if (!this.m_initialized) {
            this.mapToMiningSchema(inst.dataset());
        }
        double[] preds = null;
        preds = this.m_miningSchema.getFieldsAsInstances().classAttribute().isNumeric() ? new double[1] : new double[this.m_miningSchema.getFieldsAsInstances().classAttribute().numValues()];
        double[] incoming = this.m_fieldsMap.instanceToSchema(inst, this.m_miningSchema);
        preds = this.m_ruleSet.score(incoming, this.m_miningSchema.getFieldsAsInstances().classAttribute());
        if (this.m_miningSchema.getFieldsAsInstances().classAttribute().isNominal()) {
            Utils.normalize(preds);
        }
        return preds;
    }

    public String toString() {
        StringBuffer temp = new StringBuffer();
        temp.append("PMML version " + this.getPMMLVersion());
        if (!this.getCreatorApplication().equals("?")) {
            temp.append("\nApplication: " + this.getCreatorApplication());
        }
        temp.append("\nPMML Model: RuleSetModel");
        temp.append("\n\n");
        temp.append(this.m_miningSchema);
        if (this.m_algorithmName != null) {
            temp.append("\nAlgorithm: " + this.m_algorithmName + "\n");
        }
        temp.append(this.m_ruleSet);
        return temp.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision$");
    }

    static class RuleSet
    implements Serializable {
        private static final long serialVersionUID = -8718126887943074376L;
        private double m_recordCount = Utils.missingValue();
        private double m_nbCorrect = Utils.missingValue();
        private String m_defaultScore;
        private double m_defaultPrediction = Utils.missingValue();
        private ArrayList<TreeModel.ScoreDistribution> m_scoreDistributions = new ArrayList();
        private double m_defaultConfidence = Utils.missingValue();
        private RuleSelectionMethod m_currentMethod;
        private ArrayList<RuleSelectionMethod> m_availableRuleSelectionMethods = new ArrayList();
        private ArrayList<Rule> m_rules = new ArrayList();

        public String toString() {
            StringBuffer temp = new StringBuffer();
            temp.append("Rule selection method: " + (Object)((Object)this.m_currentMethod) + "\n");
            if (this.m_defaultScore != null) {
                temp.append("Default prediction: " + this.m_defaultScore + "\n");
                if (!Utils.isMissingValue(this.m_recordCount)) {
                    temp.append("       recordCount: " + this.m_recordCount + "\n");
                }
                if (!Utils.isMissingValue(this.m_nbCorrect)) {
                    temp.append("         nbCorrect: " + this.m_nbCorrect + "\n");
                }
                if (!Utils.isMissingValue(this.m_defaultConfidence)) {
                    temp.append(" defaultConfidence: " + this.m_defaultConfidence + "\n");
                }
                temp.append("\n");
            }
            for (Rule r : this.m_rules) {
                temp.append(r + "\n");
            }
            return temp.toString();
        }

        public RuleSet(Element ruleSetNode, MiningSchema miningSchema) throws Exception {
            Object tagName;
            Node child;
            String defaultConfidence;
            String defaultScore;
            String nbCorrect;
            String recordCount = ruleSetNode.getAttribute("recordCount");
            if (recordCount != null && recordCount.length() > 0) {
                this.m_recordCount = Double.parseDouble(recordCount);
            }
            if ((nbCorrect = ruleSetNode.getAttribute("nbCorrect")) != null & nbCorrect.length() > 0) {
                this.m_nbCorrect = Double.parseDouble(nbCorrect);
            }
            if ((defaultScore = ruleSetNode.getAttribute("defaultScore")) != null && defaultScore.length() > 0) {
                this.m_defaultScore = defaultScore;
                Attribute classAtt = miningSchema.getFieldsAsInstances().classAttribute();
                if (classAtt == null) {
                    throw new Exception("[RuleSet] class attribute not set!");
                }
                if (classAtt.isNumeric()) {
                    this.m_defaultPrediction = Double.parseDouble(defaultScore);
                } else {
                    if (classAtt.indexOfValue(defaultScore) < 0) {
                        throw new Exception("[RuleSet] class value " + defaultScore + " not found!");
                    }
                    this.m_defaultPrediction = classAtt.indexOfValue(defaultScore);
                }
            }
            if ((defaultConfidence = ruleSetNode.getAttribute("defaultConfidence")) != null && defaultConfidence.length() > 0) {
                this.m_defaultConfidence = Double.parseDouble(defaultConfidence);
            }
            NodeList selectionNL = ruleSetNode.getElementsByTagName("RuleSelectionMethod");
            for (int i = 0; i < selectionNL.getLength(); ++i) {
                Node selectN = selectionNL.item(i);
                if (selectN.getNodeType() != 1) continue;
                Element sN = (Element)selectN;
                String criterion = sN.getAttribute("criterion");
                for (RuleSelectionMethod m : RuleSelectionMethod.values()) {
                    if (!m.toString().equals(criterion)) continue;
                    this.m_availableRuleSelectionMethods.add(m);
                    if (i != 0) continue;
                    this.m_currentMethod = m;
                }
            }
            if (miningSchema.getFieldsAsInstances().classAttribute().isNominal()) {
                NodeList scoreChildren = ruleSetNode.getChildNodes();
                for (int i = 0; i < scoreChildren.getLength(); ++i) {
                    child = scoreChildren.item(i);
                    if (child.getNodeType() != 1 || !((String)(tagName = ((Element)child).getTagName())).equals("ScoreDistribution")) continue;
                    TreeModel.ScoreDistribution newDist = new TreeModel.ScoreDistribution((Element)child, miningSchema, this.m_recordCount);
                    this.m_scoreDistributions.add(newDist);
                }
                if (Utils.isMissingValue(this.m_recordCount)) {
                    double baseCount = 0.0;
                    for (TreeModel.ScoreDistribution s : this.m_scoreDistributions) {
                        baseCount += s.getRecordCount();
                    }
                    for (TreeModel.ScoreDistribution s : this.m_scoreDistributions) {
                        s.deriveConfidenceValue(baseCount);
                    }
                }
            }
            NodeList ruleChildren = ruleSetNode.getChildNodes();
            for (int i = 0; i < ruleChildren.getLength(); ++i) {
                Rule tempRule;
                child = ruleChildren.item(i);
                if (child.getNodeType() != 1) continue;
                tagName = ((Element)child).getTagName();
                if (((String)tagName).equals("SimpleRule")) {
                    tempRule = new SimpleRule((Element)child, miningSchema);
                    this.m_rules.add(tempRule);
                    continue;
                }
                if (!((String)tagName).equals("CompoundRule")) continue;
                tempRule = new CompoundRule((Element)child, miningSchema);
                this.m_rules.add(tempRule);
            }
        }

        protected double[] score(double[] instance, Attribute classAtt) throws Exception {
            double[] preds = null;
            preds = classAtt.isNumeric() ? new double[1] : new double[classAtt.numValues()];
            ArrayList<SimpleRule> firingRules = new ArrayList<SimpleRule>();
            for (Rule r : this.m_rules) {
                r.fires(instance, firingRules);
            }
            if (firingRules.size() > 0) {
                if (this.m_currentMethod == RuleSelectionMethod.FIRSTHIT) {
                    preds = firingRules.get(0).score(instance, classAtt);
                } else if (this.m_currentMethod == RuleSelectionMethod.WEIGHTEDMAX) {
                    double wMax = Double.NEGATIVE_INFINITY;
                    SimpleRule best = null;
                    for (SimpleRule s : firingRules) {
                        if (Utils.isMissingValue(s.getWeight())) {
                            throw new Exception("[RuleSet] Scoring criterion is WEIGHTEDMAX, but rule " + s.getID() + " does not have a weight defined!");
                        }
                        if (!(s.getWeight() > wMax)) continue;
                        wMax = s.getWeight();
                        best = s;
                    }
                    if (best == null) {
                        throw new Exception("[RuleSet] Unable to determine the best rule under the WEIGHTEDMAX criterion!");
                    }
                    preds = best.score(instance, classAtt);
                } else if (this.m_currentMethod == RuleSelectionMethod.WEIGHTEDSUM) {
                    double sumOfWeights = 0.0;
                    for (SimpleRule s : firingRules) {
                        if (Utils.isMissingValue(s.getWeight())) {
                            throw new Exception("[RuleSet] Scoring criterion is WEIGHTEDSUM, but rule " + s.getID() + " does not have a weight defined!");
                        }
                        if (classAtt.isNumeric()) {
                            sumOfWeights += s.getWeight();
                            preds[0] = preds[0] + s.getScore() * s.getWeight();
                            continue;
                        }
                        int n = (int)s.getScore();
                        preds[n] = preds[n] + s.getWeight();
                    }
                    if (classAtt.isNumeric()) {
                        if (sumOfWeights == 0.0) {
                            throw new Exception("[RuleSet] Sum of weights is zero!");
                        }
                        preds[0] = preds[0] / sumOfWeights;
                    }
                }
            } else if (classAtt.isNumeric()) {
                preds[0] = this.m_defaultPrediction;
            } else if (this.m_scoreDistributions.size() > 0) {
                for (TreeModel.ScoreDistribution s : this.m_scoreDistributions) {
                    preds[s.getClassLabelIndex()] = s.getConfidence();
                }
            } else {
                preds[(int)this.m_defaultPrediction] = !Utils.isMissingValue(this.m_defaultConfidence) ? this.m_defaultConfidence : 1.0;
            }
            return preds;
        }

        static enum RuleSelectionMethod {
            WEIGHTEDSUM("weightedSum"),
            WEIGHTEDMAX("weightedMax"),
            FIRSTHIT("firstHit");

            private final String m_stringVal;

            private RuleSelectionMethod(String name) {
                this.m_stringVal = name;
            }

            public String toString() {
                return this.m_stringVal;
            }
        }
    }

    static class CompoundRule
    extends Rule {
        private static final long serialVersionUID = -2853658811459970718L;
        ArrayList<Rule> m_childRules = new ArrayList();

        @Override
        public String toString(String prefix, int indent) {
            StringBuffer temp = new StringBuffer();
            for (int i = 0; i < indent; ++i) {
                prefix = prefix + " ";
            }
            temp.append(prefix + "Compound rule: " + this.m_predicate + "\n");
            for (Rule r : this.m_childRules) {
                temp.append(r.toString(prefix, indent + 1));
            }
            return temp.toString();
        }

        public String toString() {
            return this.toString("", 0);
        }

        public CompoundRule(Element ruleE, MiningSchema miningSchema) throws Exception {
            super(ruleE, miningSchema);
            NodeList ruleChildren = ruleE.getChildNodes();
            for (int i = 0; i < ruleChildren.getLength(); ++i) {
                Rule childRule;
                Node child = ruleChildren.item(i);
                if (child.getNodeType() != 1) continue;
                String tagName = ((Element)child).getTagName();
                if (tagName.equals("SimpleRule")) {
                    childRule = new SimpleRule((Element)child, miningSchema);
                    this.m_childRules.add(childRule);
                    continue;
                }
                if (!tagName.equals("CompoundRule")) continue;
                childRule = new CompoundRule((Element)child, miningSchema);
                this.m_childRules.add(childRule);
            }
        }

        @Override
        public void fires(double[] input, ArrayList<SimpleRule> ruleCollection) {
            if (this.m_predicate.evaluate(input) == TreeModel.Predicate.Eval.TRUE) {
                for (Rule r : this.m_childRules) {
                    r.fires(input, ruleCollection);
                }
            }
        }
    }

    static class SimpleRule
    extends Rule {
        private static final long serialVersionUID = -2612893679476049682L;
        protected String m_ID;
        protected String m_scoreString;
        protected double m_score = Utils.missingValue();
        protected double m_recordCount = Utils.missingValue();
        protected double m_nbCorrect = Utils.missingValue();
        protected double m_confidence = Utils.missingValue();
        protected ArrayList<TreeModel.ScoreDistribution> m_scoreDistributions = new ArrayList();
        protected double m_weight = Utils.missingValue();

        @Override
        public String toString(String prefix, int indent) {
            StringBuffer temp = new StringBuffer();
            for (int i = 0; i < indent; ++i) {
                prefix = prefix + " ";
            }
            temp.append(prefix + "Simple rule: " + this.m_predicate + "\n");
            temp.append(prefix + " => " + this.m_scoreString + "\n");
            if (!Utils.isMissingValue(this.m_recordCount)) {
                temp.append(prefix + " recordCount: " + this.m_recordCount + "\n");
            }
            if (!Utils.isMissingValue(this.m_nbCorrect)) {
                temp.append(prefix + "   nbCorrect: " + this.m_nbCorrect + "\n");
            }
            if (!Utils.isMissingValue(this.m_confidence)) {
                temp.append(prefix + "  confidence: " + this.m_confidence + "\n");
            }
            if (!Utils.isMissingValue(this.m_weight)) {
                temp.append(prefix + "      weight: " + this.m_weight + "\n");
            }
            return temp.toString();
        }

        public String toString() {
            return this.toString("", 0);
        }

        public SimpleRule(Element ruleE, MiningSchema miningSchema) throws Exception {
            super(ruleE, miningSchema);
            String weight;
            String confidence;
            String nbCorrect;
            String id = ruleE.getAttribute("id");
            if (id != null && id.length() > 0) {
                this.m_ID = id;
            }
            this.m_scoreString = ruleE.getAttribute("score");
            Attribute classAtt = miningSchema.getFieldsAsInstances().classAttribute();
            if (classAtt.isNumeric()) {
                this.m_score = Double.parseDouble(this.m_scoreString);
            } else {
                if (classAtt.indexOfValue(this.m_scoreString) < 0) {
                    throw new Exception("[SimpleRule] class value " + this.m_scoreString + "does not exist in class attribute " + classAtt.name());
                }
                this.m_score = classAtt.indexOfValue(this.m_scoreString);
            }
            String recordCount = ruleE.getAttribute("recordCount");
            if (recordCount != null && recordCount.length() > 0) {
                this.m_recordCount = Double.parseDouble(recordCount);
            }
            if ((nbCorrect = ruleE.getAttribute("nbCorrect")) != null && nbCorrect.length() > 0) {
                this.m_nbCorrect = Double.parseDouble(nbCorrect);
            }
            if ((confidence = ruleE.getAttribute("confidence")) != null && confidence.length() > 0) {
                this.m_confidence = Double.parseDouble(confidence);
            }
            if ((weight = ruleE.getAttribute("weight")) != null && weight.length() > 0) {
                this.m_weight = Double.parseDouble(weight);
            }
            if (miningSchema.getFieldsAsInstances().classAttribute().isNominal()) {
                NodeList scoreChildren = ruleE.getChildNodes();
                for (int i = 0; i < scoreChildren.getLength(); ++i) {
                    String tagName;
                    Node child = scoreChildren.item(i);
                    if (child.getNodeType() != 1 || !(tagName = ((Element)child).getTagName()).equals("ScoreDistribution")) continue;
                    TreeModel.ScoreDistribution newDist = new TreeModel.ScoreDistribution((Element)child, miningSchema, this.m_recordCount);
                    this.m_scoreDistributions.add(newDist);
                }
                if (this.m_scoreDistributions.size() > 0 && this.m_scoreDistributions.size() != miningSchema.getFieldsAsInstances().classAttribute().numValues()) {
                    throw new Exception("[SimpleRule] Number of score distribution elements is  different than the number of class labels!");
                }
                if (Utils.isMissingValue(this.m_recordCount)) {
                    double baseCount = 0.0;
                    for (TreeModel.ScoreDistribution s : this.m_scoreDistributions) {
                        baseCount += s.getRecordCount();
                    }
                    for (TreeModel.ScoreDistribution s : this.m_scoreDistributions) {
                        s.deriveConfidenceValue(baseCount);
                    }
                }
            }
        }

        @Override
        public void fires(double[] input, ArrayList<SimpleRule> ruleCollection) {
            if (this.m_predicate.evaluate(input) == TreeModel.Predicate.Eval.TRUE) {
                ruleCollection.add(this);
            }
        }

        public double[] score(double[] instance, Attribute classAtt) throws Exception {
            double[] preds;
            if (classAtt.isNumeric()) {
                preds = new double[]{this.m_score};
            } else {
                preds = new double[classAtt.numValues()];
                if (this.m_scoreDistributions.size() > 0) {
                    for (TreeModel.ScoreDistribution s : this.m_scoreDistributions) {
                        preds[s.getClassLabelIndex()] = s.getConfidence();
                    }
                } else {
                    preds[classAtt.indexOfValue((String)this.m_scoreString)] = !Utils.isMissingValue(this.m_confidence) ? this.m_confidence : 1.0;
                }
            }
            return preds;
        }

        public double getWeight() {
            return this.m_weight;
        }

        public String getID() {
            return this.m_ID;
        }

        public double getScore() {
            return this.m_score;
        }
    }

    static abstract class Rule
    implements Serializable {
        private static final long serialVersionUID = 6236231263477446102L;
        protected TreeModel.Predicate m_predicate;

        public Rule(Element ruleE, MiningSchema miningSchema) throws Exception {
            this.m_predicate = TreeModel.Predicate.getPredicate(ruleE, miningSchema);
        }

        public abstract void fires(double[] var1, ArrayList<SimpleRule> var2);

        public abstract String toString(String var1, int var2);
    }
}

