/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class Memory
implements RevisionHandler {
    public static final long OUT_OF_MEMORY_THRESHOLD = 0x3200000L;
    public static final long LOW_MEMORY_MINIMUM = 0x6400000L;
    public static final long MAX_SLEEP_TIME = 10L;
    protected boolean m_Enabled = true;
    protected boolean m_UseGUI = false;
    protected static MemoryMXBean m_MemoryMXBean = ManagementFactory.getMemoryMXBean();
    protected MemoryUsage m_MemoryUsage = null;
    protected long m_SleepTime = 10L;

    public Memory() {
        this(false);
    }

    public Memory(boolean useGUI) {
        this.m_UseGUI = useGUI;
    }

    public boolean isEnabled() {
        return this.m_Enabled;
    }

    public void setEnabled(boolean value) {
        this.m_Enabled = value;
    }

    public boolean getUseGUI() {
        return this.m_UseGUI;
    }

    public long getInitial() {
        this.m_MemoryUsage = m_MemoryMXBean.getHeapMemoryUsage();
        return this.m_MemoryUsage.getInit();
    }

    public long getCurrent() {
        this.m_MemoryUsage = m_MemoryMXBean.getHeapMemoryUsage();
        return this.m_MemoryUsage.getUsed();
    }

    public long getMax() {
        this.m_MemoryUsage = m_MemoryMXBean.getHeapMemoryUsage();
        return this.m_MemoryUsage.getMax();
    }

    public boolean isOutOfMemory() {
        try {
            Thread.sleep(this.m_SleepTime);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        this.m_MemoryUsage = m_MemoryMXBean.getHeapMemoryUsage();
        if (this.isEnabled()) {
            long avail = this.m_MemoryUsage.getMax() - this.m_MemoryUsage.getUsed();
            if (avail > 0x3200000L) {
                long num = (avail - 0x3200000L) / 0x500000L + 1L;
                this.m_SleepTime = (long)(2.0 * (Math.log(num) + 2.5));
                if (this.m_SleepTime > 10L) {
                    this.m_SleepTime = 10L;
                }
            }
            return avail < 0x3200000L;
        }
        return false;
    }

    public boolean memoryIsLow() {
        this.m_MemoryUsage = m_MemoryMXBean.getHeapMemoryUsage();
        if (this.isEnabled()) {
            long avail;
            long lowThreshold = (long)(0.2 * (double)this.m_MemoryUsage.getMax());
            if (lowThreshold < 0x6400000L) {
                lowThreshold = 0x6400000L;
            }
            return (avail = this.m_MemoryUsage.getMax() - this.m_MemoryUsage.getUsed()) < lowThreshold;
        }
        return false;
    }

    public static double toMegaByte(long bytes) {
        return (double)bytes / 1048576.0;
    }

    public void showOutOfMemory() {
        if (!this.isEnabled() || this.m_MemoryUsage == null) {
            return;
        }
        System.gc();
        String msg = "Not enough memory (less than 50MB left on heap). Please load a smaller dataset or use a larger heap size.\n- initial heap size:   " + Utils.doubleToString(Memory.toMegaByte(this.m_MemoryUsage.getInit()), 1) + "MB\n- current memory (heap) used:  " + Utils.doubleToString(Memory.toMegaByte(this.m_MemoryUsage.getUsed()), 1) + "MB\n- max. memory (heap) available: " + Utils.doubleToString(Memory.toMegaByte(this.m_MemoryUsage.getMax()), 1) + "MB\n\nNote:\nThe Java heap size can be specified with the -Xmx option.\nE.g., to use 128MB as heap size, the command line looks like this:\n   java -Xmx128m -classpath ...\nThis does NOT work in the SimpleCLI, the above java command refers\nto the one with which Weka is started. See the Weka FAQ on the web\nfor further info.";
        System.err.println(msg);
        if (this.getUseGUI()) {
            JOptionPane.showMessageDialog(null, msg, "OutOfMemory", 2);
        }
    }

    public boolean showMemoryIsLow() {
        if (!this.isEnabled() || this.m_MemoryUsage == null) {
            return true;
        }
        String msg = "Warning: memory is running low - available heap space is less than 20% of maximum or 100MB (whichever is greater)\n\n- initial heap size:   " + Utils.doubleToString(Memory.toMegaByte(this.m_MemoryUsage.getInit()), 1) + "MB\n- current memory (heap) used:  " + Utils.doubleToString(Memory.toMegaByte(this.m_MemoryUsage.getUsed()), 1) + "MB\n- max. memory (heap) available: " + Utils.doubleToString(Memory.toMegaByte(this.m_MemoryUsage.getMax()), 1) + "MB\n\nConsider deleting some results before continuing.\nCheck the Weka FAQ on the web for suggestions on how to save memory.\nNote that Weka will shut down when less than 50MB remain.\nDo you wish to continue regardless?\n\n";
        System.err.println(msg);
        if (this.getUseGUI() && !Utils.getDontShowDialog("weka.core.Memory.LowMemoryWarning")) {
            JCheckBox dontShow = new JCheckBox("Do not show this message again");
            Object[] stuff = new Object[]{msg, dontShow};
            int result = JOptionPane.showConfirmDialog(null, stuff, "Memory", 0);
            if (dontShow.isSelected()) {
                try {
                    Utils.setDontShowDialog("weka.core.Memory.LowMemoryWarning");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return result == 0;
        }
        return true;
    }

    public void stopThreads() {
        Thread[] thGroup = new Thread[Thread.activeCount()];
        Thread.enumerate(thGroup);
        for (int i = 0; i < thGroup.length; ++i) {
            Thread t = thGroup[i];
            if (t == null || t == Thread.currentThread()) continue;
            if (t.getName().startsWith("Thread")) {
                t.stop();
                continue;
            }
            if (!t.getName().startsWith("AWT-EventQueue")) continue;
            t.stop();
        }
        thGroup = null;
        System.gc();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision$");
    }

    public static void main(String[] args) {
        Memory mem = new Memory();
        System.out.println("Initial memory: " + Utils.doubleToString(Memory.toMegaByte(mem.getInitial()), 1) + "MB (" + mem.getInitial() + ")");
        System.out.println("Max memory: " + Utils.doubleToString(Memory.toMegaByte(mem.getMax()), 1) + "MB (" + mem.getMax() + ")");
    }
}

