/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.matrix.Matrix;

public abstract class Optimization
implements TechnicalInformationHandler,
RevisionHandler {
    protected double m_ALF = 1.0E-4;
    protected double m_BETA = 0.9;
    protected double m_TOLX = 1.0E-6;
    protected double m_STPMX = 100.0;
    protected int m_MAXITS = 200;
    protected boolean m_Debug = false;
    protected double m_f;
    private double m_Slope;
    protected boolean m_IsZeroStep = false;
    protected double[] m_X;
    protected static double m_Epsilon = 1.0;
    protected static double m_Zero;

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.MASTERSTHESIS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Xin Xu");
        result.setValue(TechnicalInformation.Field.YEAR, "2003");
        result.setValue(TechnicalInformation.Field.TITLE, "Statistical learning in multiple instance problem");
        result.setValue(TechnicalInformation.Field.SCHOOL, "University of Waikato");
        result.setValue(TechnicalInformation.Field.ADDRESS, "Hamilton, NZ");
        result.setValue(TechnicalInformation.Field.NOTE, "0657.594");
        TechnicalInformation additional = result.add(TechnicalInformation.Type.BOOK);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "P. E. Gill and W. Murray and M. H. Wright");
        additional.setValue(TechnicalInformation.Field.YEAR, "1981");
        additional.setValue(TechnicalInformation.Field.TITLE, "Practical Optimization");
        additional.setValue(TechnicalInformation.Field.PUBLISHER, "Academic Press");
        additional.setValue(TechnicalInformation.Field.ADDRESS, "London and New York");
        additional = result.add(TechnicalInformation.Type.TECHREPORT);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "P. E. Gill and W. Murray");
        additional.setValue(TechnicalInformation.Field.YEAR, "1976");
        additional.setValue(TechnicalInformation.Field.TITLE, "Minimization subject to bounds on the variables");
        additional.setValue(TechnicalInformation.Field.INSTITUTION, "National Physical Laboratory");
        additional.setValue(TechnicalInformation.Field.NUMBER, "NAC 72");
        additional = result.add(TechnicalInformation.Type.BOOK);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "E. K. P. Chong and S. H. Zak");
        additional.setValue(TechnicalInformation.Field.YEAR, "1996");
        additional.setValue(TechnicalInformation.Field.TITLE, "An Introduction to Optimization");
        additional.setValue(TechnicalInformation.Field.PUBLISHER, "John Wiley and Sons");
        additional.setValue(TechnicalInformation.Field.ADDRESS, "New York");
        additional = result.add(TechnicalInformation.Type.BOOK);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "J. E. Dennis and R. B. Schnabel");
        additional.setValue(TechnicalInformation.Field.YEAR, "1983");
        additional.setValue(TechnicalInformation.Field.TITLE, "Numerical Methods for Unconstrained Optimization and Nonlinear Equations");
        additional.setValue(TechnicalInformation.Field.PUBLISHER, "Prentice-Hall");
        additional = result.add(TechnicalInformation.Type.BOOK);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "W. H. Press and B. P. Flannery and S. A. Teukolsky and W. T. Vetterling");
        additional.setValue(TechnicalInformation.Field.YEAR, "1992");
        additional.setValue(TechnicalInformation.Field.TITLE, "Numerical Recipes in C");
        additional.setValue(TechnicalInformation.Field.PUBLISHER, "Cambridge University Press");
        additional.setValue(TechnicalInformation.Field.EDITION, "Second");
        additional = result.add(TechnicalInformation.Type.ARTICLE);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "P. E. Gill and G. H. Golub and W. Murray and M. A. Saunders");
        additional.setValue(TechnicalInformation.Field.YEAR, "1974");
        additional.setValue(TechnicalInformation.Field.TITLE, "Methods for modifying matrix factorizations");
        additional.setValue(TechnicalInformation.Field.JOURNAL, "Mathematics of Computation");
        additional.setValue(TechnicalInformation.Field.VOLUME, "28");
        additional.setValue(TechnicalInformation.Field.NUMBER, "126");
        additional.setValue(TechnicalInformation.Field.PAGES, "505-535");
        return result;
    }

    protected abstract double objectiveFunction(double[] var1) throws Exception;

    protected abstract double[] evaluateGradient(double[] var1) throws Exception;

    protected double[] evaluateHessian(double[] x, int index) throws Exception {
        return null;
    }

    public double getMinFunction() {
        return this.m_f;
    }

    public void setMaxIteration(int it) {
        this.m_MAXITS = it;
    }

    public void setDebug(boolean db) {
        this.m_Debug = db;
    }

    public double[] getVarbValues() {
        return this.m_X;
    }

    public double[] lnsrch(double[] xold, double[] gradient, double[] direct, double stpmax, boolean[] isFixed, double[][] nwsBounds, DynamicIntArray wsBdsIndx) throws Exception {
        double[] newGrad;
        int i;
        if (this.m_Debug) {
            System.err.println("Machine precision is " + m_Epsilon + " and zero set to " + m_Zero);
        }
        int len = xold.length;
        int fixedOne = -1;
        double alpha = Double.POSITIVE_INFINITY;
        double fold = this.m_f;
        double alam2 = 0.0;
        double disc = 0.0;
        double maxalam = 1.0;
        double[] x = new double[len];
        double sum = 0.0;
        for (i = 0; i < len; ++i) {
            if (isFixed[i]) continue;
            sum += direct[i] * direct[i];
        }
        sum = Math.sqrt(sum);
        if (this.m_Debug) {
            System.err.println("fold:  " + Utils.doubleToString(fold, 10, 7) + "\nsum:  " + Utils.doubleToString(sum, 10, 7) + "\nstpmax:  " + Utils.doubleToString(stpmax, 10, 7));
        }
        if (sum > stpmax) {
            for (i = 0; i < len; ++i) {
                if (isFixed[i]) continue;
                int n = i;
                direct[n] = direct[n] * (stpmax / sum);
            }
        } else {
            maxalam = stpmax / sum;
        }
        this.m_Slope = 0.0;
        for (i = 0; i < len; ++i) {
            x[i] = xold[i];
            if (isFixed[i]) continue;
            this.m_Slope += gradient[i] * direct[i];
        }
        if (this.m_Debug) {
            System.err.print("slope:  " + Utils.doubleToString(this.m_Slope, 10, 7) + "\n");
        }
        if (Math.abs(this.m_Slope) <= m_Zero) {
            if (this.m_Debug) {
                System.err.println("Gradient and direction orthogonal -- Min. found with current fixed variables (or all variables fixed). Try to release some variables now.");
            }
            return x;
        }
        if (this.m_Slope > m_Zero) {
            if (this.m_Debug) {
                for (int h = 0; h < x.length; ++h) {
                    System.err.println(h + ": isFixed=" + isFixed[h] + ", x=" + x[h] + ", grad=" + gradient[h] + ", direct=" + direct[h]);
                }
            }
            throw new Exception("g'*p positive! -- Try to debug from here: line 327.");
        }
        double test = 0.0;
        for (i = 0; i < len; ++i) {
            double temp;
            if (isFixed[i] || !((temp = Math.abs(direct[i]) / Math.max(Math.abs(x[i]), 1.0)) > test)) continue;
            test = temp;
        }
        if (!(test > m_Zero)) {
            if (this.m_Debug) {
                System.err.println("Zero directions for all free variables -- Min. found with current fixed variables (or all variables fixed). Try to release some variables now.");
            }
            return x;
        }
        double alamin = this.m_TOLX / test;
        for (i = 0; i < len; ++i) {
            double alpi;
            if (isFixed[i]) continue;
            if (direct[i] < -m_Epsilon && !Double.isNaN(nwsBounds[0][i])) {
                alpi = (nwsBounds[0][i] - xold[i]) / direct[i];
                if (alpi <= m_Zero) {
                    if (this.m_Debug) {
                        System.err.println("Fix variable " + i + " to lower bound " + nwsBounds[0][i] + " from value " + xold[i]);
                    }
                    x[i] = nwsBounds[0][i];
                    isFixed[i] = true;
                    alpha = 0.0;
                    nwsBounds[0][i] = Double.NaN;
                    wsBdsIndx.addElement(i);
                    continue;
                }
                if (!(alpha > alpi)) continue;
                alpha = alpi;
                fixedOne = i;
                continue;
            }
            if (!(direct[i] > m_Epsilon) || Double.isNaN(nwsBounds[1][i])) continue;
            alpi = (nwsBounds[1][i] - xold[i]) / direct[i];
            if (alpi <= m_Zero) {
                if (this.m_Debug) {
                    System.err.println("Fix variable " + i + " to upper bound " + nwsBounds[1][i] + " from value " + xold[i]);
                }
                x[i] = nwsBounds[1][i];
                isFixed[i] = true;
                alpha = 0.0;
                nwsBounds[1][i] = Double.NaN;
                wsBdsIndx.addElement(i);
                continue;
            }
            if (!(alpha > alpi)) continue;
            alpha = alpi;
            fixedOne = i;
        }
        if (this.m_Debug) {
            System.err.println("alamin: " + Utils.doubleToString(alamin, 10, 7));
            System.err.println("alpha: " + Utils.doubleToString(alpha, 10, 7));
        }
        if (alpha <= m_Zero) {
            this.m_IsZeroStep = true;
            if (this.m_Debug) {
                System.err.println("Alpha too small, try again");
            }
            return x;
        }
        double alam = alpha;
        if (alam > 1.0) {
            alam = 1.0;
        }
        double initF = fold;
        double hi = alam;
        double lo = alam;
        double newSlope = 0.0;
        double fhi = this.m_f;
        double flo = this.m_f;
        int k = 0;
        while (true) {
            double tmplam;
            if (this.m_Debug) {
                System.err.println("\nLine search iteration: " + k);
            }
            for (i = 0; i < len; ++i) {
                if (isFixed[i]) continue;
                x[i] = xold[i] + alam * direct[i];
                if (!Double.isNaN(nwsBounds[0][i]) && x[i] < nwsBounds[0][i]) {
                    x[i] = nwsBounds[0][i];
                    continue;
                }
                if (Double.isNaN(nwsBounds[1][i]) || !(x[i] > nwsBounds[1][i])) continue;
                x[i] = nwsBounds[1][i];
            }
            this.m_f = this.objectiveFunction(x);
            if (Double.isNaN(this.m_f)) {
                throw new Exception("Objective function value is NaN!");
            }
            while (Double.isInfinite(this.m_f)) {
                if (this.m_Debug) {
                    System.err.println("Too large m_f.  Shrink step by half.");
                }
                if ((alam *= 0.5) <= m_Epsilon) {
                    if (this.m_Debug) {
                        System.err.println("Wrong starting points, change them!");
                    }
                    return x;
                }
                for (i = 0; i < len; ++i) {
                    if (isFixed[i]) continue;
                    x[i] = xold[i] + alam * direct[i];
                }
                this.m_f = this.objectiveFunction(x);
                if (Double.isNaN(this.m_f)) {
                    throw new Exception("Objective function value is NaN!");
                }
                initF = Double.POSITIVE_INFINITY;
            }
            if (this.m_Debug) {
                System.err.println("obj. function: " + Utils.doubleToString(this.m_f, 10, 7));
                System.err.println("threshold: " + Utils.doubleToString(fold + this.m_ALF * alam * this.m_Slope, 10, 7));
            }
            if (this.m_f <= fold + this.m_ALF * alam * this.m_Slope) {
                if (this.m_Debug) {
                    System.err.println("Sufficient function decrease (alpha condition): ");
                }
                newGrad = this.evaluateGradient(x);
                newSlope = 0.0;
                for (i = 0; i < len; ++i) {
                    if (isFixed[i]) continue;
                    newSlope += newGrad[i] * direct[i];
                }
                if (this.m_Debug) {
                    System.err.println("newSlope: " + newSlope);
                }
                if (newSlope >= this.m_BETA * this.m_Slope) {
                    if (this.m_Debug) {
                        System.err.println("Increasing derivatives (beta condition): ");
                    }
                    if (fixedOne != -1 && alam >= alpha) {
                        if (direct[fixedOne] > 0.0) {
                            x[fixedOne] = nwsBounds[1][fixedOne];
                            nwsBounds[1][fixedOne] = Double.NaN;
                        } else {
                            x[fixedOne] = nwsBounds[0][fixedOne];
                            nwsBounds[0][fixedOne] = Double.NaN;
                        }
                        if (this.m_Debug) {
                            System.err.println("Fix variable " + fixedOne + " to bound " + x[fixedOne] + " from value " + xold[fixedOne]);
                        }
                        isFixed[fixedOne] = true;
                        wsBdsIndx.addElement(fixedOne);
                    }
                    return x;
                }
                if (k == 0) {
                    double upper = Math.min(alpha, maxalam);
                    if (this.m_Debug) {
                        System.err.println("Alpha condition holds, increase alpha... ");
                    }
                    while (!(alam >= upper) && !(this.m_f > fold + this.m_ALF * alam * this.m_Slope)) {
                        lo = alam;
                        flo = this.m_f;
                        if ((alam *= 2.0) >= upper) {
                            alam = upper;
                        }
                        for (i = 0; i < len; ++i) {
                            if (isFixed[i]) continue;
                            x[i] = xold[i] + alam * direct[i];
                        }
                        this.m_f = this.objectiveFunction(x);
                        if (Double.isNaN(this.m_f)) {
                            throw new Exception("Objective function value is NaN!");
                        }
                        if (this.m_f > fold + this.m_ALF * alam * this.m_Slope) continue;
                        newGrad = this.evaluateGradient(x);
                        newSlope = 0.0;
                        for (i = 0; i < len; ++i) {
                            if (isFixed[i]) continue;
                            newSlope += newGrad[i] * direct[i];
                        }
                        if (!(newSlope >= this.m_BETA * this.m_Slope)) continue;
                        if (this.m_Debug) {
                            System.err.println("Increasing derivatives (beta condition): \nnewSlope = " + Utils.doubleToString(newSlope, 10, 7));
                        }
                        if (fixedOne != -1 && alam >= alpha) {
                            if (direct[fixedOne] > 0.0) {
                                x[fixedOne] = nwsBounds[1][fixedOne];
                                nwsBounds[1][fixedOne] = Double.NaN;
                            } else {
                                x[fixedOne] = nwsBounds[0][fixedOne];
                                nwsBounds[0][fixedOne] = Double.NaN;
                            }
                            if (this.m_Debug) {
                                System.err.println("Fix variable " + fixedOne + " to bound " + x[fixedOne] + " from value " + xold[fixedOne]);
                            }
                            isFixed[fixedOne] = true;
                            wsBdsIndx.addElement(fixedOne);
                        }
                        return x;
                    }
                    hi = alam;
                    fhi = this.m_f;
                    break;
                }
                if (this.m_Debug) {
                    System.err.println("Alpha condition holds.");
                }
                hi = alam2;
                lo = alam;
                flo = this.m_f;
                break;
            }
            if (alam < alamin) {
                if (initF < fold) {
                    alam = Math.min(1.0, alpha);
                    for (i = 0; i < len; ++i) {
                        if (isFixed[i]) continue;
                        x[i] = xold[i] + alam * direct[i];
                    }
                    if (this.m_Debug) {
                        System.err.println("No feasible lambda: still take alpha=" + alam);
                    }
                    if (fixedOne != -1 && alam >= alpha) {
                        if (direct[fixedOne] > 0.0) {
                            x[fixedOne] = nwsBounds[1][fixedOne];
                            nwsBounds[1][fixedOne] = Double.NaN;
                        } else {
                            x[fixedOne] = nwsBounds[0][fixedOne];
                            nwsBounds[0][fixedOne] = Double.NaN;
                        }
                        if (this.m_Debug) {
                            System.err.println("Fix variable " + fixedOne + " to bound " + x[fixedOne] + " from value " + xold[fixedOne]);
                        }
                        isFixed[fixedOne] = true;
                        wsBdsIndx.addElement(fixedOne);
                    }
                } else {
                    for (i = 0; i < len; ++i) {
                        x[i] = xold[i];
                    }
                    this.m_f = fold;
                    if (this.m_Debug) {
                        System.err.println("Cannot find feasible lambda");
                    }
                }
                return x;
            }
            if (k == 0) {
                if (!Double.isInfinite(initF)) {
                    initF = this.m_f;
                }
                tmplam = -0.5 * alam * this.m_Slope / ((this.m_f - fold) / alam - this.m_Slope);
            } else {
                double rhs1 = this.m_f - fold - alam * this.m_Slope;
                double rhs2 = fhi - fold - alam2 * this.m_Slope;
                double a = (rhs1 / (alam * alam) - rhs2 / (alam2 * alam2)) / (alam - alam2);
                double b = (-alam2 * rhs1 / (alam * alam) + alam * rhs2 / (alam2 * alam2)) / (alam - alam2);
                if (a == 0.0) {
                    tmplam = -this.m_Slope / (2.0 * b);
                } else {
                    double numerator;
                    disc = b * b - 3.0 * a * this.m_Slope;
                    if (disc < 0.0) {
                        disc = 0.0;
                    }
                    if ((numerator = -b + Math.sqrt(disc)) >= Double.MAX_VALUE) {
                        numerator = Double.MAX_VALUE;
                        if (this.m_Debug) {
                            System.err.print("-b+sqrt(disc) too large! Set it to MAX_VALUE.");
                        }
                    }
                    tmplam = numerator / (3.0 * a);
                }
                if (this.m_Debug) {
                    System.err.print("Cubic interpolation: \na:   " + Utils.doubleToString(a, 10, 7) + "\nb:   " + Utils.doubleToString(b, 10, 7) + "\ndisc:   " + Utils.doubleToString(disc, 10, 7) + "\ntmplam:   " + tmplam + "\nalam:   " + Utils.doubleToString(alam, 10, 7) + "\n");
                }
                if (tmplam > 0.5 * alam) {
                    tmplam = 0.5 * alam;
                }
            }
            alam2 = alam;
            fhi = this.m_f;
            alam = Math.max(tmplam, 0.1 * alam);
            if (alam > alpha) {
                throw new Exception("Sth. wrong in lnsrch:Lambda infeasible!(lambda=" + alam + ", alpha=" + alpha + ", upper=" + tmplam + "|" + -alpha * this.m_Slope / (2.0 * ((this.m_f - fold) / alpha - this.m_Slope)) + ", m_f=" + this.m_f + ", fold=" + fold + ", slope=" + this.m_Slope);
            }
            ++k;
        }
        double ldiff = hi - lo;
        if (this.m_Debug) {
            System.err.println("Last stage of searching for beta condition (alam between " + Utils.doubleToString(lo, 10, 7) + " and " + Utils.doubleToString(hi, 10, 7) + ")...\nQuadratic Interpolation(QI):\nLast newSlope = " + Utils.doubleToString(newSlope, 10, 7));
        }
        while (newSlope < this.m_BETA * this.m_Slope && ldiff >= alamin) {
            double lincr = -0.5 * newSlope * ldiff * ldiff / (fhi - flo - newSlope * ldiff);
            if (this.m_Debug) {
                System.err.println("fhi = " + fhi + "\nflo = " + flo + "\nldiff = " + ldiff + "\nlincr (using QI) = " + lincr + "\n");
            }
            if (lincr < 0.2 * ldiff) {
                lincr = 0.2 * ldiff;
            }
            if ((alam = lo + lincr) >= hi) {
                alam = hi;
                lincr = ldiff;
            }
            for (i = 0; i < len; ++i) {
                if (isFixed[i]) continue;
                x[i] = xold[i] + alam * direct[i];
            }
            this.m_f = this.objectiveFunction(x);
            if (Double.isNaN(this.m_f)) {
                throw new Exception("Objective function value is NaN!");
            }
            if (this.m_f > fold + this.m_ALF * alam * this.m_Slope) {
                ldiff = lincr;
                fhi = this.m_f;
                continue;
            }
            newGrad = this.evaluateGradient(x);
            newSlope = 0.0;
            for (i = 0; i < len; ++i) {
                if (isFixed[i]) continue;
                newSlope += newGrad[i] * direct[i];
            }
            if (!(newSlope < this.m_BETA * this.m_Slope)) continue;
            lo = alam;
            ldiff -= lincr;
            flo = this.m_f;
        }
        if (newSlope < this.m_BETA * this.m_Slope) {
            if (this.m_Debug) {
                System.err.println("Beta condition cannot be satisfied, take alpha condition");
            }
            alam = lo;
            for (i = 0; i < len; ++i) {
                if (isFixed[i]) continue;
                x[i] = xold[i] + alam * direct[i];
            }
            this.m_f = flo;
        } else if (this.m_Debug) {
            System.err.println("Both alpha and beta conditions are satisfied. alam=" + Utils.doubleToString(alam, 10, 7));
        }
        if (fixedOne != -1 && alam >= alpha) {
            if (direct[fixedOne] > 0.0) {
                x[fixedOne] = nwsBounds[1][fixedOne];
                nwsBounds[1][fixedOne] = Double.NaN;
            } else {
                x[fixedOne] = nwsBounds[0][fixedOne];
                nwsBounds[0][fixedOne] = Double.NaN;
            }
            if (this.m_Debug) {
                System.err.println("Fix variable " + fixedOne + " to bound " + x[fixedOne] + " from value " + xold[fixedOne]);
            }
            isFixed[fixedOne] = true;
            wsBdsIndx.addElement(fixedOne);
        }
        return x;
    }

    public double[] findArgmin(double[] initX, double[][] constraints) throws Exception {
        int l = initX.length;
        boolean[] isFixed = new boolean[l];
        double[][] nwsBounds = new double[2][l];
        DynamicIntArray wsBdsIndx = new DynamicIntArray(constraints.length);
        DynamicIntArray toFree = null;
        DynamicIntArray oldToFree = null;
        this.m_f = this.objectiveFunction(initX);
        if (Double.isNaN(this.m_f)) {
            throw new Exception("Objective function value is NaN!");
        }
        double sum = 0.0;
        double[] grad = this.evaluateGradient(initX);
        double[] deltaGrad = new double[l];
        double[] deltaX = new double[l];
        double[] direct = new double[l];
        double[] x = new double[l];
        Matrix L = new Matrix(l, l);
        double[] D = new double[l];
        for (int i = 0; i < l; ++i) {
            L.set(i, i, 1.0);
            D[i] = 1.0;
            direct[i] = -grad[i];
            sum += grad[i] * grad[i];
            x[i] = initX[i];
            nwsBounds[0][i] = constraints[0][i];
            nwsBounds[1][i] = constraints[1][i];
            isFixed[i] = false;
        }
        double stpmax = this.m_STPMX * Math.max(Math.sqrt(sum), (double)l);
        for (int step = 0; step < this.m_MAXITS; ++step) {
            if (this.m_Debug) {
                System.err.println("\nIteration # " + step + ":");
            }
            double[] oldX = x;
            double[] oldGrad = grad;
            if (this.m_Debug) {
                System.err.println("Line search ... ");
            }
            this.m_IsZeroStep = false;
            x = this.lnsrch(x, grad, direct, stpmax, isFixed, nwsBounds, wsBdsIndx);
            if (this.m_Debug) {
                System.err.println("Line search finished.");
            }
            if (this.m_IsZeroStep) {
                for (int f = 0; f < wsBdsIndx.size(); ++f) {
                    int[] idx = new int[]{wsBdsIndx.elementAt(f)};
                    L.setMatrix(idx, 0, l - 1, new Matrix(1, l));
                    L.setMatrix(0, l - 1, idx, new Matrix(l, 1));
                    D[idx[0]] = 0.0;
                }
                grad = this.evaluateGradient(x);
                --step;
            } else {
                boolean finish = false;
                double test = 0.0;
                for (int h = 0; h < l; ++h) {
                    deltaX[h] = x[h] - oldX[h];
                    double tmp = Math.abs(deltaX[h]) / Math.max(Math.abs(x[h]), 1.0);
                    if (!(tmp > test)) continue;
                    test = tmp;
                }
                if (test < m_Zero) {
                    if (this.m_Debug) {
                        System.err.println("\nDeltaX converge: " + test);
                    }
                    finish = true;
                }
                grad = this.evaluateGradient(x);
                test = 0.0;
                double denom = 0.0;
                double dxSq = 0.0;
                double dgSq = 0.0;
                double newlyBounded = 0.0;
                for (int g = 0; g < l; ++g) {
                    if (!isFixed[g]) {
                        deltaGrad[g] = grad[g] - oldGrad[g];
                        denom += deltaX[g] * deltaGrad[g];
                        dxSq += deltaX[g] * deltaX[g];
                        dgSq += deltaGrad[g] * deltaGrad[g];
                    } else {
                        newlyBounded += deltaX[g] * (grad[g] - oldGrad[g]);
                    }
                    double tmp = Math.abs(grad[g]) * Math.max(Math.abs(direct[g]), 1.0) / Math.max(Math.abs(this.m_f), 1.0);
                    if (!(tmp > test)) continue;
                    test = tmp;
                }
                if (test < m_Zero) {
                    if (this.m_Debug) {
                        System.err.println("Gradient converge: " + test);
                    }
                    finish = true;
                }
                if (this.m_Debug) {
                    System.err.println("dg'*dx=" + (denom + newlyBounded));
                }
                if (Math.abs(denom + newlyBounded) < m_Zero) {
                    finish = true;
                }
                int size = wsBdsIndx.size();
                boolean isUpdate = true;
                if (finish) {
                    if (this.m_Debug) {
                        System.err.println("Test any release possible ...");
                    }
                    if (toFree != null) {
                        oldToFree = (DynamicIntArray)toFree.copy();
                    }
                    toFree = new DynamicIntArray(wsBdsIndx.size());
                    for (int m = size - 1; m >= 0; --m) {
                        boolean isConverge;
                        double L1;
                        int index = wsBdsIndx.elementAt(m);
                        double[] hessian = this.evaluateHessian(x, index);
                        double deltaL = 0.0;
                        if (hessian != null) {
                            for (int mm = 0; mm < hessian.length; ++mm) {
                                if (isFixed[mm]) continue;
                                deltaL += hessian[mm] * direct[mm];
                            }
                        }
                        if (x[index] >= constraints[1][index]) {
                            L1 = -grad[index];
                        } else if (x[index] <= constraints[0][index]) {
                            L1 = grad[index];
                        } else {
                            throw new Exception("x[" + index + "] not fixed on the bounds where it should have been!");
                        }
                        double L2 = L1 + deltaL;
                        if (this.m_Debug) {
                            System.err.println("Variable " + index + ": Lagrangian=" + L1 + "|" + L2);
                        }
                        boolean bl = isConverge = 2.0 * Math.abs(deltaL) < Math.min(Math.abs(L1), Math.abs(L2));
                        if (L1 * L2 > 0.0 && isConverge && L2 < 0.0) {
                            toFree.addElement(index);
                            wsBdsIndx.removeElementAt(m);
                            finish = false;
                        }
                        if (hessian != null || toFree == null || !toFree.equal(oldToFree)) continue;
                        finish = true;
                    }
                    if (finish) {
                        if (this.m_Debug) {
                            System.err.println("Minimum found.");
                        }
                        this.m_f = this.objectiveFunction(x);
                        if (Double.isNaN(this.m_f)) {
                            throw new Exception("Objective function value is NaN!");
                        }
                        return x;
                    }
                    for (int mmm = 0; mmm < toFree.size(); ++mmm) {
                        int freeIndx = toFree.elementAt(mmm);
                        isFixed[freeIndx] = false;
                        if (x[freeIndx] <= constraints[0][freeIndx]) {
                            nwsBounds[0][freeIndx] = constraints[0][freeIndx];
                            if (this.m_Debug) {
                                System.err.println("Free variable " + freeIndx + " from bound " + nwsBounds[0][freeIndx]);
                            }
                        } else {
                            nwsBounds[1][freeIndx] = constraints[1][freeIndx];
                            if (this.m_Debug) {
                                System.err.println("Free variable " + freeIndx + " from bound " + nwsBounds[1][freeIndx]);
                            }
                        }
                        L.set(freeIndx, freeIndx, 1.0);
                        D[freeIndx] = 1.0;
                        isUpdate = false;
                    }
                }
                if (denom < Math.max(m_Zero * Math.sqrt(dxSq) * Math.sqrt(dgSq), m_Zero)) {
                    if (this.m_Debug) {
                        System.err.println("dg'*dx negative!");
                    }
                    isUpdate = false;
                }
                if (isUpdate) {
                    double coeff = 1.0 / denom;
                    this.updateCholeskyFactor(L, D, deltaGrad, coeff, isFixed);
                    coeff = 1.0 / this.m_Slope;
                    this.updateCholeskyFactor(L, D, oldGrad, coeff, isFixed);
                }
            }
            Matrix LD = new Matrix(l, l);
            double[] b = new double[l];
            for (int k = 0; k < l; ++k) {
                b[k] = !isFixed[k] ? -grad[k] : 0.0;
                for (int j = k; j < l; ++j) {
                    if (isFixed[j] || isFixed[k]) continue;
                    LD.set(j, k, L.get(j, k) * D[k]);
                }
            }
            double[] LDIR = Optimization.solveTriangle(LD, b, true, isFixed);
            LD = null;
            for (int m = 0; m < LDIR.length; ++m) {
                if (!Double.isNaN(LDIR[m])) continue;
                throw new Exception("L*direct[" + m + "] is NaN!|-g=" + b[m] + "|" + isFixed[m] + "|diag=" + D[m]);
            }
            for (double element : direct = Optimization.solveTriangle(L, LDIR, false, isFixed)) {
                if (!Double.isNaN(element)) continue;
                throw new Exception("direct is NaN!");
            }
        }
        if (this.m_Debug) {
            System.err.println("Cannot find minimum -- too many interations!");
        }
        this.m_X = x;
        return null;
    }

    public static double[] solveTriangle(Matrix t, double[] b, boolean isLower, boolean[] isZero) {
        double[] result;
        block13: {
            int j;
            int n;
            block12: {
                int j2;
                n = b.length;
                result = new double[n];
                if (isZero == null) {
                    isZero = new boolean[n];
                }
                if (!isLower) break block12;
                for (j2 = 0; j2 < n && isZero[j2]; ++j2) {
                    result[j2] = 0.0;
                }
                if (j2 >= n) break block13;
                result[j2] = b[j2] / t.get(j2, j2);
                while (j2 < n) {
                    if (!isZero[j2]) {
                        double numerator = b[j2];
                        for (int k = 0; k < j2; ++k) {
                            numerator -= t.get(j2, k) * result[k];
                        }
                        result[j2] = numerator / t.get(j2, j2);
                    } else {
                        result[j2] = 0.0;
                    }
                    ++j2;
                }
                break block13;
            }
            for (j = n - 1; j >= 0 && isZero[j]; --j) {
                result[j] = 0.0;
            }
            if (j >= 0) {
                result[j] = b[j] / t.get(j, j);
                while (j >= 0) {
                    if (!isZero[j]) {
                        double numerator = b[j];
                        for (int k = j + 1; k < n; ++k) {
                            numerator -= t.get(k, j) * result[k];
                        }
                        result[j] = numerator / t.get(j, j);
                    } else {
                        result[j] = 0.0;
                    }
                    --j;
                }
            }
        }
        return result;
    }

    protected void updateCholeskyFactor(Matrix L, double[] D, double[] v, double coeff, boolean[] isFixed) throws Exception {
        int n = v.length;
        double[] vp = new double[n];
        for (int i = 0; i < v.length; ++i) {
            vp[i] = !isFixed[i] ? v[i] : 0.0;
        }
        if (coeff > 0.0) {
            double t = coeff;
            for (int j = 0; j < n; ++j) {
                double dbarj;
                if (isFixed[j]) continue;
                double p = vp[j];
                double d = D[j];
                D[j] = dbarj = d + t * p * p;
                double b = p * t / dbarj;
                t *= d / dbarj;
                for (int r = j + 1; r < n; ++r) {
                    if (!isFixed[r]) {
                        double l = L.get(r, j);
                        int n2 = r;
                        vp[n2] = vp[n2] - p * l;
                        L.set(r, j, l + b * vp[r]);
                        continue;
                    }
                    L.set(r, j, 0.0);
                }
            }
        } else {
            double[] P = Optimization.solveTriangle(L, v, true, isFixed);
            double t = 0.0;
            for (int i = 0; i < n; ++i) {
                if (isFixed[i]) continue;
                t += P[i] * P[i] / D[i];
            }
            double sqrt = 1.0 + coeff * t;
            sqrt = sqrt < 0.0 ? 0.0 : Math.sqrt(sqrt);
            double alpha = coeff;
            double sigma = coeff / (1.0 + sqrt);
            for (int j = 0; j < n; ++j) {
                if (isFixed[j]) continue;
                double d = D[j];
                double p = P[j] * P[j] / d;
                double theta = 1.0 + sigma * p;
                if ((t -= p) < 0.0) {
                    t = 0.0;
                }
                double plus = sigma * sigma * p * t;
                if (j < n - 1 && plus <= m_Zero) {
                    plus = m_Zero;
                }
                double rho = theta * theta + plus;
                D[j] = rho * d;
                if (Double.isNaN(D[j])) {
                    throw new Exception("d[" + j + "] NaN! P=" + P[j] + ",d=" + d + ",t=" + t + ",p=" + p + ",sigma=" + sigma + ",sclar=" + coeff);
                }
                double b = alpha * P[j] / (rho * d);
                alpha /= rho;
                rho = Math.sqrt(rho);
                double sigmaOld = sigma;
                if (j < n - 1 && (Double.isNaN(sigma *= (1.0 + rho) / (rho * (theta + rho))) || Double.isInfinite(sigma))) {
                    throw new Exception("sigma NaN/Inf! rho=" + rho + ",theta=" + theta + ",P[" + j + "]=" + P[j] + ",p=" + p + ",d=" + d + ",t=" + t + ",oldsigma=" + sigmaOld);
                }
                for (int r = j + 1; r < n; ++r) {
                    if (!isFixed[r]) {
                        double l = L.get(r, j);
                        int n3 = r;
                        vp[n3] = vp[n3] - P[j] * l;
                        L.set(r, j, l + b * vp[r]);
                        continue;
                    }
                    L.set(r, j, 0.0);
                }
            }
        }
    }

    static {
        while (1.0 + m_Epsilon > 1.0) {
            m_Epsilon /= 2.0;
        }
        m_Zero = Math.sqrt(m_Epsilon *= 2.0);
    }

    protected class DynamicIntArray
    implements RevisionHandler {
        private int[] m_Objects;
        private int m_Size = 0;
        private int m_CapacityIncrement = 1;
        private int m_CapacityMultiplier = 2;

        public DynamicIntArray(int capacity) {
            this.m_Objects = new int[capacity];
        }

        public final void addElement(int element) {
            if (this.m_Size == this.m_Objects.length) {
                int[] newObjects = new int[this.m_CapacityMultiplier * (this.m_Objects.length + this.m_CapacityIncrement)];
                System.arraycopy(this.m_Objects, 0, newObjects, 0, this.m_Size);
                this.m_Objects = newObjects;
            }
            this.m_Objects[this.m_Size] = element;
            ++this.m_Size;
        }

        public final Object copy() {
            DynamicIntArray copy = new DynamicIntArray(this.m_Objects.length);
            copy.m_Size = this.m_Size;
            copy.m_CapacityIncrement = this.m_CapacityIncrement;
            copy.m_CapacityMultiplier = this.m_CapacityMultiplier;
            System.arraycopy(this.m_Objects, 0, copy.m_Objects, 0, this.m_Size);
            return copy;
        }

        public final int elementAt(int index) {
            return this.m_Objects[index];
        }

        private boolean equal(DynamicIntArray b) {
            if (b == null || this.size() != b.size()) {
                return false;
            }
            int size = this.size();
            int[] sorta = Utils.sort(this.m_Objects);
            int[] sortb = Utils.sort(b.m_Objects);
            for (int j = 0; j < size; ++j) {
                if (this.m_Objects[sorta[j]] == b.m_Objects[sortb[j]]) continue;
                return false;
            }
            return true;
        }

        public final void removeElementAt(int index) {
            System.arraycopy(this.m_Objects, index + 1, this.m_Objects, index, this.m_Size - index - 1);
            --this.m_Size;
        }

        public final void removeAllElements() {
            this.m_Objects = new int[this.m_Objects.length];
            this.m_Size = 0;
        }

        public final int size() {
            return this.m_Size;
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision$");
        }
    }
}

