/*
 * Decompiled with CFR 0.152.
 */
package weka.core.stemmers;

import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import weka.core.ClassDiscovery;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.PluginManager;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WekaPackageClassLoaderManager;
import weka.core.stemmers.Stemmer;
import weka.core.stemmers.Stemming;

public class SnowballStemmer
implements Stemmer,
OptionHandler {
    static final long serialVersionUID = -6111170431963015178L;
    public static final String PACKAGE = "org.tartarus.snowball";
    public static final String PACKAGE_EXT = "org.tartarus.snowball.ext";
    protected static final String SNOWBALL_PROGRAM = "org.tartarus.snowball.SnowballProgram";
    protected static boolean m_Present = false;
    protected static Vector<String> m_Stemmers;
    protected Object m_Stemmer;
    protected transient Method m_StemMethod;
    protected transient Method m_SetCurrentMethod;
    protected transient Method m_GetCurrentMethod;

    public SnowballStemmer() {
        this("porter");
        SnowballStemmer.initStemmers();
    }

    public SnowballStemmer(String name) {
        this.setStemmer(name);
    }

    private static void checkForSnowball() {
        try {
            WekaPackageClassLoaderManager.forName(SNOWBALL_PROGRAM);
            m_Present = true;
        }
        catch (Exception e) {
            m_Present = false;
        }
    }

    public String globalInfo() {
        return "A wrapper class for the Snowball stemmers. Only available if the Snowball classes are in the classpath.\nIf the class discovery is not dynamic, i.e., the property 'UseDynamic' in the props file 'weka/gui/GenericPropertiesCreator.props' is 'false', then the property 'org.tartarus.snowball.SnowballProgram' in the 'weka/gui/GenericObjectEditor.props' file has to be uncommented as well. If necessary you have to discover and fill in the snowball stemmers manually. You can use the 'weka.core.ClassDiscovery' for this:\n  java weka.core.ClassDiscovery org.tartarus.snowball.SnowballProgram org.tartarus.snowball.ext\n";
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tThe name of the snowball stemmer (default 'porter').\n\tavailable stemmers:\n" + SnowballStemmer.getStemmerList(65, "\t   "), "S", 1, "-S <name>"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('S', options);
        if (tmpStr.length() != 0) {
            this.setStemmer(tmpStr);
        } else {
            this.setStemmer("porter");
        }
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        if (this.getStemmer() != null) {
            result.add("-S");
            result.add("" + this.getStemmer());
        }
        return result.toArray(new String[result.size()]);
    }

    private static String getStemmerName(String classname) {
        return classname.replaceAll(".*\\.", "").replaceAll("Stemmer$", "");
    }

    private static String getStemmerClassname(String name) {
        return "org.tartarus.snowball.ext." + name + "Stemmer";
    }

    private static void initStemmers() {
        if (m_Stemmers != null) {
            return;
        }
        m_Stemmers = new Vector();
        if (!m_Present) {
            return;
        }
        List<String> classnames = PluginManager.getPluginNamesOfTypeList(SNOWBALL_PROGRAM);
        if (classnames.size() == 0) {
            classnames = ClassDiscovery.find(SNOWBALL_PROGRAM, PACKAGE_EXT);
        }
        for (int i = 0; i < classnames.size(); ++i) {
            m_Stemmers.add(SnowballStemmer.getStemmerName(classnames.get(i).toString()));
        }
    }

    public static boolean isPresent() {
        return m_Present;
    }

    public static Enumeration<String> listStemmers() {
        SnowballStemmer.initStemmers();
        return m_Stemmers.elements();
    }

    private static String getStemmerList(int lineLength, String indention) {
        String result = "";
        String line = "";
        Enumeration<String> enm = SnowballStemmer.listStemmers();
        while (enm.hasMoreElements()) {
            String name = enm.nextElement().toString();
            if (line.length() > 0) {
                line = line + ", ";
            }
            if (lineLength > 0 && line.length() + name.length() > lineLength) {
                result = result + indention + line + "\n";
                line = "";
            }
            line = line + name;
        }
        if (line.length() > 0) {
            result = result + indention + line + "\n";
        }
        return result;
    }

    public String getStemmer() {
        SnowballStemmer.initStemmers();
        if (this.m_Stemmer == null) {
            return null;
        }
        return SnowballStemmer.getStemmerName(this.m_Stemmer.getClass().getName());
    }

    public void setStemmer(String name) {
        SnowballStemmer.initStemmers();
        if (m_Stemmers.contains(name)) {
            try {
                Class<?> snowballClass = WekaPackageClassLoaderManager.forName(SnowballStemmer.getStemmerClassname(name));
                this.m_Stemmer = snowballClass.newInstance();
                Class[] argClasses = new Class[]{};
                this.m_StemMethod = snowballClass.getMethod("stem", argClasses);
                argClasses = new Class[]{String.class};
                this.m_SetCurrentMethod = snowballClass.getMethod("setCurrent", argClasses);
                argClasses = new Class[]{};
                this.m_GetCurrentMethod = snowballClass.getMethod("getCurrent", argClasses);
            }
            catch (Exception e) {
                System.out.println("Error initializing stemmer '" + name + "'!" + e.getMessage());
                this.m_Stemmer = null;
            }
        } else {
            System.err.println("Stemmer '" + name + "' unknown!");
            this.m_Stemmer = null;
        }
    }

    public String stemmerTipText() {
        return "The Snowball stemmer to use, available: " + SnowballStemmer.getStemmerList(0, "");
    }

    @Override
    public String stem(String word) {
        String result;
        if (this.m_Stemmer == null) {
            result = new String(word);
        } else {
            if (this.m_SetCurrentMethod == null) {
                this.setStemmer(this.getStemmer());
            }
            try {
                Object[] args = new Object[]{word};
                this.m_SetCurrentMethod.invoke(this.m_Stemmer, args);
                args = new Object[]{};
                this.m_StemMethod.invoke(this.m_Stemmer, args);
                args = new Object[]{};
                result = (String)this.m_GetCurrentMethod.invoke(this.m_Stemmer, args);
            }
            catch (Exception e) {
                e.printStackTrace();
                result = word;
            }
        }
        return result;
    }

    public String toString() {
        String result = this.getClass().getName();
        result = result + " " + Utils.joinOptions(this.getOptions());
        return result.trim();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision$");
    }

    public static void main(String[] args) {
        try {
            Stemming.useStemmer(new SnowballStemmer(), args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        SnowballStemmer.checkForSnowball();
    }
}

