/*
 * Decompiled with CFR 0.152.
 */
package weka.filters;

import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.WeightedAttributesHandler;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.Sourcable;

public class AllFilter
extends Filter
implements Sourcable,
WeightedAttributesHandler,
WeightedInstancesHandler {
    static final long serialVersionUID = 5022109283147503266L;

    public String globalInfo() {
        return "An instance filter that passes all instances through unmodified. Primarily for testing purposes.";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        this.setOutputFormat(instanceInfo);
        return true;
    }

    @Override
    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (instance.dataset() == null) {
            this.push((Instance)instance.copy());
        } else {
            this.push(instance);
        }
        return true;
    }

    @Override
    public String toSource(String className, Instances data) throws Exception {
        StringBuffer result = new StringBuffer();
        result.append("class " + className + " {\n");
        result.append("\n");
        result.append("  /**\n");
        result.append("   * filters a single row\n");
        result.append("   * \n");
        result.append("   * @param i the row to process\n");
        result.append("   * @return the processed row\n");
        result.append("   */\n");
        result.append("  public static Object[] filter(Object[] i) {\n");
        result.append("    return i;\n");
        result.append("  }\n");
        result.append("\n");
        result.append("  /**\n");
        result.append("   * filters multiple rows\n");
        result.append("   * \n");
        result.append("   * @param i the rows to process\n");
        result.append("   * @return the processed rows\n");
        result.append("   */\n");
        result.append("  public static Object[][] filter(Object[][] i) {\n");
        result.append("    return i;\n");
        result.append("  }\n");
        result.append("}\n");
        return result.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision$");
    }

    public static void main(String[] argv) {
        AllFilter.runFilter(new AllFilter(), argv);
    }
}

