/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.AbstractInstance;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RandomSample;
import weka.core.Randomizable;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.core.WeightedAttributesHandler;
import weka.core.WeightedInstancesHandler;
import weka.filters.SimpleBatchFilter;

public class RandomSubset
extends SimpleBatchFilter
implements Randomizable,
WeightedInstancesHandler,
WeightedAttributesHandler {
    private static final long serialVersionUID = 2911221724251628050L;
    protected double m_NumAttributes = 0.5;
    protected int m_Seed = 1;
    protected int[] m_Indices = null;
    protected boolean m_invertSelection;

    @Override
    public String globalInfo() {
        return "Chooses a random subset of non-class attributes, either an absolute number or a percentage. Attributes are included in the order in which they occur in the input data. The class attribute (if present) is always included in the output.";
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tThe number of attributes to randomly select.\n\tIf < 1 then percentage, >= 1 absolute number.\n\t(default: 0.5)", "N", 1, "-N <double>"));
        result.addElement(new Option("\tInvert selection - i.e. randomly remove rather than select.", "V", 0, "-V"));
        result.addElement(new Option("\tThe seed value.\n\t(default: 1)", "S", 1, "-S <int>"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-N");
        result.add("" + this.m_NumAttributes);
        if (this.getInvertSelection()) {
            result.add("-V");
        }
        result.add("-S");
        result.add("" + this.m_Seed);
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption("N", options);
        if (tmpStr.length() != 0) {
            this.setNumAttributes(Double.parseDouble(tmpStr));
        } else {
            this.setNumAttributes(0.5);
        }
        this.setInvertSelection(Utils.getFlag('V', options));
        tmpStr = Utils.getOption("S", options);
        if (tmpStr.length() != 0) {
            this.setSeed(Integer.parseInt(tmpStr));
        } else {
            this.setSeed(1);
        }
        super.setOptions(options);
    }

    public String numAttributesTipText() {
        return "The number of attributes to choose: < 1 percentage, >= 1 absolute number.";
    }

    public double getNumAttributes() {
        return this.m_NumAttributes;
    }

    public void setNumAttributes(double value) {
        this.m_NumAttributes = value;
    }

    public String invertSelectionTipText() {
        return "Randomly remove rather than select attributes.";
    }

    public void setInvertSelection(boolean inv) {
        this.m_invertSelection = inv;
    }

    public boolean getInvertSelection() {
        return this.m_invertSelection;
    }

    public String seedTipText() {
        return "The seed value for the random number generator.";
    }

    @Override
    public int getSeed() {
        return this.m_Seed;
    }

    @Override
    public void setSeed(int value) {
        this.m_Seed = value;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public boolean allowAccessToFullInputFormat() {
        return true;
    }

    @Override
    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        int i;
        int i2;
        int numAttsWithoutClass = inputFormat.numAttributes();
        if (inputFormat.classIndex() > -1) {
            --numAttsWithoutClass;
        }
        int sizeOfSample = 0;
        if (this.m_NumAttributes < 1.0) {
            sizeOfSample = (int)Math.round((double)numAttsWithoutClass * this.m_NumAttributes);
        } else if (this.m_NumAttributes < (double)numAttsWithoutClass) {
            sizeOfSample = (int)this.m_NumAttributes;
        }
        if (this.getDebug()) {
            System.out.println("# of atts: " + sizeOfSample);
        }
        Random rand = inputFormat.getRandomNumberGenerator(this.getSeed());
        int[] indices = RandomSample.drawSortedSample(sizeOfSample, numAttsWithoutClass, rand);
        if (this.m_invertSelection) {
            int[] newIndices = new int[numAttsWithoutClass - indices.length];
            int index = 0;
            int indexNew = 0;
            for (i2 = 0; i2 < numAttsWithoutClass; ++i2) {
                while (indexNew < newIndices.length && (indices.length <= index || i2 < indices[index])) {
                    newIndices[indexNew++] = i2++;
                }
                ++index;
            }
            indices = newIndices;
        }
        ArrayList<Integer> selected = new ArrayList<Integer>();
        int newClassIndex = -1;
        if (inputFormat.classIndex() > -1) {
            for (i = 0; i < indices.length; ++i) {
                int index = indices[i];
                if (index < inputFormat.classIndex()) {
                    selected.add(index);
                    continue;
                }
                selected.add(index + 1);
            }
            newClassIndex = -Collections.binarySearch(selected, inputFormat.classIndex()) - 1;
            selected.add(newClassIndex, inputFormat.classIndex());
        } else {
            for (i = 0; i < indices.length; ++i) {
                selected.add(indices[i]);
            }
        }
        if (this.getDebug()) {
            System.out.println("Selected indices: " + selected);
        }
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        this.m_Indices = new int[selected.size()];
        for (i2 = 0; i2 < selected.size(); ++i2) {
            atts.add((Attribute)inputFormat.attribute((Integer)selected.get(i2)).copy());
            this.m_Indices[i2] = (Integer)selected.get(i2);
        }
        Instances result = new Instances(inputFormat.relationName(), atts, 0).stringFreeStructure();
        if (inputFormat.classIndex() > -1) {
            result.setClassIndex(newClassIndex);
        }
        this.initInputLocators(this.inputFormatPeek(), this.m_Indices);
        return result;
    }

    @Override
    protected Instances process(Instances instances) throws Exception {
        Instances result = new Instances(this.outputFormatPeek(), 0);
        for (Instance instance : instances) {
            AbstractInstance newInstance;
            if (instance instanceof SparseInstance) {
                int n1 = instance.numValues();
                int n2 = this.m_Indices.length;
                int[] indices = new int[instance.numValues()];
                double[] values = new double[instance.numValues()];
                int vals = 0;
                int p1 = 0;
                int p2 = 0;
                while (p1 < n1 && p2 < n2) {
                    int ind2;
                    int ind1 = instance.index(p1);
                    if (ind1 == (ind2 = this.m_Indices[p2])) {
                        indices[vals] = p2++;
                        values[vals] = instance.valueSparse(p1);
                        ++vals;
                        ++p1;
                        continue;
                    }
                    if (ind1 > ind2) {
                        ++p2;
                        continue;
                    }
                    ++p1;
                }
                newInstance = new SparseInstance(instance.weight(), values, indices, this.m_Indices.length);
            } else {
                double[] values = new double[this.m_Indices.length];
                for (int i = 0; i < this.m_Indices.length; ++i) {
                    values[i] = instance.value(this.m_Indices[i]);
                }
                newInstance = new DenseInstance(instance.weight(), values);
            }
            this.copyValues(newInstance, false, instance.dataset(), result);
            result.add(newInstance);
        }
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision$");
    }

    public static void main(String[] args) {
        RandomSubset.runFilter(new RandomSubset(), args);
    }
}

