/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import weka.core.AbstractInstance;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.core.WeightedAttributesHandler;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;

public class Reorder
extends Filter
implements UnsupervisedFilter,
StreamableFilter,
OptionHandler,
WeightedAttributesHandler,
WeightedInstancesHandler {
    static final long serialVersionUID = -1135571321097202292L;
    protected String m_NewOrderCols = "first-last";
    protected int[] m_SelectedAttributes;
    protected int[] m_InputStringIndex;
    protected boolean m_setAllAttributeWeightsToOne;

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>();
        newVector.addElement(new Option("\tSpecifies the order of the attributes (default first-last).", "R", 1, "-R <index1,index2-index4,...>"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String orderList = Utils.getOption('R', options);
        if (orderList.length() != 0) {
            this.setAttributeIndices(orderList);
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        if (!this.getAttributeIndices().equals("")) {
            options.add("-R");
            options.add(this.getAttributeIndices());
        }
        return options.toArray(new String[0]);
    }

    protected int determineIndex(String s, int numAttributes) throws Exception {
        int result = s.equals("first") ? 0 : (s.equals("last") ? numAttributes - 1 : Integer.parseInt(s) - 1);
        if (result < 0 || result > numAttributes - 1) {
            throw new IllegalArgumentException("'" + s + "' is not a valid index for the range '1-" + numAttributes + "'!");
        }
        return result;
    }

    protected int[] determineIndices(int numAttributes) throws Exception {
        int i;
        Vector<Integer> list = new Vector<Integer>();
        StringTokenizer tok = new StringTokenizer(this.m_NewOrderCols, ",");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (token.indexOf("-") > -1) {
                int to;
                String[] range = token.split("-");
                if (range.length != 2) {
                    throw new IllegalArgumentException("'" + token + "' is not a valid range!");
                }
                int from = this.determineIndex(range[0], numAttributes);
                if (from <= (to = this.determineIndex(range[1], numAttributes))) {
                    for (i = from; i <= to; ++i) {
                        list.add(i);
                    }
                    continue;
                }
                for (i = from; i >= to; --i) {
                    list.add(i);
                }
                continue;
            }
            list.add(this.determineIndex(token, numAttributes));
        }
        int[] result = new int[list.size()];
        for (i = 0; i < list.size(); ++i) {
            result[i] = (Integer)list.get(i);
        }
        return result;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.NO_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        int[] frequency = new int[instanceInfo.numAttributes()];
        this.m_SelectedAttributes = this.determineIndices(instanceInfo.numAttributes());
        boolean atLeastOneAttributeOccursMoreThanOnce = false;
        int[] nArray = this.m_SelectedAttributes;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int current;
            int n2 = current = nArray[i];
            frequency[n2] = frequency[n2] + 1;
            if (frequency[current] <= 1) continue;
            if (current == instanceInfo.classIndex()) {
                throw new IllegalArgumentException("Reorder filter: Cannot duplicate class attribute");
            }
            atLeastOneAttributeOccursMoreThanOnce = true;
            break;
        }
        Arrays.fill(frequency, 0);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        int outputClass = -1;
        for (int current : this.m_SelectedAttributes) {
            if (instanceInfo.classIndex() == current) {
                outputClass = attributes.size();
            }
            String newName = instanceInfo.attribute(current).name();
            if (atLeastOneAttributeOccursMoreThanOnce) {
                int n3 = current;
                int n4 = frequency[n3] + 1;
                frequency[n3] = n4;
                newName = newName + "_" + n4;
            }
            Attribute keep = instanceInfo.attribute(current).copy(newName);
            if (this.m_setAllAttributeWeightsToOne) {
                keep.setWeight(1.0);
            }
            attributes.add(keep);
        }
        this.initInputLocators(instanceInfo, this.m_SelectedAttributes);
        Instances outputFormat = new Instances(instanceInfo.relationName(), attributes, 0);
        outputFormat.setClassIndex(outputClass);
        this.setOutputFormat(outputFormat);
        return true;
    }

    public void setAllAttributeWeightsToOne(boolean b) {
        this.m_setAllAttributeWeightsToOne = b;
    }

    @Override
    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        double[] vals = new double[this.outputFormatPeek().numAttributes()];
        for (int i = 0; i < this.m_SelectedAttributes.length; ++i) {
            int current = this.m_SelectedAttributes[i];
            vals[i] = instance.value(current);
        }
        AbstractInstance inst = null;
        inst = instance instanceof SparseInstance ? new SparseInstance(instance.weight(), vals) : new DenseInstance(instance.weight(), vals);
        this.copyValues(inst, false, instance.dataset(), this.outputFormatPeek());
        this.push(inst);
        return true;
    }

    public String globalInfo() {
        return "A filter that generates output with a new order of the attributes. Useful if one wants to move an attribute to the end of the list of attributes to use it as class attribute (e.g., using \"-R 2-last,1\").\n\nIt is not only possible to change the order of the attributes. Attributes can also be left out. E.g. if you have 10 attributes, you can generate the following output order: 1,3,5,7,9,10 or 10,1-5.\n\nYou can also duplicate attributes, e.g., for further processing later on: e.g., using 1,1,1,4,4,4,2,2,2 if one needs to process two copies of the attributes with other filters but also needs to keep the original attributes.\n\nOne can simply reverse the order of the attributes via 'last-first'.\n\nAfter applying the filter, the index of the class attribute is set to the index of the last attribute.";
    }

    public String getAttributeIndices() {
        return this.m_NewOrderCols;
    }

    public String attributeIndicesTipText() {
        return "Specify range of attributes to act on. This is a comma separated list of attribute indices, with \"first\" and \"last\" valid values. Specify an inclusive range with \"-\". E.g: \"first-3,5,6-10,last\".";
    }

    public void setAttributeIndices(String rangeList) throws Exception {
        if (rangeList.replaceAll("[afilrst0-9\\-,]*", "").length() != 0) {
            throw new IllegalArgumentException("Not a valid range string!");
        }
        this.m_NewOrderCols = rangeList;
    }

    public void setAttributeIndicesArray(int[] attributes) throws Exception {
        this.setAttributeIndices(Range.indicesToRangeList(attributes));
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision$");
    }

    public static void main(String[] argv) {
        Reorder.runFilter(new Reorder(), argv);
    }
}

