/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WeightedAttributesHandler;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.UnsupervisedFilter;

public class RemoveRange
extends Filter
implements UnsupervisedFilter,
OptionHandler,
WeightedAttributesHandler,
WeightedInstancesHandler {
    static final long serialVersionUID = -3064641215340828695L;
    private final Range m_Range = new Range("first-last");

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(2);
        newVector.addElement(new Option("\tSpecifies list of instances to select. First and last\n\tare valid indexes. (required)\n", "R", 1, "-R <inst1,inst2-inst4,...>"));
        newVector.addElement(new Option("\tSpecifies if inverse of selection is to be output.\n", "V", 0, "-V"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String str = Utils.getOption('R', options);
        if (str.length() != 0) {
            this.setInstancesIndices(str);
        } else {
            this.setInstancesIndices("first-last");
        }
        this.setInvertSelection(Utils.getFlag('V', options));
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        if (this.getInvertSelection()) {
            options.add("-V");
        }
        options.add("-R");
        options.add(this.getInstancesIndices());
        return options.toArray(new String[0]);
    }

    public String globalInfo() {
        return "A filter that removes a given range of instances of a dataset.";
    }

    public String instancesIndicesTipText() {
        return "The range of instances to select. First and last are valid indexes.";
    }

    public String getInstancesIndices() {
        return this.m_Range.getRanges();
    }

    public void setInstancesIndices(String rangeList) {
        this.m_Range.setRanges(rangeList);
    }

    public String invertSelectionTipText() {
        return "Whether to invert the selection.";
    }

    public boolean getInvertSelection() {
        return this.m_Range.getInvert();
    }

    public void setInvertSelection(boolean inverse) {
        this.m_Range.setInvert(inverse);
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        this.setOutputFormat(instanceInfo);
        return true;
    }

    @Override
    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.isFirstBatchDone()) {
            this.push(instance);
            return true;
        }
        this.bufferInput(instance);
        return false;
    }

    @Override
    public boolean batchFinished() {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (!this.isFirstBatchDone()) {
            this.m_Range.setUpper(this.getInputFormat().numInstances() - 1);
            for (int i = 0; i < this.getInputFormat().numInstances(); ++i) {
                if (this.m_Range.isInRange(i)) continue;
                this.push(this.getInputFormat().instance(i), false);
            }
        } else {
            for (int i = 0; i < this.getInputFormat().numInstances(); ++i) {
                this.push(this.getInputFormat().instance(i), false);
            }
        }
        this.flushInput();
        this.m_NewBatch = true;
        this.m_FirstBatchDone = true;
        return this.numPendingOutput() != 0;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision$");
    }

    public static void main(String[] argv) {
        RemoveRange.runFilter(new RemoveRange(), argv);
    }
}

