import weka.clusterers.SimpleKMeans;
import weka.core.Instances;
import weka.core.converters.ConverterUtils.DataSource;
import weka.core.WekaPackageManager;


public class k_means_clustering {
    public static void main(String args[]) throws Exception {

        WekaPackageManager wk = new WekaPackageManager();   //create Package Manager instance
        wk.loadPackages(false);   //load the packages (false = output should not be the loading progress)

        //Import data set
        DataSource src = new DataSource("./weather.nominal.arff");   //create DataSource pointing to data set
        Instances weather = src.getDataSet();   //load data set into instances

        //Compute K-Means Clustering
        SimpleKMeans skm = new SimpleKMeans();   //create k-means clustering instance
        skm.buildClusterer(weather);   //build the model
        System.out.println(skm);   //print out the result
    }
}