// https://deeplearning.cms.waikato.ac.nz/user-guide/getting-started/
import weka.classifiers.Evaluation;
import weka.classifiers.functions.Dl4jMlpClassifier;
import weka.core.Instances;

import java.io.FileReader;
import java.nio.file.Paths;
import java.util.Random;

public class TestWeka {
    public static void main(String[] args) throws Exception {
        Dl4jMlpClassifier clf = new Dl4jMlpClassifier();

        // String irisPath = Paths.get(System.getenv("WEKA_HOME"),
        //                  "packages", "wekaDeeplearning4j", "datasets",
        //                  "nominal", "iris.arff").toString();
        // change by rgf: use Weka location instead
        String irisPath = System.getenv("WEKA_HOME")+"/data/iris.arff";
        Instances inst = new Instances(new FileReader(irisPath));
        inst.setClassIndex(inst.numAttributes() - 1);
        Evaluation ev = new Evaluation(inst);
        ev.crossValidateModel(clf, inst, 10, new Random(0));
        System.out.println(ev.toSummaryString());
    }
}
