import weka.core.Instances;
import weka.core.converters.ConverterUtils.DataSource;
import weka.core.WekaPackageManager;
import weka.gui.visualize.PlotData2D;
import weka.gui.visualize.VisualizePanel;
import javax.swing.*;


public class data_visualization {
    public static void main(String args[]) throws Exception {

        WekaPackageManager wk = new WekaPackageManager();   //create Package Manager instance
        wk.loadPackages(false);   //load the packages (false = output should not be the loading progress)

        //Import data set
        DataSource src = new DataSource("./house_prices.csv");   //create DataSource pointing to data set
        Instances housing = src.getDataSet();   //load data set into instances

        // Create the plot data
        PlotData2D plotData = new PlotData2D(housing);   //create plotdata2D instance with the data as input
        plotData.setPlotName("DATA");   //set plot name

        // Create the visualization panel
        VisualizePanel panel = new VisualizePanel();   //create a visualization panel
        panel.addPlot(plotData);   //add plot to panel

        // Create a JFrame to hold the visualization panel
        JFrame frame = new JFrame("Data Visualization");   //create JFRAME
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);   //make the JFRAME closable
        frame.setSize(1600, 1200);   //set the size of the JFRAME
        frame.getContentPane().add(panel);   //add panel to JFRAME
        frame.setVisible(true);   //set the JFRAME as visible
    }
}
